/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexRecordPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexRecordQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyIndexRecordService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexRecordVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyIndexRecordConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyIndexRecordDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyIndexRecordDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyIndexRecordRepo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessStrategyIndexRecordServiceImpl
extends BaseServiceImpl
implements BusinessStrategyIndexRecordService {
    private static final Logger log = LoggerFactory.getLogger(BusinessStrategyIndexRecordServiceImpl.class);
    private final BusinessStrategyIndexRecordRepo businessStrategyIndexRecordRepo;
    private final BusinessStrategyIndexRecordDAO businessStrategyIndexRecordDAO;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    public PagingVO<BusinessStrategyIndexRecordVO> queryPaging(BusinessStrategyIndexRecordQuery query) {
        return this.businessStrategyIndexRecordDAO.queryPaging(query);
    }

    public List<BusinessStrategyIndexRecordVO> queryListDynamic(BusinessStrategyIndexRecordQuery query) {
        return this.businessStrategyIndexRecordDAO.queryListDynamic(query);
    }

    public BusinessStrategyIndexRecordVO queryByKey(Long key) {
        BusinessStrategyIndexRecordDO entity = this.businessStrategyIndexRecordRepo.findById(key).orElseGet(BusinessStrategyIndexRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyIndexRecordVO vo = BusinessStrategyIndexRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyIndexRecordVO insert(BusinessStrategyIndexRecordPayload payload) {
        BusinessStrategyIndexRecordDO entityDo = BusinessStrategyIndexRecordConvert.INSTANCE.toDo(payload);
        return BusinessStrategyIndexRecordConvert.INSTANCE.toVo((BusinessStrategyIndexRecordDO)this.businessStrategyIndexRecordRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyIndexRecordVO update(BusinessStrategyIndexRecordPayload payload) {
        BusinessStrategyIndexRecordDO entity = this.businessStrategyIndexRecordRepo.findById(payload.getId()).orElseGet(BusinessStrategyIndexRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyIndexRecordDO entityDo = BusinessStrategyIndexRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyIndexRecordConvert.INSTANCE.toVo((BusinessStrategyIndexRecordDO)this.businessStrategyIndexRecordRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessStrategyIndexRecordPayload payload) {
        BusinessStrategyIndexRecordDO entity = this.businessStrategyIndexRecordRepo.findById(payload.getId()).orElseGet(BusinessStrategyIndexRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessStrategyIndexRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessStrategyIndexRecordDAO.deleteSoft(keys);
        }
    }

    public List<BusinessStrategyIndexRecordVO> queryListByCustomerId(Long customerId) {
        BusinessCustomerInfoVO businessCustomerInfoVO = this.businessCustomerInfoService.queryByKey(customerId);
        String indexInfo = businessCustomerInfoVO.getIndexInfo();
        if (StringUtils.isEmpty((CharSequence)indexInfo)) {
            return null;
        }
        List businessStrategyIndexRecordVOS = JSON.parseArray((String)indexInfo, BusinessStrategyIndexRecordVO.class);
        return businessStrategyIndexRecordVOS;
    }

    public BusinessStrategyIndexRecordServiceImpl(BusinessStrategyIndexRecordRepo businessStrategyIndexRecordRepo, BusinessStrategyIndexRecordDAO businessStrategyIndexRecordDAO, BusinessCustomerInfoService businessCustomerInfoService) {
        this.businessStrategyIndexRecordRepo = businessStrategyIndexRecordRepo;
        this.businessStrategyIndexRecordDAO = businessStrategyIndexRecordDAO;
        this.businessCustomerInfoService = businessCustomerInfoService;
    }
}

