/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.db.DbUtil;
import cn.hutool.db.sql.SqlExecutor;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.util.DataSourceUtil;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanVersionPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanVersionQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanVersionService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVersionVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanDaysService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PersonPlanConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanDao;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanDtlDao;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanDtlDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanDtlRepo;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PersonPlanServiceImpl
implements PersonPlanService {
    private static final Logger log = LoggerFactory.getLogger(PersonPlanServiceImpl.class);
    private final DataSourceUtil dataSource;
    private final PersonPlanDao personPlanDao;
    private final PersonPlanDtlDao personPlanDtlDao;
    private final PersonPlanRepo personPlanRepo;
    private final PersonPlanDtlService personPlanDtlService;
    private final PersonPlanDtlRepo personPlanDtlRepo;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    private final UdcUtil udcUtil;
    private final PersonPlanVersionService personPlanVersionService;
    private final PmsResourcePlanService pmsResourcePlanService;
    private final PmsResourcePlanRoleService pmsResourcePlanRoleService;
    private final PmsResourcePlanDaysService pmsResourcePlanDaysService;
    private static final BigDecimal hours = new BigDecimal(8);
    private static final BigDecimal jsonDay = BigDecimal.ONE;

    @Transactional(rollbackFor={Exception.class})
    public PersonPlanVO save(PersonPlanPayload personPlanPayload) {
        this.checkData(personPlanPayload);
        PersonPlanDO personPlanDO = new PersonPlanDO();
        personPlanDO = PersonPlanConvert.INSTANCE.p2d(personPlanPayload);
        personPlanDO.setModifyTime(LocalDateTime.now());
        PersonPlanDO res = (PersonPlanDO)((Object)this.personPlanRepo.save((Object)personPlanDO));
        PersonPlanVO personPlanVO = PersonPlanConvert.INSTANCE.d2v(res);
        this.personPlanDtlService.del(personPlanPayload.getDelIds());
        if (!CollectionUtils.isEmpty((Collection)personPlanPayload.getPersonPlanDtlPayloadList())) {
            personPlanPayload.getPersonPlanDtlPayloadList().stream().forEach(x -> x.setPlanId(res.getId()));
            List personPlanDtlVOS = this.personPlanDtlService.saveAll(personPlanPayload.getPersonPlanDtlPayloadList(), res.getId());
            personPlanVO.setPersonPlanDtlVOList(personPlanDtlVOS);
        }
        return personPlanVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PersonPlanVO updateAll(PersonPlanPayload personPlanPayload) {
        Assert.notNull((Object)personPlanPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PersonPlanVO res = this.save(personPlanPayload);
        return res;
    }

    public PersonPlanVO get(Long id) {
        if (null == id) {
            return null;
        }
        PersonPlanVO res = this.personPlanDao.get(id);
        if (null != res) {
            PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
            personPlanDtlQuery.setPlanId(res.getId());
            List<PersonPlanDtlVO> dtlList = this.personPlanDtlDao.getList(personPlanDtlQuery);
            if (CollUtil.isNotEmpty(dtlList)) {
                this.translateDtl(dtlList);
            }
            res.setPersonPlanDtlVOList(dtlList);
            if (StringUtils.hasText((String)res.getFileCodes())) {
                res.setFileDatas(this.fileUtil.getFileDatas(res.getFileCodes()));
            }
        }
        return res;
    }

    public PagingVO<PersonPlanVO> page(PersonPlanQuery personPlanQuery) {
        PagingVO<PersonPlanVO> res = this.personPlanDao.page(personPlanQuery);
        if (!CollectionUtils.isEmpty((Collection)res.getRecords())) {
            res.stream().forEach(p -> this.translate((PersonPlanVO)p));
        }
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.personPlanDao.del(ids);
        if (res != null && res > 0L) {
            this.personPlanDtlService.deleteByPlanIds(ids);
        }
        return res;
    }

    public List<PersonPlanVO> getList(PersonPlanQuery personPlanQuery) {
        List<PersonPlanVO> res = this.personPlanDao.getList(personPlanQuery);
        if (!CollectionUtils.isEmpty(res)) {
            res.stream().forEach(p -> this.translate((PersonPlanVO)p));
        }
        return res;
    }

    private void checkData(PersonPlanPayload personPlanPayload) {
        Assert.notEmpty((CharSequence)personPlanPayload.getUom(), (String)"\u5468\u671f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)personPlanPayload.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)personPlanPayload.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)personPlanPayload.getObjId(), (String)"\u5173\u8054\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(PersonPlanPayload personPlanPayload) {
        Assert.notNull((Object)personPlanPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.personPlanDao.update(personPlanPayload);
        return res;
    }

    public PersonPlanVO getByObjIdAndPlanType(Long objId, List<String> planTypeList) {
        PersonPlanVO res = null;
        if (planTypeList.contains(PersonPlanTypeEnum.PRE_SALES.getCode()) || planTypeList.contains(PersonPlanTypeEnum.DELIVERY.getCode())) {
            res = this.personPlanDao.queryOppo(objId, planTypeList);
        }
        if (planTypeList.contains(PersonPlanTypeEnum.BUDGET.getCode())) {
            res = this.personPlanDao.queryBudget(objId, planTypeList);
        }
        if (planTypeList.contains(PersonPlanTypeEnum.PROJECT.getCode())) {
            res = this.personPlanDao.queryProject(objId, planTypeList);
        }
        if (planTypeList.contains(PersonPlanTypeEnum.INNER_PROJECT.getCode())) {
            res = this.personPlanDao.queryInnerProject(objId, planTypeList);
        }
        if (null != res) {
            PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
            personPlanDtlQuery.setPlanId(res.getId());
            List dtlList = this.personPlanDtlService.getList(personPlanDtlQuery);
            if (CollUtil.isNotEmpty((Collection)dtlList)) {
                this.translateDtl(dtlList);
            }
            res.setPersonPlanDtlVOList(dtlList);
            if (StringUtils.hasText((String)res.getFileCodes())) {
                res.setFileDatas(this.fileUtil.getFileDatas(res.getFileCodes()));
            }
        }
        return res;
    }

    @Transactional
    public void saveNewVersion(PersonPlanPayload personPlanPayload) {
        PersonPlanVO personPlanVO = this.save(personPlanPayload);
        List personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
        personPlanVO = (PersonPlanVO)this.udcUtil.translate(personPlanVO);
        if (!CollectionUtils.isEmpty((Collection)personPlanDtlVOList)) {
            personPlanVO.setPersonPlanDtlVOList(this.udcUtil.translateList(personPlanDtlVOList));
        }
        String content = JSONUtil.toJsonStr((Object)personPlanVO);
        Object versionName = personPlanVO.getObjName();
        if (PersonPlanTypeEnum.PRE_SALES.getCode().equals(personPlanPayload.getPlanType()) || PersonPlanTypeEnum.DELIVERY.getCode().equals(personPlanPayload.getPlanType())) {
            String format = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            versionName = (String)versionName + "-" + personPlanPayload.getOppoSalePhaseName() + "-" + format;
            PersonPlanVersionQuery personPlanVersionQuery = new PersonPlanVersionQuery();
            personPlanVersionQuery.setPlanId(personPlanVO.getId());
            personPlanVersionQuery.setVersionName((String)versionName);
            List personPlanVersionVOS = this.personPlanVersionService.queryListDynamic(personPlanVersionQuery);
            if (CollectionUtils.isEmpty((Collection)personPlanVersionVOS)) {
                versionName = (String)versionName + "01";
            } else {
                PersonPlanVersionVO personPlanVersionVO = (PersonPlanVersionVO)personPlanVersionVOS.get(0);
                personPlanVersionVO.getVersionName();
                versionName = personPlanVersionVO.getVersionName().substring(0, personPlanVersionVO.getVersionName().length() - 2) + String.format("%02d", Integer.parseInt(personPlanVersionVO.getVersionName().substring(personPlanVersionVO.getVersionName().length() - 2)) + 1);
            }
        }
        PersonPlanVersionPayload personPlanVersionPayload = PersonPlanVersionPayload.builder().versionName((String)versionName).planId(personPlanVO.getId()).planType(personPlanVO.getPlanType()).objId(personPlanVO.getObjId()).changeContent(content).build();
        this.personPlanVersionService.save(personPlanVersionPayload);
    }

    public void transferData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDate(List<PersonPlanDO> personPlanDOList, List<PersonPlanDtlDO> personPlanDtlDOList) {
        long startTime;
        block12: {
            startTime = System.currentTimeMillis();
            if (CollectionUtils.isEmpty(personPlanDOList)) {
                return;
            }
            DataSource ds = this.dataSource.getDs();
            try {
                Connection conn;
                block11: {
                    conn = ds.getConnection();
                    try {
                        conn.setAutoCommit(false);
                        String sql = "INSERT INTO person_plan(id, start_date, end_date, duration, uom, version, tenant_id,  remark, create_user_id, creator, create_time, modify_user_id, updater, modify_time, delete_flag,obj_id, obj_name, plan_type, file_codes) \nVALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        int num = 0;
                        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                        for (PersonPlanDO personPlanDO : personPlanDOList) {
                            Object[] params = new Object[]{personPlanDO.getId(), personPlanDO.getStartDate(), personPlanDO.getEndDate(), personPlanDO.getDuration(), personPlanDO.getUom(), personPlanDO.getVersion(), "-1", personPlanDO.getRemark(), personPlanDO.getCreateUserId(), personPlanDO.getCreator(), personPlanDO.getCreateTime(), personPlanDO.getModifyUserId(), personPlanDO.getUpdater(), personPlanDO.getModifyTime(), 0, personPlanDO.getObjId(), personPlanDO.getObjName(), personPlanDO.getPlanType(), personPlanDO.getFileCodes()};
                            paramsList.add(params);
                            if (++num <= 1000) continue;
                            SqlExecutor.executeBatch((Connection)conn, (String)sql, paramsList);
                            conn.commit();
                            paramsList = new ArrayList();
                            num = 0;
                        }
                        SqlExecutor.executeBatch((Connection)conn, (String)sql, paramsList);
                        conn.commit();
                        log.info("\u8d44\u6e90\u89c4\u5212\u4e3b\u8868\u4fdd\u5b58\u5b8c\u6bd5\uff0c\u5f00\u59cb\u4fdd\u5b58\u8d44\u6e90\u89c4\u5212\u660e\u7ec6\u8868");
                        if (CollectionUtils.isEmpty(personPlanDtlDOList)) break block11;
                        String sql2 = "INSERT INTO person_plan_dtl(id, plan_id, price, days, amt, days_json, tenant_id,  remark, create_user_id, creator, create_time, modify_user_id, updater, modify_time, delete_flag, role_name, capaset_level_id, res_id, distribute_rate, total_eqva, hidden_flag, role_code) \nVALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        int num2 = 0;
                        ArrayList<Object[]> paramsList2 = new ArrayList<Object[]>();
                        for (PersonPlanDtlDO personPlanDtlDO : personPlanDtlDOList) {
                            ++num;
                            Object[] params = new Object[]{personPlanDtlDO.getId(), personPlanDtlDO.getPlanId(), personPlanDtlDO.getPrice(), personPlanDtlDO.getDays(), personPlanDtlDO.getAmt(), personPlanDtlDO.getDaysJson(), "-1", personPlanDtlDO.getRemark(), personPlanDtlDO.getCreateUserId(), personPlanDtlDO.getCreator(), personPlanDtlDO.getCreateTime(), personPlanDtlDO.getModifyUserId(), personPlanDtlDO.getUpdater(), personPlanDtlDO.getModifyTime(), 0, personPlanDtlDO.getRoleName(), personPlanDtlDO.getCapasetLevelId(), personPlanDtlDO.getResId(), personPlanDtlDO.getDistributeRate(), personPlanDtlDO.getTotalEqva(), personPlanDtlDO.getHiddenFlag(), personPlanDtlDO.getRoleCode()};
                            paramsList2.add(params);
                            if (num2 <= 1000) continue;
                            SqlExecutor.executeBatch((Connection)conn, (String)sql2, paramsList2);
                            conn.commit();
                            paramsList2 = new ArrayList();
                            num2 = 0;
                        }
                        SqlExecutor.executeBatch((Connection)conn, (String)sql2, paramsList2);
                        conn.commit();
                        log.info("\u8d44\u6e90\u89c4\u5212\u660e\u7ec6\u8868\u4fdd\u5b58\u5b8c\u6bd5");
                    }
                    catch (SQLException e) {
                        try {
                            log.error("SQL error!", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            DbUtil.close((Object[])new Object[]{conn});
                            throw throwable;
                        }
                        DbUtil.close((Object[])new Object[]{conn});
                        break block12;
                    }
                }
                DbUtil.close((Object[])new Object[]{conn});
            }
            catch (Exception e) {
                try {
                    log.error("sql error", (Throwable)e);
                    throw TwException.error("", "\u6570\u636e\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                catch (Throwable throwable) {
                    DbUtil.close((Object[])new Object[]{this.dataSource});
                    long endTime = System.currentTimeMillis();
                    log.info("\u6570\u636e\u5bfc\u5165\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
                    throw throwable;
                }
            }
        }
        DbUtil.close((Object[])new Object[]{this.dataSource});
        long endTime = System.currentTimeMillis();
        log.info("\u6570\u636e\u5bfc\u5165\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
    }

    private void translateDtl(List<PersonPlanDtlVO> dtlList) {
        dtlList.forEach(dtl -> {
            BigDecimal days = dtl.getDays();
            BigDecimal distributeRate = dtl.getDistributeRate();
            if (days != null && distributeRate != null) {
                dtl.setTotalEqva(distributeRate.multiply(days));
            } else {
                dtl.setTotalEqva(BigDecimal.ZERO);
            }
        });
    }

    private void translate(PersonPlanVO res) {
        if (StringUtils.hasText((String)res.getFileCodes())) {
            this.fileUtil.getFileDatas(res.getFileCodes());
        }
    }

    public static long getMonthsBetween(LocalDate startDate, LocalDate endDate) {
        return Math.abs(ChronoUnit.MONTHS.between(startDate, endDate));
    }

    public PersonPlanServiceImpl(DataSourceUtil dataSource, PersonPlanDao personPlanDao, PersonPlanDtlDao personPlanDtlDao, PersonPlanRepo personPlanRepo, PersonPlanDtlService personPlanDtlService, PersonPlanDtlRepo personPlanDtlRepo, FileUtil fileUtil, CacheUtil cacheUtil, UdcUtil udcUtil, PersonPlanVersionService personPlanVersionService, PmsResourcePlanService pmsResourcePlanService, PmsResourcePlanRoleService pmsResourcePlanRoleService, PmsResourcePlanDaysService pmsResourcePlanDaysService) {
        this.dataSource = dataSource;
        this.personPlanDao = personPlanDao;
        this.personPlanDtlDao = personPlanDtlDao;
        this.personPlanRepo = personPlanRepo;
        this.personPlanDtlService = personPlanDtlService;
        this.personPlanDtlRepo = personPlanDtlRepo;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.udcUtil = udcUtil;
        this.personPlanVersionService = personPlanVersionService;
        this.pmsResourcePlanService = pmsResourcePlanService;
        this.pmsResourcePlanRoleService = pmsResourcePlanRoleService;
        this.pmsResourcePlanDaysService = pmsResourcePlanDaysService;
    }
}

