/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummarySettingPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummarySettingQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSummarySettingService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummarySettingVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectSummarySettingConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectSummarySettingDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSummarySettingDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSummarySettingRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectSummarySettingServiceImpl
extends BaseServiceImpl
implements PmsProjectSummarySettingService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectSummarySettingServiceImpl.class);
    private final PmsProjectSummarySettingRepo pmsProjectSummarySettingRepo;
    private final PmsProjectSummarySettingDAO pmsProjectSummarySettingDAO;
    private final PmsProjectService pmsProjectService;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService systemRoleService;

    public PagingVO<PmsProjectSummarySettingVO> queryPaging(PmsProjectSummarySettingQuery query) {
        PagingVO<PmsProjectSummarySettingVO> pmsProjectSummarySettingVOPagingVO = this.pmsProjectSummarySettingDAO.queryPaging(query);
        List records = pmsProjectSummarySettingVOPagingVO.getRecords();
        for (PmsProjectSummarySettingVO record : records) {
            this.translate(record);
        }
        return pmsProjectSummarySettingVOPagingVO;
    }

    public List<PmsProjectSummarySettingVO> queryListDynamic(PmsProjectSummarySettingQuery query) {
        List<PmsProjectSummarySettingVO> records = this.pmsProjectSummarySettingDAO.queryListDynamic(query);
        for (PmsProjectSummarySettingVO record : records) {
            this.translate(record);
        }
        return records;
    }

    private void translate(PmsProjectSummarySettingVO record) {
        if (StringUtils.hasText((String)record.getSummaryUsers())) {
            ArrayList<String> userNames = new ArrayList<String>();
            for (String sourceId : record.getSummaryUsers().split(",")) {
                String userName = this.cacheUtil.getUserName(Long.parseLong(sourceId));
                userNames.add(userName);
            }
            String userName = String.join((CharSequence)",", userNames);
            record.setSummaryUsersName(userName);
        }
    }

    private void addMenu(String users) {
        if (StringUtils.hasText((String)users)) {
            List userList = Arrays.stream(users.split(",")).map(Long::parseLong).collect(Collectors.toList());
            this.systemRoleService.addUserMenu(userList, "PROJECT_SYMMARY_RES");
        }
    }

    public PmsProjectSummarySettingVO queryByKey(Long key) {
        PmsProjectSummarySettingDO entity = this.pmsProjectSummarySettingRepo.findById(key).orElseGet(PmsProjectSummarySettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectSummarySettingVO vo = PmsProjectSummarySettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectSummarySettingVO insert(PmsProjectSummarySettingPayload payload) {
        PmsProjectSummarySettingDO entityDo = PmsProjectSummarySettingConvert.INSTANCE.toDo(payload);
        PmsProjectSummarySettingVO pmsProjectSummarySettingVO = PmsProjectSummarySettingConvert.INSTANCE.toVo((PmsProjectSummarySettingDO)this.pmsProjectSummarySettingRepo.save(entityDo));
        return pmsProjectSummarySettingVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectSummarySettingVO update(PmsProjectSummarySettingPayload payload) {
        PmsProjectSummarySettingDO entity = this.pmsProjectSummarySettingRepo.findById(payload.getId()).orElseGet(PmsProjectSummarySettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectSummarySettingDO entityDo = PmsProjectSummarySettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PmsProjectSummarySettingVO pmsProjectSummarySettingVO = PmsProjectSummarySettingConvert.INSTANCE.toVo((PmsProjectSummarySettingDO)this.pmsProjectSummarySettingRepo.save(entity));
        return pmsProjectSummarySettingVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectSummarySettingPayload payload) {
        PmsProjectSummarySettingDO entity = this.pmsProjectSummarySettingRepo.findById(payload.getId()).orElseGet(PmsProjectSummarySettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectSummarySettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectSummarySettingDAO.deleteSoft(keys);
        }
    }

    public List<PmsProjectVO> queryProjList(Long pmResId, String workType) {
        List<Object> pmsProjectVOS = new ArrayList<PmsProjectVO>();
        Long userId = GlobalUtil.getLoginUserId();
        PmsProjectSummarySettingQuery query = new PmsProjectSummarySettingQuery();
        query.setSummaryUsers(userId.toString());
        List<PmsProjectSummarySettingVO> pmsProjectSummarySettingVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(pmsProjectSummarySettingVOS)) {
            List deliOrgList = pmsProjectSummarySettingVOS.stream().map(e -> e.getDeliOrgId()).collect(Collectors.toList());
            PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
            pmsProjectQuery.setDeliBuIds(deliOrgList);
            if (!ObjectUtils.isEmpty((Object)pmResId)) {
                pmsProjectQuery.setPmResId(pmResId);
            }
            if (!ObjectUtils.isEmpty((Object)workType)) {
                pmsProjectQuery.setWorkType(workType);
            }
            pmsProjectVOS = this.pmsProjectService.queryListDynamic(pmsProjectQuery);
        }
        return pmsProjectVOS;
    }

    public PmsProjectSummarySettingServiceImpl(PmsProjectSummarySettingRepo pmsProjectSummarySettingRepo, PmsProjectSummarySettingDAO pmsProjectSummarySettingDAO, PmsProjectService pmsProjectService, CacheUtil cacheUtil, PrdSystemRoleService systemRoleService) {
        this.pmsProjectSummarySettingRepo = pmsProjectSummarySettingRepo;
        this.pmsProjectSummarySettingDAO = pmsProjectSummarySettingDAO;
        this.pmsProjectService = pmsProjectService;
        this.cacheUtil = cacheUtil;
        this.systemRoleService = systemRoleService;
    }
}

