/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.LatePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementPaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.LatePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.WriteOffPaymentApplyVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchasePaymentPlanConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentPlanDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentPlanDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentPlanRepo;
import com.querydsl.core.Tuple;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchasePaymentPlanServiceImpl
extends BaseServiceImpl
implements PurchasePaymentPlanService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentPlanServiceImpl.class);
    private final PurchasePaymentPlanRepo purchasePaymentPlanRepo;
    private final PurchasePaymentPlanDAO purchasePaymentPlanDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final BusinessPartnerService businessPartnerService;
    @Autowired
    private PurchasePaymentService purchasePaymentService;
    @Autowired
    private final PaymentSlipService paymentSlipService;

    public PagingVO<PurchasePaymentPlanVO> queryPaging(PurchasePaymentPlanQuery query) {
        return this.purchasePaymentPlanDAO.queryPaging(query);
    }

    public List<PurchasePaymentPlanVO> queryListDynamic(PurchasePaymentPlanQuery query) {
        return this.purchasePaymentPlanDAO.queryListDynamic(query);
    }

    public PurchasePaymentPlanVO queryByKey(Long key) {
        PurchasePaymentPlanDO entity = this.purchasePaymentPlanRepo.findById(key).orElseGet(PurchasePaymentPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchasePaymentPlanVO vo = PurchasePaymentPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchasePaymentPlanVO insert(PurchasePaymentPlanPayload payload) {
        PurchasePaymentPlanDO entityDo = PurchasePaymentPlanConvert.INSTANCE.toDo(payload);
        PurchasePaymentPlanDO save = (PurchasePaymentPlanDO)this.purchasePaymentPlanRepo.save(entityDo);
        String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo);
        this.logService.saveNewLog(save.getId(), PrdSystemObjectEnum.PROCUREMENT_PAYPLAN.getCode(), fieldsCreateLog);
        return PurchasePaymentPlanConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchasePaymentPlanVO update(PurchasePaymentPlanPayload payload) {
        PurchasePaymentPlanDO entity = this.purchasePaymentPlanRepo.findById(payload.getId()).orElseGet(PurchasePaymentPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchasePaymentPlanDO entityDo = PurchasePaymentPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PurchasePaymentPlanConvert.INSTANCE.toVo((PurchasePaymentPlanDO)this.purchasePaymentPlanRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.purchasePaymentPlanDAO.deleteSoft(keys);
        }
    }

    public List<PurchasePaymentPlanVO> findListByConNo(String docNo, Boolean applyIdIsNull) {
        return this.purchasePaymentPlanDAO.findListByConNo(docNo, applyIdIsNull);
    }

    public List<PurchasePaymentPlanVO> queryListByPaymentApplyId(Long paymentApplyId) {
        return this.purchasePaymentPlanDAO.queryListByPaymentApplyId(paymentApplyId);
    }

    public void setPaymentApplyVOPlanList(PurchasePaymentVO purchasePaymentVO) {
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = this.purchasePaymentPlanDAO.queryListByPaymentApplyId(purchasePaymentVO.getId());
        if (CollectionUtils.isEmpty(purchasePaymentPlanVOS)) {
            return;
        }
        if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY_WRITE_OFF.getCode().equals(purchasePaymentVO.getPaymentApplicationType())) {
            ArrayList<Long> prePaymentPlanIds = new ArrayList<Long>(purchasePaymentPlanVOS.size());
            purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                Long prePaymentPlanId = purchasePaymentPlanVO.getPrePaymentPlanId();
                if (prePaymentPlanId != null) {
                    prePaymentPlanIds.add(prePaymentPlanId);
                }
            });
            Map<Long, BigDecimal> writeOffAmtMap = this.findWriteOffAmtByPrePaymentPlanIdIn(prePaymentPlanIds);
            purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                BigDecimal paymentAmt = purchasePaymentPlanVO.getPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getPaymentAmt();
                BigDecimal writeOffAmt = (BigDecimal)writeOffAmtMap.get(purchasePaymentPlanVO.getPrePaymentPlanId());
                writeOffAmt = writeOffAmt == null ? BigDecimal.ZERO : writeOffAmt;
                purchasePaymentPlanVO.setAlreadyWriteOffAmt(writeOffAmt);
                purchasePaymentPlanVO.setNoWriteOffAmt(paymentAmt.subtract(writeOffAmt));
            });
        } else if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentVO.getPaymentApplicationType())) {
            this.setWriteOffAmtAndPlans(purchasePaymentPlanVOS);
        }
        purchasePaymentVO.setPurchasePaymentPlanVOS(purchasePaymentPlanVOS);
    }

    private Map<Long, BigDecimal> findWriteOffAmtByPrePaymentPlanIdIn(List<Long> prePaymentPlanIds) {
        List<Tuple> writeOffAmtList;
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        if (!CollectionUtils.isEmpty(prePaymentPlanIds) && !CollectionUtils.isEmpty(writeOffAmtList = this.purchasePaymentPlanDAO.findWriteOffAmtByPrePaymentPlanIdIn(prePaymentPlanIds))) {
            writeOffAmtList.forEach(tuple -> {
                Long prePaymentPlanId = (Long)tuple.get(0, Long.class);
                BigDecimal writeOffAmt = tuple.get(1, BigDecimal.class) == null ? BigDecimal.ZERO : (BigDecimal)tuple.get(1, BigDecimal.class);
                resultMap.put(prePaymentPlanId, writeOffAmt);
            });
        }
        return resultMap;
    }

    public void resettingPlanByPaymentId(Long paymentApplyId) {
        this.purchasePaymentPlanDAO.resettingPlanByPaymentId(paymentApplyId);
    }

    public void updatePlans(List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads) {
        purchasePaymentPlanPayloads.forEach(this.purchasePaymentPlanDAO::updatePlan);
    }

    public void insertAll(List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads) {
        ArrayList purchasePaymentPlanDOS = new ArrayList();
        purchasePaymentPlanPayloads.forEach(purchasePaymentPlanPayload -> {
            PurchasePaymentPlanDO purchasePaymentPlanDO = PurchasePaymentPlanConvert.INSTANCE.toDo((PurchasePaymentPlanPayload)purchasePaymentPlanPayload);
            purchasePaymentPlanDOS.add(purchasePaymentPlanDO);
        });
        this.purchasePaymentPlanRepo.saveAll(purchasePaymentPlanDOS);
    }

    public void deleteByPaymentId(Long id) {
        this.purchasePaymentPlanDAO.deleteByPaymentId(id);
    }

    public PagingVO<LatePaymentPlanVO> findLatePaymentPlanList(LatePaymentPlanQuery latePaymentPlanQuery) {
        PagingVO<LatePaymentPlanVO> latePaymentPlanList = this.purchasePaymentPlanDAO.findLatePaymentPlanList(latePaymentPlanQuery);
        this.translateBusinessPartner(latePaymentPlanList.getRecords());
        return latePaymentPlanList;
    }

    public PagingVO<PurchasePaymentPlanVO> findPlanListByAgreementNo(PurchaseAgreementPaymentQuery query) {
        PagingVO<PurchasePaymentPlanVO> planListByAgreementNo = this.purchasePaymentPlanDAO.findPlanListByAgreementNo(query);
        List records = planListByAgreementNo.getRecords();
        this.setWriteOffAmtAndPlans(records);
        return planListByAgreementNo;
    }

    public List<PurchasePaymentPlanVO> findPlanListByConOrAgreementNoAndPrePaymentNo(String conOrAgreementNo, String prePaymentNo) {
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = this.purchasePaymentPlanDAO.findPlanListByConOrAgreementNoAndPrePaymentNo(conOrAgreementNo, prePaymentNo);
        this.setWriteOffAmtAndPlans(purchasePaymentPlanVOS);
        return purchasePaymentPlanVOS;
    }

    public List<PurchasePaymentPlanVO> queryListByConId(Long purConId, Boolean isIgnoreWriteOff) {
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = this.purchasePaymentPlanDAO.queryListByConId(purConId, isIgnoreWriteOff);
        this.setWriteOffAmtAndPlans(purchasePaymentPlanVOS);
        return purchasePaymentPlanVOS;
    }

    private void translateBusinessPartner(List<LatePaymentPlanVO> result) {
        ArrayList bookIdList = new ArrayList();
        result.forEach(latePaymentPlanVO -> bookIdList.add(latePaymentPlanVO.getSupplierBookId()));
        Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
        result.forEach(latePaymentPlanVO -> latePaymentPlanVO.setSupplierName((String)nameByBookIds.get(latePaymentPlanVO.getSupplierBookId())));
    }

    private void setWriteOffAmtAndPlansOld(List<PurchasePaymentPlanVO> purchasePaymentPlanVOS) {
        ArrayList prePaymentApplyNoList = new ArrayList();
        purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
            if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentPlanVO.getPaymentApplicationType())) {
                prePaymentApplyNoList.add(purchasePaymentPlanVO.getPaymentApplyNo());
            }
        });
        if (!CollectionUtils.isEmpty(prePaymentApplyNoList)) {
            Map writeOffMap = this.purchasePaymentService.findWriteOffByPrePaymentNoList(prePaymentApplyNoList);
            purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                List writeOffPaymentApplyVOS = (List)writeOffMap.get(purchasePaymentPlanVO.getPaymentApplyNo());
                if (!CollectionUtils.isEmpty((Collection)writeOffPaymentApplyVOS)) {
                    purchasePaymentPlanVO.setWriteOffAmtPaymentApplyVOS(writeOffPaymentApplyVOS);
                    BigDecimal alreadyWrittenOffAmount = BigDecimal.ZERO;
                    BigDecimal paymentAmt = purchasePaymentPlanVO.getPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getPaymentAmt();
                    for (WriteOffPaymentApplyVO writeOffPaymentApplyVO : writeOffPaymentApplyVOS) {
                        if (!PurchasePaymentEnum.PaymentStatus.APPROVED.getCode().equals(writeOffPaymentApplyVO.getState())) continue;
                        BigDecimal currCurrPaymentAmt = writeOffPaymentApplyVO.getCurrPaymentAmt() == null ? BigDecimal.ZERO : writeOffPaymentApplyVO.getCurrPaymentAmt();
                        alreadyWrittenOffAmount = alreadyWrittenOffAmount.add(currCurrPaymentAmt);
                    }
                    purchasePaymentPlanVO.setAlreadyWriteOffAmt(alreadyWrittenOffAmount);
                    purchasePaymentPlanVO.setNoWriteOffAmt(paymentAmt.subtract(alreadyWrittenOffAmount));
                }
            });
        }
    }

    private void setWriteOffAmtAndPlans(List<PurchasePaymentPlanVO> purchasePaymentPlanVOS) {
        ArrayList prePaymentPlanVOList = new ArrayList();
        ArrayList<Long> prePaymentPlanId = new ArrayList<Long>();
        HashSet paymentApplyIdSet = new HashSet();
        purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
            if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(purchasePaymentPlanVO.getPaymentApplicationType())) {
                prePaymentPlanVOList.add(purchasePaymentPlanVO);
                prePaymentPlanId.add(purchasePaymentPlanVO.getId());
                paymentApplyIdSet.add(purchasePaymentPlanVO.getPaymentApplyId());
            }
        });
        if (!CollectionUtils.isEmpty(prePaymentPlanVOList)) {
            List<PurchasePaymentPlanVO> writeOffPlanVOS = this.purchasePaymentPlanDAO.queryListByPrePaymentPlanId(prePaymentPlanId);
            Map<Long, List<PurchasePaymentPlanVO>> writeOffMap = writeOffPlanVOS.stream().collect(Collectors.groupingBy(PurchasePaymentPlanVO::getPrePaymentPlanId));
            Map noPayAmtMap = this.paymentSlipService.findNoPayAmtByPaymentApplyIdIn(paymentApplyIdSet);
            prePaymentPlanVOList.forEach(purchasePaymentPlanVO -> {
                BigDecimal currentPaymentAmt;
                List writeOffPaymentPlanVOS = (List)writeOffMap.get(purchasePaymentPlanVO.getId());
                BigDecimal[] alreadyWriteOffAmt = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal bigDecimal = currentPaymentAmt = purchasePaymentPlanVO.getCurrentPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getCurrentPaymentAmt();
                if (!CollectionUtils.isEmpty((Collection)writeOffPaymentPlanVOS)) {
                    ArrayList writeOffPaymentApplyVOS = new ArrayList();
                    Map<Long, List<PurchasePaymentPlanVO>> writeOffPaymentPlanMap = writeOffPaymentPlanVOS.stream().collect(Collectors.groupingBy(PurchasePaymentPlanVO::getPaymentApplyId));
                    writeOffPaymentPlanMap.values().forEach(writeOffPlanVOList -> {
                        WriteOffPaymentApplyVO writeOffPaymentApplyVO = new WriteOffPaymentApplyVO();
                        writeOffPlanVOList.forEach(writeOffPlan -> {
                            writeOffPaymentApplyVO.setPaymentNo(writeOffPlan.getPaymentApplyNo());
                            writeOffPaymentApplyVO.setId(writeOffPlan.getPaymentApplyId());
                            alreadyWriteOffAmt[0] = alreadyWriteOffAmt[0].add(writeOffPlan.getCurrentPaymentAmt());
                        });
                        writeOffPaymentApplyVO.setCurrPaymentAmt(alreadyWriteOffAmt[0]);
                        writeOffPaymentApplyVOS.add(writeOffPaymentApplyVO);
                    });
                    purchasePaymentPlanVO.setWriteOffAmtPaymentApplyVOS(writeOffPaymentApplyVOS);
                }
                purchasePaymentPlanVO.setAlreadyWriteOffAmt(alreadyWriteOffAmt[0]);
                BigDecimal noPayAmt = noPayAmtMap.get(purchasePaymentPlanVO.getPaymentApplyId()) == null ? BigDecimal.ZERO : (BigDecimal)noPayAmtMap.get(purchasePaymentPlanVO.getPaymentApplyId());
                purchasePaymentPlanVO.setNoWriteOffAmt(currentPaymentAmt.subtract(alreadyWriteOffAmt[0]).subtract(noPayAmt));
            });
        }
    }

    public BigDecimal findWriteOffAmtByPrePaymentNo(String prePaymentNo) {
        return this.purchasePaymentPlanDAO.findWriteOffAmtByPrePaymentNo(prePaymentNo);
    }

    public PurchasePaymentPlanServiceImpl(PurchasePaymentPlanRepo purchasePaymentPlanRepo, PurchasePaymentPlanDAO purchasePaymentPlanDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, BusinessPartnerService businessPartnerService, PaymentSlipService paymentSlipService) {
        this.purchasePaymentPlanRepo = purchasePaymentPlanRepo;
        this.purchasePaymentPlanDAO = purchasePaymentPlanDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.businessPartnerService = businessPartnerService;
        this.paymentSlipService = paymentSlipService;
    }
}

