/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemShortcutPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemShortcutQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutJsonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.PrdOrgEmployeeConfigTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdOrgEmployeeConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdSystemShortcutIconTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemShortcutConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemShortcutDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemShortcutDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemShortcutRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdSystemShortcutServiceImpl
extends BaseServiceImpl
implements PrdSystemShortcutService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemShortcutServiceImpl.class);
    private final PrdSystemShortcutRepo prdSystemShortcutRepo;
    private final PrdSystemShortcutDAO prdSystemShortcutDAO;
    private final CacheUtil cacheUtil;
    private final String SHORTCUT_PREFIX = "/cloudt/system/com/file/v1/";
    private final String SHORTCUT_SUFFIX = "/show";
    private final PrdOrgEmployeeConfigDAO prdOrgEmployeeConfigDAO;
    private final FileUtil fileUtil;

    public PagingVO<PrdSystemShortcutVO> queryPaging(PrdSystemShortcutQuery query) {
        return this.prdSystemShortcutDAO.queryPaging(query);
    }

    public List<PrdSystemShortcutVO> queryListDynamic(PrdSystemShortcutQuery query) {
        return this.prdSystemShortcutDAO.queryListDynamic(query);
    }

    public PrdSystemShortcutVO queryByKey(Long key) {
        PrdSystemShortcutDO entity = this.prdSystemShortcutRepo.findById(key).orElseGet(PrdSystemShortcutDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemShortcutVO vo = PrdSystemShortcutConvert.INSTANCE.toVo(entity);
        vo.setShortcutIconData(this.fileUtil.getFileDatas(vo.getShortcutIcon()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemShortcutVO insert(PrdSystemShortcutPayload payload) {
        PrdSystemShortcutDO entityDo = PrdSystemShortcutConvert.INSTANCE.toDo(payload);
        return PrdSystemShortcutConvert.INSTANCE.toVo((PrdSystemShortcutDO)this.prdSystemShortcutRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemShortcutVO update(PrdSystemShortcutPayload payload) {
        PrdSystemShortcutDO entity = this.prdSystemShortcutRepo.findById(payload.getId()).orElseGet(PrdSystemShortcutDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemShortcutDO entityDo = PrdSystemShortcutConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdSystemShortcutConvert.INSTANCE.toVo((PrdSystemShortcutDO)this.prdSystemShortcutRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PrdSystemShortcutPayload payload) {
        PrdSystemShortcutDO entity = this.prdSystemShortcutRepo.findById(payload.getId()).orElseGet(PrdSystemShortcutDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.prdSystemShortcutDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdSystemShortcutDAO.deleteSoft(keys);
        }
    }

    public PrdUserDataVO queryAllIcon() {
        PrdOrgEmployeeConfigVO prdOrgEmployeeConfigVO;
        String contentJson;
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeConfigQuery query = new PrdOrgEmployeeConfigQuery();
        query.setUserId(loginUserId);
        query.setConfigType("icon");
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = this.queryEmployeeConfigListDynamic(query);
        List prdSystemShortcutJsonVOSFromEmployeeConfig = new ArrayList();
        if (!prdOrgEmployeeConfigVOS.isEmpty() && StringUtils.hasText((String)(contentJson = (prdOrgEmployeeConfigVO = prdOrgEmployeeConfigVOS.get(0)).getContentJson()))) {
            prdSystemShortcutJsonVOSFromEmployeeConfig = JSON.parseArray((String)contentJson, PrdSystemShortcutJsonVO.class);
        }
        PrdSystemShortcutQuery prdSystemShortcutQuery = new PrdSystemShortcutQuery();
        prdSystemShortcutQuery.setShortcutStatus(Integer.valueOf(1));
        List<PrdSystemShortcutVO> shortcutVOs = this.prdSystemShortcutDAO.queryListDynamic(prdSystemShortcutQuery);
        Set configNames = prdSystemShortcutJsonVOSFromEmployeeConfig.stream().map(e -> e.getTitle()).collect(Collectors.toSet());
        shortcutVOs.removeIf(obj -> configNames.contains(obj.getShortcutName()));
        PrdUserDataVO vo = new PrdUserDataVO();
        if (!CollectionUtils.isEmpty(shortcutVOs)) {
            Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            ArrayList prdSystemShortcutJsonVOS = new ArrayList();
            shortcutVOs.stream().forEach(shortcutVO -> {
                if (!rolePermission.booleanValue() && shortcutVO.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())) {
                    return;
                }
                PrdSystemShortcutJsonVO prdSystemShortcutJsonVO = new PrdSystemShortcutJsonVO();
                prdSystemShortcutJsonVO.setType(shortcutVO.getType());
                prdSystemShortcutJsonVO.setFixFlag(shortcutVO.getFixFlag());
                prdSystemShortcutJsonVO.setIcon("/cloudt/system/com/file/v1/" + shortcutVO.getShortcutIcon() + "/show");
                prdSystemShortcutJsonVO.setTitle(shortcutVO.getShortcutName());
                prdSystemShortcutJsonVO.setBadge("");
                prdSystemShortcutJsonVO.setShowBadgeFlag(Boolean.valueOf(false));
                prdSystemShortcutJsonVO.setExt1("");
                prdSystemShortcutJsonVO.setExt2("");
                prdSystemShortcutJsonVO.setExt3("");
                prdSystemShortcutJsonVOS.add(prdSystemShortcutJsonVO);
            });
            prdSystemShortcutJsonVOSFromEmployeeConfig.addAll(prdSystemShortcutJsonVOS);
        }
        if (!CollectionUtils.isEmpty(prdSystemShortcutJsonVOSFromEmployeeConfig)) {
            vo.setShortcutJson(JSON.toJSONString(prdSystemShortcutJsonVOSFromEmployeeConfig));
        }
        return vo;
    }

    private List<PrdOrgEmployeeConfigVO> queryEmployeeConfigListDynamic(PrdOrgEmployeeConfigQuery query) {
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = this.prdOrgEmployeeConfigDAO.queryListDynamic(query);
        if (PrdOrgEmployeeConfigTypeEnum.icon.getCode().equals(query.getConfigType())) {
            Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            if (!CollectionUtils.isEmpty(prdOrgEmployeeConfigVOS)) {
                prdOrgEmployeeConfigVOS.forEach(vo -> {
                    if (StringUtils.hasText((String)vo.getContentJson())) {
                        boolean match;
                        PrdSystemShortcutQuery prdSystemShortcutQuery = new PrdSystemShortcutQuery();
                        if (rolePermission.booleanValue()) {
                            prdSystemShortcutQuery.setTypeList(Arrays.asList(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode(), PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode()));
                        } else {
                            prdSystemShortcutQuery.setType(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode());
                        }
                        prdSystemShortcutQuery.setShortcutStatus(Integer.valueOf(1));
                        List<PrdSystemShortcutVO> prdSystemShortcutVOS = this.queryListDynamic(prdSystemShortcutQuery);
                        List prdSystemShortcutJsonVOS = JSON.parseArray((String)vo.getContentJson(), PrdSystemShortcutJsonVO.class);
                        PrdSystemShortcutVO moreFunctionShortcutVO = prdSystemShortcutVOS.stream().filter(item -> item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())).findFirst().orElse(null);
                        if (moreFunctionShortcutVO != null) {
                            PrdSystemShortcutJsonVO moreFunctionVO = new PrdSystemShortcutJsonVO();
                            moreFunctionVO.setType(moreFunctionShortcutVO.getType());
                            moreFunctionVO.setFixFlag(moreFunctionShortcutVO.getFixFlag());
                            moreFunctionVO.setIcon("/cloudt/system/com/file/v1/" + moreFunctionShortcutVO.getShortcutIcon() + "/show");
                            moreFunctionVO.setTitle(moreFunctionShortcutVO.getShortcutName());
                            moreFunctionVO.setBadge("");
                            moreFunctionVO.setShowBadgeFlag(Boolean.valueOf(false));
                            moreFunctionVO.setExt1("");
                            moreFunctionVO.setExt2("");
                            moreFunctionVO.setExt3("");
                            prdSystemShortcutJsonVOS.add(11, moreFunctionVO);
                        }
                        if (rolePermission.booleanValue() && !(match = prdSystemShortcutJsonVOS.stream().anyMatch(p -> p.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())))) {
                            PrdSystemShortcutJsonVO prdSystemShortcutJsonVO = new PrdSystemShortcutJsonVO();
                            PrdSystemShortcutVO businessPartnerShortcutVO = prdSystemShortcutVOS.stream().filter(item -> item.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())).findFirst().orElse(null);
                            prdSystemShortcutJsonVO.setType(businessPartnerShortcutVO.getType());
                            prdSystemShortcutJsonVO.setFixFlag(businessPartnerShortcutVO.getFixFlag());
                            prdSystemShortcutJsonVO.setIcon("/cloudt/system/com/file/v1/" + businessPartnerShortcutVO.getShortcutIcon() + "/show");
                            prdSystemShortcutJsonVO.setTitle(businessPartnerShortcutVO.getShortcutName());
                            prdSystemShortcutJsonVO.setBadge("");
                            prdSystemShortcutJsonVO.setShowBadgeFlag(Boolean.valueOf(false));
                            prdSystemShortcutJsonVO.setExt1("");
                            prdSystemShortcutJsonVO.setExt2("");
                            prdSystemShortcutJsonVO.setExt3("");
                            prdSystemShortcutJsonVOS.add(prdSystemShortcutJsonVO);
                        }
                        vo.setContentJson(JSON.toJSONString((Object)prdSystemShortcutJsonVOS));
                    }
                });
            }
            return prdOrgEmployeeConfigVOS;
        }
        return prdOrgEmployeeConfigVOS;
    }

    public PrdSystemShortcutServiceImpl(PrdSystemShortcutRepo prdSystemShortcutRepo, PrdSystemShortcutDAO prdSystemShortcutDAO, CacheUtil cacheUtil, PrdOrgEmployeeConfigDAO prdOrgEmployeeConfigDAO, FileUtil fileUtil) {
        this.prdSystemShortcutRepo = prdSystemShortcutRepo;
        this.prdSystemShortcutDAO = prdSystemShortcutDAO;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeConfigDAO = prdOrgEmployeeConfigDAO;
        this.fileUtil = fileUtil;
    }
}

