/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.BuProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import com.elitesland.tw.tw5.server.prd.task.common.AcceptMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.common.PricingMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskInfoConvert;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskPackageConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskSettleTimesheetDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskSettleTimesheetDO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskCommonServiceImpl
extends BaseServiceImpl
implements TaskCommonService {
    private static final Logger log = LoggerFactory.getLogger(TaskCommonServiceImpl.class);
    private final TaskInfoDAO taskInfoDAO;
    private final TaskPackageDAO taskPackageDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final BuProjectDAO buProjectDAO;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;
    private final CalResourceService calResourceService;
    private final CacheUtil cacheUtil;
    private final PmsProjectMembersDAO pmsProjectMembersDAO;
    private final TimesheetDAO timesheetDAO;
    private final TaskSettleTimesheetDAO taskSettleTimesheetDAO;

    public List<TaskInfoVO> queryTaskByReason(String reasonType, Long reasonId) {
        return this.taskInfoDAO.queryTaskByReason(reasonType, reasonId);
    }

    public List<TaskPackageVO> queryTaskPackageList(TaskPackageQuery taskPackageQuery) {
        return this.taskPackageDAO.queryListDynamic(taskPackageQuery);
    }

    public long taskPackageCount(TaskPackageQuery taskPackageQuery) {
        return this.taskPackageDAO.count(taskPackageQuery);
    }

    TaskInfoVO checkData(TimesheetPayload timesheetPayload, Long taskId, Long userId, BigDecimal workHour, String type) {
        List<String> statuss;
        if (workHour == null || workHour.compareTo(BigDecimal.ZERO) == 0 || taskId == null) {
            throw TwException.error("", "\u5de5\u65f6\u6570\u636e\u4e0d\u5408\u89c4");
        }
        log.info("\u5de5\u65f6\u63d0\u4ea4\u6216\u5ba1\u6279\u64cd\u4f5c\u8c03\u7528\u53c2\u6570\uff1a \n taskId:", (Object)(taskId + " \n workHour:" + workHour + "\n type\uff1a" + type));
        TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey(taskId);
        if (taskInfoVO == null) {
            throw TwException.error("", "\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (!userId.equals(taskInfoVO.getTaskResId())) {
            throw TwException.error("", "\u4efb\u52a1\u8d1f\u8d23\u4eba\u548c\u5de5\u65f6\u586b\u5199\u4eba\u4e0d\u5339\u914d");
        }
        if (!(!type.equals("1") || workHour.compareTo(BigDecimal.ZERO) <= 0 || StringUtils.hasText((String)taskInfoVO.getSourceType()) && TaskSourceTypeEnum.REWARD.getCode().equals(taskInfoVO.getSourceType()) || (statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode())).contains(taskInfoVO.getTaskStatus()))) {
            throw TwException.error("", taskInfoVO.getTaskName() + "-\u4efb\u52a1\u4e0d\u53ef\u7528");
        }
        if (taskInfoVO.getEqvaRatio() == null) {
            LocalDate searchDate = null;
            if (null != timesheetPayload && null != timesheetPayload.getWorkDate()) {
                searchDate = timesheetPayload.getWorkDate();
            }
            BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(userId, searchDate);
            taskInfoVO.setEqvaRatio(eqvaRatio);
        }
        if (taskInfoVO.getEqvaRatio() == null) {
            throw TwException.error("", "\u5f53\u91cf\u7cfb\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return taskInfoVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTimeSheet(TimesheetPayload timesheetPayload, Long taskId, Long userId, BigDecimal workHour, String type) {
        TaskInfoVO taskInfoVO = this.checkData(timesheetPayload, taskId, userId, workHour, type);
        LocalDate localDate = DateUtil.strToLocalDate("2024-08-10");
        LocalDate now = LocalDate.now();
        Boolean isCheckRef = false;
        if (now.isAfter(localDate)) {
            isCheckRef = true;
        }
        boolean isForward = true;
        if (workHour.compareTo(BigDecimal.ZERO) < 0) {
            isForward = false;
        }
        BigDecimal divide = workHour.divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
        BigDecimal upEqva = divide.multiply(taskInfoVO.getEqvaRatio()).abs();
        TaskSettleTimesheetVO taskSettleTimesheetVO = this.taskSettleTimesheetDAO.queryByTimesheetId(timesheetPayload.getId());
        if (taskSettleTimesheetVO != null && taskSettleTimesheetVO.getEqva() != null) {
            upEqva = taskSettleTimesheetVO.getEqva();
        }
        BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
        BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(taskId);
        BigDecimal newUsedEqva = null;
        if (type.equals("1")) {
            if (isForward) {
                PrdSystemSettingVO settingVO;
                newUsedEqva = usedEqva.add(upEqva);
                if (!(newUsedEqva.compareTo(taskInfoVO.getTotalEqva()) <= 0 || (settingVO = this.cacheUtil.getSystemSetting(SystemSettingsItemEnum.prj_member_init_task.getCode())) != null && StringUtils.hasText((String)settingVO.getSettingValue()) && "true".equals(settingVO.getSettingValue()))) {
                    throw TwException.error("", "\u4efb\u52a1\u5269\u4f59\u5f53\u91cf\u4e0d\u8db3");
                }
                if (taskSettleTimesheetVO != null) {
                    throw TwException.error("", "\u8be5\u5de5\u65f6\u91cd\u590d\u63d0\u4ea4");
                }
                TaskSettleTimesheetDO timesheetDO = new TaskSettleTimesheetDO();
                timesheetDO.setEqva(upEqva);
                timesheetDO.setTaskId(taskInfoVO.getId());
                timesheetDO.setTimesheetId(timesheetPayload.getId());
                timesheetDO.setWorkHour(workHour);
                timesheetDO.setWorkDate(timesheetPayload.getWorkDate());
                timesheetDO.setWorkDesc(timesheetPayload.getWorkDesc());
                timesheetDO.setSettleFlag(-1);
                this.taskSettleTimesheetDAO.save(timesheetDO);
            } else {
                newUsedEqva = usedEqva.subtract(upEqva);
                if (newUsedEqva.compareTo(BigDecimal.ZERO) < 0 || newUsedEqva.compareTo(approvedEqva) < 0) {
                    throw TwException.error("", "\u5df2\u63d0\u4ea4\u548c\u5df2\u5ba1\u6279\u5de5\u65f6\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (taskSettleTimesheetVO == null) {
                    if (isCheckRef.booleanValue()) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u63d0\u4ea4\u8bb0\u5f55\u5f02\u5e38\uff0c\u4e0d\u53ef\u64a4\u56de\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                } else {
                    this.taskSettleTimesheetDAO.deleteSoft(Arrays.asList(taskSettleTimesheetVO.getId()));
                }
            }
        }
        if (type.equals("2")) {
            BigDecimal newApprovedEqva = null;
            if (isForward) {
                newApprovedEqva = approvedEqva.add(upEqva);
                if (newApprovedEqva.compareTo(usedEqva) > 0 || newApprovedEqva.compareTo(taskInfoVO.getTotalEqva()) > 0) {
                    throw TwException.error("", "\u5df2\u5ba1\u6279\u5de5\u65f6\u548c\u5df2\u63d0\u4ea4\u5de5\u65f6\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (taskSettleTimesheetVO == null) {
                    if (isCheckRef.booleanValue()) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u5ba1\u6279\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    TaskSettleTimesheetDO timesheetDO = new TaskSettleTimesheetDO();
                    timesheetDO.setEqva(upEqva);
                    timesheetDO.setTaskId(taskInfoVO.getId());
                    timesheetDO.setTimesheetId(timesheetPayload.getId());
                    timesheetDO.setWorkHour(workHour);
                    timesheetDO.setWorkDate(timesheetPayload.getWorkDate());
                    timesheetDO.setWorkDesc(timesheetPayload.getWorkDesc());
                    timesheetDO.setSettleFlag(0);
                    this.taskSettleTimesheetDAO.save(timesheetDO);
                } else {
                    Integer settleFlag = taskSettleTimesheetVO.getSettleFlag();
                    if (settleFlag != null && settleFlag != -1) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u5ba1\u6279\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    TaskSettleTimesheetPayload taskSettleTimesheetPayload = new TaskSettleTimesheetPayload();
                    taskSettleTimesheetPayload.setId(taskSettleTimesheetVO.getId());
                    taskSettleTimesheetPayload.setSettleFlag(Integer.valueOf(0));
                    this.taskSettleTimesheetDAO.updateByKeyDynamic(taskSettleTimesheetPayload);
                }
            } else {
                newApprovedEqva = approvedEqva.subtract(upEqva);
                newUsedEqva = usedEqva.subtract(upEqva);
                if (taskSettleTimesheetVO == null) {
                    if (isCheckRef.booleanValue()) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u4efb\u52a1\u5173\u7cfb\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    if (taskInfoVO.getPricingMethod().equals(PricingMethodEnum.SINGLE.getCode())) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u53ef\u64a4\u56de");
                    }
                } else {
                    Integer settleFlag = taskSettleTimesheetVO.getSettleFlag();
                    if (settleFlag == null || settleFlag == -1) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u5ba1\u6279\u4e2d\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5904\u7406");
                    }
                    if (taskSettleTimesheetVO.getSettleId() != null) {
                        CalTaskSettleService bean = (CalTaskSettleService)SpringUtil.getBean(CalTaskSettleService.class);
                        bean.reverseTaskSettle(taskInfoVO.getTaskNo(), upEqva.negate(), timesheetPayload.getWorkDate() + "-\u5de5\u65f6\u64a4\u56de\u53cd\u5411\u7ed3\u7b97");
                    }
                    this.taskSettleTimesheetDAO.deleteSoft(Arrays.asList(taskSettleTimesheetVO.getId()));
                }
            }
            payload.setApprovedEqva(newApprovedEqva);
        }
        payload.setUsedEqva(newUsedEqva);
        this.taskInfoDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetVO> bw8TimeSheetSubmit(List<TimesheetPayload> payloads) {
        ArrayList<TimesheetVO> timesheetVOS = new ArrayList<TimesheetVO>();
        Long userId = GlobalUtil.getLoginUserId();
        Map<Long, List<TimesheetPayload>> projTimeSheetMap = payloads.stream().filter(pay -> pay.getProjId() != null).collect(Collectors.groupingBy(TimesheetPayload::getProjId));
        if (ObjectUtils.isEmpty(projTimeSheetMap)) {
            throw TwException.error("", "\u5de5\u65f6\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryByKeys(projTimeSheetMap.keySet().stream().collect(Collectors.toList()));
        if (ObjectUtils.isEmpty(pmsProjectVOS)) {
            throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        ArrayList<TaskInfoDO> saveTaskInfoS = new ArrayList<TaskInfoDO>();
        ArrayList<PmsProjectMembersDO> saveProjMemberS = new ArrayList<PmsProjectMembersDO>();
        BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(userId, null);
        projTimeSheetMap.forEach((projectId, timeSheets) -> {
            TaskPackageDO taskPackageDO;
            Optional<PmsProjectVO> first = pmsProjectVOS.stream().filter(vo -> vo.getId().equals(projectId)).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            PmsProjectVO pmsProjectVO = first.get();
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "\u975e\u6fc0\u6d3b\u9879\u76ee\u4e0d\u53ef\u64cd\u4f5c");
            }
            if (!StringUtils.hasText((String)pmsProjectVO.getExt1()) || !pmsProjectVO.getExt1().equals("DEV_OPS")) {
                throw TwException.error("", "\u975e\u8fd0\u7ef4\u9879\u76ee\u4e0d\u53ef\u64cd\u4f5c");
            }
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            taskPackageQuery.setReasonId(projectId);
            taskPackageQuery.setReceiverResId(userId);
            taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
            List<TaskPackageVO> taskPackageVOS = this.taskPackageDAO.queryListDynamic(taskPackageQuery);
            TaskPackageVO taskPackageVO = null;
            BigDecimal eqvaRatio0 = eqvaRatio;
            if (!ObjectUtils.isEmpty(taskPackageVOS) && null == (eqvaRatio0 = (taskPackageVO = taskPackageVOS.get(0)).getEqvaRatio())) {
                eqvaRatio0 = eqvaRatio;
            }
            BigDecimal workHour = timeSheets.stream().map(TimesheetPayload::getWorkHour).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            Long timeSheetId = ((TimesheetPayload)timeSheets.get(0)).getId();
            BigDecimal divide = workHour.divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
            BigDecimal upEqva = divide.multiply(eqvaRatio0);
            BudgetCommonService bean = (BudgetCommonService)SpringUtil.getBean(BudgetCommonService.class);
            bean.checkBudgetEqva(projectId, PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), null, upEqva);
            TaskInfoDO taskInfo = null;
            if (taskPackageVO == null) {
                TaskPackageDO taskPackage = this.createTaskPackage(PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO, userId, eqvaRatio0);
                taskPackageDO = this.taskPackageDAO.save(taskPackage);
                PmsProjectMembersDO projMember = this.createProjMember(taskPackageDO);
                saveProjMemberS.add(projMember);
            } else {
                taskPackageDO = TaskPackageConvert.INSTANCE.voToDo(taskPackageVO);
                TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
                taskInfoQuery.setSourceType(TaskSourceTypeEnum.BANGWO8.getCode());
                taskInfoQuery.setSourceId(timeSheetId);
                List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryTaskSimpleList(taskInfoQuery);
                if (!ObjectUtils.isEmpty(taskInfoVOS)) {
                    taskInfo = (TaskInfoDO)TaskInfoConvert.INSTANCE.toEntity(taskInfoVOS.get(0));
                }
            }
            if (taskInfo == null) {
                taskInfo = this.createBW8TaskInfo(taskPackageDO, upEqva, timeSheetId);
                saveTaskInfoS.add(taskInfo);
            }
            Long taskPackageId = taskPackageDO.getId();
            String taskPackageName = taskPackageDO.getTaskPackageName();
            Long reasonId = taskPackageDO.getReasonId();
            String reasonName = taskPackageDO.getReasonName();
            String reasonType = taskPackageDO.getReasonType();
            Long taskId = taskInfo.getId();
            String taskName = taskInfo.getTaskName();
            timeSheets.forEach(timesheetPayload -> {
                timesheetPayload.setTaskPackageId(taskPackageId);
                timesheetPayload.setTaskPackageName(taskPackageName);
                timesheetPayload.setTaskId(taskId);
                timesheetPayload.setTaskName(taskName);
                timesheetPayload.setReasonName(reasonName);
                timesheetPayload.setReasonId(reasonId);
                timesheetPayload.setReasonType(reasonType);
            });
        });
        if (saveProjMemberS.size() > 0) {
            this.pmsProjectMembersDAO.saveAll(saveProjMemberS);
        }
        List<Object> taskInfoDOS = new ArrayList();
        if (saveTaskInfoS.size() > 0) {
            taskInfoDOS = this.taskInfoDAO.saveAll(saveTaskInfoS);
        }
        ArrayList finalTaskInfoDOS = taskInfoDOS;
        payloads.forEach(payload -> {
            TimesheetVO vo = new TimesheetVO();
            vo.setId(payload.getId());
            vo.setTaskPackageId(payload.getTaskPackageId());
            vo.setTaskPackageName(payload.getTaskPackageName());
            vo.setReasonId(payload.getReasonId());
            vo.setReasonName(payload.getReasonName());
            vo.setReasonType(payload.getReasonType());
            Optional<TaskInfoDO> first = finalTaskInfoDOS.stream().filter(taskInfoDO -> taskInfoDO.getTaskPackageId().equals(payload.getTaskPackageId())).findFirst();
            if (first.isPresent()) {
                TaskInfoDO taskInfoDO2 = first.get();
                vo.setTaskId(taskInfoDO2.getId());
                vo.setTaskNo(taskInfoDO2.getTaskNo());
                vo.setTaskName(taskInfoDO2.getTaskName());
            } else {
                vo.setTaskId(payload.getTaskId());
                vo.setTaskNo(payload.getTaskNo());
                vo.setTaskName(payload.getTaskName());
            }
            timesheetVOS.add(vo);
        });
        return timesheetVOS;
    }

    public List<TimesheetVO> queryTimeSheets(String reasonType, Long reasonId, List<Long> userIds) {
        TimesheetQuery query = new TimesheetQuery();
        query.setReasonType(reasonType);
        query.setReasonId(reasonId);
        query.setTsUserIdList(new HashSet<Long>(userIds));
        return this.timesheetDAO.queryList(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchCreatTaskPackage(String reasonType, Long reasonId, List<Long> userIds, Object project) {
        if (ObjectUtils.isEmpty((Object)project)) {
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && ObjectUtils.isEmpty((Object)(project = this.pmsProjectDAO.queryByKey(reasonId)))) {
                throw TwException.error("", "\u4e8b\u7531\u4e0d\u5b58\u5728");
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode()) && ObjectUtils.isEmpty((Object)(project = this.buProjectDAO.queryByKey(reasonId)))) {
                throw TwException.error("", "\u4e8b\u7531\u4e0d\u5b58\u5728");
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(reasonId);
                List<CrmOpportunityListVO> crmOpportunityListVOS = this.crmOpportunityDAO.queryListDynamic(query);
                if (ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                    throw TwException.error("", "\u4e8b\u7531\u4e0d\u5b58\u5728");
                }
                project = crmOpportunityListVOS.get(0);
            }
        }
        ArrayList<TaskPackageDO> taskPackageDOS = new ArrayList<TaskPackageDO>();
        Object finalProject = project;
        userIds.forEach(userId -> {
            BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(userId, null);
            TaskPackageDO taskPackage = this.createTaskPackage(reasonType, finalProject, (Long)userId, eqvaRatio);
            taskPackageDOS.add(taskPackage);
        });
        if (taskPackageDOS.size() > 0) {
            List<TaskPackageDO> taskPackageDOS1 = this.taskPackageDAO.saveAll(taskPackageDOS);
            ArrayList<TaskInfoDO> taskInfoDOS = new ArrayList<TaskInfoDO>();
            taskPackageDOS1.forEach(taskPackageDO -> {
                TaskInfoDO taskInfo = this.createTaskInfo((TaskPackageDO)taskPackageDO);
                taskInfoDOS.add(taskInfo);
            });
            this.taskInfoDAO.saveAll(taskInfoDOS);
        }
    }

    TaskPackageDO createTaskPackage(String reasonType, Object projectVO, Long userId, BigDecimal eqvaRatio) {
        PmsProjectVO projectVO1;
        Long compositeAbilityId = null;
        CalResourcePriceQuery query = new CalResourcePriceQuery();
        query.setResId(userId);
        BigDecimal bigDecimal = this.calResourceService.queryIncomePrice(query);
        if (bigDecimal == null) {
            bigDecimal = BigDecimal.valueOf(800L);
        }
        TaskPackageDO taskPackageDO = new TaskPackageDO();
        String name = "";
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            projectVO1 = (PmsProjectVO)projectVO;
            taskPackageDO.setAcceptorId(projectVO1.getPmResId());
            taskPackageDO.setDisterResId(projectVO1.getPmResId());
            taskPackageDO.setEndDate(projectVO1.getPlanEndDate());
            taskPackageDO.setReasonId(projectVO1.getId());
            taskPackageDO.setReasonName(projectVO1.getProjName());
            taskPackageDO.setSettlePrice(projectVO1.getEqvaPrice());
            taskPackageDO.setStartDate(projectVO1.getPlanStartDate());
            name = projectVO1.getProjName();
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            projectVO1 = (PmsProjectVO)projectVO;
            taskPackageDO.setAcceptorId(projectVO1.getPmResId());
            taskPackageDO.setDisterResId(projectVO1.getPmResId());
            taskPackageDO.setEndDate(projectVO1.getPlanEndDate());
            taskPackageDO.setReasonId(projectVO1.getId());
            taskPackageDO.setReasonName(projectVO1.getProjName());
            taskPackageDO.setSettlePrice(projectVO1.getEqvaPrice());
            taskPackageDO.setStartDate(projectVO1.getPlanStartDate());
            name = projectVO1.getProjName();
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            projectVO1 = (CrmOpportunityListVO)projectVO;
            taskPackageDO.setAcceptorId(projectVO1.getPreSaleUserId());
            taskPackageDO.setDisterResId(projectVO1.getPreSaleUserId());
            taskPackageDO.setEndDate(projectVO1.getForecastWinDate());
            taskPackageDO.setReasonId(projectVO1.getId());
            taskPackageDO.setReasonName(projectVO1.getProjectName());
            taskPackageDO.setSettlePrice(projectVO1.getEqvaPrice());
            taskPackageDO.setStartDate(LocalDate.now());
            name = projectVO1.getProjectName();
        }
        taskPackageDO.setAcceptMethod(AcceptMethodEnum.TASK_PACKAGE.getCode());
        taskPackageDO.setAutoSettleFlag(1);
        taskPackageDO.setCompositeAbilityId(compositeAbilityId);
        taskPackageDO.setEqvaRatio(eqvaRatio);
        taskPackageDO.setGuaranteeRate(BigDecimal.ZERO);
        taskPackageDO.setIncomePrice(bigDecimal);
        taskPackageDO.setPricingMethod(PricingMethodEnum.SINGLE.getCode());
        taskPackageDO.setReasonType(reasonType);
        taskPackageDO.setReceiverResId(userId);
        taskPackageDO.setReceiverBuId(this.cacheUtil.getDefaultOrgIdByUserId(userId));
        taskPackageDO.setTaskPackageDes("\u81ea\u52a8\u751f\u6210\u4efb\u52a1\u5305");
        taskPackageDO.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        taskPackageDO.setTaskPackageType("CONVENTION_TASK_PACKAGE");
        String taskPackageName = name + "\u4efb\u52a1\u5305-" + this.cacheUtil.getUserName(userId) + "-" + taskPackageDO.getStartDate().toString() + "~" + taskPackageDO.getEndDate().toString();
        taskPackageDO.setTaskPackageName(taskPackageName);
        if (taskPackageDO.getSettlePrice() == null) {
            taskPackageDO.setSettlePrice(BigDecimal.valueOf(2000L));
        }
        return taskPackageDO;
    }

    TaskInfoDO createTaskInfo(TaskPackageDO taskPackage) {
        BigDecimal zero = BigDecimal.ZERO;
        TaskInfoDO taskInfoDO = new TaskInfoDO();
        taskInfoDO.setTaskNo(this.generateSeqNum("TASK_NO", new String[0]));
        taskInfoDO.setTaskPackageId(taskPackage.getId());
        taskInfoDO.setTaskName(taskPackage.getTaskPackageName());
        taskInfoDO.setDisterResId(taskPackage.getDisterResId());
        taskInfoDO.setTaskResId(taskPackage.getReceiverResId());
        taskInfoDO.setPlanStartDate(taskPackage.getStartDate());
        taskInfoDO.setPlanEndDate(taskPackage.getEndDate());
        taskInfoDO.setTotalEqva(zero);
        taskInfoDO.setSettledEqva(zero);
        taskInfoDO.setSplitEqva(zero);
        taskInfoDO.setOriginalEqva(zero);
        taskInfoDO.setPlanEqva(zero);
        taskInfoDO.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
        return taskInfoDO;
    }

    TaskInfoDO createBW8TaskInfo(TaskPackageDO taskPackage, BigDecimal upEqva, Long timeSheetId) {
        BigDecimal zero = BigDecimal.ZERO;
        TaskInfoDO taskInfoDO = new TaskInfoDO();
        taskInfoDO.setTaskNo(this.generateSeqNum("TASK_NO", new String[0]));
        taskInfoDO.setTaskPackageId(taskPackage.getId());
        taskInfoDO.setTaskName(taskPackage.getTaskPackageName());
        taskInfoDO.setDisterResId(taskPackage.getDisterResId());
        taskInfoDO.setTaskResId(taskPackage.getReceiverResId());
        taskInfoDO.setPlanStartDate(taskPackage.getStartDate());
        taskInfoDO.setPlanEndDate(taskPackage.getEndDate());
        taskInfoDO.setTotalEqva(upEqva);
        taskInfoDO.setSettledEqva(zero);
        taskInfoDO.setSplitEqva(zero);
        taskInfoDO.setOriginalEqva(upEqva);
        taskInfoDO.setPlanEqva(upEqva);
        taskInfoDO.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
        taskInfoDO.setBw8Flag(1);
        taskInfoDO.setSourceType(TaskSourceTypeEnum.BANGWO8.getCode());
        taskInfoDO.setSourceId(timeSheetId);
        return taskInfoDO;
    }

    PmsProjectMembersDO createProjMember(TaskPackageDO taskPackage) {
        PmsProjectMembersDO memberDO = new PmsProjectMembersDO();
        memberDO.setTaskPackageId(taskPackage.getId());
        memberDO.setPlanStartDate(taskPackage.getStartDate());
        memberDO.setPlanEndDate(taskPackage.getEndDate());
        memberDO.setCapasetLevelId(taskPackage.getCompositeAbilityId());
        memberDO.setResId(taskPackage.getReceiverResId());
        memberDO.setProjId(taskPackage.getReasonId());
        return memberDO;
    }

    public TaskCommonServiceImpl(TaskInfoDAO taskInfoDAO, TaskPackageDAO taskPackageDAO, PmsProjectDAO pmsProjectDAO, BuProjectDAO buProjectDAO, CrmOpportunityDAO crmOpportunityDAO, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService, PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService, CalResourceService calResourceService, CacheUtil cacheUtil, PmsProjectMembersDAO pmsProjectMembersDAO, TimesheetDAO timesheetDAO, TaskSettleTimesheetDAO taskSettleTimesheetDAO) {
        this.taskInfoDAO = taskInfoDAO;
        this.taskPackageDAO = taskPackageDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.buProjectDAO = buProjectDAO;
        this.crmOpportunityDAO = crmOpportunityDAO;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
        this.prdEmployeCompositeAbilityService = prdEmployeCompositeAbilityService;
        this.calResourceService = calResourceService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectMembersDAO = pmsProjectMembersDAO;
        this.timesheetDAO = timesheetDAO;
        this.taskSettleTimesheetDAO = taskSettleTimesheetDAO;
    }
}

