/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanConfirmService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanConfirmDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/CON_PROMPT/callBack"})
@Transactional
public class ConRecePlanConfirmWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(ConRecePlanConfirmWorkflowCallBackController.class);
    private final ConReceivablePlanConfirmService service;
    private final ConReceivablePlanConfirmDAO dao;
    private final ConReceivablePlanService conReceivablePlanService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ConReceivablePlanConfirmPayload receivablePlanConfirmPayload = new ConReceivablePlanConfirmPayload();
        receivablePlanConfirmPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        ConReceivablePlanConfirmVO conReceivablePlanConfirmVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (conReceivablePlanConfirmVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    receivablePlanConfirmPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    receivablePlanConfirmPayload.setDeleteFlag(Integer.valueOf(1));
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    receivablePlanConfirmPayload.setApprovedTime(LocalDateTime.now());
                    this.finish(conReceivablePlanConfirmVO);
                    break;
                }
                case APPROVING: {
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.dao.updateByKeyDynamic(receivablePlanConfirmPayload);
        }
        return WorkflowResult.success(null);
    }

    private void finish(ConReceivablePlanConfirmVO view) {
        if (view.getFinanceConfirm() != null && view.getFinanceConfirm() == 1 || view.getReceDateConfirm() != null && view.getReceDateConfirm() == 1) {
            log.debug("\u5df2\u4ed8\u6b3e\u9700\u8d22\u52a1\u786e\u8ba4");
            log.debug("\u9884\u8ba1\u6536\u6b3e\u65e5\u671f\u65e0\u8bef");
        } else {
            ConRecvplanChangeLogPayload logEntity = new ConRecvplanChangeLogPayload();
            logEntity.setRcvpConfirmId(view.getId());
            logEntity.setFlag1(Boolean.valueOf(view.getSendPaymentRequest() == 1));
            logEntity.setRecvplanId(view.getRecePlanId());
            logEntity.setOldRecvOrInvDate(view.getExpectReceDate());
            logEntity.setRecvOrInvDate(view.getAdjExpectReceDate());
            logEntity.setType("RECV");
            logEntity.setApplyUserId(view.getApplyUserId());
            if (null != view.getPmConfirm() && view.getPmConfirm() == 1) {
                logEntity.setReason(view.getPmRemark());
            } else {
                logEntity.setReason(view.getSalesRemark());
            }
            this.conReceivablePlanService.updateRecvOrInvDate(logEntity);
        }
    }

    public ConRecePlanConfirmWorkflowCallBackController(ConReceivablePlanConfirmService service, ConReceivablePlanConfirmDAO dao, ConReceivablePlanService conReceivablePlanService) {
        this.service = service;
        this.dao = dao;
        this.conReceivablePlanService = conReceivablePlanService;
    }
}

