/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.log.controller;

import com.elitesland.tw.tw5.api.log.query.LogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.log.service.LogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/common/log"})
public class LogController {
    private static final Logger log = LoggerFactory.getLogger(LogController.class);
    private final LogService logService;

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.logService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(LogQuery query) {
        return TwOutputUtil.ok(this.logService.paging(query));
    }

    @GetMapping(value={"/list"})
    public TwOutputUtil queryList(LogQuery query) {
        return TwOutputUtil.ok(this.logService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.logService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/log/delete"})
    public TwOutputUtil delete(Long[] keys) {
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            this.logService.delete(Arrays.asList(keys));
        }
        return TwOutputUtil.ok();
    }

    public LogController(LogService logService) {
        this.logService = logService;
    }
}

