/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.dao;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbPayload;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbAddressRepo;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class PrdAbDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbRepo repo;
    private final PrdAbAddressRepo repoAddress;
    private final PrdOrgCompanyRepo repoCompany;
    private final QPrdAbDO qdo = QPrdAbDO.prdAbDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdAbAddressDO qdoAddress = QPrdAbAddressDO.prdAbAddressDO;

    public PrdAbDO save(PrdAbDO ado) {
        return (PrdAbDO)((Object)this.repo.save((Object)ado));
    }

    public PrdOrgCompanyDO saveCompany(PrdOrgCompanyDO ado) {
        return (PrdOrgCompanyDO)((Object)this.repoCompany.save((Object)ado));
    }

    public PrdAbAddressDO saveAddress(PrdAbAddressDO ado) {
        return (PrdAbAddressDO)((Object)this.repoAddress.save((Object)ado));
    }

    private JPAQuery<PrdAbVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdAbVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookNo, this.qdo.bookType, this.qdo.relateType, this.qdo.bookName, this.qdoCompany.id.as("companyId"), this.qdoCompany.taxNo})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoCompany.bookId.longValue().eq((Expression)this.qdo.id.longValue()));
        return jpaQuery;
    }

    public PrdAbVO queryCompanyByTaxNo(String taxNo) {
        JPAQuery<PrdAbVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdoCompany.taxNo.eq((Object)taxNo));
        ((JPAQuery)jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdoCompany.deleteFlag.eq((Object)0));
        return (PrdAbVO)jpaQuery.fetchFirst();
    }

    public List<PrdAbVO> queryBookInfoByRelat(String relateType) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdAbVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookNo, this.qdo.bookType, this.qdo.relateType, this.qdo.bookName})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        if (StringUtils.hasText((String)relateType)) {
            jpaQuery.where((Predicate)this.qdo.relateType.like(SqlUtil.toSqlLikeString(relateType)));
        }
        return jpaQuery.fetch();
    }

    public PrdAbVO queryCompanyByBookId(Long bookId) {
        JPAQuery<PrdAbVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdoCompany.bookId.eq((Object)bookId));
        ((JPAQuery)jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdoCompany.deleteFlag.eq((Object)0));
        return (PrdAbVO)jpaQuery.fetchFirst();
    }

    public long updateByKeyDynamic(PrdAbPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getBookName() != null) {
            update.set((Path)this.qdo.bookName, (Object)payload.getBookName());
        }
        if (payload.getBookType() != null) {
            update.set((Path)this.qdo.bookType, (Object)payload.getBookType());
        }
        if (payload.getRelateType() != null) {
            update.set((Path)this.qdo.relateType, (Object)payload.getRelateType());
        }
        return update.execute();
    }

    public long updateCompanyByKey(PrdAbOrCompanyPayload companyDO) {
        boolean isUp = false;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoCompany).where(new Predicate[]{this.qdoCompany.bookId.eq((Object)companyDO.getId())});
        if (companyDO.getCompanyName() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyName, (Object)companyDO.getCompanyName());
        }
        if (companyDO.getCompanyIndustry() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyIndustry, (Object)companyDO.getCompanyIndustry());
        }
        if (companyDO.getTaxNo() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.taxNo, (Object)companyDO.getTaxNo());
        }
        if (companyDO.getCompanyPhone() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyPhone, (Object)companyDO.getCompanyPhone());
        }
        if (companyDO.getCompanyEmail() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyEmail, (Object)companyDO.getCompanyEmail());
        }
        if (companyDO.getCompanyFax() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyFax, (Object)companyDO.getCompanyFax());
        }
        if (companyDO.getProvince() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.province, (Object)companyDO.getProvince());
        }
        if (companyDO.getProvinceName() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.provinceName, (Object)companyDO.getProvinceName());
        }
        if (companyDO.getCity() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.city, (Object)companyDO.getCity());
        }
        if (companyDO.getCityName() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.cityName, (Object)companyDO.getCityName());
        }
        if (companyDO.getDistrict() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.district, (Object)companyDO.getDistrict());
        }
        if (companyDO.getDistrictName() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.districtName, (Object)companyDO.getDistrictName());
        }
        if (companyDO.getCompanyAddress() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyAddress, (Object)companyDO.getCompanyAddress());
        }
        if (companyDO.getCompanyWebsite() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyWebsite, (Object)companyDO.getCompanyWebsite());
        }
        if (companyDO.getCompanyScale() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyScale, (Object)companyDO.getCompanyScale());
        }
        if (companyDO.getCurrency() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.currency, (Object)companyDO.getCurrency());
        }
        if (companyDO.getLanguage() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.language, (Object)companyDO.getLanguage());
        }
        if (companyDO.getCompanyNature() != null) {
            isUp = true;
            update.set((Path)this.qdoCompany.companyNature, (Object)companyDO.getCompanyNature());
        }
        if (!isUp) {
            return 0L;
        }
        return update.execute();
    }

    public long setProvinceCityDistrictForCompany(PrdAbOrCompanyPayload payload) {
        return this.jpaQueryFactory.update((EntityPath)this.qdoCompany).set((Path)this.qdoCompany.province, (Object)payload.getProvince()).set((Path)this.qdoCompany.provinceName, (Object)payload.getProvinceName()).set((Path)this.qdoCompany.city, (Object)payload.getCity()).set((Path)this.qdoCompany.cityName, (Object)payload.getCityName()).set((Path)this.qdoCompany.district, (Object)payload.getDistrict()).set((Path)this.qdoCompany.districtName, (Object)payload.getDistrictName()).where(new Predicate[]{this.qdoCompany.bookId.eq((Object)payload.getId())}).execute();
    }

    public Long getIdByV4(Long bookIdV4) {
        return this.repo.getIdByV4(bookIdV4);
    }

    public PrdAbVO queryByKey(Long id) {
        JPAQuery<PrdAbVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdAbVO)jpaQuery.fetchFirst();
    }

    public PrdAbDAO(JPAQueryFactory jpaQueryFactory, PrdAbRepo repo, PrdAbAddressRepo repoAddress, PrdOrgCompanyRepo repoCompany) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoAddress = repoAddress;
        this.repoCompany = repoCompany;
    }
}

