/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimJdePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourcePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimFinancialExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPrintVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimPayModeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimConvert;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d39\u7528\u62a5\u9500\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/acc/accReim"})
public class AccReimController {
    private static final Logger log = LoggerFactory.getLogger(AccReimController.class);
    private final AccReimService accReimService;
    private final UdcUtil udcUtil;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil<AccReimVO> insert(@RequestBody AccReimPayload payload) {
        return TwOutputUtil.ok(this.accReimService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u90e8\u5206\u66f4\u65b0-\u4fee\u6539\u6536\u6b3e\u8d26\u53f7")
    public TwOutputUtil partialUpdate(@RequestBody AccReimPayload payload) {
        this.accReimService.updateBankAccount(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/dynamic"})
    @ApiOperation(value="\u52a8\u6001\u66f4\u65b0")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimPayload payload) {
        return TwOutputUtil.ok(this.accReimService.updateByKeyDynamic(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u8be6\u60c5")
    public TwOutputUtil<AccReimVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.accReimService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil<PagingVO<AccReimVO>> paging(AccReimQuery query) {
        return TwOutputUtil.ok(this.accReimService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<AccReimVO>> queryList(AccReimQuery query) {
        return TwOutputUtil.ok(this.accReimService.queryListDynamic(query));
    }

    @DeleteMapping
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.accReimService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryOneByReimNo/{reimNo}"})
    @ApiOperation(value="\u6839\u636e\u62a5\u9500\u5355\u53f7\u67e5\u8be2\u552f\u4e00")
    public TwOutputUtil<AccReimVO> queryOneByReimNo(@PathVariable(value="reimNo") String reimNo) {
        AccReimVO vo = this.accReimService.queryOneByReimNo(reimNo);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/chargeUp/{reimNo}"})
    @ApiOperation(value="\u8d22\u52a1\u6536\u5355")
    public TwOutputUtil<AccReimVO> finChargeUp(@PathVariable(value="reimNo") String reimNo) {
        AccReimVO vo = this.accReimService.finChargeUp(reimNo);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/payMode/{keys}"})
    @ApiOperation(value="\u4fee\u6539\u4ed8\u6b3e\u65b9\u5f0f")
    public TwOutputUtil updatePayMode(@PathVariable(value="keys") Long[] keys, String payMode) {
        this.accReimService.updatePayMode(keys, payMode);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/batchChargeOrPay"})
    @ApiOperation(value="\u6279\u91cf\u5f85\u8bb0\u8d26/\u4ed8\u6b3e\u5904\u7406")
    public TwOutputUtil batchChargeOrPay(@RequestBody AccReimPayload payload) {
        AccReimJdePayload accReimJdePayload = this.accReimService.batchChargeOrPay(payload.getKeys(), payload.getType(), payload.getExpenseProofDigest(), payload.getExpenseAccountDate(), AccReimPayModeEnum.PAY_MODE_2.getCode());
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/calcAmt/{busItemCode}"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97(\u76ee\u524d\u4ec5\u9910\u8d39)")
    public TwOutputUtil calcAmt(@PathVariable(value="busItemCode") String busItemCode, AccReimSourcePayload calcSource) {
        AccReimSourcePayload payload = this.accReimService.calcAmt(busItemCode, calcSource);
        return TwOutputUtil.ok(payload);
    }

    @PutMapping(value={"/export/charge/{batchId}"})
    @ApiOperation(value="\u8bb0\u8d26\u5bfc\u51fa")
    public void exportChargeDtl(HttpServletResponse response, @PathVariable(value="batchId") Long batchId) {
        this.accReimService.exportChargeDtl(response, batchId);
    }

    @PutMapping(value={"/export/pay/{batchId}"})
    @ApiOperation(value="\u4ed8\u6b3e\u5bfc\u51fa")
    public void exportPayDtl(HttpServletResponse response, @PathVariable(value="batchId") Long batchId) {
        this.accReimService.exportPayData(response, batchId);
    }

    @GetMapping(value={"/exportProjectAccReim"})
    @ApiOperation(value="\u9879\u76ee\u8be6\u60c5\u62a5\u9500\u5bfc\u51fa")
    public void exportProjectAccReim(HttpServletResponse response, AccReimQuery query) throws IOException {
        List accReimVOS = this.accReimService.queryListDynamic(query);
        if (!CollectionUtils.isEmpty((Collection)accReimVOS)) {
            accReimVOS = this.udcUtil.translateList(accReimVOS);
            for (AccReimVO accReimVO : accReimVOS) {
                if (accReimVO.getAdjustAmt() != null) continue;
                accReimVO.setAdjustAmt(accReimVO.getReimTotalAmt());
            }
            String sheetName = "\u62a5\u9500\u5bfc\u51fa";
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), AccReimVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, AccReimVO.class, null);
            sheet.doWrite(accReimVOS);
        }
    }

    @GetMapping(value={"/exportFinancialAccReim"})
    @ApiOperation(value="\u8d22\u52a1\u62a5\u9500\u5bfc\u51fa")
    public void exportFinancialAccReim(HttpServletResponse response, AccReimQuery query) throws IOException {
        List accReimVOS = this.accReimService.queryListDynamic(query);
        if (!CollectionUtils.isEmpty((Collection)accReimVOS)) {
            accReimVOS = this.udcUtil.translateList(accReimVOS);
            List<AccReimFinancialExportVO> accReimFinancialExportVOS = AccReimConvert.INSTANCE.voListToFinVoList(accReimVOS);
            String sheetName = "\u62a5\u9500\u5bfc\u51fa";
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), AccReimFinancialExportVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, AccReimFinancialExportVO.class, null);
            sheet.doWrite(accReimFinancialExportVOS);
        }
    }

    @PostMapping(value={"/payBankSubmit/{ids}"})
    @ApiOperation(value="\u7f51\u94f6\u63d0\u4ea4")
    public TwOutputUtil payBankSubmit(@PathVariable(value="ids") Long[] ids) {
        this.accReimService.payBankSubmit(ids);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/paging2Budget"})
    @UdcNameClass
    @ApiOperation(value="\u9884\u7b97-\u8d39\u7528\u5360\u7528\u5206\u9875")
    public TwOutputUtil<PagingVO<AccReimVO>> paging2Budget(@RequestBody AccReimQuery query) {
        return TwOutputUtil.ok(this.accReimService.paging2Budget(query));
    }

    @GetMapping(value={"/queryPendingPayChargePaging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u5f85\u8bb0\u8d26\u5206\u9875\u67e5\u8be2")
    public TwOutputUtil<PagingVO<AccReimVO>> queryPendingPayChargePaging(AccReimQuery query) {
        query.setReimStatus(AccReimDocStatusEnum.PENDING_PAYMENT_CHARGE.getCode());
        return TwOutputUtil.ok(this.accReimService.queryPaging(query));
    }

    @PostMapping(value={"/batchPayCharge"})
    @ApiOperation(value="\u4ed8\u6b3e\u5f85\u8bb0\u8d26\u5ba1\u6279")
    public TwOutputUtil batchPayCharge(@RequestBody AccReimPayload payload) {
        if (CollectionUtils.isEmpty((Collection)payload.getKeys())) {
            throw TwException.error("", "\u8bf7\u52fe\u9009\u6570\u636e\u540e\u518d\u63d0\u4ea4");
        }
        this.accReimService.batchPayCharge(payload.getKeys(), payload.getPayProofDigest());
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/print/pay"})
    @ApiOperation(value="\u4ed8\u6b3e\u6253\u5370\u67e5\u8be2")
    public TwOutputUtil<AccReimPrintVO> exportPayDtl(Long[] batchIdList) {
        if (batchIdList == null || batchIdList.length == 0) {
            throw TwException.error("", "\u8bf7\u52fe\u9009\u6570\u636e\u540e\u518d\u63d0\u4ea4");
        }
        return TwOutputUtil.ok(this.accReimService.queryPrintPayData(Arrays.asList(batchIdList)));
    }

    public AccReimController(AccReimService accReimService, UdcUtil udcUtil) {
        this.accReimService = accReimService;
        this.udcUtil = udcUtil;
    }
}

