/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.common;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.workflow.params.ProcDefDTO;
import com.elitescloud.cloudt.workflow.params.TaskNodeConfigDTO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.workFlow.TwWorkflowAssignType;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgRoleRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtil.class);
    private final WorkflowService workflowService;
    private final PrdSystemRoleService prdSystemRoleService;
    private final PrdOrgRoleRepo prevOrgRoleRepo;
    private final PrdOrgOrganizationService prevOrgOrganizationService;
    private final EntityManager entityManager;
    private final TransactionUtilService transactionUtilService;

    public ProcessInfo startProcess(StartProcessPayload payload, Long ... startUserId) {
        String starterId = null;
        if (startUserId != null && startUserId.length > 0) {
            starterId = "" + startUserId[0];
        }
        payload.setStarterId(starterId);
        WorkflowResult workflowResult = this.workflowService.startProcess(payload);
        System.out.println("workflowResult:::" + workflowResult.toString());
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return (ProcessInfo)workflowResult.getData();
            }
            throw TwException.error("", "\u5de5\u4f5c\u6d41\u521b\u5efa\u5f02\u5e38:" + workflowResult.getMsg());
        }
        throw TwException.error("", "\u5de5\u4f5c\u6d41\u521b\u5efa\u8fd4\u56de\u503c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
    }

    public Map<String, Object> setTwCustomAssign(String definitionKey, Object context, HashMap<String, Object> variables) {
        Map<String, Object> contextMap = BeanUtil.beanToMap(context);
        WorkflowResult nodeConfig = this.workflowService.getNodeConfig(definitionKey, null);
        if (nodeConfig.isSuccess()) {
            List data = (List)nodeConfig.getData();
            for (TaskNodeConfigDTO taskNodeConfigDTO : data) {
                PrdOrgOrganizationVO prdOrgOrganizationVO;
                Object userIds;
                Object userIds2;
                if (TwWorkflowAssignType.TW_SYSTEM_ROLE.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String systemRole = taskNodeConfigDTO.getCustomParams2();
                    userIds2 = this.prdSystemRoleService.queryUserIdByRoleCode(systemRole);
                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList((Collection)userIds2));
                    continue;
                }
                if (TwWorkflowAssignType.TW_ORG_ROLE.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String orgRole = taskNodeConfigDTO.getCustomParams2();
                    Optional orgRoleDO = this.prevOrgRoleRepo.findById(Long.valueOf(orgRole));
                    userIds = orgRoleDO.orElse(new PrdOrgRoleDO()).getRoleEmployees();
                    if (userIds == null) {
                        userIds = "";
                    }
                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList((Object[])((String)userIds).split(",")));
                    continue;
                }
                if (TwWorkflowAssignType.DOC_USER_FIELD.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String docUserField = taskNodeConfigDTO.getCustomParams2();
                    userIds2 = contextMap.get(docUserField).toString();
                    if (userIds2 == null) {
                        userIds2 = "";
                    }
                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList((Object[])((String)userIds2).split(",")));
                    continue;
                }
                if (!TwWorkflowAssignType.DOC_ORG_FIELD.name().equals(taskNodeConfigDTO.getCustomParams())) continue;
                String docOrgField = taskNodeConfigDTO.getCustomParams2();
                String orgId = contextMap.get(docOrgField).toString();
                userIds = "";
                if (orgId != null && !orgId.trim().isEmpty() && (prdOrgOrganizationVO = this.prevOrgOrganizationService.queryDetailSimpleByOrgId(Long.valueOf(orgId))) != null) {
                    userIds = "" + prdOrgOrganizationVO.getManageId();
                }
                variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList((Object[])((String)userIds).split(",")));
            }
        }
        return variables;
    }

    public ProcessInfo simpleStartProcess(StartProcessPayload payload, Object context, Long ... startUserId) {
        String starterId = null;
        if (startUserId != null && startUserId.length > 0) {
            starterId = "" + startUserId[0];
        }
        payload.setStarterId(starterId);
        this.setTwCustomAssign(payload.getProcessDefinitionKey(), context, payload.getVariables());
        WorkflowResult workflowResult = this.workflowService.startProcess(payload);
        System.out.println("workflowResult:::" + workflowResult.toString());
        if (workflowResult.isSuccess()) {
            ProcessInfo data = (ProcessInfo)workflowResult.getData();
            WorkflowResult procDefResult = this.workflowService.getProcDef(payload.getProcessDefinitionKey());
            String tableName = ((ProcDefDTO)procDefResult.getData()).getEs2();
            this.transactionUtilService.executeWithRunnable(() -> {
                String sql = "UPDATE " + tableName + " SET proc_inst_id = ?1 WHERE id = ?2";
                Query query = this.entityManager.createNativeQuery(sql).setParameter(1, (Object)data.getProcInstId()).setParameter(2, (Object)payload.getBusinessKey());
                query.executeUpdate();
            });
            return data;
        }
        throw TwException.error("", "\u5de5\u4f5c\u6d41\u521b\u5efa\u5f02\u5e38:" + workflowResult.getMsg());
    }

    public void deleteProcess(DeleteProcessPayload payload) {
        WorkflowResult workflowResult = this.workflowService.deleteProcess(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "\u5de5\u4f5c\u6d41\u5220\u9664\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    public void setVariables(SetVariablesPayload payload) {
        WorkflowResult workflowResult = this.workflowService.setVariables(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "\u4fee\u6539\u8282\u70b9\u5ba1\u6279\u4eba\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    public void setVaribales(SetVariablesPayload payload) {
        WorkflowResult workflowResult = this.workflowService.setVariables(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "\u5de5\u4f5c\u6d41\u66f4\u6539\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    public void approve(ApprovePayload payload) {
        WorkflowResult workflowResult = this.workflowService.approve(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "\u5de5\u4f5c\u6d41\u63a8\u8fdb\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    public TaskInfo currentTaskInfo(String procInstId) {
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(procInstId);
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return (TaskInfo)workflowResult.getData();
            }
            throw TwException.error("", "\u5de5\u4f5c\u6d41\u83b7\u53d6\u4fe1\u606f\u5f02\u5e38:" + workflowResult.getMsg());
        }
        throw TwException.error("", "\u5de5\u4f5c\u6d41\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
    }

    public WorkflowUtil(WorkflowService workflowService, PrdSystemRoleService prdSystemRoleService, PrdOrgRoleRepo prevOrgRoleRepo, PrdOrgOrganizationService prevOrgOrganizationService, EntityManager entityManager, TransactionUtilService transactionUtilService) {
        this.workflowService = workflowService;
        this.prdSystemRoleService = prdSystemRoleService;
        this.prevOrgRoleRepo = prevOrgRoleRepo;
        this.prevOrgOrganizationService = prevOrgOrganizationService;
        this.entityManager = entityManager;
        this.transactionUtilService = transactionUtilService;
    }
}

