/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOffshoreService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsCustomerVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsMembersVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.prj.query.PrjProjectQuery;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsMembersConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsOffshoreConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsMembersDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreRuleAttrExcludeDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsMembersDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreMembersDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleAttrExcludeDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStageEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemLogDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmLeadsServiceImpl
extends BaseServiceImpl
implements CrmLeadsService {
    private static final Logger log = LoggerFactory.getLogger(CrmLeadsServiceImpl.class);
    private final CrmLeadsDAO dao;
    private final CrmLeadsMembersDAO membersDAO;
    private final PrdSystemLogDAO logDAO;
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO marketDAO;
    private final CrmOffshoreService offshoreService;
    private final CrmOffshoreRuleAttrExcludeDAO offshoreRuleAttrExcludeDAO;
    private final CrmOffshoreDAO offshoreDAO;
    private final CrmLeadsOffshoreDAO leadsOffshoreDAO;
    private final PrdMessageConfigService messageConfigService;
    private final CrmFollowService followService;
    private final PrdSystemLogService logService;
    private final ExcelUtil excelUtil;
    private final PrdSystemSelectionService selectionService;
    private final PrjProjectDAO prjProjectDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Autowired
    private CrmOpportunityService opportunityService;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdOrgEmployeeService employeeService;
    private final FileService fileService;
    private final CrmCommonService crmCommonService;
    private final CrmFollowService crmFollowService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final PrdOrgOrganizationService organizationService;
    private final PrdMessageConfigRepo repoMessage;
    private final PrdOrgOrganizationDAO daoOrg;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmFollowDAO followDAO;
    private final CrmPotentialCustomerDAO crmPotentialCustomerDAO;
    private final BusinessPartnerService businessPartnerService;
    @Resource
    private BusinessCustomerInfoService businessCustomerInfoService;
    private final BusinessTeamMemberService teamMemberService;
    @Value(value="${tw4.leads.operation}")
    private String leads_operation;
    private static final String[] MIDDLE_GROUND_PRODS = new String[]{"orthopaedic", "supply_chain", "marketing", "data", "financial", "fees_charged", "barcode", "stores", "srm", "scrm", "b2b", "problem", "dms", "oms", "ams"};

    @Transactional
    public CrmLeadsVO saveOne(CrmLeadsPayload payload) {
        CrmOffshoreDO offshoreDO;
        CrmLeadsDO oldEntity = null;
        if (payload.getCreateUserIdV4() != null) {
            payload.setCreateUserId(this.employeeDAO.getUserIdByV4(payload.getCreateUserIdV4()));
        }
        if (payload.getSaleUserIdV4() != null) {
            payload.setSaleUserId(this.employeeDAO.getUserIdByV4(payload.getSaleUserIdV4()));
        }
        if (payload.getSourceUserIdV4() != null) {
            payload.setSourceUserId(this.employeeDAO.getUserIdByV4(payload.getSaleUserIdV4()));
        }
        if (payload.getBonusDistributeToV4() != null && payload.getBonusDistributeType() != null) {
            switch (payload.getBonusDistributeType()) {
                case "personal": {
                    payload.setBonusDistributeTo(this.employeeDAO.getUserIdByV4(payload.getBonusDistributeToV4()));
                    break;
                }
                case "department": {
                    payload.setBonusDistributeTo(this.orgOrganizationDAO.getOrgIdByV4(payload.getBonusDistributeToV4()));
                }
            }
        }
        if (payload.getId() == null) {
            String leadsNo = this.generateSeqNum("LEADS", new String[0]);
            payload.setLeadsNo(leadsNo);
            payload.setLeadsStage("leads");
            payload.setLeadsStatus("undistributed");
            if (payload.getLeadsType() != null && payload.getLeadsType() == 1L) {
                payload.setSaleUserId((Long)(payload.getSaleUserId() == null ? (payload.getCreateUserId() == null ? null : payload.getCreateUserId()) : payload.getSaleUserId()));
                payload.setLeadsStage("sql");
                payload.setLeadsStatus("follow");
            }
        } else {
            oldEntity = this.dao.queryById(payload.getId());
        }
        CrmLeadsDO ado = CrmLeadsConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        ArrayList<CrmLeadsOffshoreDO> leadsOffshoreDOS = new ArrayList<CrmLeadsOffshoreDO>();
        if (payload.getOffshoreIds() != null && !payload.getOffshoreIds().isEmpty()) {
            List offshoreIds = payload.getOffshoreIds();
            for (int i = 0; i < offshoreIds.size(); ++i) {
                Long offshoreId = (Long)offshoreIds.get(i);
                offshoreDO = this.offshoreDAO.queryById(offshoreId);
                CrmLeadsOffshorePayload leadsOffshore = new CrmLeadsOffshorePayload();
                CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
                offshorePayload.setId(offshoreId);
                CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
                leadsPayload.setId(ado.getId());
                leadsOffshore.setOffshore(offshorePayload);
                leadsOffshore.setLeads(leadsPayload);
                Long distributeLeadsRemindTime = offshoreDO.getOffshoreRule() == null ? null : offshoreDO.getOffshoreRule().getDistributeLeadsRemindTime();
                LocalDateTime triggerTime = LocalDateTime.now().plusSeconds(distributeLeadsRemindTime == null || distributeLeadsRemindTime < 1L ? 10800L : distributeLeadsRemindTime);
                leadsOffshore.setNotDistributeLeadsRemindTime(triggerTime);
                CrmLeadsOffshoreDO leadsOffshoreDO = this.leadsOffshoreDAO.save(CrmLeadsOffshoreConvert.INSTANCE.toDo(leadsOffshore));
                leadsOffshoreDOS.add(leadsOffshoreDO);
                int num = this.offshoreDAO.countLeads(offshoreId);
                offshorePayload.setLeadsNum(Integer.valueOf(num));
                this.offshoreDAO.updateByKeyDynamic(offshorePayload);
            }
        }
        if (payload.getLeadsType() != null) {
            CrmLeadsOffshorePayload leadsOffshore = new CrmLeadsOffshorePayload();
            CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
            CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
            leadsPayload.setId(ado.getId());
            offshoreDO = new CrmOffshoreDO();
            if (payload.getLeadsType() == 0L) {
                offshoreDO = this.offshoreDAO.queryByOffshoreName("\u5458\u5de5\u8fd1\u6d77");
                leadsPayload.setOffshoreId(offshoreDO.getId());
                this.dao.updateByKeyDynamic(leadsPayload);
                Long distributeLeadsRemindTime = offshoreDO.getOffshoreRule().getDistributeLeadsRemindTime();
                LocalDateTime triggerTime = LocalDateTime.now().plusSeconds(distributeLeadsRemindTime == null || distributeLeadsRemindTime < 1L ? 10800L : distributeLeadsRemindTime);
                leadsOffshore.setNotDistributeLeadsRemindTime(triggerTime);
                offshorePayload.setId(offshoreDO.getId());
                leadsOffshore.setOffshore(offshorePayload);
                leadsOffshore.setLeads(leadsPayload);
                CrmLeadsOffshoreDO save = this.leadsOffshoreDAO.save(CrmLeadsOffshoreConvert.INSTANCE.toDo(leadsOffshore));
                leadsOffshoreDOS.add(save);
                this.leadsOffshoreDAO.setLeadsOffshoresOrder(save.getId(), 0);
            } else {
                this.dao.updateByKeyDynamic(leadsPayload);
                CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
                membersPayload.setUserId(payload.getSaleUserId());
                CrmLeadsPayload leadsPayload1 = new CrmLeadsPayload();
                leadsPayload1.setId(ado.getId());
                membersPayload.setLeads(leadsPayload1);
                this.updateMembers(Collections.singletonList(membersPayload));
            }
        }
        Object fieldsLog = "";
        if (payload.getId() == null) {
            this.logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Leads.getCode(), "\u65b0\u5efa " + ado.getLeadsName());
            fieldsLog = this.changeFieldLogUtil.getFieldsCreateLog(ado);
            CrmLeadsCustomerDO customer = ado.getCustomer();
            fieldsLog = (String)fieldsLog + this.changeFieldLogUtil.getFieldsCreateLog(customer);
        } else {
            fieldsLog = this.changeFieldLogUtil.getFieldsUpdateLog(ado, oldEntity);
            fieldsLog = (String)fieldsLog + this.changeFieldLogUtil.getFieldsUpdateLog(ado.getCustomer(), oldEntity.getCustomer());
        }
        if (fieldsLog != null && ((String)fieldsLog).length() > 0) {
            this.logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Leads.getCode(), (String)fieldsLog);
        }
        return CrmLeadsConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public List<CrmOffshoreListVO> getOffshoreList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        int i = this.offshoreDAO.countByOffshoreAdmin(userId);
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            CrmOffshoreQuery offshoreQuery = new CrmOffshoreQuery();
            Specification<CrmOffshoreDO> spec = this.offshoreDAO.getSpec(offshoreQuery);
            List<CrmOffshoreDO> all = this.offshoreDAO.findAll(spec);
            List<CrmOffshoreListVO> collect = all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo((CrmOffshoreDO)((Object)e))).filter(e -> !e.getOffshoreName().equals("\u65e0\u8fd1\u6d77")).distinct().collect(Collectors.toList());
            return collect;
        }
        if (i > 0) {
            CrmOffshoreQuery offshoreQuery = new CrmOffshoreQuery();
            offshoreQuery.setOffshoreAdminId(userId);
            Specification<CrmOffshoreDO> spec = this.offshoreDAO.getSpec(offshoreQuery);
            List<CrmOffshoreDO> all = this.offshoreDAO.findAll(spec);
            List<CrmOffshoreListVO> collect = all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo((CrmOffshoreDO)((Object)e))).filter(e -> !e.getOffshoreName().equals("\u65e0\u8fd1\u6d77")).distinct().collect(Collectors.toList());
            return collect;
        }
        List<String> statusList = Arrays.asList("undistributed", "back");
        leadsOffshoreQuery.setLeadsStatusList(statusList);
        leadsOffshoreQuery.setMemberId(userId);
        leadsOffshoreQuery.setDistributeReceiveRule("all");
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> all = this.leadsOffshoreDAO.findAll(spec);
        List<CrmOffshoreListVO> collect = all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo(e.getOffshore())).filter(e -> !e.getOffshoreName().equals("\u65e0\u8fd1\u6d77")).distinct().collect(Collectors.toList());
        return collect;
    }

    public PagingVO<CrmLeadsListVO> pagingOffshoreLeads(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec;
        GeneralUserDetails userDetails;
        if (null != leadsOffshoreQuery.getFollowCreateTimeStart() || null != leadsOffshoreQuery.getFollowCreateTimeEnd()) {
            ArrayList<Long> de = new ArrayList<Long>();
            de.add(9999L);
            leadsOffshoreQuery.setLeadsIdsForFollow(de);
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            OrderItem orderItem = OrderItem.desc((String)"createTime");
            crmFollowQuery.defaultOrder(orderItem);
            crmFollowQuery.setCreateTimeStart(leadsOffshoreQuery.getFollowCreateTimeStart());
            crmFollowQuery.setCreateTimeEnd(leadsOffshoreQuery.getFollowCreateTimeEnd());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Leads.name());
            List crmFollowVOList = this.crmFollowService.list(crmFollowQuery);
            List potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO -> crmFollowVO.getObjectId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                leadsOffshoreQuery.setLeadsIdsForFollow(potentialCustomerIdsForFollow);
            }
        }
        Long userId = (userDetails = SecurityContextUtil.currentUser()) == null ? 0L : userDetails.getUser().getId();
        int i = this.offshoreDAO.countByOffshoreAdmin(userId);
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        } else if (i > 0) {
            spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        } else {
            List<String> statusList = Arrays.asList("undistributed", "back");
            leadsOffshoreQuery.setLeadsStatusList(statusList);
            leadsOffshoreQuery.setMemberId(userId);
            leadsOffshoreQuery.setDistributeReceiveRule("all");
            leadsOffshoreQuery.setFilterOffshore(Boolean.valueOf(true));
            spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        }
        PageRequest pageRequest = leadsOffshoreQuery.getPageRequest();
        Page<CrmLeadsOffshoreDO> all = this.leadsOffshoreDAO.findAll(spec, (Pageable)pageRequest);
        List content = all.getContent();
        List<CrmLeadsListVO> collect = this.transLeadsOffshoreDoToListVO(content);
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    public List<CrmLeadsListVO> queryListMarketLeads(CrmLeadsQuery leadsQuery) {
        leadsQuery.setLeadsStageNotEqual("oppo");
        Specification<CrmLeadsDO> spec = this.dao.getSpec(leadsQuery);
        List<CrmLeadsDO> all = this.dao.findAll(spec);
        List<CrmLeadsListVO> collect = all.stream().map(e -> {
            CrmLeadsListVO leadsListVO = CrmLeadsConvert.INSTANCE.toListVo((CrmLeadsDO)e);
            leadsListVO.setDumpFlag(Boolean.valueOf(false));
            return leadsListVO;
        }).collect(Collectors.toList());
        this.transferList(collect);
        return collect;
    }

    public PagingVO<CrmLeadsListVO> pageListMarketLeads(CrmLeadsQuery leadsQuery) {
        leadsQuery.setLeadsStageNotEqual("oppo");
        return this.pageByQuery(leadsQuery);
    }

    public long countNotReceivedLeadsByUserId(long userId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setSaleUserId(Long.valueOf(userId));
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("distributed");
        leadsOffshoreQuery.setFilterLeadsOffshore(Boolean.valueOf(true));
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = this.leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    public PagingVO<CrmLeadsListVO> queryListNotReceivedLeadsByUserId(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        leadsOffshoreQuery.setSaleUserId(userId);
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("distributed");
        leadsOffshoreQuery.setFilterLeadsOffshore(Boolean.valueOf(true));
        PagingVO<CrmLeadsListVO> crmLeadsListVOPagingVO = this.pageByQuery(leadsOffshoreQuery);
        List records = crmLeadsListVOPagingVO.getRecords();
        crmLeadsListVOPagingVO.setRecords(records);
        return crmLeadsListVOPagingVO;
    }

    public long countNotDistributedLeadsByUserId(long userId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setOffshoreAdminId(Long.valueOf(userId));
        List<String> statusList = Arrays.asList("undistributed", "back");
        leadsOffshoreQuery.setLeadsStatusList(statusList);
        leadsOffshoreQuery.setLeadsStage("mql");
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = this.leadsOffshoreDAO.countBySpec(spec);
        return num;
    }

    public PagingVO<CrmLeadsListVO> queryListNotDistributedLeadsByUserId(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        leadsOffshoreQuery.setOffshoreAdminId(userId);
        List<String> statusList = Arrays.asList("undistributed", "back");
        leadsOffshoreQuery.setLeadsStatusList(statusList);
        leadsOffshoreQuery.setLeadsStage("mql");
        return this.pageByQuery(leadsOffshoreQuery);
    }

    private PagingVO<CrmLeadsListVO> pageByQuery(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Page<CrmLeadsOffshoreDO> all = this.leadsOffshoreDAO.findAll(spec, (Pageable)leadsOffshoreQuery.getPageRequest());
        List content = all.getContent();
        List<CrmLeadsListVO> collect = this.transLeadsOffshoreDoToListVO(content);
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    private PagingVO<CrmLeadsListVO> pageByQuery(CrmLeadsQuery leadsQuery) {
        Specification<CrmLeadsDO> spec = this.dao.getSpec(leadsQuery);
        Page<CrmLeadsDO> all = this.dao.findAll(spec, (Pageable)leadsQuery.getPageRequest());
        List content = all.getContent();
        List<CrmLeadsListVO> collect = content.stream().map(e -> CrmLeadsConvert.INSTANCE.toListVo((CrmLeadsDO)e)).collect(Collectors.toList());
        this.transferList(collect);
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    public Long leadsCount(CrmLeadsQuery leadsQuery) {
        Specification<CrmLeadsDO> spec = this.dao.getSpec(leadsQuery);
        return this.dao.count(spec);
    }

    @Transactional
    public List<CrmLeadsListVO> transLeadsOffshoreDoToListVO(List<CrmLeadsOffshoreDO> leadsOffshoreDOS) {
        ArrayList<CrmLeadsDO> content = new ArrayList<CrmLeadsDO>();
        for (CrmLeadsOffshoreDO crmLeadsOffshoreDO : leadsOffshoreDOS) {
            CrmLeadsDO leads = crmLeadsOffshoreDO.getLeads();
            CrmLeadsDO leadsClone = (CrmLeadsDO)leads.clone();
            leadsClone.setOffshore(crmLeadsOffshoreDO.getOffshore());
            leadsClone.setDumpFlag(crmLeadsOffshoreDO.getDumpFlag());
            content.add(leadsClone);
        }
        List<CrmLeadsListVO> collect = content.stream().map(e -> CrmLeadsConvert.INSTANCE.toListVo((CrmLeadsDO)e)).collect(Collectors.toList());
        this.transferList(collect);
        return collect;
    }

    public Integer countMarketLeads(Long marketId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setMarketId(marketId);
        leadsOffshoreQuery.setLeadsStageNotEqual("oppo");
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = this.leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    public Integer countMarketLeadsSql(Long marketId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setMarketId(marketId);
        leadsOffshoreQuery.setLeadsStage("sql");
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = this.leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    public Integer countMarketLeadsBack(Long marketId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setMarketId(marketId);
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("back");
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = this.leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    public BigDecimal countMarketLeadsFollowPercent(Integer marketLeads, Long projectId) {
        if (marketLeads.equals(0)) {
            return BigDecimal.ZERO;
        }
        Integer sqlLeads = this.countMarketLeadsSql(projectId);
        return new BigDecimal(sqlLeads).divide(new BigDecimal(marketLeads), 4, RoundingMode.UP).multiply(new BigDecimal(100));
    }

    public BigDecimal countMarketLeadsBackPercent(Long projectId) {
        Integer backLeads = this.countMarketLeadsBack(projectId);
        Integer sqlLeads = this.countMarketLeadsSql(projectId);
        if (backLeads + sqlLeads == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(backLeads).divide(new BigDecimal(sqlLeads + backLeads), 4, RoundingMode.UP).multiply(new BigDecimal(100));
    }

    public List<CrmLeadsListVO> queryListOffshoreLeads(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec;
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        int i = this.offshoreDAO.countByOffshoreAdmin(userId);
        if (i > 0) {
            leadsOffshoreQuery.setOffshoreAdminId(userId);
            spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        } else {
            List<String> statusList = Arrays.asList("undistributed", "back");
            leadsOffshoreQuery.setLeadsStage("sql");
            leadsOffshoreQuery.setLeadsStatusList(statusList);
            leadsOffshoreQuery.setMemberId(userId);
            leadsOffshoreQuery.setDistributeReceiveRule("all");
            spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        }
        List<CrmLeadsOffshoreDO> content = this.leadsOffshoreDAO.findAll(spec);
        List<CrmLeadsListVO> collect = this.transLeadsOffshoreDoToListVO(content);
        return collect;
    }

    @Transactional
    public PagingVO<CrmLeadsListVO> paging(CrmLeadsQuery leadsQuery) {
        leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed", "back"));
        if (null != leadsQuery.getFollowCreateTimeStart() || null != leadsQuery.getFollowCreateTimeEnd()) {
            ArrayList<Long> de = new ArrayList<Long>();
            de.add(9999L);
            leadsQuery.setLeadsIdsForFollow(de);
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            OrderItem orderItem = OrderItem.desc((String)"createTime");
            crmFollowQuery.defaultOrder(orderItem);
            crmFollowQuery.setCreateTimeStart(leadsQuery.getFollowCreateTimeStart());
            crmFollowQuery.setCreateTimeEnd(leadsQuery.getFollowCreateTimeEnd());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Leads.name());
            List crmFollowVOList = this.crmFollowService.list(crmFollowQuery);
            List potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO -> crmFollowVO.getObjectId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                leadsQuery.setLeadsIdsForFollow(potentialCustomerIdsForFollow);
            }
        }
        Long userId = leadsQuery.getQueryUserId() == null ? GlobalUtil.getLoginUserId() : leadsQuery.getQueryUserId();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            leadsQuery.setLeadsStageIn(Arrays.asList("oppo", "sql"));
            return this.pageByQuery(leadsQuery);
        }
        List<Object> userIds = new ArrayList();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
        if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
            Long orgId = prdOrgEmployeeRefVO.getOrgId();
            List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
            userIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
        } else {
            userIds = Collections.singletonList(userId);
        }
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = this.membersDAO.queryByUserIds(userIds);
        List ids = crmLeadsMembersDOS.stream().map(e -> e.getLeads().getId()).collect(Collectors.toList());
        leadsQuery.setIds(ids);
        leadsQuery.setSaleUserId(userId);
        leadsQuery.setLeadsStageNotIn(Arrays.asList("leads", "mql"));
        leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed", "back"));
        return this.pageByQuery(leadsQuery);
    }

    public Long count(CrmLeadsQuery leadsQuery) {
        GeneralUserDetails userDetails;
        leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed", "back"));
        if (null != leadsQuery.getFollowCreateTimeStart() || null != leadsQuery.getFollowCreateTimeEnd()) {
            ArrayList<Long> de = new ArrayList<Long>();
            de.add(9999L);
            leadsQuery.setLeadsIdsForFollow(de);
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            OrderItem orderItem = OrderItem.desc((String)"createTime");
            crmFollowQuery.defaultOrder(orderItem);
            crmFollowQuery.setCreateTimeStart(leadsQuery.getFollowCreateTimeStart());
            crmFollowQuery.setCreateTimeEnd(leadsQuery.getFollowCreateTimeEnd());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Leads.name());
            List crmFollowVOList = this.crmFollowService.list(crmFollowQuery);
            List potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO -> crmFollowVO.getObjectId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                leadsQuery.setLeadsIdsForFollow(potentialCustomerIdsForFollow);
            }
        }
        Long userId = (userDetails = SecurityContextUtil.currentUser()) == null ? 0L : userDetails.getUser().getId();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            leadsQuery.setLeadsStageIn(Arrays.asList("oppo", "sql"));
            return this.leadsCount(leadsQuery);
        }
        List<Object> userIds = new ArrayList();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
        if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
            Long orgId = prdOrgEmployeeRefVO.getOrgId();
            List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
            userIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
        } else {
            userIds = Collections.singletonList(userId);
        }
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = this.membersDAO.queryByUserIds(userIds);
        List ids = crmLeadsMembersDOS.stream().map(e -> e.getLeads().getId()).collect(Collectors.toList());
        leadsQuery.setIds(ids);
        leadsQuery.setSaleUserId(userId);
        leadsQuery.setLeadsStageNotIn(Arrays.asList("leads", "mql"));
        leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed", "back"));
        return this.leadsCount(leadsQuery);
    }

    public PagingVO<CrmLeadsListVO> pagingPersonalLeads(CrmLeadsQuery leadsQuery) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        leadsQuery.setCreateUserId(userId);
        return this.pageByQuery(leadsQuery);
    }

    public List<CrmLeadsListVO> queryList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = this.leadsOffshoreDAO.findAll(spec);
        List<CrmLeadsListVO> collect = this.transLeadsOffshoreDoToListVO(content);
        return collect;
    }

    private void filterFields(List<CrmLeadsListVO> leadsListVOS) {
        for (CrmLeadsListVO leadsListVO : leadsListVOS) {
            CrmLeadsCustomerVO customer = leadsListVO.getCustomer();
            CrmOffshoreListVO offshore = leadsListVO.getOffshore();
            List<CrmOffshoreRuleAttrExcludeDO> crmOffshoreRuleAttrExcludeDOS = this.offshoreRuleAttrExcludeDAO.queryByOffshoreId(offshore.getId());
            block12: for (CrmOffshoreRuleAttrExcludeDO excludeDO : crmOffshoreRuleAttrExcludeDOS) {
                switch (excludeDO.getLeadsAttribute()) {
                    case "customerName": 
                    case "customerIndustry": 
                    case "customerContacts": 
                    case "contactsDepartment": 
                    case "contactsPosition": 
                    case "contactsPhone": {
                        BeanUtil.setFieldValueByFieldName(excludeDO.getLeadsAttribute(), null, customer);
                        continue block12;
                    }
                }
                BeanUtil.setFieldValueByFieldName(excludeDO.getLeadsAttribute(), null, leadsListVO);
            }
        }
    }

    public List<CrmLeadsMembersVO> queryMembersList(Long leadsId) {
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = this.membersDAO.queryByLeadsId(leadsId);
        List<CrmLeadsMembersVO> collect = crmLeadsMembersDOS.stream().map(e -> {
            CrmLeadsMembersVO vo = CrmLeadsMembersConvert.INSTANCE.toVo((CrmLeadsMembersDO)((Object)e));
            if (!ObjectUtils.isEmpty((Object)vo.getUserId())) {
                String userName = this.cacheUtil.getUserName(vo.getUserId());
                vo.setUserName(userName);
            }
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    public List<PrdSystemLogVO> queryLogList(Long leadsId, String stage) {
        List prdSystemLogVOS = this.logService.queryLogList(leadsId, PrdSystemObjectEnum.Leads.getCode());
        if (stage != null && stage.equals("market")) {
            prdSystemLogVOS = prdSystemLogVOS.stream().filter(e -> e.getExtString1() == null || e.getExtString1() != null && !e.getExtString1().equals("saleLog")).collect(Collectors.toList());
        }
        return prdSystemLogVOS;
    }

    public PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Leads.getCode());
        return this.logService.pageLog(query);
    }

    public boolean isOffshoreAdmin() {
        boolean flag = false;
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        int i = this.offshoreDAO.countByOffshoreAdmin(userId);
        if (i > 0) {
            flag = true;
        }
        return flag;
    }

    @Transactional
    public void deleteOffshoreSoft(Long offshoreId, Long newOffshoreId) {
        List<CrmLeadsOffshoreDO> leadsOffshoreDOS = this.offshoreDAO.queryOffshoreLeads(offshoreId);
        if (leadsOffshoreDOS != null && !leadsOffshoreDOS.isEmpty()) {
            for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsOffshoreDOS) {
                CrmLeadsDO leads = leadsOffshoreDO.getLeads();
                CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
                leadsPayload.setId(leads.getId());
                leadsPayload.setOffshoreId(offshoreId);
                leadsPayload.setNewOffshoreId(newOffshoreId);
                leadsPayload.setTransferReason("\u539f\u8fd1\u6d77\u5220\u9664\uff0c\u7ebf\u7d22\u8f6c\u79fb\u5230\u672c\u8fd1\u6d77");
                this.transferLeadsOffshore(leadsPayload);
            }
            CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
            offshorePayload.setId(newOffshoreId);
            int num = this.offshoreDAO.countLeads(newOffshoreId);
            offshorePayload.setLeadsNum(Integer.valueOf(num));
            this.offshoreDAO.updateByKeyDynamic(offshorePayload);
        }
        CrmOffshorePayload payload = new CrmOffshorePayload();
        payload.setId(offshoreId);
        payload.setDeleteFlag(Integer.valueOf(1));
        this.offshoreService.dynamicUpdate(payload);
    }

    public void updateMembers(List<CrmLeadsMembersPayload> members) {
        for (CrmLeadsMembersPayload member : members) {
            CrmLeadsMembersDO crmLeadsMembersDO = CrmLeadsMembersConvert.INSTANCE.toDo(member);
            if (crmLeadsMembersDO.getDeleteFlag() != null && crmLeadsMembersDO.getDeleteFlag() == 1) {
                crmLeadsMembersDO.setUserId(crmLeadsMembersDO.getUserId() + System.currentTimeMillis() / 1000L);
            }
            try {
                this.membersDAO.save(crmLeadsMembersDO);
            }
            catch (Exception ex) {}
        }
    }

    @Transactional
    public void dynamicUpdate(CrmLeadsPayload payload, String action) {
        CrmLeadsDO crmLeadsDO = this.dao.queryById(payload.getId());
        if (null != crmLeadsDO && crmLeadsDO.getLeadsStage().equals("oppo")) {
            throw new BusinessException("\u8be5\u7ebf\u7d22\u5df2\u8f6c\u5316\u4e3a\u5546\u673a,\u8bf7\u52ff\u91cd\u590d\u8f6c\u5316");
        }
        CrmLeadsDO entityLog = new CrmLeadsDO();
        BeanUtils.copyProperties((Object)crmLeadsDO, (Object)entityLog);
        CrmLeadsCustomerDO oldCustomerDO = new CrmLeadsCustomerDO();
        BeanUtils.copyProperties((Object)((Object)crmLeadsDO.getCustomer()), (Object)((Object)oldCustomerDO));
        if (payload.getCustomer() != null && payload.getCustomer().getCustomerGrade() != null && crmLeadsDO.getFormalCustomerId() != null) {
            this.businessCustomerInfoService.changeCustomerGrade(crmLeadsDO.getFormalCustomerId(), payload.getCustomer().getCustomerGrade());
        }
        this.dao.updateByKeyDynamic(payload);
        crmLeadsDO = this.dao.queryById(payload.getId());
        Object fieldsLog = "";
        if (payload.getPreSaleUserId() != null) {
            fieldsLog = "\u5c06 " + crmLeadsDO.getLeadsName() + " \u7531 " + this.cacheUtil.getUserName(crmLeadsDO.getPreSaleUserId()) + " \u8f6c\u79fb\u7ed9 " + this.cacheUtil.getUserName(crmLeadsDO.getSaleUserId());
        } else if (payload.getNewOffshoreId() != null) {
            Long oldOffshore = payload.getOldOffshoreId();
            Long newOffshore = payload.getNewOffshoreId();
            if (oldOffshore != null && newOffshore != null) {
                fieldsLog = "\u5c06 " + crmLeadsDO.getLeadsName() + " \u7531 " + this.offshoreDAO.queryById(oldOffshore).getOffshoreName() + " \u8f6c\u79fb\u5230 " + this.offshoreDAO.queryById(newOffshore).getOffshoreName();
            }
        } else if (payload.getBackReason() != null) {
            fieldsLog = "\u9000\u56de " + crmLeadsDO.getLeadsName() + "\n\u9000\u56de\u539f\u56e0\uff1a" + crmLeadsDO.getBackReason();
        } else if (payload.getWithdrawReason() != null) {
            fieldsLog = "\u6536\u56de " + crmLeadsDO.getLeadsName() + "\n\u6536\u56de\u539f\u56e0\uff1a" + crmLeadsDO.getWithdrawReason();
        } else {
            fieldsLog = this.changeFieldLogUtil.getFieldsUpdateLog(crmLeadsDO, entityLog);
            fieldsLog = (String)fieldsLog + this.changeFieldLogUtil.getFieldsUpdateLog(crmLeadsDO.getCustomer(), oldCustomerDO);
        }
        if (fieldsLog != null && ((String)fieldsLog).length() > 0) {
            String leadsStage = crmLeadsDO.getLeadsStage();
            if (leadsStage != null && (leadsStage.equals("oppo") || leadsStage.equals("sql"))) {
                this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), (String)fieldsLog, "saleLog");
            } else {
                this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), (String)fieldsLog);
            }
        }
    }

    @Transactional
    public Object distributeLeads(CrmLeadsPayload payload) {
        Long offshoreId = payload.getOffshoreId();
        CrmOffshoreDO offshoreDO = this.offshoreDAO.queryById(offshoreId);
        CrmOffshoreRuleDO offshoreRule = offshoreDO.getOffshoreRule();
        String distributeReceiveRule = offshoreRule.getDistributeReceiveRule();
        List<CrmOffshoreMembersDO> offshoreMembers = offshoreDO.getOffshoreMembers();
        String string = distributeReceiveRule = distributeReceiveRule == null ? "distribute_all" : distributeReceiveRule;
        if (!distributeReceiveRule.equals("distribute_all")) {
            boolean flag = false;
            for (CrmOffshoreMembersDO offshoreMember : offshoreMembers) {
                if (!offshoreMember.getUserId().equals(payload.getSaleUserId())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                throw TwException.error("", "\u6839\u636e\u5f53\u524d\u8fd1\u6d77\u7684\u89c4\u5219\uff0c\u7ebf\u7d22\u4e0d\u80fd\u5206\u914d\u7ed9\u8fd1\u6d77\u6210\u5458\u4ee5\u5916\u7684\u4eba\u5458");
            }
        }
        payload.setLeadsStatus("distributed");
        payload.setDistributeDate(LocalDate.now());
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setLeadsId(payload.getId());
        CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
        membersPayload.setUserId(payload.getSaleUserId());
        membersPayload.setLeads(payload);
        this.updateMembers(Collections.singletonList(membersPayload));
        CrmLeadsVO crmLeadsVO = this.dao.queryByKey(payload.getId());
        if (crmLeadsVO != null && crmLeadsVO.getFormalCustomerId() != null && payload.getSaleUserId() != null) {
            Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getSaleUserId());
            List businessTeamMemberVOS = this.teamMemberService.queryByObjectIdAndRole(crmLeadsVO.getFormalCustomerId(), BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
            if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                BusinessTeamMemberVO businessTeamMemberVO = (BusinessTeamMemberVO)businessTeamMemberVOS.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getSaleUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getSaleUserId());
                this.teamMemberService.update(businessTeamMemberPayload);
            } else {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getSaleUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getSaleUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SERVICE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(crmLeadsVO.getFormalCustomerId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SERVICE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                this.teamMemberService.save(businessTeamMemberPayload);
            }
        }
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> leadsOffshoreDOS = this.leadsOffshoreDAO.findAll(spec);
        for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsOffshoreDOS) {
            CrmLeadsOffshorePayload crmLeadsOffshorePayload = new CrmLeadsOffshorePayload();
            crmLeadsOffshorePayload.setId(leadsOffshoreDO.getId());
            crmLeadsOffshorePayload.setNullFields(Arrays.asList("notDistributeLeadsRemindTime"));
            this.leadsOffshoreDAO.updateByKeyDynamic(crmLeadsOffshorePayload);
        }
        Long followLeadsRemindTime = offshoreDO.getOffshoreRule().getFollowLeadsRemindTime() == null || offshoreDO.getOffshoreRule().getFollowLeadsRemindTime() < 1L ? 10800L : offshoreDO.getOffshoreRule().getFollowLeadsRemindTime();
        LocalDateTime remindTime = LocalDateTime.now().plusSeconds(followLeadsRemindTime);
        payload.setNotFollowLeadsRemindTime(remindTime);
        this.dynamicUpdate(payload, PrdSystemLogEnum.DISTRIBUTE.getDesc());
        return this.sendLeadsMessage("distribute", this.dao.queryById(payload.getId()), null);
    }

    @Transactional
    public void batchDistributeLeads(List<CrmLeadsPayload> payloads) {
        for (CrmLeadsPayload payload : payloads) {
            this.distributeLeads(payload);
        }
    }

    @Transactional
    public void withdrawLeads(CrmLeadsPayload payload) {
        CrmLeadsVO crmLeadsVO = this.dao.queryByKey(payload.getId());
        CrmLeadsVO crmLeadsVOCopy = new CrmLeadsVO();
        BeanUtils.copyProperties((Object)crmLeadsVO, (Object)crmLeadsVOCopy);
        payload.setLeadsStatus("undistributed");
        payload.setLeadsStage("mql");
        List<String> nullFields = Arrays.asList("saleUserId", "distributeDate");
        payload.setNullFields(nullFields);
        this.dynamicUpdate(payload, PrdSystemLogEnum.WITHDRAW.getDesc());
        crmLeadsVO = this.dao.queryByKey(payload.getId());
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20220711001505");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("leadsName", crmLeadsVO.getLeadsName());
        result.put("withdrawReason", crmLeadsVO.getWithdrawReason());
        result.put("url", "/leadsManager/detail?id=" + payload.getId() + "&offshoreId=-1&from=leads&canEdit=false");
        this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", crmLeadsVOCopy.getSaleUserId().toString());
    }

    public void receiveLeads(Long key) {
        CrmLeadsPayload payload = new CrmLeadsPayload();
        payload.setLeadsStage("sql");
        payload.setLeadsStatus("follow");
        payload.setId(key);
        this.dynamicUpdate(payload, PrdSystemLogEnum.RECEIVE.getDesc());
        this.sendLeadsMessage("receive", this.dao.queryById(payload.getId()), null);
    }

    @Transactional
    public void backLeads(CrmLeadsPayload payload) {
        Long leadsId = payload.getId();
        CrmLeadsDO leadsDO = this.dao.queryById(leadsId);
        Long preSaleUserId = leadsDO.getPreSaleUserId();
        String action = "";
        if (preSaleUserId != null) {
            payload.setSaleUserId(preSaleUserId);
            List<String> nullFields = Arrays.asList("distributeDate");
            payload.setNullFields(nullFields);
            action = "\u62d2\u7edd";
            CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
            membersPayload.setUserId(preSaleUserId);
            membersPayload.setLeads(payload);
            this.updateMembers(Collections.singletonList(membersPayload));
        } else {
            payload.setLeadsStatus("back");
            payload.setLeadsStage("mql");
            List<String> nullFields = Arrays.asList("saleUserId", "distributeDate");
            payload.setNullFields(nullFields);
            action = "\u9000\u56de";
            List<CrmLeadsMembersDO> crmLeadsMembersDOS = this.membersDAO.queryByLeadsId(payload.getId());
            if (crmLeadsMembersDOS != null && crmLeadsMembersDOS.size() > 0) {
                this.membersDAO.deleteSoft(crmLeadsMembersDOS.stream().map(e -> e.getId()).collect(Collectors.toList()));
            }
            int existNum = this.leadsOffshoreDAO.getExist(leadsId, 585574794225788164L);
            if (leadsDO.getSourceType() != null && leadsDO.getSourceType().equals("personal") && existNum < 1) {
                CrmLeadsOffshoreDO crmLeadsOffshoreDO = new CrmLeadsOffshoreDO();
                CrmLeadsDO crmLeadsDO = new CrmLeadsDO();
                crmLeadsDO.setId(leadsId);
                CrmOffshoreDO newOffshoreDO = new CrmOffshoreDO();
                newOffshoreDO.setId(585574794225788164L);
                crmLeadsOffshoreDO.setOffshore(newOffshoreDO);
                crmLeadsOffshoreDO.setLeads(crmLeadsDO);
                this.leadsOffshoreDAO.save(crmLeadsOffshoreDO);
            }
            this.sendLeadsMessage("back", this.dao.queryById(payload.getId()), payload.getBackReason());
        }
        this.dynamicUpdate(payload, PrdSystemLogEnum.BACK.getDesc());
    }

    @Transactional
    public void transferLeadsUser(CrmLeadsPayload payload) {
        payload.setLeadsStage("mql");
        CrmLeadsDO leadsDO = this.dao.queryById(payload.getId());
        payload.setLeadsStatus("distributed");
        payload.setPreSaleUserId(leadsDO.getSaleUserId());
        this.dynamicUpdate(payload, PrdSystemLogEnum.TRANSFER.getDesc());
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = this.membersDAO.queryByLeadsId(payload.getId());
        if (crmLeadsMembersDOS != null && crmLeadsMembersDOS.size() > 0) {
            this.membersDAO.deleteSoft(crmLeadsMembersDOS.stream().map(e -> e.getId()).collect(Collectors.toList()));
        }
        CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
        membersPayload.setUserId(payload.getSaleUserId());
        membersPayload.setLeads(payload);
        this.updateMembers(Collections.singletonList(membersPayload));
    }

    @Transactional
    public void transferLeadsOffshore(CrmLeadsPayload payload) {
        CrmLeadsDO leadsDO = this.dao.queryById(payload.getId());
        if (leadsDO.getLeadsOffshores() != null && leadsDO.getLeadsOffshores().size() > 0 && leadsDO.getLeadsOffshores().get(0) != null) {
            CrmOffshoreDO offshore = leadsDO.getLeadsOffshores().get(0).getOffshore();
            CrmOffshoreDO offshoreCopy = new CrmOffshoreDO();
            BeanUtils.copyProperties((Object)((Object)offshore), (Object)((Object)offshoreCopy));
            payload.setOldOffshoreId(offshoreCopy.getId());
        }
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setOffshoreId(payload.getOffshoreId());
        leadsOffshoreQuery.setLeadsId(payload.getId());
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = this.leadsOffshoreDAO.findAll(spec);
        CrmLeadsOffshoreDO crmLeadsOffshoreDO = content.get(0);
        Long newOffshoreId = payload.getNewOffshoreId();
        CrmOffshoreDO newOffshoreDO = new CrmOffshoreDO();
        newOffshoreDO.setId(newOffshoreId);
        crmLeadsOffshoreDO.setOffshore(newOffshoreDO);
        try {
            this.leadsOffshoreDAO.save(crmLeadsOffshoreDO);
        }
        catch (Exception e2) {
            this.leadsOffshoreDAO.deleteSoft(crmLeadsOffshoreDO.getId());
        }
        payload.setLeadsStatus("undistributed");
        payload.setOffshoreId(newOffshoreId);
        this.dynamicUpdate(payload, PrdSystemLogEnum.TRANSFER.getDesc());
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = this.membersDAO.queryByLeadsId(payload.getId());
        if (crmLeadsMembersDOS != null && crmLeadsMembersDOS.size() > 0) {
            this.membersDAO.deleteSoft(crmLeadsMembersDOS.stream().map(e -> e.getId()).collect(Collectors.toList()));
        }
    }

    @Transactional
    public void transferLeadsOffshoreBatch(List<CrmLeadsPayload> payloads) {
        for (CrmLeadsPayload payload : payloads) {
            this.transferLeadsOffshore(payload);
        }
    }

    public void closeLeads(CrmLeadsPayload payload) {
        payload.setLeadsStatus("closed");
        this.dynamicUpdate(payload, PrdSystemLogEnum.CLOSE.getDesc());
        CrmLeadsDO leadsDO = this.dao.queryById(payload.getId());
        if (leadsDO != null) {
            this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), "\u5173\u95ed " + leadsDO.getLeadsName());
        }
    }

    @Transactional
    public void remarkLeads(CrmLeadsPayload payload) {
        Object remark = "";
        remark = PrdSystemLogEnum.REMARK.getDesc() + "\u4e3a" + payload.getLeadsStage();
        this.dynamicUpdate(payload, (String)remark);
    }

    @Transactional
    public void batchRemarkLeads(List<CrmLeadsPayload> payloads) {
        for (CrmLeadsPayload payload : payloads) {
            this.remarkLeads(payload);
        }
    }

    @Transactional
    public Long toOpportunity(Long id, CrmOpportunityPayload opportunityPayload) {
        CrmLeadsPayload payload = new CrmLeadsPayload();
        payload.setId(id);
        payload.setLeadsStatus("closed");
        payload.setCloseReason("oppo");
        payload.setLeadsStage("oppo");
        String remark = "\u5df2\u8f6c\u4e3a\u5546\u673a";
        this.dynamicUpdate(payload, remark);
        CrmOpportunityVO insert = this.opportunityService.insert(opportunityPayload);
        this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), this.dao.queryById(id).getLeadsName() + " \u5df2\u8f6c\u4e3a\u5546\u673a");
        return insert.getId();
    }

    public Map<String, String> queryFields() {
        ArrayList<String> withChildrenFields = new ArrayList<String>();
        withChildrenFields.add("customer");
        Map<String, String> value = BeanUtil.getAllFieldsAndName(CrmLeadsDO.class, withChildrenFields);
        return value;
    }

    @Transactional
    public void updateFollow(CrmFollowPayload payload) {
        payload.setFollowObject(CrmFollowObjectEnum.Leads.getCode());
        this.followService.addFollow(payload);
        CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
        Long leadsId = payload.getObjectId();
        leadsPayload.setId(leadsId);
        leadsPayload.setNullFields(Arrays.asList("notFollowLeadsRemindTime"));
        this.dao.updateByKeyDynamic(leadsPayload);
    }

    @Transactional
    public CrmLeadsVO queryDetail(Long offshoreId, Long id) {
        CrmLeadsDO detail = this.dao.queryById(id);
        CrmLeadsVO crmLeadsVO = CrmLeadsConvert.INSTANCE.toVo(detail);
        CrmOffshoreDO offshoreDO = new CrmOffshoreDO();
        if (offshoreId != -1L) {
            offshoreDO = this.offshoreDAO.queryById(offshoreId);
            CrmOffshoreListVO crmOffshoreListVO = CrmOffshoreConvert.INSTANCE.toListVo(offshoreDO);
            crmLeadsVO.setOffshore(crmOffshoreListVO);
        }
        Map orgMap = this.organizationService.queryOrgs(Arrays.asList(crmLeadsVO.getDemandProductOrg()));
        this.transferDetail(crmLeadsVO, orgMap);
        return crmLeadsVO;
    }

    @Transactional
    public void deleteSoft(List<Long> asList) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole == null || userIdsByRole.isEmpty() || !userIdsByRole.contains(userId)) {
            throw TwException.error("", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8fd1\u6d77\u7ebf\u7d22\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        for (Long aLong : asList) {
            CrmLeadsDO leadsDO = this.dao.queryById(aLong);
            String leadsStatus = leadsDO.getLeadsStatus();
            if (leadsStatus.equals("undistributed")) continue;
            throw TwException.error("", "\u53ea\u6709\u672a\u5206\u914d\u72b6\u6001\u7684\u7ebf\u7d22\u624d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        this.dao.deleteSoft(asList);
        this.leadsOffshoreDAO.deleteSoftByLeadsIds(asList);
    }

    private void transferDetail(CrmLeadsVO vo, Map<Long, String> orgMap) {
        PrdOrgEmployeeVO employee;
        if (vo.getArea() != null) {
            vo.setAreaName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), vo.getArea()));
        }
        vo.setLeadsStageDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStage.getCode(), vo.getLeadsStage()));
        vo.setLeadsStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStatus.getCode(), vo.getLeadsStatus()));
        String bonusDistributeType = vo.getBonusDistributeType();
        vo.setBonusDistributeTypeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsBonusDistributeType.getCode(), bonusDistributeType));
        vo.setSourceTypeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsSourceType.getCode(), vo.getSourceType()));
        vo.setCloseReasonDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsCloseReason.getCode(), vo.getCloseReason()));
        vo.setDemandProductDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), vo.getDemandProduct()));
        vo.setDemandProductOrgName(orgMap.get(vo.getDemandProductOrg()));
        vo.setAnnualTurnoverDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsAnnualTurnover.getCode(), vo.getAnnualTurnover()));
        CrmLeadsCustomerVO customer = vo.getCustomer();
        if (customer != null) {
            customer.setCustomerGradeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), customer.getCustomerGrade()));
            customer.setCustomerIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), customer.getCustomerIndustry()));
            customer.setCustRegionDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), customer.getCustRegion()));
        }
        if (vo.getMarketChannel() != null) {
            String marketChannel = vo.getMarketChannel();
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                vo.setMarketChannelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
            } else {
                String s1 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                String s2 = "";
                switch (split[0]) {
                    case "baidu": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                        break;
                    }
                    case "sem_360": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                        break;
                    }
                    case "offline_activity": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                        break;
                    }
                    case "thrid_party_data": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                    }
                }
                vo.setMarketChannelDesc((String)(s2.equals("") ? s1 : s1 + "/" + s2));
            }
        }
        if (!ObjectUtils.isEmpty((Object)vo.getBonusDistributeTo())) {
            vo.setBonusDistributeToUserName("");
            if ("personal".equals(bonusDistributeType)) {
                vo.setBonusDistributeToUserName(this.cacheUtil.getUserName(vo.getBonusDistributeTo()));
            } else if ("department".equals(bonusDistributeType)) {
                PrdOrgOrganizationVO prdOrgOrganizationVO = this.orgOrganizationDAO.queryOrgById(vo.getBonusDistributeTo());
                vo.setBonusDistributeToUserName(null != prdOrgOrganizationVO ? prdOrgOrganizationVO.getOrgName() : "");
            }
        }
        if (!ObjectUtils.isEmpty((Object)vo.getSaleUserId()) && (employee = this.cacheUtil.getEmployee(vo.getSaleUserId())) != null) {
            vo.setSaleUserName(employee.getEmployeeName());
            vo.setSaleEmployeeNo(employee.getEmployeeNo());
        }
        if (!ObjectUtils.isEmpty((Object)vo.getSourceUserId()) && (employee = this.cacheUtil.getEmployee(vo.getSourceUserId())) != null) {
            vo.setSourceUserName(employee.getEmployeeName());
            vo.setSourceEmployeeNo(employee.getEmployeeNo());
        }
        if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
            vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        }
    }

    private void transferList(List<CrmLeadsListVO> list) {
        List<Long> leadsListIds = list.stream().map(BaseViewModel::getId).toList();
        List<CrmFollowVO> lastFollowVOS = this.followDAO.findLastFollowByObjectIds(leadsListIds, CrmFollowObjectEnum.Leads.name());
        HashMap lastFollowMap = new HashMap(lastFollowVOS.size());
        lastFollowVOS.forEach(crmFollowVO -> lastFollowMap.put(crmFollowVO.getObjectId(), crmFollowVO));
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.employeeDAO.queryUserOrgDataList();
        for (CrmLeadsListVO vo : list) {
            CrmLeadsCustomerVO customer;
            CrmFollowVO lastFollowVO = (CrmFollowVO)lastFollowMap.get(vo.getId());
            if (lastFollowVO != null) {
                vo.setFollow(lastFollowVO);
            }
            if (vo.getArea() != null) {
                vo.setAreaName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), vo.getArea()));
            }
            vo.setLeadsStageDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStage.getCode(), vo.getLeadsStage()));
            vo.setLeadsStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStatus.getCode(), vo.getLeadsStatus()));
            vo.setSourceTypeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsSourceType.getCode(), vo.getSourceType()));
            vo.setDemandProductDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), vo.getDemandProduct()));
            vo.setAnnualTurnoverDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsAnnualTurnover.getCode(), vo.getAnnualTurnover()));
            if (vo.getMarketChannel() != null) {
                String marketChannel = vo.getMarketChannel();
                String[] split = marketChannel.split(",");
                if (split.length < 2) {
                    vo.setMarketChannelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
                } else {
                    String s1 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                    String s2 = "";
                    switch (split[0]) {
                        case "baidu": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                            break;
                        }
                        case "sem_360": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                            break;
                        }
                        case "offline_activity": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                            break;
                        }
                        case "thrid_party_data": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                        }
                    }
                    vo.setMarketChannelDesc((String)(s2.equals("") ? s1 : s1 + "/" + s2));
                }
            }
            if ((customer = vo.getCustomer()) != null) {
                customer.setCustomerIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), customer.getCustomerIndustry()));
                customer.setCustRegionDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), customer.getCustRegion()));
                customer.setCustomerGradeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), customer.getCustomerGrade()));
            }
            if (!ObjectUtils.isEmpty((Object)vo.getSaleUserId())) {
                vo.setSaleUserName(this.cacheUtil.getUserName(vo.getSaleUserId()));
            }
            if (!ObjectUtils.isEmpty((Object)vo.getSourceUserId())) {
                vo.setSourceUserName(this.cacheUtil.getUserName(vo.getSourceUserId()));
            }
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            String leadsTagIds = vo.getLeadsTagIds();
            ArrayList<PrdSystemTagVO> leadsTags = new ArrayList<PrdSystemTagVO>();
            if (leadsTagIds != null && !leadsTagIds.isEmpty()) {
                String[] tags = leadsTagIds.split(",");
                for (String tag : tags) {
                    List<PrdSystemTagVO> systemTags = this.cacheUtil.getSystemTag(Long.parseLong(tag));
                    leadsTags.addAll(systemTags);
                }
            }
            vo.setLeadsTags(leadsTags);
            if (vo.getSaleUserId() == null) continue;
            Long saleUserId = vo.getSaleUserId();
            for (PrdOrgEmployeeRefVO prdOrgEmployeeRefVO : prdOrgEmployeeRefVOS) {
                if (!prdOrgEmployeeRefVO.getUserId().equals(saleUserId)) continue;
                vo.setSaleUserBuId(prdOrgEmployeeRefVO.getOrgId());
                vo.setSaleUserBuName(prdOrgEmployeeRefVO.getOrgName());
            }
        }
    }

    public void downloadBatchOffshore(HttpServletResponse response, CrmLeadsOffshoreQuery query) {
        if (StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("model")) {
            this.downloadModel(response);
        } else {
            PagingVO<CrmLeadsListVO> paging = this.pagingOffshoreLeads(query);
            this.download(paging.getRecords(), "\u8fd1\u6d77\u6c60\u6570\u636e", response, 1);
        }
    }

    public void downloadBatch(HttpServletResponse response, CrmLeadsQuery query) {
        if (StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("model")) {
            this.downloadModel(response);
        } else {
            PagingVO<CrmLeadsListVO> paging = this.paging(query);
            this.download(paging.getRecords(), "\u7ebf\u7d22\u6570\u636e", response, 2);
        }
    }

    public Map<String, Object> importBatch(HttpServletResponse response, MultipartFile file, Boolean force) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error(e2.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u7ebf\u7d22\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<CrmLeadsPayload> leadsPayloads = new ArrayList<CrmLeadsPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String sourceUserId;
            Object importError = "";
            Object importWarn = "";
            CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
            Row row = sheet.getRow(i);
            String leadsName = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText((String)leadsName) && leadsName.length() > 0) {
                leadsPayload.setLeadsName(leadsName);
            } else {
                importError = (String)importError + "\u7ebf\u7d22\u540d\u79f0\u4e3a\u7a7a;";
            }
            String offshoreIdsStr = ExcelUtil.getCellFormatValue(row.getCell(37));
            if (StringUtils.hasText((String)offshoreIdsStr) && offshoreIdsStr.length() > 0) {
                List offshoreIds = Arrays.asList(offshoreIdsStr.split(",")).stream().map(e -> Long.parseLong(e)).collect(Collectors.toList());
                leadsPayload.setOffshoreIds(offshoreIds);
                leadsPayload.setOffshoreIdsStr(offshoreIdsStr);
                leadsPayload.setOffshoreIdsDesc(ExcelUtil.getCellFormatValue(row.getCell(1)));
            } else {
                importError = (String)importError + "\u8fd1\u6d77\u4e0d\u80fd\u4e3a\u7a7a;";
            }
            String marketId = ExcelUtil.getCellFormatValue(row.getCell(38));
            if (StringUtils.hasText((String)marketId) && marketId.length() > 0) {
                PrjProjectPayload prjProjectPayload = new PrjProjectPayload();
                prjProjectPayload.setId(Long.valueOf(Long.parseLong(marketId)));
                leadsPayload.setMarket(prjProjectPayload);
                leadsPayload.setMarketId(marketId);
                leadsPayload.setMarketIdDesc(ExcelUtil.getCellFormatValue(row.getCell(2)));
            }
            leadsPayload.setSourceTypeDesc(ExcelUtil.getCellFormatValue(row.getCell(4)));
            leadsPayload.setSourceType(ExcelUtil.getCellFormatValue(row.getCell(39)));
            leadsPayload.setMarketChannel(ExcelUtil.getCellFormatValue(row.getCell(5)));
            String saleUserId = ExcelUtil.getCellFormatValue(row.getCell(40));
            if (StringUtils.hasText((String)saleUserId) && saleUserId.length() > 0) {
                leadsPayload.setSaleUserId(Long.valueOf(Long.parseLong(saleUserId)));
                leadsPayload.setSaleUserName(ExcelUtil.getCellFormatValue(row.getCell(6)));
            }
            if (StringUtils.hasText((String)(sourceUserId = ExcelUtil.getCellFormatValue(row.getCell(41)))) && sourceUserId.length() > 0) {
                leadsPayload.setSourceUserId(Long.valueOf(Long.parseLong(sourceUserId)));
                leadsPayload.setSourceUserName(ExcelUtil.getCellFormatValue(row.getCell(7)));
            }
            leadsPayload.setCloseReason(ExcelUtil.getCellFormatValue(row.getCell(8)));
            leadsPayload.setExtString1(ExcelUtil.getCellFormatValue(row.getCell(19)));
            leadsPayload.setExtString2(ExcelUtil.getCellFormatValue(row.getCell(20)));
            String createTime = ExcelUtil.getCellFormatValue(row.getCell(21));
            if (createTime != null && createTime != "") {
                try {
                    LocalDate parse = LocalDate.parse(createTime);
                    leadsPayload.setCreateTime(parse.atStartOfDay());
                }
                catch (Exception e3) {
                    importError = (String)importError + "\u521b\u5efa\u65f6\u95f4\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b";
                }
            }
            leadsPayload.setRemark(ExcelUtil.getCellFormatValue(row.getCell(22)));
            CrmLeadsCustomerPayload customerPayload = new CrmLeadsCustomerPayload();
            String customerName = ExcelUtil.getCellFormatValue(row.getCell(9));
            List company = new ArrayList();
            if (customerName != null && customerName.length() > 0 && (company = this.crmCommonService.checkRepeat("company", customerName)) != null && !company.isEmpty()) {
                Iterator iterator = company.iterator();
                while (iterator.hasNext()) {
                    Map stringObjectMap;
                    stringObjectMap.put("salesMan", (stringObjectMap = (Map)iterator.next()).get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                    importWarn = (String)importWarn + "\u91cd\u590d\u7c7b\u578b\uff1a" + stringObjectMap.get("repeatType") + ",\u4f01\u4e1a\u540d\u79f0\uff1a" + stringObjectMap.get("companyName") + ",\u8054\u7cfb\u4eba\uff1a" + stringObjectMap.get("contactsName") + ",\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a" + stringObjectMap.get("contactsPhone") + "\uff0c\u9500\u552e\u4eba\u5458\uff1a" + stringObjectMap.get("salesMan") + ";";
                }
            }
            customerPayload.setCustomerName(customerName);
            customerPayload.setCustomerIndustryDesc(ExcelUtil.getCellFormatValue(row.getCell(10)));
            customerPayload.setCustomerIndustry(ExcelUtil.getCellFormatValue(row.getCell(42)));
            customerPayload.setCustomerGradeDesc(ExcelUtil.getCellFormatValue(row.getCell(11)));
            customerPayload.setCustomerGrade(ExcelUtil.getCellFormatValue(row.getCell(43)));
            customerPayload.setCustRegionDesc(ExcelUtil.getCellFormatValue(row.getCell(12)));
            customerPayload.setCustRegion(ExcelUtil.getCellFormatValue(row.getCell(44)));
            String customerContacts = ExcelUtil.getCellFormatValue(row.getCell(13));
            if (StringUtils.hasText((String)customerContacts) && customerContacts.length() > 0) {
                customerPayload.setCustomerContacts(customerContacts);
            } else {
                importError = (String)importError + "\u5ba2\u6237\u8054\u7cfb\u4eba\u4e3a\u7a7a;";
            }
            customerPayload.setContactsDepartment(ExcelUtil.getCellFormatValue(row.getCell(14)));
            String customerPhone = ExcelUtil.getCellFormatValue(row.getCell(15));
            if (customerPhone != null && customerPhone.length() > 0) {
                List phone = this.crmCommonService.checkRepeat("phone", customerPhone);
                if (phone != null && !phone.isEmpty()) {
                    for (Map stringObjectMap : phone) {
                        boolean repeatFlag = false;
                        for (Map companyMap : company) {
                            if (!companyMap.get("id").equals(stringObjectMap.get("id")) || !companyMap.get("repeatType").equals(stringObjectMap.get("repeatType"))) continue;
                            repeatFlag = true;
                            break;
                        }
                        if (repeatFlag) continue;
                        stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                        importWarn = (String)importWarn + "\u91cd\u590d\u7c7b\u578b\uff1a" + stringObjectMap.get("repeatType") + ",\u4f01\u4e1a\u540d\u79f0\uff1a" + stringObjectMap.get("companyName") + ",\u8054\u7cfb\u4eba\uff1a" + stringObjectMap.get("contactsName") + ",\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a" + stringObjectMap.get("contactsPhone") + "\uff0c\u9500\u552e\u4eba\u5458\uff1a" + stringObjectMap.get("salesMan") + ";";
                    }
                }
            } else {
                importError = (String)importError + "\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a;";
            }
            customerPayload.setContactsPhone(customerPhone);
            customerPayload.setContactsPosition(ExcelUtil.getCellFormatValue(row.getCell(17)));
            customerPayload.setContactsEmail(ExcelUtil.getCellFormatValue(row.getCell(16)));
            customerPayload.setSaleProduct(ExcelUtil.getCellFormatValue(row.getCell(18)));
            leadsPayload.setCustomer(customerPayload);
            leadsPayload.setImoprtError((String)importError);
            leadsPayload.setImportWarn((String)importWarn);
            leadsPayloads.add(leadsPayload);
        }
        int warnNum = 0;
        int errorNum = 0;
        for (CrmLeadsPayload leadsPayload : leadsPayloads) {
            if (StringUtils.hasText((String)leadsPayload.getImoprtError()) && leadsPayload.getImoprtError().length() > 0) {
                ++errorNum;
            }
            if (!StringUtils.hasText((String)leadsPayload.getImportWarn()) && leadsPayload.getImportWarn().length() <= 0 || force.booleanValue()) continue;
            ++warnNum;
        }
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(leadsPayloads));
        } else if (warnNum > 0) {
            resultMap.put("ok", "warn");
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(leadsPayloads));
        } else {
            ArrayList<Long> leadsIds = new ArrayList<Long>();
            for (CrmLeadsPayload leadsPayload : leadsPayloads) {
                CrmLeadsVO crmLeadsVO = this.saveOne(leadsPayload);
                leadsIds.add(crmLeadsVO.getId());
            }
            resultMap.put("ok", "ok");
            resultMap.put("leadsIds", leadsIds);
        }
        return resultMap;
    }

    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/crmLeadsBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet leadsSheet = (XSSFSheet)workbook.getSheet("\u7ebf\u7d22\u6570\u636e");
            Sheet lovSheet = workbook.getSheet("LOV");
            Sheet offshoreSheet = workbook.getSheet("\u8fd1\u6d77\u5217\u8868");
            Sheet marketSheet = workbook.getSheet("\u5e02\u573a\u6d3b\u52a8\u5217\u8868");
            Sheet employeeSheet = workbook.getSheet("\u4eba\u5458\u4e0b\u62c9");
            List leadsStatusSelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsStatus.getCode());
            this.excelUtil.insertLOVdata(lovSheet, leadsStatusSelectionVOS, 0);
            List leadsStageSelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsStage.getCode());
            this.excelUtil.insertLOVdata(lovSheet, leadsStageSelectionVOS, 2);
            List sourceTypeSelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsSourceType.getCode());
            this.excelUtil.insertLOVdata(lovSheet, sourceTypeSelectionVOS, 4);
            List customerIndustrySelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerIndustry.getCode());
            this.excelUtil.insertLOVdata(lovSheet, customerIndustrySelectionVOS, 6);
            List customerGradeSelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerGrade.getCode());
            this.excelUtil.insertLOVdata(lovSheet, customerGradeSelectionVOS, 8);
            List custRegionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerRegion.getCode());
            this.excelUtil.insertLOVdata(lovSheet, custRegionVOS, 10);
            List crmOffshoreListVOS = this.offshoreService.queryList(new CrmOffshoreQuery());
            this.excelUtil.insertListData(offshoreSheet, crmOffshoreListVOS, "id", "offshoreName", 0);
            List<PrjProjectVO> prjProjectVOS = this.marketDAO.queryListDynamic(new PrjProjectQuery());
            this.excelUtil.insertListData(marketSheet, prjProjectVOS, "id", "projectName", 0);
            List prdOrgEmployeeVOS = this.employeeService.queryList(new PrdOrgEmployeeQuery());
            this.excelUtil.insertListData(employeeSheet, prdOrgEmployeeVOS, "userId", "employeeName", 0);
            this.excelUtil.generateRangeList(leadsSheet, 1, 1, "\u8fd1\u6d77\u5217\u8868", 2, "A");
            this.excelUtil.generateRangeList(leadsSheet, 2, 1, "\u5e02\u573a\u6d3b\u52a8\u5217\u8868", 2, "A");
            this.excelUtil.generateRangeList(leadsSheet, 4, 1, "LOV", 2, "E");
            this.excelUtil.generateRangeList(leadsSheet, 6, 1, "\u4eba\u5458\u4e0b\u62c9", 2, "A");
            this.excelUtil.generateRangeList(leadsSheet, 7, 1, "\u4eba\u5458\u4e0b\u62c9", 2, "A");
            this.excelUtil.generateRangeList(leadsSheet, 10, 1, "LOV", 2, "G");
            this.excelUtil.generateRangeList(leadsSheet, 11, 1, "LOV", 2, "I");
            this.excelUtil.generateRangeList(leadsSheet, 12, 1, "LOV", 2, "K");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 37, "VLOOKUP(B:rowNo,\u8fd1\u6d77\u5217\u8868!A:B,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 38, "VLOOKUP(C:rowNo,\u5e02\u573a\u6d3b\u52a8\u5217\u8868!A:B,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 39, "VLOOKUP(E:rowNo,LOV!E:F,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 40, "VLOOKUP(G:rowNo,\u4eba\u5458\u4e0b\u62c9!A:B,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 41, "VLOOKUP(H:rowNo,\u4eba\u5458\u4e0b\u62c9!A:B,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 42, "VLOOKUP(K:rowNo,LOV!G:H,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 43, "VLOOKUP(L:rowNo,LOV!I:J,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1)), 44, "VLOOKUP(M:rowNo,LOV!K:L,2,FALSE)");
            return workbook;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void downloadModel(HttpServletResponse response) {
        Workbook workbook = this.getVol();
        String fileName = "\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
        ExcelUtil.writeResponse(response, fileName, workbook);
    }

    private Object downloadModelWithData(List<CrmLeadsPayload> records) {
        Workbook workbook = this.getVol();
        try {
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u7ebf\u7d22\u6570\u636e");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                XSSFCell errorCell = batchProjectSheet.getRow(0).getCell(23);
                errorCell.setCellValue("\u5bfc\u5165\u9519\u8bef");
                XSSFCell warnCell = batchProjectSheet.getRow(0).getCell(24);
                warnCell.setCellValue("\u5bfc\u5165\u8b66\u544a");
                int nextRow = 1;
                for (CrmLeadsPayload dataPayload : records) {
                    XSSFRow row = batchProjectSheet.getRow(nextRow);
                    if (row == null) {
                        row = batchProjectSheet.createRow(nextRow);
                    }
                    this.excelUtil.setCellValueNew((Row)row, 0, nextRow);
                    this.excelUtil.setCellValueNew((Row)row, 1, dataPayload.getOffshoreIdsDesc());
                    this.excelUtil.setCellValueNew((Row)row, 37, dataPayload.getOffshoreIdsStr());
                    this.excelUtil.setCellValueNew((Row)row, 2, dataPayload.getMarketIdDesc());
                    this.excelUtil.setCellValueNew((Row)row, 38, dataPayload.getMarketId());
                    this.excelUtil.setCellValueNew((Row)row, 3, dataPayload.getLeadsName());
                    this.excelUtil.setCellValueNew((Row)row, 4, dataPayload.getSourceTypeDesc());
                    this.excelUtil.setCellValueNew((Row)row, 39, dataPayload.getSourceType());
                    this.excelUtil.setCellValueNew((Row)row, 5, dataPayload.getMarketChannel());
                    this.excelUtil.setCellValueNew((Row)row, 6, dataPayload.getSaleUserName());
                    this.excelUtil.setCellValueNew((Row)row, 40, dataPayload.getSaleUserId());
                    this.excelUtil.setCellValueNew((Row)row, 7, dataPayload.getSourceUserName());
                    this.excelUtil.setCellValueNew((Row)row, 41, dataPayload.getSourceUserId());
                    this.excelUtil.setCellValueNew((Row)row, 8, dataPayload.getCloseReason());
                    this.excelUtil.setCellValueNew((Row)row, 19, dataPayload.getExtString1());
                    this.excelUtil.setCellValueNew((Row)row, 20, dataPayload.getExtString2());
                    this.excelUtil.setCellValueNew((Row)row, 21, dataPayload.getCreateTime());
                    this.excelUtil.setCellValueNew((Row)row, 22, dataPayload.getRemark());
                    this.excelUtil.setCellValueNew((Row)row, 23, dataPayload.getImoprtError());
                    this.excelUtil.setCellValueNew((Row)row, 24, dataPayload.getImportWarn());
                    CrmLeadsCustomerPayload customer = dataPayload.getCustomer();
                    if (customer != null) {
                        this.excelUtil.setCellValueNew((Row)row, 9, customer.getCustomerName());
                        this.excelUtil.setCellValueNew((Row)row, 10, customer.getCustomerIndustryDesc());
                        this.excelUtil.setCellValueNew((Row)row, 42, customer.getCustomerIndustry());
                        this.excelUtil.setCellValueNew((Row)row, 11, customer.getCustomerGradeDesc());
                        this.excelUtil.setCellValueNew((Row)row, 43, customer.getCustomerGrade());
                        this.excelUtil.setCellValueNew((Row)row, 12, customer.getCustRegionDesc());
                        this.excelUtil.setCellValueNew((Row)row, 44, customer.getCustRegion());
                        this.excelUtil.setCellValueNew((Row)row, 13, customer.getCustomerContacts());
                        this.excelUtil.setCellValueNew((Row)row, 14, customer.getContactsDepartment());
                        this.excelUtil.setCellValueNew((Row)row, 15, customer.getContactsPhone());
                        this.excelUtil.setCellValueNew((Row)row, 16, customer.getContactsEmail());
                        this.excelUtil.setCellValueNew((Row)row, 17, customer.getContactsPosition());
                        this.excelUtil.setCellValueNew((Row)row, 18, customer.getSaleProduct());
                    }
                    ++nextRow;
                }
            }
            String fileName = "\u7ebf\u7d22\u6570\u636e\u5bfc\u5165-" + UUID.randomUUID();
            File file = ExcelUtil.workbookToFile(workbook, fileName);
            ApiResult upload = this.fileService.upload(file);
            return upload.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void download(List<CrmLeadsListVO> records, String type, HttpServletResponse response, int fromType) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmLeadsDownloadBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u7ebf\u7d22\u6570\u636e");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                int nextRow = 1;
                for (CrmLeadsListVO dataPayload : records) {
                    CrmFollowVO crmFollowVO;
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    if (fromType == 2 && dataPayload.getOffshoreId() != null) {
                        CrmOffshoreDO offshoreDO = this.offshoreDAO.queryById(dataPayload.getOffshoreId());
                        this.excelUtil.setCellValue((Row)row, 1, offshoreDO.getOffshoreName());
                    }
                    if (fromType == 1 && dataPayload.getOffshore() != null) {
                        this.excelUtil.setCellValue((Row)row, 1, dataPayload.getOffshore().getOffshoreName());
                    }
                    this.excelUtil.setCellValue((Row)row, 2, dataPayload.getMarket() == null ? null : dataPayload.getMarket().getProjectName());
                    this.excelUtil.setCellValue((Row)row, 3, dataPayload.getLeadsName());
                    this.excelUtil.setCellValue((Row)row, 4, dataPayload.getLeadsStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 5, dataPayload.getLeadsStageDesc());
                    this.excelUtil.setCellValue((Row)row, 6, dataPayload.getSourceTypeDesc());
                    this.excelUtil.setCellValue((Row)row, 7, dataPayload.getMarketChannelDesc());
                    this.excelUtil.setCellValue((Row)row, 8, dataPayload.getSaleUserName());
                    this.excelUtil.setCellValue((Row)row, 9, dataPayload.getSourceUserName());
                    this.excelUtil.setCellValue((Row)row, 10, dataPayload.getCloseReason());
                    this.excelUtil.setCellValue((Row)row, 15, dataPayload.getAreaName());
                    this.excelUtil.setCellValue((Row)row, 22, dataPayload.getExtString1());
                    this.excelUtil.setCellValue((Row)row, 23, dataPayload.getExtString2());
                    this.excelUtil.setCellValue((Row)row, 24, dataPayload.getCreateTime());
                    this.excelUtil.setCellValue((Row)row, 27, dataPayload.getRemark());
                    CrmLeadsCustomerVO customer = dataPayload.getCustomer();
                    if (customer != null) {
                        this.excelUtil.setCellValue((Row)row, 11, customer.getCustomerName());
                        this.excelUtil.setCellValue((Row)row, 12, customer.getCustomerIndustryDesc());
                        this.excelUtil.setCellValue((Row)row, 13, customer.getCustomerGradeDesc());
                        this.excelUtil.setCellValue((Row)row, 14, customer.getCustRegionDesc());
                        this.excelUtil.setCellValue((Row)row, 16, customer.getCustomerContacts());
                        this.excelUtil.setCellValue((Row)row, 17, customer.getContactsDepartment());
                        this.excelUtil.setCellValue((Row)row, 18, customer.getContactsPhone());
                        this.excelUtil.setCellValue((Row)row, 19, customer.getContactsEmail());
                        this.excelUtil.setCellValue((Row)row, 20, customer.getContactsPosition());
                        this.excelUtil.setCellValue((Row)row, 21, customer.getSaleProduct());
                    }
                    if ((crmFollowVO = dataPayload.getFollow()) != null) {
                        this.excelUtil.setCellValue((Row)row, 25, crmFollowVO.getCreateTime());
                        this.excelUtil.setCellValue((Row)row, 26, crmFollowVO.getFollowContent());
                    }
                    ++nextRow;
                }
            }
            String fileName = type + "-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean leadsNotFollowRemind() {
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setNotFollowLeadsRemindTimeNotNull(Boolean.valueOf(true));
        Specification<CrmLeadsDO> spec = this.dao.getSpec(leadsQuery);
        List<CrmLeadsDO> all = this.dao.findAll(spec);
        XxlJobLogger.log((String)("\u6570\u636e\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a" + all.stream().map(e -> e.getSaleUserId()).collect(Collectors.toList())), (Object[])new Object[0]);
        for (CrmLeadsDO leadsDO : all) {
            LocalDateTime notFollowLeadsRemindTime = leadsDO.getNotFollowLeadsRemindTime();
            if (leadsDO.getNotFollowLeadsRemindTime() == null || !notFollowLeadsRemindTime.isBefore(LocalDateTime.now()) || leadsDO.getSaleUserId() == null) continue;
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20220711001502");
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("leadsName", leadsDO.getLeadsName());
            result.put("url", "/leadsManager/management");
            this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", leadsDO.getSaleUserId().toString());
            CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
            Long leadsId = leadsDO.getId();
            leadsPayload.setId(leadsId);
            leadsPayload.setNullFields(Arrays.asList("notFollowLeadsRemindTime"));
            this.dao.updateByKeyDynamic(leadsPayload);
        }
        return true;
    }

    @Transactional
    public boolean leadsNotReceiveRemind(int days) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("distributed");
        leadsOffshoreQuery.setFilterLeadsOffshore(Boolean.valueOf(true));
        leadsOffshoreQuery.setExpireDays(Integer.valueOf(days));
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> all = this.leadsOffshoreDAO.findAll(spec);
        ArrayList messageConfigDOS = new ArrayList();
        if (!ObjectUtils.isEmpty(all)) {
            for (CrmLeadsOffshoreDO leadsOffshoreDO : all) {
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
                Long parentId;
                PrdMessageConfigVO configVO = null;
                if (days == 7) {
                    configVO = this.messageConfigService.queryByMessageCode("MC20221129001502");
                } else if (days == 10) {
                    configVO = this.messageConfigService.queryByMessageCode("MC20221129001503");
                }
                HashMap<String, String> result = new HashMap<String, String>();
                CrmLeadsDO leads = leadsOffshoreDO.getLeads();
                CrmLeadsCustomerDO customer = leadsOffshoreDO.getLeads().getCustomer();
                result.put("customerName", customer.getCustomerName());
                result.put("customerContacts", customer.getCustomerContacts());
                result.put("contactsPhone", customer.getContactsPhone());
                result.put("saleUserName", this.cacheUtil.getUserName(leads.getSaleUserId()));
                result.put("remark", leads.getRemark());
                result.put("distributeDate", leads.getDistributeDate().toString());
                ArrayList<String> noticeSourceList = new ArrayList<String>();
                Long saleUserId = leads.getSaleUserId();
                noticeSourceList.add(saleUserId.toString());
                noticeSourceList.add("81424904826650635");
                if (days != 7 && days == 10 && (parentId = (prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(saleUserId)).getParentId()) != null && !parentId.toString().equals("579786152370897074")) {
                    noticeSourceList.add(parentId.toString());
                }
                result.put("customerName", customer.getCustomerName());
                if (ObjectUtils.isEmpty(noticeSourceList)) continue;
                String noticeSource = String.join((CharSequence)",", noticeSourceList);
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
            }
        }
        return true;
    }

    public Object sendLeadsMessage(String messageType, CrmLeadsDO leadsdo, String extraParam) {
        CrmLeadsCustomerDO customer = leadsdo.getCustomer();
        HashSet<String> noticeSourceList = new HashSet<String>();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("customerName", customer.getCustomerName());
        result.put("saleUserName", this.cacheUtil.getUserName(leadsdo.getSaleUserId()));
        result.put("remark", leadsdo.getRemark());
        String messageCode = "";
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(leadsdo.getSaleUserId());
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        switch (messageType) {
            case "distribute": {
                messageCode = "MC20221129001501";
                result.put("customerContacts", customer.getCustomerContacts());
                result.put("contactsPhone", customer.getContactsPhone());
                result.put("distributeDate", leadsdo.getDistributeDate().toString());
                noticeSourceList.add(leadsdo.getSaleUserId().toString());
                Long demandProductOrg = leadsdo.getDemandProductOrg();
                Set<Long> childOrgs = this.orgOrganizationDAO.queryAllChildOrgs(Set.of(Long.valueOf(579786628743037043L)));
                childOrgs.add(579786628743037043L);
                if (demandProductOrg != null && childOrgs.contains(demandProductOrg)) {
                    noticeSourceList.add("579785838427245479");
                }
                Set<Long> childOrgs1 = this.orgOrganizationDAO.queryAllChildOrgs(Set.of(Long.valueOf(579786628743037030L)));
                childOrgs1.add(579786628743037030L);
                if (demandProductOrg != null && childOrgs1.contains(demandProductOrg)) {
                    noticeSourceList.add("579785858698314390");
                }
                if (parentId != null) {
                    noticeSourceList.add(parentId.toString());
                }
                noticeSourceList.add("579786152370897074");
                noticeSourceList.add("579786650192841178");
                noticeSourceList.add("81424904826650635");
                break;
            }
            case "receive": {
                Long manageUserId;
                messageCode = "MC20221129001504";
                result.put("demandProduct", this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), leadsdo.getDemandProduct()));
                if (parentId != null && !parentId.toString().equals("579786152370897074")) {
                    noticeSourceList.add(parentId.toString());
                }
                if (leadsdo.getDemandProductOrg() != null && (manageUserId = this.daoOrg.queryManageIdById(leadsdo.getDemandProductOrg())) != null) {
                    noticeSourceList.add(manageUserId.toString());
                }
                List<String> middleChildOrgs = Arrays.asList(MIDDLE_GROUND_PRODS);
                if (!ObjectUtils.isEmpty((Object)leadsdo.getDemandProduct()) && middleChildOrgs.contains(leadsdo.getDemandProduct())) {
                    noticeSourceList.add("579785838427245479");
                    noticeSourceList.add("579786625358367036");
                }
                noticeSourceList.add("579786152370897074");
                noticeSourceList.add("81424904826650635");
                noticeSourceList.add("579786650192841178");
                noticeSourceList.add("579785831934460429");
                noticeSourceList.add("579785846660664966");
                break;
            }
            case "back": {
                messageCode = "MC20221129001505";
                result.put("demandProduct", this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), leadsdo.getDemandProduct()));
                result.put("backReason", extraParam);
                noticeSourceList.add("81424904826650635");
                noticeSourceList.add("579786650192841178");
            }
        }
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode(messageCode);
        result.put("customerName", customer.getCustomerName());
        if (!ObjectUtils.isEmpty(noticeSourceList)) {
            String noticeSource = String.join((CharSequence)",", noticeSourceList);
            return this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
        }
        return null;
    }

    public boolean leadsToDistributeRemind() {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setLeadsStatus("undistributed");
        leadsOffshoreQuery.setLeadsStage("mql");
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> all = this.leadsOffshoreDAO.findAll(spec);
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20220711001503");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("numToDistribute", all.size());
        result.put("url", "/leadsManager/offshore?remindFlag=true");
        this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", "81424904826650635");
        return true;
    }

    public void batchAddTags(Long[] keys, String leadsTagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmLeadsPayload payload = new CrmLeadsPayload();
            payload.setId(key);
            CrmLeadsDO leadsDO = this.dao.queryById(key);
            String leadsTagIds1 = leadsDO.getLeadsTagIds();
            if (leadsTagIds != null && !leadsTagIds.isEmpty() && leadsTagIds1 != null && !leadsTagIds1.isEmpty()) {
                ArrayList<String> leadsTagIdList = new ArrayList<String>(Arrays.asList(leadsTagIds.split(",")));
                leadsTagIdList.addAll(new ArrayList<String>(Arrays.asList(leadsTagIds1.split(","))));
                newTags = String.join((CharSequence)",", leadsTagIdList.stream().distinct().collect(Collectors.toList()));
            } else {
                newTags = leadsTagIds;
            }
            payload.setLeadsTagIds(newTags);
            this.dao.updateByKeyDynamic(payload);
        }
    }

    public void batchDelTags(Long[] keys, String leadsTagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmLeadsPayload payload = new CrmLeadsPayload();
            payload.setId(key);
            CrmLeadsDO leadsDO = this.dao.queryById(key);
            String existingTags = leadsDO.getLeadsTagIds();
            if (existingTags != null && !existingTags.isEmpty()) {
                if (leadsTagIds != null && !leadsTagIds.isEmpty()) {
                    ArrayList<String> leadsTagIdList = new ArrayList<String>(Arrays.asList(existingTags.split(",")));
                    leadsTagIdList.removeAll(new ArrayList<String>(Arrays.asList(leadsTagIds.split(","))));
                    newTags = String.join((CharSequence)",", leadsTagIdList.stream().distinct().collect(Collectors.toList()));
                } else {
                    newTags = existingTags;
                }
            } else {
                newTags = null;
            }
            payload.setLeadsTagIds(newTags);
            this.dao.updateByKeyDynamic(payload);
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public Map<String, Object> bindCustomer(Long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Boolean isNewCust = false;
        CrmLeadsDO leadsDO = this.dao.queryById(id);
        String customerName = leadsDO.getCustomer().getCustomerName();
        String customerGrade = leadsDO.getCustomer().getCustomerGrade();
        CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
        leadsPayload.setId(id);
        BusinessPartnerSimpleVO businessPartnerSimpleVO = this.businessPartnerService.queryByPartnerName(customerName);
        if (businessPartnerSimpleVO != null) {
            BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
            if (businessPartnerSimpleVO.getCustomerFlag().booleanValue()) {
                if (customerGrade != null) {
                    CrmCustomerSimpleVO crmCustomerSimpleVO = this.businessCustomerInfoService.listSimpleByPartnerId(businessPartnerSimpleVO.getId());
                    payload.setCustomerGradle(customerGrade);
                    payload.setId(crmCustomerSimpleVO.getId());
                    this.businessCustomerInfoService.update(payload);
                }
                leadsPayload.setFormalCustomerId(businessPartnerSimpleVO.getId());
            } else {
                BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                businessPartnerPayload.setPartnerIdentity(businessPartnerSimpleVO.getPartnerIdentity() + "," + BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                businessPartnerPayload.setId(businessPartnerSimpleVO.getId());
                businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
                this.businessPartnerService.update(businessPartnerPayload);
                BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                businessCustomerInfoPayload.setPartnerId(businessPartnerSimpleVO.getId());
                businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                businessCustomerInfoPayload.setConfirmFlag(Boolean.valueOf(false));
                businessCustomerInfoPayload.setCustomerGradle(customerGrade);
                businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                this.businessCustomerInfoService.insert(businessCustomerInfoPayload);
                leadsPayload.setFormalCustomerId(businessPartnerSimpleVO.getId());
                isNewCust = true;
            }
        } else {
            CrmLeadsCustomerDO customer = leadsDO.getCustomer();
            BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
            businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
            businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
            businessPartnerPayload.setPartnerName(customerName);
            businessPartnerPayload.setCustomerGradle(customerGrade);
            businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
            businessPartnerPayload.setPartnerIndustry(customer.getCustomerIndustry());
            businessPartnerPayload.setContactsName(customer.getCustomerContacts());
            businessPartnerPayload.setContactsPhone(customer.getContactsPhone());
            businessPartnerPayload.setPartnerEmail(customer.getContactsEmail());
            businessPartnerPayload.setContactsPosition(customer.getContactsPosition());
            businessPartnerPayload.setContactsDepartment(customer.getContactsDepartment());
            businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.insert(businessPartnerPayload);
            leadsPayload.setFormalCustomerId(businessPartnerVO.getId());
            isNewCust = true;
        }
        this.dao.updateByKeyDynamic(leadsPayload);
        if (customerGrade == null || customerGrade != null && (customerGrade.equals("general") || customerGrade.equals("plain") || customerGrade.equals("null"))) {
            result.put("showBindMess", false);
        } else {
            result.put("showBindMess", true);
        }
        result.put("isNewCust", isNewCust);
        return result;
    }

    @Transactional
    public void bindCustomerBatch(Long[] ids) {
        for (Long id : ids) {
            try {
                this.bindCustomer(id);
            }
            catch (Exception e) {
                this.deleteSoft(Collections.singletonList(id));
            }
        }
    }

    @Transactional
    public void bindCustomerNotBind() {
        List<Long> ids = this.dao.queryNotBindLeads();
        for (Long id : ids) {
            try {
                this.bindCustomer(id);
            }
            catch (Exception e) {}
        }
    }

    public Map<String, Object> bindCustomers() {
        List<Long> notBindLeads = this.dao.findNotBindLeads();
        for (Long notBindLead : notBindLeads) {
            this.bindCustomer(notBindLead);
        }
        return new HashMap<String, Object>();
    }

    public List<CrmLeadsListVO> queryListByCustomName(String customName) {
        CrmLeadsQuery query = new CrmLeadsQuery();
        query.setCustomerName(customName);
        Specification<CrmLeadsDO> spec = this.dao.getSpec(query);
        List<CrmLeadsDO> list = this.dao.findAll(spec);
        return list.stream().map(CrmLeadsConvert.INSTANCE::toListVo).toList();
    }

    public CrmLeadsServiceImpl(CrmLeadsDAO dao, CrmLeadsMembersDAO membersDAO, PrdSystemLogDAO logDAO, CacheUtil cacheUtil, PrjProjectDAO marketDAO, CrmOffshoreService offshoreService, CrmOffshoreRuleAttrExcludeDAO offshoreRuleAttrExcludeDAO, CrmOffshoreDAO offshoreDAO, CrmLeadsOffshoreDAO leadsOffshoreDAO, PrdMessageConfigService messageConfigService, CrmFollowService followService, PrdSystemLogService logService, ExcelUtil excelUtil, PrdSystemSelectionService selectionService, PrjProjectDAO prjProjectDAO, PrdOrgEmployeeDAO employeeDAO, PrdOrgOrganizationDAO orgOrganizationDAO, PrdSystemRoleDAO systemRoleDAO, PrdOrgEmployeeService employeeService, FileService fileService, CrmCommonService crmCommonService, CrmFollowService crmFollowService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, PrdOrgOrganizationService organizationService, PrdMessageConfigRepo repoMessage, PrdOrgOrganizationDAO daoOrg, ChangeFieldLogUtil changeFieldLogUtil, CrmFollowDAO followDAO, CrmPotentialCustomerDAO crmPotentialCustomerDAO, BusinessPartnerService businessPartnerService, BusinessTeamMemberService teamMemberService) {
        this.dao = dao;
        this.membersDAO = membersDAO;
        this.logDAO = logDAO;
        this.cacheUtil = cacheUtil;
        this.marketDAO = marketDAO;
        this.offshoreService = offshoreService;
        this.offshoreRuleAttrExcludeDAO = offshoreRuleAttrExcludeDAO;
        this.offshoreDAO = offshoreDAO;
        this.leadsOffshoreDAO = leadsOffshoreDAO;
        this.messageConfigService = messageConfigService;
        this.followService = followService;
        this.logService = logService;
        this.excelUtil = excelUtil;
        this.selectionService = selectionService;
        this.prjProjectDAO = prjProjectDAO;
        this.employeeDAO = employeeDAO;
        this.orgOrganizationDAO = orgOrganizationDAO;
        this.systemRoleDAO = systemRoleDAO;
        this.employeeService = employeeService;
        this.fileService = fileService;
        this.crmCommonService = crmCommonService;
        this.crmFollowService = crmFollowService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.organizationService = organizationService;
        this.repoMessage = repoMessage;
        this.daoOrg = daoOrg;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.followDAO = followDAO;
        this.crmPotentialCustomerDAO = crmPotentialCustomerDAO;
        this.businessPartnerService = businessPartnerService;
        this.teamMemberService = teamMemberService;
    }
}

