/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRelateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdPerformanceExamServiceImpl
implements PrdPerformanceExamService {
    private static final Logger log = LoggerFactory.getLogger(PrdPerformanceExamServiceImpl.class);
    private final PrdPerformanceExamDao prdPerformanceExamDao;
    private final PrdPerformanceExamRepo prdPerformanceExamRepo;
    private final PrdPerformanceExamPointService prdPerformanceExamPointService;
    private final PrdPerformanceExamGradeService prdPerformanceExamGradeService;
    private final PrdPerformanceExamRelateService prdPerformanceExamRelateService;
    @Autowired
    @Lazy
    private PrdPerformanceExamRangeService prdPerformanceExamRangeService;
    private final PrdPerformanceExamResultService prdPerformanceExamResultService;
    private final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final WorkflowUtil workflowUtil;

    @Transactional(rollbackFor={Exception.class})
    public PrdPerformanceExamVO save(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        this.checkData(prdPerformanceExamPayload);
        PrdPerformanceExamDO prdPerformanceExamDO = new PrdPerformanceExamDO();
        prdPerformanceExamDO = PrdPerformanceExamConvert.INSTANCE.p2d(prdPerformanceExamPayload);
        PrdPerformanceExamDO res = (PrdPerformanceExamDO)((Object)this.prdPerformanceExamRepo.save((Object)prdPerformanceExamDO));
        prdPerformanceExamPayload.getPrdPerformanceExamPointPayloadList().forEach(x -> {
            x.setExamId(res.getId());
            this.prdPerformanceExamPointService.save(x);
        });
        prdPerformanceExamPayload.getPrdPerformanceExamGradePayloadList().forEach(x -> {
            x.setExamId(res.getId());
            this.prdPerformanceExamGradeService.save(x);
        });
        prdPerformanceExamPayload.getPrdPerformanceExamRangePayloadList().forEach(x -> {
            x.setExamId(res.getId());
            PrdPerformanceExamRangeVO save = this.prdPerformanceExamRangeService.save(x);
        });
        return PrdPerformanceExamConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdPerformanceExamVO update(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        Assert.notNull((Object)prdPerformanceExamPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        this.prdPerformanceExamPointService.delByExamId(prdPerformanceExamPayload.getId());
        this.prdPerformanceExamGradeService.delByExamId(prdPerformanceExamPayload.getId());
        PrdPerformanceExamVO res = this.save(prdPerformanceExamPayload);
        return res;
    }

    public PrdPerformanceExamVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdPerformanceExamVO res = this.prdPerformanceExamDao.get(id);
        PrdPerformanceExamPointQuery prdPerformanceExamPointQuery = new PrdPerformanceExamPointQuery();
        prdPerformanceExamPointQuery.setExamId(id);
        List pointVOList = this.prdPerformanceExamPointService.getList(prdPerformanceExamPointQuery);
        res.setPrdPerformanceExamPointVOList(pointVOList);
        PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery = new PrdPerformanceExamGradeQuery();
        prdPerformanceExamGradeQuery.setExamId(id);
        List gradeVOList = this.prdPerformanceExamGradeService.getList(prdPerformanceExamGradeQuery);
        res.setPrdPerformanceExamGradeVOList(gradeVOList);
        return res;
    }

    public PagingVO<PrdPerformanceExamVO> page(PrdPerformanceExamQuery prdPerformanceExamQuery) {
        PagingVO<PrdPerformanceExamVO> res = this.prdPerformanceExamDao.page(prdPerformanceExamQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdPerformanceExamDao.del(ids);
        return res;
    }

    public List<PrdPerformanceExamVO> getList(PrdPerformanceExamQuery prdPerformanceExamQuery) {
        List<PrdPerformanceExamVO> res = this.prdPerformanceExamDao.getList(prdPerformanceExamQuery);
        return res;
    }

    private void checkData(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        if (StringUtils.isBlank((CharSequence)prdPerformanceExamPayload.getName())) {
            throw new BusinessException("\u8003\u6838\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdPerformanceExamPayload.getCycle())) {
            throw new BusinessException("\u8003\u6838\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdPerformanceExamPayload.getScoreMax()) {
            throw new BusinessException("\u5206\u6570\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdPerformanceExamPayload.getScoreMin()) {
            throw new BusinessException("\u5206\u6570\u4e0b\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        Assert.notNull((Object)prdPerformanceExamPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdPerformanceExamDao.update(prdPerformanceExamPayload);
        return res;
    }

    public Long startflow(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        PrdPerformanceExamVO prdPerformanceExamVO = this.prdPerformanceExamDao.get(prdPerformanceExamPayload.getId());
        PrdPerformanceExamResultQuery prdPerformanceExamResultQuery = new PrdPerformanceExamResultQuery();
        prdPerformanceExamResultQuery.setExamId(prdPerformanceExamPayload.getId());
        List resultVOList = this.prdPerformanceExamResultService.getList(prdPerformanceExamResultQuery);
        for (PrdPerformanceExamResultVO prdPerformanceExamResultVO : resultVOList) {
            this.startWorkFlow(prdPerformanceExamResultVO, prdPerformanceExamVO.getName());
        }
        PrdPerformanceExamPayload payload = new PrdPerformanceExamPayload();
        payload.setId(prdPerformanceExamVO.getId());
        payload.setState(String.valueOf(1));
        this.updateByCondition(payload);
        return prdPerformanceExamVO.getId();
    }

    public void startWorkFlow(PrdPerformanceExamResultVO res, String name) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("Activity_1afn3zj", res.getUserId());
        PrdOrgEmployeeRefDO prdOrgEmployeeRefDO = this.prdOrgEmployeeDAO.queryByOrgIdAndUserId(res.getBaseBuId(), res.getUserId());
        if (null != prdOrgEmployeeRefDO) {
            variables.put("Activity_19d0izo", prdOrgEmployeeRefDO.getParentId());
        }
        List<Long> zyUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode()));
        variables.put("Activity_1hrp7lh", zyUserIds);
        PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_1co4fc9", prdOrgOrganizationVO.getManageId());
        List<Long> hrUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        variables.put("Activity_0i5l378", hrUserIds);
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)HrBaseEnum.PERFORMANCE_EXAM.getCode(), (String)("A113.\u7ee9\u6548\u8003\u6838\u6d41\u7a0b-" + name), (String)res.getId().toString(), variables), new Long[0]);
        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        PrdPerformanceExamResultPayload payload = new PrdPerformanceExamResultPayload();
        payload.setId(res.getId());
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setState(ProcInstStatus.APPROVING.name());
        this.prdPerformanceExamResultService.updateByCondition(payload);
    }

    public PrdPerformanceExamServiceImpl(PrdPerformanceExamDao prdPerformanceExamDao, PrdPerformanceExamRepo prdPerformanceExamRepo, PrdPerformanceExamPointService prdPerformanceExamPointService, PrdPerformanceExamGradeService prdPerformanceExamGradeService, PrdPerformanceExamRelateService prdPerformanceExamRelateService, PrdPerformanceExamResultService prdPerformanceExamResultService, PrdPerformanceExamResDtlService prdPerformanceExamResDtlService, PrdOrgOrganizationService prdOrgOrganizationService, PrdSystemRoleDAO prdSystemRoleDAO, PrdOrgEmployeeDAO prdOrgEmployeeDAO, WorkflowUtil workflowUtil) {
        this.prdPerformanceExamDao = prdPerformanceExamDao;
        this.prdPerformanceExamRepo = prdPerformanceExamRepo;
        this.prdPerformanceExamPointService = prdPerformanceExamPointService;
        this.prdPerformanceExamGradeService = prdPerformanceExamGradeService;
        this.prdPerformanceExamRelateService = prdPerformanceExamRelateService;
        this.prdPerformanceExamResultService = prdPerformanceExamResultService;
        this.prdPerformanceExamResDtlService = prdPerformanceExamResDtlService;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.workflowUtil = workflowUtil;
    }
}

