/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ExternalResApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ExternalResApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ExternalResApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ExternalResApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.ExternalResApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ExternalResApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ExternalResApplyDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ExternalResApplyServiceImpl
extends BaseServiceImpl
implements ExternalResApplyService {
    private static final Logger log = LoggerFactory.getLogger(ExternalResApplyServiceImpl.class);
    private final ExternalResApplyDAO externalResApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleService prdSystemRoleService;
    private final PrdOrgPersonDAO personDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdSystemSelectionService prdSystemSelectionService;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    @Transactional
    public void apply(ExternalResApplyPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getResType2())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5916\u90e8\u8d44\u6e90\u7c7b\u578b");
        }
        if (payload.getId() == null) {
            ProcessInfo processInfo = new ProcessInfo();
            String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("emailFlag", payload.getEmailFlag());
            variables.put("elpFlag", payload.getElpFlag());
            variables.put("Activity_0wlielw", payload.getParentId());
            List resDirectors = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode());
            variables.put("Activity_1nivyah", resDirectors);
            Long orgId = payload.getOrgId();
            PrdOrgOrganizationVO orgOrganizationVO = this.cacheUtil.getOrg(orgId);
            Long manageId = orgOrganizationVO.getManageId();
            variables.put("Activity_0qbiiu8", manageId);
            List itAdministratorId = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode());
            variables.put("Activity_1nppj6a", itAdministratorId);
            Long personId = payload.getPersonId();
            PrdOrgEmployeeDO prdOrgEmployeeDO = this.personDAO.findEmployeeByPersonId(personId);
            Long employeeId = prdOrgEmployeeDO.getId();
            payload.setEmployeeId(employeeId);
            ExternalResApplyDO applyDO = this.externalResApplyDAO.save(ExternalResApplyConvert.INSTANCE.payloadToDo(payload));
            Long applyId = applyDO.getId();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.EXTERNAL_RES_APPLY.name(), (String)("A46.\u5916\u90e8\u8d44\u6e90\u5f15\u5165\u6d41\u7a0b-" + payload.getPersonName()), (String)("" + applyId), variables), new Long[0]);
            this.employeeDAO.updateResStatus(employeeId, "2");
            this.personDAO.updateApprStatus(personId, "APPROVING");
            PrdOrgPersonPayload prdOrgPersonPayload = new PrdOrgPersonPayload();
            prdOrgPersonPayload.setId(personId);
            prdOrgPersonPayload.setProcInstStatus(processInfo.getProcInstStatus());
            prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            this.personDAO.updateProcessDate(prdOrgPersonPayload);
            payload.setId(applyDO.getId());
            payload.setProcInstId(processInfo.getProcInstId());
            payload.setProcInstStatus(processInfo.getProcInstStatus());
            payload.setProcInstStatus(ProcInstStatus.APPROVING);
            this.externalResApplyDAO.updateProcData(payload);
            String userName = applyDO.getPersonName();
            String title = "\u5916\u90e8\u8d44\u6e90\u5f15\u5165-" + userName;
            String content = "\u5916\u90e8\u8d44\u6e90\u5f15\u5165-" + userName + "\uff0c\u8bf7\u76f8\u5173\u8d1f\u8d23\u4eba\u53ca\u65f6\u67e5\u770b";
            this.sendMessage(applyId, title, content);
        } else {
            ExternalResApplyDO externalResApplyDO = this.externalResApplyDAO.findById(payload.getId());
            ExternalResApplyDO saveDO = ExternalResApplyConvert.INSTANCE.payloadToDo(payload);
            saveDO.setEmployeeId(externalResApplyDO.getEmployeeId());
            saveDO.setEmployeeNo(externalResApplyDO.getEmployeeNo());
            this.externalResApplyDAO.save(saveDO);
        }
    }

    public ExternalResApplyVO queryByProcId(String procId) {
        ExternalResApplyDO applyDO = this.externalResApplyDAO.findByProcId(procId);
        if (applyDO != null) {
            ExternalResApplyVO externalResApplyVO = ExternalResApplyConvert.INSTANCE.doToVo(applyDO);
            externalResApplyVO.setCreateUserName(this.cacheUtil.getUserName(externalResApplyVO.getCreateUserId()));
            return externalResApplyVO;
        }
        return null;
    }

    public PagingVO<ExternalResApplyVO> ExternalResApplyPage(ExternalResApplyQuery query) {
        List records;
        PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection("org:employee:jobType");
        HashMap<String, String> result = new HashMap<String, String>();
        List selectionVOS = view.getChildren();
        for (PrdSystemSelectionVO selectionVO : selectionVOS) {
            List children = selectionVO.getChildren();
            if (Collections.isEmpty((Collection)children)) continue;
            for (PrdSystemSelectionVO child : children) {
                result.put(child.getSelectionValue(), child.getSelectionName());
            }
        }
        PagingVO<ExternalResApplyVO> page = this.externalResApplyDAO.queryPaging(query);
        if (page != null && (records = page.getRecords()) != null) {
            for (ExternalResApplyVO externalResApplyVO : records) {
                externalResApplyVO.setJobClass2Desc((String)result.get(externalResApplyVO.getJobClass2()));
            }
        }
        return page;
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public ExternalResApplyServiceImpl(ExternalResApplyDAO externalResApplyDAO, WorkflowUtil workflowUtil, PrdSystemRoleService prdSystemRoleService, PrdOrgPersonDAO personDAO, CacheUtil cacheUtil, PrdOrgEmployeeDAO employeeDAO, PrdSystemSelectionService prdSystemSelectionService, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.externalResApplyDAO = externalResApplyDAO;
        this.workflowUtil = workflowUtil;
        this.prdSystemRoleService = prdSystemRoleService;
        this.personDAO = personDAO;
        this.cacheUtil = cacheUtil;
        this.employeeDAO = employeeDAO;
        this.prdSystemSelectionService = prdSystemSelectionService;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

