/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personcare.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.tw.tw5.server.prd.personcare.dto.PersonCareDTO;
import com.elitesland.tw.tw5.server.prd.personcare.repo.PersonCareRepo;
import com.elitesland.tw.tw5.server.prd.personcare.service.MarkImageUtils;
import com.elitesland.tw.tw5.server.prd.personcare.service.PersonCareService;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@RefreshScope
public class PersonCareServiceImpl
implements PersonCareService {
    private static final Logger log = LoggerFactory.getLogger(PersonCareServiceImpl.class);
    @Resource
    private MailProperties mailProperties;
    @Resource
    private JavaMailSender javaMailSender;
    private final PersonCareRepo personCareRepo;
    @Value(value="${tw5.mail.enabled:false}")
    private Boolean enabled;

    @Override
    public int taskSendBirthEmailMessage() {
        List<PersonCareDTO> prdOrgPersonDOS = this.personCareRepo.listPersonBirthday();
        AtomicInteger result = new AtomicInteger();
        if (!CollectionUtils.isEmpty(prdOrgPersonDOS)) {
            prdOrgPersonDOS.forEach(personCareView -> {
                try {
                    File temp2 = MarkImageUtils.markMain(personCareView.getPersonName());
                    log.info("\u3010MESSAGE-EMAIL\u3011 \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\uff1a {}...");
                    MimeMessageHelper helper = this.messageHelper(true);
                    ArrayList<String> receiveEmails = new ArrayList<String>();
                    String email = personCareView.getEmail();
                    if (ObjectUtil.isNotEmpty((Object)email)) {
                        receiveEmails.add(email);
                    }
                    if (receiveEmails.size() < 1) {
                        XxlJobLogger.log((String)"[\u5458\u5de5\u5173\u6000\u90ae\u4ef6\u53d1\u9001]  \u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
                        throw new RuntimeException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    String[] toArray = new String[receiveEmails.size()];
                    helper.setTo(receiveEmails.toArray(toArray));
                    helper.setSubject("\u4eb2\u7231\u7684" + personCareView.getPersonName() + ",\u795d\u4f60\u751f\u65e5\u5feb\u4e50\uff01");
                    helper.setText("<html><head></head><body><img src=\"cid:image\"/></body></html>", true);
                    helper.addInline("image", temp2);
                    this.sendMessage(helper);
                    log.info("\u3010MESSAGE-EMAIL\u3011 \u90ae\u4ef6\u53d1\u9001\u6210\u529f");
                    log.debug("[EDP-SNS] EMAIL message SENT.");
                    temp2.delete();
                    result.getAndIncrement();
                }
                catch (Throwable e) {
                    log.error("[EDP-SNS] EMAIL message sent FAILED.", e);
                }
            });
        }
        return result.get();
    }

    public void sendMessage(MimeMessageHelper messageHelper) {
        if (this.enabled.booleanValue()) {
            this.javaMailSender.send(messageHelper.getMimeMessage());
        } else {
            log.warn("\u90ae\u4ef6\u672a\u53d1\u9001\uff0c\u539f\u56e0\uff1a\u90ae\u4ef6\u670d\u52a1\u5df2\u5173\u95ed\u3002\u8bf7\u8bbe\u7f6e'el.mail.enabled: true' \u6253\u5f00");
        }
    }

    private MimeMessageHelper messageHelper(boolean withAttachments) throws MessagingException {
        MimeMessageHelper msg = new MimeMessageHelper(this.javaMailSender.createMimeMessage(), withAttachments, "UTF-8");
        msg.setSentDate(Calendar.getInstance().getTime());
        String senderMail = this.mailProperties.getUsername();
        msg.setFrom(senderMail);
        msg.setReplyTo(senderMail);
        return msg;
    }

    public PersonCareServiceImpl(PersonCareRepo personCareRepo) {
        this.personCareRepo = personCareRepo;
    }
}

