/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsReasonService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsReasonVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PmsReasonServiceImpl
extends BaseServiceImpl
implements PmsReasonService {
    private static final Logger log = LoggerFactory.getLogger(PmsReasonServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationService orgService;
    private final CrmLeadsService leadsService;
    private final CrmOpportunityService opportunityService;
    private final PmsProjectDAO pmsProjectDAO;
    @Value(value="${tw5.sys_default.ou_id:1001}")
    private Long ou_id;

    public List<PmsReasonVO> queryReasonInfos(String reasonType) {
        List prdOrgOrganizationVOS;
        PmsProjectQuery query;
        Long loginUserId = GlobalUtil.getLoginUserId();
        ArrayList<PmsReasonVO> list = new ArrayList<PmsReasonVO>();
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            query = new PmsProjectQuery();
            query.setPmResId(loginUserId);
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
            query.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryTaskAuthorizedProjectList(query);
            if (pmsProjectVOS != null) {
                pmsProjectVOS.forEach(vo -> {
                    PmsReasonVO reasonVO = new PmsReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjName());
                    reasonVO.setCode(vo.getProjNo());
                    reasonVO.setExpenseBuId(vo.getDeliBuId());
                    reasonVO.setExpenseBuName(this.cacheUtil.getOrgName(vo.getDeliBuId()));
                    reasonVO.setExpenseCompanyId(vo.getOuBookId());
                    reasonVO.setExpenseCompanyName(this.cacheUtil.getCompanyNameByBookId(vo.getOuBookId()));
                    reasonVO.setCustId(vo.getCustId());
                    reasonVO.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustId()));
                    list.add(reasonVO);
                });
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode()) && (prdOrgOrganizationVOS = this.orgService.queryByManageIdOrgs(loginUserId)) != null) {
            prdOrgOrganizationVOS.forEach(vo -> {
                PmsReasonVO reasonVO = new PmsReasonVO();
                reasonVO.setId(vo.getId());
                reasonVO.setName(vo.getOrgName());
                reasonVO.setCode(vo.getOrgCode());
                reasonVO.setExpenseBuId(vo.getId());
                reasonVO.setExpenseBuName(vo.getOrgName());
                reasonVO.setExpenseCompanyId(this.ou_id);
                reasonVO.setExpenseCompanyName(this.cacheUtil.getCompanyNameByBookId(this.ou_id));
                list.add(reasonVO);
            });
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            query = new CrmOpportunityQuery();
            query.setPreSaleUserId(loginUserId);
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic((CrmOpportunityQuery)query);
            if (crmOpportunityListVOS != null) {
                crmOpportunityListVOS.forEach(vo -> {
                    PmsReasonVO reasonVO = new PmsReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjectName());
                    reasonVO.setCode(vo.getProjectNo());
                    reasonVO.setExpenseBuId(vo.getPreSaleOrgId());
                    reasonVO.setExpenseBuName(this.cacheUtil.getOrgName(vo.getPreSaleOrgId()));
                    reasonVO.setExpenseCompanyId(this.ou_id);
                    reasonVO.setExpenseCompanyName(this.cacheUtil.getCompanyNameByBookId(this.ou_id));
                    reasonVO.setCustId(vo.getCustBookId());
                    reasonVO.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustBookId()));
                    reasonVO.setRemark("\u5546\u673a");
                    list.add(reasonVO);
                });
            }
        }
        return list;
    }

    public PmsReasonServiceImpl(CacheUtil cacheUtil, PrdOrgOrganizationService orgService, CrmLeadsService leadsService, CrmOpportunityService opportunityService, PmsProjectDAO pmsProjectDAO) {
        this.cacheUtil = cacheUtil;
        this.orgService = orgService;
        this.leadsService = leadsService;
        this.opportunityService = opportunityService;
        this.pmsProjectDAO = pmsProjectDAO;
    }
}

