/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionRuleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleDetailVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionFieldType;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionRuleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionRuleDetailDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemBusinessObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFieldDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFieldObjRoleFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFunctionObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionRuleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionRuleDetailDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionRuleDetailRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionRuleRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class PrdSystemPermissionRuleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemPermissionRuleRepo ruleRepo;
    private final QPrdSystemPermissionRuleDO qdoPermissionRule = QPrdSystemPermissionRuleDO.prdSystemPermissionRuleDO;
    private final PrdSystemPermissionRuleDetailRepo ruleDetailRepo;
    private final QPrdSystemPermissionRuleDetailDO qdoPermissionRuleDetail = QPrdSystemPermissionRuleDetailDO.prdSystemPermissionRuleDetailDO;
    private static final QPrdSystemBusinessObjectDO Q_BUSINESS_OBJECT_DO = QPrdSystemBusinessObjectDO.prdSystemBusinessObjectDO;
    private final QPrdSystemPermissionFieldDO fieldDO = QPrdSystemPermissionFieldDO.prdSystemPermissionFieldDO;
    private final QPrdSystemPermissionFunctionObjectDO functionObjectDO = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;
    private final QPrdSystemPermissionFieldObjRoleFunctionDO qdoPermissionField = QPrdSystemPermissionFieldObjRoleFunctionDO.prdSystemPermissionFieldObjRoleFunctionDO;
    private final QPrdSystemRoleDO roleDO = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemNewFunctionDO functionDO = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdSystemNewFunctionDO qdoNewFunction = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;
    private final QPrdSystemPermissionFunctionObjectDO qdoFunctionObject = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;

    public PrdSystemPermissionRuleDO saveBusinessObjectDataRule(PrdSystemPermissionRuleDO entityDo) {
        return (PrdSystemPermissionRuleDO)((Object)this.ruleRepo.save((Object)entityDo));
    }

    public PrdSystemPermissionRuleDO queryPermissionRuleByCode(String ruleCode) {
        JPAQuery<PrdSystemPermissionRuleDO> jpaQuery = this.getJPAQueryPermissionRule();
        jpaQuery.where((Predicate)this.qdoPermissionRule.ruleCode.eq((Object)ruleCode));
        return (PrdSystemPermissionRuleDO)((Object)jpaQuery.fetchOne());
    }

    private JPAQuery<PrdSystemPermissionRuleDO> getJPAQueryPermissionRule() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemPermissionRuleDO.class, (Expression[])new Expression[]{this.qdoPermissionRule.objectId, this.qdoPermissionRule.id, this.qdoPermissionRule.ruleCode, this.qdoPermissionRule.ruleScope, this.qdoPermissionRule.ruleType, this.qdoPermissionRule.deep, this.qdoPermissionRule.ruleScopeName})).from((EntityPath)this.qdoPermissionRule);
    }

    public PrdSystemPermissionRuleDetailDO saveBusinessObjectDataRuleDetail(PrdSystemPermissionRuleDetailDO ruleDetailDO) {
        return (PrdSystemPermissionRuleDetailDO)((Object)this.ruleDetailRepo.save((Object)ruleDetailDO));
    }

    public void deletePermissonRuleByIds(Long[] keys) {
        this.ruleRepo.deleteAllById(Arrays.asList(keys));
    }

    public List<Long> queryPermissionRuleDetailIdsByRuleId(Long key) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoPermissionRuleDetail.id).from((EntityPath)this.qdoPermissionRuleDetail)).where((Predicate)this.qdoPermissionRuleDetail.ruleId.longValue().eq((Object)key));
        return jpaQuery.fetch();
    }

    public void deletePermissionRuleDetailByIds(List<Long> detailIds) {
        this.ruleDetailRepo.deleteAllById(detailIds);
    }

    public PagingVO<PrdSystemPermissionRuleVO> queryPermissionRule(PrdSystemPermissionRuleQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = this.getJPAQueryPermissionRuleWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    private JPAQuery<PrdSystemPermissionRuleVO> getJPAQueryPermissionRules() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemPermissionRuleVO.class, (Expression[])new Expression[]{this.qdoPermissionRule.objectId, this.qdoPermissionRule.id, this.qdoPermissionRule.ruleCode, this.qdoPermissionRule.ruleScope, this.qdoPermissionRule.ruleType, this.qdoPermissionRule.ruleScopeName, this.qdoPermissionRule.groupExpr, this.qdoPermissionRule.modifyTime, this.qdoPermissionRule.deep, this.qdoPermissionRule.modifyUserId, this.qdoPermissionRule.createTime, this.qdoPermissionRule.ruleTypeName, this.qdoPermissionRule.createUserId, this.qdoPermissionRule.ruleSubType, this.qdoPermissionRule.ruleSubTypeName, this.qdoPermissionRule.scopeType, this.qdoPermissionRule.scopeTypeName, this.qdoPermissionRule.levelScope, this.qdoPermissionRule.levelScopeName, this.qdoPermissionRule.functionId})).from((EntityPath)this.qdoPermissionRule);
    }

    private JPAQuery<PrdSystemPermissionRuleVO> getJPAQueryPermissionRuleWhere(PrdSystemPermissionRuleQuery query) {
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = this.getJPAQueryPermissionRules();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdoPermissionRule._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoPermissionRule, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<PrdSystemPermissionRuleVO> getJPAQueryPermissionRuleByUserWhere(PrdSystemPermissionRuleQuery query) {
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = this.getJPAQueryPermissionRules();
        jpaQuery.where(this.wherePermissionRuleByUser(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdoPermissionRule._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoPermissionRule, query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PrdSystemPermissionRuleQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (StringUtils.hasText((String)query.getRuleType())) {
            list.add(this.qdoPermissionRule.ruleType.like(SqlUtil.toSqlLikeString(query.getRuleType())));
        }
        if (StringUtils.hasText((String)query.getRuleScopeName())) {
            list.add(this.qdoPermissionRule.ruleScope.like(SqlUtil.toSqlLikeString(query.getRuleScopeName())));
        }
        list.add(this.qdoPermissionRule.functionId.longValue().eq((Object)query.getFunctionId()));
        return ExpressionUtils.allOf(list);
    }

    private Predicate wherePermissionRuleByUser(PrdSystemPermissionRuleQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!CollectionUtils.isEmpty((Collection)query.getOrgIds())) {
            list.add(this.qdoPermissionRule.ruleScope.eq((Object)String.valueOf(query.getRoleId())).or((Predicate)this.qdoPermissionRule.ruleScope.eq((Object)String.valueOf(query.getUserId()))).or((Predicate)this.qdoPermissionRule.ruleScope.in((Collection)query.getOrgIds())));
        } else {
            list.add(this.qdoPermissionRule.ruleScope.eq((Object)String.valueOf(query.getRoleId())).or((Predicate)this.qdoPermissionRule.ruleScope.eq((Object)String.valueOf(query.getUserId()))));
        }
        return ExpressionUtils.allOf(list);
    }

    private long count(PrdSystemPermissionRuleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoPermissionRule.count()).from((EntityPath)this.qdoPermissionRule);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdoPermissionRule._super, (TwQueryParam)query);
        Long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private long countPermissionRuleByUser(PrdSystemPermissionRuleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoPermissionRule.count()).from((EntityPath)this.qdoPermissionRule);
        jpaQuery.where(this.wherePermissionRuleByUser(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdoPermissionRule._super, (TwQueryParam)query);
        Long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public JPAQuery<PrdSystemPermissionRuleDetailDO> getJpaQueryPermissionRuleDetail() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemPermissionRuleDetailDO.class, (Expression[])new Expression[]{this.qdoPermissionRuleDetail.id, this.qdoPermissionRuleDetail.ruleId, this.qdoPermissionRuleDetail.ruleDetailCode, this.qdoPermissionRuleDetail.deep, this.qdoPermissionRuleDetail.ruleField, this.qdoPermissionRuleDetail.ruleValue, this.qdoPermissionRuleDetail.ruleConditionType})).from((EntityPath)this.qdoPermissionRuleDetail);
        return jpaQuery;
    }

    public JPAQuery<PrdSystemPermissionRuleDetailVO> getJpaQueryPermissionRuleDetails() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemPermissionRuleDetailVO.class, (Expression[])new Expression[]{this.qdoPermissionRuleDetail.id, this.qdoPermissionRuleDetail.ruleId, this.qdoPermissionRuleDetail.ruleFieldName, this.qdoPermissionRuleDetail.ruleDetailCode, this.qdoPermissionRuleDetail.ruleField, this.qdoPermissionRuleDetail.ruleValue, this.qdoPermissionRuleDetail.ruleCondition, this.qdoPermissionRuleDetail.deep, this.qdoPermissionRuleDetail.ruleValueName, this.qdoPermissionRuleDetail.ruleConditionType, this.qdoPermissionRuleDetail.ruleSql, this.qdoPermissionRuleDetail.showType, this.qdoPermissionRuleDetail.showAttr})).from((EntityPath)this.qdoPermissionRuleDetail);
        return jpaQuery;
    }

    public PrdSystemPermissionRuleDetailDO queryPermissionRuleDetailByCode(String ruleDetailCode) {
        JPAQuery<PrdSystemPermissionRuleDetailDO> jpaQuery = this.getJpaQueryPermissionRuleDetail();
        jpaQuery.where((Predicate)this.qdoPermissionRuleDetail.ruleDetailCode.eq((Object)ruleDetailCode));
        return (PrdSystemPermissionRuleDetailDO)((Object)jpaQuery.fetchOne());
    }

    public List<PrdSystemPermissionRuleDetailVO> queryPermissionRuleDetailByRuleId(Long id) {
        JPAQuery<PrdSystemPermissionRuleDetailVO> jpaQuery = this.getJpaQueryPermissionRuleDetails();
        jpaQuery.where((Predicate)this.qdoPermissionRuleDetail.ruleId.longValue().eq((Object)id));
        return jpaQuery.fetch();
    }

    public List<PrdSystemPermissionRuleVO> getAllByFunctionCode(String functionCode) {
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = this.getJPAQueryPermissionRules();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)this.functionDO)).on((Predicate)this.qdoPermissionRule.functionId.eq(this.functionDO.id))).where((Predicate)this.qdoPermissionRule.deleteFlag.eq((Object)0))).where((Predicate)this.functionDO.functionCode.eq((Object)functionCode))).fetch();
    }

    public PagingVO<PrdSystemPermissionRuleVO> queryPermissionRuleByUser(PrdSystemPermissionRuleQuery query) {
        long total = this.countPermissionRuleByUser(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = this.getJPAQueryPermissionRuleByUserWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public List<PrdSystemPermissionFieldVO> queryPermissionFieldByFunctionId(PrdSystemPermissionFieldQuery query) {
        JPAQuery<PrdSystemPermissionFieldVO> jpaQuery = this.getJPAQueryPermissionField();
        if (StringUtils.hasText((String)query.getType())) {
            jpaQuery.where((Predicate)this.qdoNewFunction.id.longValue().eq((Object)query.getFunctionId()).and((Predicate)this.fieldDO.fieldType.eq((Object)query.getType())));
        } else {
            jpaQuery.where((Predicate)this.qdoNewFunction.id.longValue().eq((Object)query.getFunctionId()).and((Predicate)this.fieldDO.fieldType.notIn((Object[])new String[]{PermissionFieldType.BUSINESS_USER.getName(), PermissionFieldType.BUSINESS_DEPT.getName()})));
        }
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdSystemPermissionFieldVO> getJPAQueryPermissionField() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemPermissionFieldVO.class, (Expression[])new Expression[]{this.fieldDO.id, this.fieldDO.field, this.fieldDO.fieldName, this.fieldDO.fieldType})).from((EntityPath)this.qdoNewFunction)).leftJoin((EntityPath)this.qdoFunctionObject)).on((Predicate)this.qdoFunctionObject.functionId.longValue().eq((Expression)this.qdoNewFunction.id.longValue()))).leftJoin((EntityPath)this.fieldDO)).on((Predicate)this.qdoFunctionObject.id.longValue().eq((Expression)this.fieldDO.functionObjectId.longValue()));
    }

    public List<PrdSystemPermissionFieldObjRoleFunctionVO> getPermissionFieldRule(String objectCode, String className, String functionCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class, (Expression[])new Expression[]{PrdSystemPermissionRuleDAO.Q_BUSINESS_OBJECT_DO.id.as("objectId"), PrdSystemPermissionRuleDAO.Q_BUSINESS_OBJECT_DO.objectCode, PrdSystemPermissionRuleDAO.Q_BUSINESS_OBJECT_DO.objectName, this.fieldDO.field.as("fieldName"), this.qdoPermissionField.isVisible, this.qdoPermissionField.isEdit, this.functionObjectDO.className, this.functionObjectDO.functionId, this.roleDO.roleCode})).from((EntityPath)this.qdoPermissionField)).leftJoin((EntityPath)this.fieldDO)).on((Predicate)this.qdoPermissionField.fieldId.eq(this.fieldDO.id))).leftJoin((EntityPath)this.functionObjectDO)).on((Predicate)this.fieldDO.functionObjectId.eq(this.functionObjectDO.id))).leftJoin((EntityPath)this.functionDO)).on((Predicate)this.functionDO.id.eq(this.functionObjectDO.functionId))).leftJoin((EntityPath)Q_BUSINESS_OBJECT_DO)).on((Predicate)this.functionObjectDO.objectId.eq(PrdSystemPermissionRuleDAO.Q_BUSINESS_OBJECT_DO.id))).leftJoin((EntityPath)this.roleDO)).on((Predicate)this.qdoPermissionField.roleId.eq(this.roleDO.id))).where((Predicate)PrdSystemPermissionRuleDAO.Q_BUSINESS_OBJECT_DO.objectCode.eq((Object)objectCode).and((Predicate)this.functionObjectDO.className.eq((Object)className)).and((Predicate)this.functionDO.functionCode.eq((Object)functionCode)))).where((Predicate)this.fieldDO.deleteFlag.eq((Object)0).and((Predicate)this.functionObjectDO.deleteFlag.eq((Object)0)).and((Predicate)PrdSystemPermissionRuleDAO.Q_BUSINESS_OBJECT_DO.deleteFlag.eq((Object)0)).and((Predicate)this.roleDO.deleteFlag.eq((Object)0)).and((Predicate)this.functionDO.deleteFlag.eq((Object)0)))).fetch();
    }

    public List<Long> getAllOrgByUserId(PrdSystemPermissionRuleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoOrg.id).from((EntityPath)this.qdoRef)).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.isCopy.eq((Object)0)))).where((Predicate)this.qdoRef.isCopy.eq((Object)0).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)).and((Predicate)this.qdoRef.userId.longValue().eq((Object)query.getUserId())));
        return jpaQuery.fetch();
    }

    public PrdSystemPermissionRuleDAO(JPAQueryFactory jpaQueryFactory, PrdSystemPermissionRuleRepo ruleRepo, PrdSystemPermissionRuleDetailRepo ruleDetailRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.ruleRepo = ruleRepo;
        this.ruleDetailRepo = ruleDetailRepo;
    }
}

