package com.elitesland.tw.tw5.server.common.change.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangeDataPayload;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.convert.ComChangeConvert;
import com.elitesland.tw.tw5.server.common.change.dao.ComChangeDAO;
import com.elitesland.tw.tw5.server.common.change.entity.ComChangeDO;
import com.elitesland.tw.tw5.server.common.change.repo.ComChangeRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 通用变更信息
 *
 * @author carl
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ComChangeServiceImpl implements ComChangeService {
    private final ComChangeRepo repo;
    private final ComChangeDAO dao;

    private final CacheUtil cacheUtil;

    @Override
    @Transactional(rollbackOn = Exception.class)
    public ComChangeVO insert(ComChangePayload payload) {
        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, payload.getChangeType(), payload.getChangeDocId());
        int num = 1;
        if (!ObjectUtils.isEmpty(count)) {
            num = count.intValue() + 1;
        }
        ComChangeDO comChangeDO = ComChangeConvert.INSTANCE.toDo(payload);
        comChangeDO.setVersionNo(num);
        ComChangeDO save = repo.save(comChangeDO);
        return ComChangeConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public Long updateByKeyDynamic(ComChangePayload payload) {
        return dao.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public Long save(String changeType, Object originalModel, Object changeModel, String docId) {

        String originalContent = JSONObject.toJSONString(originalModel);
        log.info("originalContent = {}", originalContent);
        //查询原表数据并保存
        ComChangeDO v0 = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId, 0);
        if (v0 == null) {
            ComChangeDO originalDO = new ComChangeDO()
                    .setChangeType(changeType)
                    .setVersionNo(0)
                    .setChangeContent(originalContent)
                    .setChangeDocId(docId);
            ComChangeDO save = repo.save(originalDO);
            if (save == null) {
                return -1L;
            }
        }

        //保存变更数据
        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);

        String changeContent = JSONObject.toJSONString(changeModel);
        log.info("changeContent = {}", changeContent);

        ComChangeDO changeDO = new ComChangeDO()
                .setChangeType(changeType)
                .setVersionNo(count.intValue())
                .setChangeContent(changeContent)
                .setChangeDocId(docId);
        ComChangeDO changeSave = repo.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    @Override
    public Long save(ComChangeDataPayload changeDataPayload) {
        String changeType = changeDataPayload.getChangeType();
        String docId = changeDataPayload.getChangeDocId();
        String originalContent = JSONObject.toJSONString(changeDataPayload.getOriginalModel());
        //查询原表数据并保存
        ComChangeDO v0 = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId, 0);
        if (v0 == null) {
            ComChangeDO originalDO = new ComChangeDO()
                    .setChangeType(changeType)
                    .setVersionNo(0)
                    .setChangeContent(originalContent)
                    .setChangeDocId(docId);

            ComChangeDO save = repo.save(originalDO);
            if (save == null) {
                return -1L;
            }
        }
        //保存变更数据
        Long count = repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        String changeContent = JSONObject.toJSONString(changeDataPayload.getChangeModel());
        ComChangeDO changeDO = new ComChangeDO()
                .setChangeType(changeType)
                .setVersionNo(count.intValue())
                .setChangeContent(changeContent)
                .setChangeDocId(docId)
                .setExtString1(changeDataPayload.getExtString1())
                .setExtString2(changeDataPayload.getExtString2())
                .setExtString3(changeDataPayload.getExtString3())
                .setExtString4(changeDataPayload.getExtString4())
                .setExtString5(changeDataPayload.getExtString5());
        ComChangeDO changeSave = repo.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public Long update(String changeType, String docId, Object changeModel) {
        List<ComChangeDO> dos = repo.findByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        if (ObjectUtils.isEmpty(dos)) {
            throw TwException.error("", "变更数据不存在，请核验！");
        }
        ComChangeDO changeDO = null;
        Integer versionNo = 0;
        for (ComChangeDO businessChange : dos) {
            if (businessChange.getVersionNo() > versionNo) {
                versionNo = businessChange.getVersionNo();
                changeDO = businessChange;
            }
        }
        String changeContent = JSONObject.toJSONString(changeModel);
        ComChangePayload payload = new ComChangePayload();
        payload.setId(changeDO.getId());
        payload.setChangeContent(changeContent);
        dao.updateByKeyDynamic(payload);
        return changeDO.getId();
    }

    /**
     * 获取版本列表
     *
     * @param query 条件查询对象
     * @return
     */
    @Override
    public List<ComChangeVO> changeSearch(ComChangeQuery query) {
        List<ComChangeVO> comChangeVOS = dao.queryListDynamic(query);
        //   comBusinessChangeVOS.forEach(vo -> vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId())));
        return comChangeVOS;
    }

    @Override
    public PagingVO<ComChangeVO> queryPaging(ComChangeQuery query) {
        PagingVO<ComChangeVO> pagingVO = dao.queryPaging(query);
        if (!ObjectUtils.isEmpty(pagingVO)) {
            pagingVO.getRecords().forEach(vo -> vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId())));
        }
        return pagingVO;
    }

    /**
     * 获取比较数据
     *
     * @param id
     * @param compareId
     * @return
     */
    @Override
    public Object getCompareChange(Long id, Long compareId) {

        ComChangeVO vo = dao.queryByKey(id);
        if (vo.getVersionNo() == 0) {
            return vo;
        }
        ComChangeVO vo1 = null;
        if (compareId == null) {
            ComChangeDO changeDO = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, vo.getChangeType(), vo.getChangeDocId(), (vo.getVersionNo() - 1));
            if (ObjectUtils.isEmpty(changeDO)) {
                throw TwException.error("", "比对数据不存在，请核验！");
            }
            vo1 = ComChangeConvert.INSTANCE.toVo(changeDO);
        } else {
            vo1 = dao.queryByKey(compareId);
        }
        if (vo1.getVersionNo() >= vo.getVersionNo()) {
            throw TwException.error("", "比对数据仅支持前后比对，请核验！");
        }
        /**
         * 方式一比对：
         */
        // Map<String, Object> compare = compare(vo1, vo);
        /**
         * 对比方式二：
         */
//        ProductSpuVO oldSpuVO = JSON.parseObject(vo1.getChangeContent(), ProductSpuVO.class);
//        ProductSpuVO newSpuVO = JSON.parseObject(vo.getChangeContent(), ProductSpuVO.class);
//        Map<String, Object> oldMap = JSON.parseObject(JSON.toJSONString(oldSpuVO), Map.class);
//        Map<String, Object> newMap = JSON.parseObject(JSON.toJSONString(newSpuVO), Map.class);
        Map<String, Object> oldMap = JSON.parseObject(vo1.getChangeContent(), Map.class);
        Map<String, Object> newMap = JSON.parseObject(vo.getChangeContent(), Map.class);
        Map<String, Object> updateCompare = getUpdateCompare(oldMap, newMap);
        return updateCompare;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public Long updateWorkFlow(ComChangePayload payload) {
        return dao.updateWorkFlow(payload);
    }

    @Override
    public ComChangeVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public ComChangeVO findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(String changeType, String docId, Integer versionNo) {
        ComChangeDO changeDO = repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId, versionNo);
        if (ObjectUtils.isEmpty(changeDO)) {
            throw TwException.error("", "比对数据不存在，请核验！");
        }
        return ComChangeConvert.INSTANCE.toVo(changeDO);
    }

    /**
     * 匹配获取变更数据
     *
     * @param oldMap
     * @param newMap
     * @return
     */
    public static Map<String, Object> getUpdateCompare(Map<String, Object> oldMap, Map<String, Object> newMap) {
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            if (!oldMap.containsKey(entry.getKey())) {
                oldMap.put(entry.getKey(), null);
            }
        }
        Map<String, Object> comparedMap = new HashMap<>();
        comparedMap.putAll(oldMap);
        for (Map.Entry<String, Object> entry : oldMap.entrySet()) {
            String oldKey = entry.getKey();
            Object oldValue = entry.getValue();
            Object newValue = newMap.get(oldKey);
            if (!oldKey.toLowerCase().contains("status") && !oldKey.toLowerCase().contains("createtime") && !oldKey.toLowerCase().contains("creator")) {
                if (ObjectUtils.isEmpty(oldValue)) {
                    if (!ObjectUtils.isEmpty(newValue)) {
                        //判断添加新值
                        operateMap(comparedMap, oldKey, oldValue, newValue);
                    }
                } else {
                    //如果改后值是空，则直接赋值字符串“”
                    if (ObjectUtils.isEmpty(newValue)) {
                        comparedMap.put(oldKey + "_$$_new", "");
                    } else {
                        if (!checkEquals(oldValue.toString(), newValue.toString())) {
                            //判断添加新值
                            operateMap(comparedMap, oldKey, oldValue, newValue);

                        }
                    }
                }
            } else {
                comparedMap.put(oldKey, newValue);
            }
        }
        return comparedMap;
    }

    static void operateMap(Map<String, Object> comparedMap, String key, Object oldValue, Object newValue) {
        if (newValue instanceof Map) {
            //表示结果是map，测重新判断
            Map<String, Object> oldValue0 = new HashMap<>();
            if (!ObjectUtils.isEmpty(oldValue)) {
                oldValue0 = (Map<String, Object>) oldValue;
            }

            Map<String, Object> newValue0 = (Map<String, Object>) newValue;
            Map<String, Object> comparedMap0 = getUpdateCompare(oldValue0, newValue0);
            comparedMap.put(key, comparedMap0);

        } else if (newValue instanceof List) {
            //判断是不是List<Map<String, Object>>对象
            List<Object> newValueList0 = (List<Object>) newValue;
            if (!(newValueList0.get(0) instanceof Map)) {
                return;
            }
            /**
             * 数据类型是list的处理方式
             * 1.先判断是否有新加数据（即newValue0包含oldValue0没有的对象）
             * 2.判断是否有删值（即oldValue0包含newValue0没有的对象）
             * 3.判断两个数组中对象属性是否改变
             */
            List<Map<String, Object>> oldValueList = new ArrayList<>();
            if (!ObjectUtils.isEmpty(oldValue)) {
                oldValueList = (List<Map<String, Object>>) oldValue;
            }
            List<Map<String, Object>> newValueList = (List<Map<String, Object>>) newValue;
            List<Map<String, Object>> comparedList = new ArrayList<>();
            for (Map<String, Object> oldValue0 : oldValueList) {
                //为了适配产品属性
                List<Map<String, Object>> collect = newValueList.stream().filter(newValue1 -> {
                            boolean isHave = true;
                            if (ObjectUtils.isEmpty(oldValue0.get("id"))) {
                                if (ObjectUtils.isEmpty(oldValue0.get("attrId"))) {
                                    if (ObjectUtils.isEmpty(oldValue0.get("groupId"))) {
                                        if (ObjectUtils.isEmpty(oldValue0.get("selectionValue"))) {
                                            return false;
                                        }
                                        isHave = oldValue0.get("selectionValue").toString().equals(newValue1.get("selectionValue").toString());
                                    } else {
                                        isHave = oldValue0.get("groupId").toString().equals(newValue1.get("groupId").toString());
                                    }
                                } else {
                                    isHave = oldValue0.get("attrId").toString().equals(newValue1.get("attrId").toString());
                                }
                            } else {
                                isHave = !ObjectUtils.isEmpty(newValue1.get("id")) && oldValue0.get("id").toString().equals(newValue1.get("id").toString());
                            }

                            return isHave;
                        }

                ).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    Map<String, Object> newValue0 = collect.get(0);
                    Map<String, Object> comparedMap0 = getUpdateCompare(oldValue0, newValue0);
                    comparedList.add(comparedMap0);
                    //移除关系
                    newValueList.remove(newValue0);
                } else {
                    oldValue0.put("dataStatus", 1);//表示数据被删除
                    comparedList.add(oldValue0);
                }
            }
            for (Map<String, Object> newValue0 : newValueList) {
                newValue0.put("dataStatus", 2);//表示新增数据
                comparedList.add(newValue0);
            }
            comparedMap.put(key, comparedList);
        } else {
            //其他直接加入
            comparedMap.put(key + "_$$_new", newValue);
        }
    }

    private static boolean checkEquals(String value1, String value2) {
        if (isNumeric(value1) && isNumeric(value2)) {
            value1 = new BigDecimal(value1).stripTrailingZeros().toPlainString();
            value2 = new BigDecimal(value2).stripTrailingZeros().toPlainString();
        }
        return value1.equals(value2);
    }

    public static boolean isNumeric(String str) {
        if (null == str || "".equals(str) || str.contains("-")) {
            return false;
        }
        String regx = "[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+";
        Pattern pattern = Pattern.compile(regx);
        boolean isNumber = pattern.matcher(str).matches();
        if (isNumber) {
            return isNumber;
        }
        regx = "^[-\\+]?[.\\d]*$";
        pattern = Pattern.compile(regx);
        return pattern.matcher(str).matches();
    }

}
