package com.elitesland.tw.tw5.server.common.constants;

import lombok.Getter;


/**
 * 系统设置枚举
 *
 * @author duwh
 * @date 2024/07/08
 */
public enum SystemSettingEnum {

    /**
     * 是否开启工时已经审批的增加“取消审批”功能  1 开启 0 关闭
     */
    TIMESHEET_APPROVED_REJECTED_FLAG("TIMESHEET_APPROVED_REJECTED_FLAG", "是否开启工时已经审批的增加“取消审批”功能"),
    /**
     * 可取消撤回的截止日期间隔   单位 天
     */
    TIMESHEET_APPROVED_REJECTED_INTERVAL("TIMESHEET_APPROVED_REJECTED_INTERVAL","可取消撤回的截止日期间隔"),


    ;


    @Getter
    private final String code;
    @Getter
    private final String desc;

    SystemSettingEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
