package com.elitesland.tw.tw5.server.common.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;

import java.lang.reflect.Field;
import java.util.*;

/**
 * EasyExcel导出工具类
 *
 * @author duwh
 * @date 2022/12/01
 */
public class ExcelUtil {

    /**
     * EasyExcel支持动态列导出
     *
     * @param builder        指定输出方式和样式
     * @param entityClass    实体的Class对象
     * @param customizeHeads 自定义列头
     * @param list           Excel行数据
     */
    public static void excelHelper(ExcelWriterSheetBuilder builder, Class entityClass, List<HeadVO> customizeHeads) {
        Field[] fields = entityClass.getDeclaredFields();
        // 获取类的注解
        if (null == customizeHeads) {
            customizeHeads = new ArrayList<>();
        }
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            boolean annotationPresent = field.isAnnotationPresent(ExcelProperty.class);
            if (annotationPresent) {
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                List<String> head = Arrays.asList(excelProperty.value());
                int index = excelProperty.index();
                int order = excelProperty.order();
                HeadVO headVO = HeadVO.builder().headTitle(head).index(index).order(order).key(field.getName()).build();
                customizeHeads.add(headVO);
            }
        }
        Collections.sort(customizeHeads);
        List<List<String>> heads = new ArrayList<>();
        List<String> keys = new ArrayList<>();
        for (int i = 0; i <= customizeHeads.size() - 1; i++) {
            heads.add(customizeHeads.get(i).getHeadTitle());
            keys.add(customizeHeads.get(i).getKey());
        }
        builder.head(heads);
    }


    public static void excelHelperTemp(ExcelWriterSheetBuilder builder, Class entityClass, List<HeadVO> customizeHeads, List<Map<String, Object>> list) {
        Field[] fields = entityClass.getDeclaredFields();
        // 获取类的注解

        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            boolean annotationPresent = field.isAnnotationPresent(ExcelProperty.class);
            if (annotationPresent) {
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                List<String> head = Arrays.asList(excelProperty.value());
                int index = excelProperty.index();
                int order = excelProperty.order();
                HeadVO headVO = HeadVO.builder().headTitle(head).index(index).order(order).key(field.getName()).build();
                customizeHeads.add(headVO);
            }
        }
        Collections.sort(customizeHeads);
        List<List<String>> heads = new ArrayList<>();
        List<String> keys = new ArrayList<>();
        for (int i = 0; i <= customizeHeads.size() - 1; i++) {
            heads.add(customizeHeads.get(i).getHeadTitle());
            keys.add(customizeHeads.get(i).getKey());
        }
        List<List<Object>> objs = new ArrayList<>();
        list.stream().forEach(e -> {
            List<Object> obj = new ArrayList<>();
            for (int i = 0; i < keys.size(); i++) {
                obj.add(e.get(keys.get(i)));
            }
            objs.add(obj);
        });
        builder.head(heads).doWrite(objs);
    }

}
