package com.elitesland.tw.tw5.server.common.funConfig.dao;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypePermissionPrevRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypePermissionPrevRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypePermissionPrevRecordDO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.QBusinessDocTypePermissionPrevRecordDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypePermissionPrevRecordRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 通用文档-易稻壳赋权预览地址获取记录表
 *
 * @author duwh
 * @date 2023-12-09
 */
@Repository
@RequiredArgsConstructor
public class BusinessDocTypePermissionPrevRecordDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessDocTypePermissionPrevRecordRepo repo;
    private final QBusinessDocTypePermissionPrevRecordDO qdo = QBusinessDocTypePermissionPrevRecordDO.businessDocTypePermissionPrevRecordDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypePermissionPrevRecordVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessDocTypePermissionPrevRecordVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 单据类型
                qdo.docType,
                // 单据主键
                qdo.docId,
                // 被赋权限的人员userId
                qdo.userId,
                // 文档类型配置主键 prd_business_doc_type_config.id
                qdo.configId,
                // prd_business_doc_type_config_rule.id
                qdo.configRuleId,
                qdo.libraryId,
                // 文件夹id -yeedoc返回
                qdo.folderId,
                // 文件夹名称 LeafName -yeedoc返回
                qdo.folderName,
                // 易稻壳文件路径
                qdo.itemPath,
                // 易稻壳文件预览地址
                qdo.previewUri,
                // 赋权标记
                qdo.permissionFlag,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypePermissionPrevRecordVO> getJpaQueryWhere(BusinessDocTypePermissionPrevRecordQuery query) {
        JPAQuery<BusinessDocTypePermissionPrevRecordVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessDocTypePermissionPrevRecordQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessDocTypePermissionPrevRecordQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 单据类型 精确 */
        if (!ObjectUtils.isEmpty(query.getDocType())) {
            list.add(qdo.docType.eq(query.getDocType()));
        }
        /** 单据主键 精确 */
        if (!ObjectUtils.isEmpty(query.getDocId())) {
            list.add(qdo.docId.eq(query.getDocId()));
        }
        /** 被赋权限的人员userId 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 文档类型配置主键 prd_business_doc_type_config.id 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** prd_business_doc_type_config_rule.id 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigRuleId())) {
            list.add(qdo.configRuleId.eq(query.getConfigRuleId()));
        }
        /** 文件夹id -yeedoc返回 精确 */
        if (!ObjectUtils.isEmpty(query.getFolderId())) {
            list.add(qdo.folderId.eq(query.getFolderId()));
        }
        /** libraryId -yeedoc返回 精确 */
        if (!ObjectUtils.isEmpty(query.getLibraryId())) {
            list.add(qdo.libraryId.eq(query.getLibraryId()));
        }
        /** 文件夹名称 LeafName -yeedoc返回 精确 */
        if (!ObjectUtils.isEmpty(query.getFolderName())) {
            list.add(qdo.folderName.eq(query.getFolderName()));
        }
        /** 易稻壳文件路径 精确 */
        if (!ObjectUtils.isEmpty(query.getItemPath())) {
            list.add(qdo.itemPath.eq(query.getItemPath()));
        }
        /** 易稻壳文件预览地址 精确 */
        if (!ObjectUtils.isEmpty(query.getPreviewUri())) {
            list.add(qdo.previewUri.eq(query.getPreviewUri()));
        }
        /** 赋权标记 精确 */
        if (!ObjectUtils.isEmpty(query.getPermissionFlag())) {
            list.add(qdo.permissionFlag.eq(query.getPermissionFlag()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessDocTypePermissionPrevRecordVO queryByKey(Long id) {
        JPAQuery<BusinessDocTypePermissionPrevRecordVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessDocTypePermissionPrevRecordVO> queryListDynamic(BusinessDocTypePermissionPrevRecordQuery query) {
        JPAQuery<BusinessDocTypePermissionPrevRecordVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessDocTypePermissionPrevRecordVO> queryPaging(BusinessDocTypePermissionPrevRecordQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessDocTypePermissionPrevRecordVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessDocTypePermissionPrevRecordVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessDocTypePermissionPrevRecordVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessDocTypePermissionPrevRecordDO save(BusinessDocTypePermissionPrevRecordDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessDocTypePermissionPrevRecordDO> saveAll(List<BusinessDocTypePermissionPrevRecordDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessDocTypePermissionPrevRecordPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 单据类型
        if (payload.getDocType() != null) {
            update.set(qdo.docType, payload.getDocType());
        }
        // 单据主键
        if (payload.getDocId() != null) {
            update.set(qdo.docId, payload.getDocId());
        }
        // 被赋权限的人员userId
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        // 文档类型配置主键 prd_business_doc_type_config.id
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // prd_business_doc_type_config_rule.id
        if (payload.getConfigRuleId() != null) {
            update.set(qdo.configRuleId, payload.getConfigRuleId());
        }
        // 文件夹id -yeedoc返回
        if (payload.getFolderId() != null) {
            update.set(qdo.folderId, payload.getFolderId());
        }
        // 文件夹名称 LeafName -yeedoc返回
        if (payload.getFolderName() != null) {
            update.set(qdo.folderName, payload.getFolderName());
        }
        // 易稻壳文件路径
        if (payload.getItemPath() != null) {
            update.set(qdo.itemPath, payload.getItemPath());
        }
        // 易稻壳文件预览地址
        if (payload.getPreviewUri() != null) {
            update.set(qdo.previewUri, payload.getPreviewUri());
        }
        // 赋权标记
        if (payload.getPermissionFlag() != null) {
            update.set(qdo.permissionFlag, payload.getPermissionFlag());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 单据类型
            if (nullFields.contains("docType")) {
                update.setNull(qdo.docType);
            }
            // 单据主键
            if (nullFields.contains("docId")) {
                update.setNull(qdo.docId);
            }
            // 被赋权限的人员userId
            if (nullFields.contains("userId")) {
                update.setNull(qdo.userId);
            }
            // 文档类型配置主键 prd_business_doc_type_config.id
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // prd_business_doc_type_config_rule.id
            if (nullFields.contains("configRuleId")) {
                update.setNull(qdo.configRuleId);
            }
            // 文件夹id -yeedoc返回
            if (nullFields.contains("folderId")) {
                update.setNull(qdo.folderId);
            }
            // 文件夹名称 LeafName -yeedoc返回
            if (nullFields.contains("folderName")) {
                update.setNull(qdo.folderName);
            }
            // 易稻壳文件路径
            if (nullFields.contains("itemPath")) {
                update.setNull(qdo.itemPath);
            }
            // 易稻壳文件预览地址
            if (nullFields.contains("previewUri")) {
                update.setNull(qdo.previewUri);
            }
            // 赋权标记
            if (nullFields.contains("permissionFlag")) {
                update.setNull(qdo.permissionFlag);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

