package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 通用文档-文档类型访问权限
 *
 * @author duwh
 * @date 2023-12-10
 */
@Entity
@Table(name = "prd_business_doc_type_config_allow_role", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_config_allow_role", comment = "通用文档-文档类型访问权限")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeConfigAllowRoleDO extends BaseModel implements Serializable  {
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @Comment("文档类型配置主键 prd_business_doc_type_config.id")
    @Column()
    private Long configId;
    /** 文档类型配置名称（冗余）prd_business_doc_type_config.name */
    @Comment("文档类型配置名称（冗余）prd_business_doc_type_config.name")
    @Column()
    private String configName;
    /** 角色编码 */
    @Comment("角色编码")
    @Column()
    private String roleCode;
    /** 角色名称 */
    @Comment("角色名称")
    @Column()
    private String roleName;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypeConfigAllowRoleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
