package com.elitesland.tw.tw5.server.log.dto;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogChannelEnum;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 接口请求日志记录
 *
 * @author duwh
 * @date 2022/11/09
 */
@Getter
@Setter
public class ApiRequestLogQuery extends TwQueryParam {

    @Serial
    private static final long serialVersionUID = 4612287078577446076L;
    /**
     * 类型
     * 新增接口，需要维护
     */
    @Query()
    @Enumerated(EnumType.STRING)
    private ApiRequestLogTypeEnum type;

    /**
     * 调入or调出
     */
    @Query()
    @Enumerated(EnumType.STRING)
    private ApiRequestLogChannelEnum channel;

    /**
     * uri
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String uri;

    /**
     * 创建者
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String creator;

    @Enumerated(EnumType.STRING)
    @Query()
    private RequestMethod requestMethod;

    /**
     * 参数
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String param;

    /**
     * 头
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String header;

    /**
     * 结果
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String result;

    /**
     * 状态
     */
    @Query()
    private String status;

    /**
     * 时间
     */
    private Long time;

    /**
     * 备注
     */
    private String remark;

    /**
     * ext1
     */
    private String ext1;

    /**
     * ext2
     */
    private String ext2;

    /**
     * ext3
     */
    private String ext3;

    /**
     * ext4
     */
    private String ext4;

    /**
     * 创建时间起
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Query(type = Query.Type.GREATER_THAN)
    private LocalDateTime createTimeStart;

    /**
     * 创建时间止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Query(type = Query.Type.LESS_THAN)
    private LocalDateTime createTimeEnd;


}
