package com.elitesland.tw.tw5.server.prd.ab.dao;


import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbInvoiceVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbInvoiceDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbInvoiceDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbInvoiceRepo;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class PrdAbInvoiceDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbInvoiceRepo repo;
    private final QPrdAbInvoiceDO qdo = QPrdAbInvoiceDO.prdAbInvoiceDO;
    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;

    /**
     * @param bookId
     * @return
     * @Description
     **/
    public Long queryIdByBookId(Long bookId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoCustomer.id).from(qdoCustomer);
        jpaQuery.where(qdoCustomer.bookId.eq(bookId));
        jpaQuery.where(qdoCustomer.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.invoiceIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.invoiceIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdAbInvoiceDO save(PrdAbInvoiceDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdAbInvoiceVO> getJpaQuerySelect() {
        JPAQuery<PrdAbInvoiceVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbInvoiceVO.class,
                qdo.id,
                qdo.bookId,
                qdo.invoiceMessage,
                qdo.invoiceTitle,
                qdo.taxRete,
                qdo.taxNo,
                qdo.invoiceType,
                qdo.invoiceAddress,
                qdo.invoicePhone,
                qdo.depositBank,
                qdo.invoiceAccount,
                qdo.currency,
                qdo.remark,
                qdo.defaultFlag
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param bookId 地址簿主键
     * @return
     * @Description 主键查询
     **/
    public List<PrdAbInvoiceVO> queryList(Long bookId) {
        JPAQuery<PrdAbInvoiceVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    public PrdAbInvoiceVO queryByKey(Long id) {
        JPAQuery<PrdAbInvoiceVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }
}
