package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBusinessItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBusinessItemVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccBusinessItemDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccBusinessItemDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccBusinessItemRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 核算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Repository
@RequiredArgsConstructor
public class AccBusinessItemDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccBusinessItemRepo repo;
    private final QAccBusinessItemDO qdo = QAccBusinessItemDO.accBusinessItemDO;
    private final QAccBusinessItemDO qdo0 = new QAccBusinessItemDO("accBusinessItemDO0");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccBusinessItemVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccBusinessItemVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 预算编码
                qdo.businessCode,
                // 预算名称
                qdo.businessName,
                // 上级id
                qdo.parentId,
                // 上级编号
                qdo.parentCode,
                // 汇总科目（0：否，1：是）
                qdo.sumFlag,
                // 明细账
                qdo.dtlAcc,
                // 处理码
                qdo.procCode,
                // 子账标记
                qdo.ledgerFlag,
                // 子账类型
                qdo.ledgerType,
                // 可配置字段1
                qdo.extStr1,
                // 可配置字段2
                qdo.extStr2,
                // 可配置字段3
                qdo.extStr3,
                // 可配置字段4
                qdo.extStr4,
                // 可配置字段5
                qdo.extStr5,
                // 核算项目类别
                qdo.businessType,
                // 状态
                qdo.businessStatus,
                // 级别
                qdo.businessLevel,
                // 大类
                qdo.businessType1,
                // 明细类1
                qdo.businessType2,
                // 明细类2
                qdo.businessType3,
                //上级名称
                qdo0.businessName.as("parentName"),
                // 税率
                qdo.taxRate
        )).from(qdo).leftJoin(qdo0).on(qdo.parentId.eq(qdo0.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccBusinessItemVO> getJpaQueryWhere(AccBusinessItemQuery query) {
        JPAQuery<AccBusinessItemVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccBusinessItemQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qdo0).on(qdo.parentId.eq(qdo0.id));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccBusinessItemQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 预算编码 模糊 */
        if (!ObjectUtils.isEmpty(query.getBusinessCode())) {
            list.add(qdo.businessCode.like(SqlUtil.toSqlLikeString(query.getBusinessCode())));
        }
        /** 预算名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getBusinessName())) {
            list.add(qdo.businessName.like(SqlUtil.toSqlLikeString(query.getBusinessName())));
        }
        /** 上级id 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()).or(qdo.id.eq(query.getParentId())));
        }
        /** 上级编号 精确 */
        if (!ObjectUtils.isEmpty(query.getParentCode())) {
            list.add(qdo.parentCode.eq(query.getParentCode()));
        }
        /** 汇总科目（0：否，1：是） 精确 */
        if (!ObjectUtils.isEmpty(query.getSumFlag())) {
            list.add(qdo.sumFlag.eq(query.getSumFlag()));
        }
        /** 明细账 精确 */
        if (!ObjectUtils.isEmpty(query.getDtlAcc())) {
            list.add(qdo.dtlAcc.eq(query.getDtlAcc()));
        }
        /** 处理码 精确 */
        if (!ObjectUtils.isEmpty(query.getProcCode())) {
            list.add(qdo.procCode.eq(query.getProcCode()));
        }
        /** 子账标记 精确 */
        if (!ObjectUtils.isEmpty(query.getLedgerFlag())) {
            list.add(qdo.ledgerFlag.eq(query.getLedgerFlag()));
        }
        /** 子账类型 精确 */
        if (!ObjectUtils.isEmpty(query.getLedgerType())) {
            list.add(qdo.ledgerType.eq(query.getLedgerType()));
        }
        /** 可配置字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr1())) {
            list.add(qdo.extStr1.eq(query.getExtStr1()));
        }
        /** 可配置字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr2())) {
            list.add(qdo.extStr2.eq(query.getExtStr2()));
        }
        /** 可配置字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr3())) {
            list.add(qdo.extStr3.eq(query.getExtStr3()));
        }
        /** 可配置字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr4())) {
            list.add(qdo.extStr4.eq(query.getExtStr4()));
        }
        /** 可配置字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr5())) {
            list.add(qdo.extStr5.eq(query.getExtStr5()));
        }
        /** 核算项目类别 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessType())) {
            list.add(qdo.businessType.eq(query.getBusinessType()));
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessStatus())) {
            list.add(qdo.businessStatus.eq(query.getBusinessStatus()));
        }
        /** 级别 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessLevel())) {
            list.add(qdo.businessLevel.eq(query.getBusinessLevel()));
        }
        /** 大类 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessType1())) {
            list.add(qdo.businessType1.eq(query.getBusinessType1()));
        }
        /** 明细类1 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessType2())) {
            list.add(qdo.businessType2.eq(query.getBusinessType2()));
        }
        /** 明细类2 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessType3())) {
            list.add(qdo.businessType3.eq(query.getBusinessType3()));
        }
        if (!ObjectUtils.isEmpty(query.getIdList())) {
            list.add(qdo.id.in(query.getIdList()));
        }
        if (!ObjectUtils.isEmpty(query.getBusCodeList())) {
            list.add(qdo.businessCode.in(query.getBusCodeList()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccBusinessItemVO queryByKey(Long id) {
        JPAQuery<AccBusinessItemVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccBusinessItemVO> queryListDynamic(AccBusinessItemQuery query) {
        JPAQuery<AccBusinessItemVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccBusinessItemVO> queryPaging(AccBusinessItemQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AccBusinessItemVO> jpaQuery = getJpaQueryWhere(query);
        List<AccBusinessItemVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccBusinessItemVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccBusinessItemDO save(AccBusinessItemDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccBusinessItemDO> saveAll(List<AccBusinessItemDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccBusinessItemPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 预算编码
        if (payload.getBusinessCode() != null) {
            update.set(qdo.businessCode, payload.getBusinessCode());
        }
        // 预算名称
        if (payload.getBusinessName() != null) {
            update.set(qdo.businessName, payload.getBusinessName());
        }
        // 上级id
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 上级编号
        if (payload.getParentCode() != null) {
            update.set(qdo.parentCode, payload.getParentCode());
        }
        // 汇总科目（0：否，1：是）
        if (payload.getSumFlag() != null) {
            update.set(qdo.sumFlag, payload.getSumFlag());
        }
        // 明细账
        if (payload.getDtlAcc() != null) {
            update.set(qdo.dtlAcc, payload.getDtlAcc());
        }
        // 处理码
        if (payload.getProcCode() != null) {
            update.set(qdo.procCode, payload.getProcCode());
        }
        // 子账标记
        if (payload.getLedgerFlag() != null) {
            update.set(qdo.ledgerFlag, payload.getLedgerFlag());
        }
        // 子账类型
        if (payload.getLedgerType() != null) {
            update.set(qdo.ledgerType, payload.getLedgerType());
        }
        // 可配置字段1
        if (payload.getExtStr1() != null) {
            update.set(qdo.extStr1, payload.getExtStr1());
        }
        // 可配置字段2
        if (payload.getExtStr2() != null) {
            update.set(qdo.extStr2, payload.getExtStr2());
        }
        // 可配置字段3
        if (payload.getExtStr3() != null) {
            update.set(qdo.extStr3, payload.getExtStr3());
        }
        // 可配置字段4
        if (payload.getExtStr4() != null) {
            update.set(qdo.extStr4, payload.getExtStr4());
        }
        // 可配置字段5
        if (payload.getExtStr5() != null) {
            update.set(qdo.extStr5, payload.getExtStr5());
        }
        // 核算项目类别
        if (payload.getBusinessType() != null) {
            update.set(qdo.businessType, payload.getBusinessType());
        }
        // 状态
        if (payload.getBusinessStatus() != null) {
            update.set(qdo.businessStatus, payload.getBusinessStatus());
        }
        // 级别
        if (payload.getBusinessLevel() != null) {
            update.set(qdo.businessLevel, payload.getBusinessLevel());
        }
        // 大类
        if (payload.getBusinessType1() != null) {
            update.set(qdo.businessType1, payload.getBusinessType1());
        }
        // 明细类1
        if (payload.getBusinessType2() != null) {
            update.set(qdo.businessType2, payload.getBusinessType2());
        }
        // 明细类2
        if (payload.getBusinessType3() != null) {
            update.set(qdo.businessType3, payload.getBusinessType3());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 预算编码
            if (nullFields.contains("businessCode")) {
                update.setNull(qdo.businessCode);
            }
            // 预算名称
            if (nullFields.contains("businessName")) {
                update.setNull(qdo.businessName);
            }
            // 上级id
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 上级编号
            if (nullFields.contains("parentCode")) {
                update.setNull(qdo.parentCode);
            }
            // 汇总科目（0：否，1：是）
            if (nullFields.contains("sumFlag")) {
                update.setNull(qdo.sumFlag);
            }
            // 明细账
            if (nullFields.contains("dtlAcc")) {
                update.setNull(qdo.dtlAcc);
            }
            // 处理码
            if (nullFields.contains("procCode")) {
                update.setNull(qdo.procCode);
            }
            // 子账标记
            if (nullFields.contains("ledgerFlag")) {
                update.setNull(qdo.ledgerFlag);
            }
            // 子账类型
            if (nullFields.contains("ledgerType")) {
                update.setNull(qdo.ledgerType);
            }
            // 可配置字段1
            if (nullFields.contains("extStr1")) {
                update.setNull(qdo.extStr1);
            }
            // 可配置字段2
            if (nullFields.contains("extStr2")) {
                update.setNull(qdo.extStr2);
            }
            // 可配置字段3
            if (nullFields.contains("extStr3")) {
                update.setNull(qdo.extStr3);
            }
            // 可配置字段4
            if (nullFields.contains("extStr4")) {
                update.setNull(qdo.extStr4);
            }
            // 可配置字段5
            if (nullFields.contains("extStr5")) {
                update.setNull(qdo.extStr5);
            }
            // 核算项目类别
            if (nullFields.contains("businessType")) {
                update.setNull(qdo.businessType);
            }
            // 状态
            if (nullFields.contains("businessStatus")) {
                update.setNull(qdo.businessStatus);
            }
            // 级别
            if (nullFields.contains("businessLevel")) {
                update.setNull(qdo.businessLevel);
            }
            // 大类
            if (nullFields.contains("businessType1")) {
                update.setNull(qdo.businessType1);
            }
            // 明细类1
            if (nullFields.contains("businessType2")) {
                update.setNull(qdo.businessType2);
            }
            // 明细类2
            if (nullFields.contains("businessType3")) {
                update.setNull(qdo.businessType3);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据编号或者名称查询
     *
     * @param businessCode
     * @param businessName
     * @return
     */
    public List<Long> queryByCodeAndName(String businessCode, String businessName) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).
                where(qdo.businessCode.eq(businessCode).and(qdo.businessName.eq(businessName)));
        return jpaQuery.fetch();
    }
}

