package com.elitesland.tw.tw5.server.prd.acc.dao;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingContinuousPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingContinuousQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingContinuousDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimSettingContinuousDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingContinuousRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 报销配置连号规则配置
 *
 * @author zoey
 * @date 2024-04-16
 */
@Repository
@RequiredArgsConstructor
public class AccReimSettingContinuousDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimSettingContinuousRepo repo;
    private final QAccReimSettingContinuousDO qdo = QAccReimSettingContinuousDO.accReimSettingContinuousDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingContinuousVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccReimSettingContinuousVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 报销配置主表id
                // 发票类型
                qdo.invoiceType,
                // 校验日期区间
                qdo.checkDays,
                // 号码间隔合理区间
                qdo.checkStep,
                // 校验范围
                qdo.checkRange
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingContinuousVO> getJpaQueryWhere(AccReimSettingContinuousQuery query) {
        JPAQuery<AccReimSettingContinuousVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccReimSettingContinuousQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccReimSettingContinuousQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 发票类型 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceType())) {
            list.add(qdo.invoiceType.eq(query.getInvoiceType()));
        }
        /** 校验日期区间 精确 */
        if (!ObjectUtils.isEmpty(query.getCheckDays())) {
            list.add(qdo.checkDays.eq(query.getCheckDays()));
        }
        /** 号码间隔合理区间 精确 */
        if (!ObjectUtils.isEmpty(query.getCheckStep())) {
            list.add(qdo.checkStep.eq(query.getCheckStep()));
        }
        /** 校验范围 精确 */
        if (!ObjectUtils.isEmpty(query.getCheckRange())) {
            list.add(qdo.checkRange.eq(query.getCheckRange()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccReimSettingContinuousVO queryByKey(Long id) {
        JPAQuery<AccReimSettingContinuousVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccReimSettingContinuousVO> queryListDynamic(AccReimSettingContinuousQuery query) {
        JPAQuery<AccReimSettingContinuousVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccReimSettingContinuousVO> queryPaging(AccReimSettingContinuousQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<AccReimSettingContinuousVO> jpaQuery = getJpaQueryWhere(query);
        List<AccReimSettingContinuousVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccReimSettingContinuousVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccReimSettingContinuousDO save(AccReimSettingContinuousDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccReimSettingContinuousDO> saveAll(List<AccReimSettingContinuousDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccReimSettingContinuousPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 发票类型
        if (payload.getInvoiceType() != null) {
            update.set(qdo.invoiceType, payload.getInvoiceType());
        }
        // 校验日期区间
        if (payload.getCheckDays() != null) {
            update.set(qdo.checkDays, payload.getCheckDays());
        }
        // 号码间隔合理区间
        if (payload.getCheckStep() != null) {
            update.set(qdo.checkStep, payload.getCheckStep());
        }
        // 校验范围
        if (payload.getCheckRange() != null) {
            update.set(qdo.checkRange, payload.getCheckRange());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 发票类型
            if (nullFields.contains("invoiceType")) {
                update.setNull(qdo.invoiceType);
            }
            // 校验日期区间
            if (nullFields.contains("checkDays")) {
                update.setNull(qdo.checkDays);
            }
            // 号码间隔合理区间
            if (nullFields.contains("checkStep")) {
                update.setNull(qdo.checkStep);
            }
            // 校验范围
            if (nullFields.contains("checkRange")) {
                update.setNull(qdo.checkRange);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

