package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 报销逾期打折表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Entity
@Table(name = "acc_reim_setting_overdue_discunt", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_setting_overdue_discunt", comment = "报销逾期打折表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSettingOverdueDiscuntDO extends BaseModel implements Serializable  {
    /** 报销逾期规则配置主表id */
    @Comment("报销逾期规则配置主表id")
    @Column()
    private Long reimSettingOverdueId;
    /** 日期区间开始（包含） */
    @Comment("日期区间开始（包含）")
    @Column()
    private Integer minDays;
    /** 日期区间结束（不包含） */
    @Comment("日期区间结束（不包含）")
    @Column()
    private Integer maxDays;
    /** 折扣（0~10） */
    @Comment("折扣（0~10）")
    @Column()
    private BigDecimal invLimit;

    public void copy(AccReimSettingOverdueDiscuntDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
