package com.elitesland.tw.tw5.server.prd.adm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketDataPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmTripTicketVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * 行政订票管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Api(tags = "行政订票管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/adm/admTripTicket")
@Slf4j
public class AdmTripTicketController {

    private final AdmTripTicketService admTripTicketService;

    /**
     * 行政订票管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("行政订票管理-新增或修改")
    public TwOutputUtil<AdmTripTicketVO> insertOrUpdate(@RequestBody AdmTripTicketPayload payload) {
        return TwOutputUtil.ok(admTripTicketService.insertOrUpdate(payload));
    }

    /**
     * 行政订票管理-批量新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/bacthInsert")
    @ApiOperation("行政订票管理-批量新增或修改")
    public TwOutputUtil<AdmTripTicketVO> bacthInsertOrUpdate(@RequestBody AdmTripTicketDataPayload payload) {
        return TwOutputUtil.ok(admTripTicketService.bacthInsert(payload));
    }

    /**
     * 行政订票管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("行政订票管理-主键查询")
    public TwOutputUtil<AdmTripTicketVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(admTripTicketService.queryByKey(key));
    }

    /**
     * 行政订票管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("行政订票管理-分页")
    public TwOutputUtil<PagingVO<AdmTripTicketVO>> paging(AdmTripTicketQuery query) {
        return TwOutputUtil.ok(admTripTicketService.queryPaging(query));
    }

    /**
     * 行政订票管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("行政订票管理-查询列表")
    public TwOutputUtil<List<AdmTripTicketVO>> queryList(AdmTripTicketQuery query) {
        return TwOutputUtil.ok(admTripTicketService.queryListDynamic(query));
    }

    /**
     * 行政订票管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("行政订票管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        admTripTicketService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 行政订票管理-导出
     *
     * @param query 查询
     */
    @GetMapping("/exportList")
    @UdcNameClass
    @ApiOperation("行政订票管理-导出")
    public void export(AdmTripTicketQuery query, HttpServletResponse response) throws IOException {
        admTripTicketService.exportList(query, response);
    }

}

