package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalSettlePricePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalSettlePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalSettlePriceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalSettlePriceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Api(tags = "当量结算定价管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calSettlePrice")
@Slf4j
public class CalSettlePriceController {

    private final CalSettlePriceService calSettlePriceService;

    /**
     * 当量结算定价管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("当量结算定价管理-新增或修改")
    public TwOutputUtil<CalSettlePriceVO> insertOrUpdate(@RequestBody CalSettlePricePayload payload) {
        return TwOutputUtil.ok(calSettlePriceService.insertOrUpdate(payload));
    }


    /**
     * 当量结算定价管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("当量结算定价管理-主键查询")
    public TwOutputUtil<CalSettlePriceVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calSettlePriceService.queryByKey(key));
    }

    /**
     * 当量结算定价管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("当量结算定价管理-分页")
    public TwOutputUtil<PagingVO<CalSettlePriceVO>> paging(CalSettlePriceQuery query) {
        return TwOutputUtil.ok(calSettlePriceService.queryPaging(query));
    }

    /**
     * 当量结算定价管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("当量结算定价管理-查询列表")
    public TwOutputUtil<List<CalSettlePriceVO>> queryList(CalSettlePriceQuery query) {
        return TwOutputUtil.ok(calSettlePriceService.queryListDynamic(query));
    }

    /**
     * 当量结算定价管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("当量结算定价管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calSettlePriceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

