package com.elitesland.tw.tw5.server.prd.cal.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleDetailPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleDetailQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleDetailService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleDetailVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskSettleTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskSettleTimesheetService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalTaskSettleConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalTaskSettleDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalTaskSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalTaskSettleRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalTaskSettleTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.task.common.PricingMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskSettleTimesheetConvert;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalTaskSettleServiceImpl extends BaseServiceImpl implements CalTaskSettleService {

    private final CalTaskSettleRepo calTaskSettleRepo;
    private final CalTaskSettleDAO calTaskSettleDAO;
    private final CalTaskSettleDetailService calTaskSettleDetailService;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CalResourceService calResourceService;
    private final TaskPackageService taskPackageService;
    private final TaskInfoService taskInfoService;
    private final FileUtil fileUtil;
    private final TaskSettleTimesheetService taskSettleTimesheetService;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.TASK_SETTLE);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskSettleJobHandler(List<Long> userIds) {
        /**
         * 处理流程
         * 1.拉取任务数据
         *  1.1：任务状态处理中或已完成
         *  1.2：审批当量和已结算当量差值及总当量和已结算当量差值最小值，都大于0
         * 2.拉取任务对应的计价方式为单价任务包数据
         * 3.按照任务包分组进行结算
         * 4.生成泛用结算单及流水记录，修改账户信息
         * 4.修改任务已结算当量数
         */
        log.info("定时任务结算开始。。。。。");
        XxlJobLogger.log("定时任务结算开始 localDateTime：" + LocalDateTime.now());
        // List<String> statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.FINISHED.getCode());
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskStatuss(taskInfoService.getEffectiveTaskStatus());
        taskInfoQuery.setTaskResIds(userIds);
        List<TaskInfoVO> taskInfoVOS = taskInfoService.queryTaskSettleList(taskInfoQuery);
        if (!ObjectUtils.isEmpty(taskInfoVOS)) {

            Map<Long, List<TaskInfoVO>> maps = taskInfoVOS.stream().collect(Collectors.groupingBy(TaskInfoVO::getTaskPackageId));
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setIds(new ArrayList<>(maps.keySet()));
            taskPackageQuery.setPricingMethod(PricingMethodEnum.SINGLE.getCode());
            List<TaskPackageVO> taskPackageVOS = taskPackageService.taskPackageList(taskPackageQuery);
            if (!ObjectUtils.isEmpty(taskPackageVOS)) {

                //自动结算 如果userIds有值则表示用最新的日期作为结算期间
                List<CalTaskSettleDetailPayload> detailPayloads = taskAutoSettle(maps, taskPackageVOS, !ObjectUtils.isEmpty(userIds));
                Map<Long, Long> taskSettleIdMap = new HashMap<>();
                detailPayloads.forEach(detailPayload -> {
                    taskInfoService.updateSettledEqva(detailPayload.getTaskId(), detailPayload.getApproveSettleEqva());
                    taskSettleIdMap.put(detailPayload.getTaskId(), detailPayload.getSettleId());
                });
                //保存工时任务结算单关系
                saveTaskTaskSettleTimesheet(taskSettleIdMap);
            }
        }
        log.info("定时任务结算结束....");
        XxlJobLogger.log("定时任务结算结束 localDateTime：" + LocalDateTime.now());
    }

    /**
     * 自动结算方法
     *
     * @param taskInfoMaps
     * @param taskPackageVOS
     * @param isNew          是否用最新的日期作为结算期间
     */
    @Override
    public List<CalTaskSettleDetailPayload> taskAutoSettle(Map<Long, List<TaskInfoVO>> taskInfoMaps, List<TaskPackageVO> taskPackageVOS, Boolean isNew) {
        log.info("自动结算执行开始....");
        LocalDate currentDate;
        if (!isNew) {
            //上个月末时间
            currentDate = DateUtil.getMinusMonth(LocalDate.now());
        } else {
            currentDate = LocalDate.now();
        }
        //结算日期
        LocalDate lastMonthEndDate = currentDate;

        //初始化结算单数据
        List<CalTaskSettlePayload> payloads = new ArrayList<>();
        taskPackageVOS.forEach(taskPackageVO -> {
            List<TaskInfoVO> taskInfoVOS1 = taskInfoMaps.get(taskPackageVO.getId());
            taskPackageVO.setTaskInfoVOS(taskInfoVOS1);
            CalTaskSettlePayload payload = new CalTaskSettlePayload();
            payload.setTaskId(taskPackageVO.getId());
            payload.setSettleDate(lastMonthEndDate);
            List<CalTaskSettleDetailPayload> detailPayloads = new ArrayList<>();
            taskInfoVOS1.forEach(taskInfoVO -> {
//                log.info("taskInfoVO::1" + taskInfoVO.toString());
                //申请当量为 总当量-已结算当量 或 已审批当量-已结算当量 最小值
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
                BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
                if (approvedEqva.compareTo(usedEqva) > 0) {
                    //正常情况，不会存在审批通过当量大于已使用当量（审批中及审批通过当量和）
                    approvedEqva = usedEqva;
                }
                BigDecimal applySettleEqva = approvedEqva.subtract(settledEqva);


                if ((taskInfoVO.getTotalEqva().subtract(settledEqva)).compareTo(applySettleEqva) < 0) {
                    applySettleEqva = taskInfoVO.getTotalEqva().subtract(settledEqva);
                }
                if (applySettleEqva.compareTo(BigDecimal.ZERO) > 0) {
                    CalTaskSettleDetailPayload payloadDetail = new CalTaskSettleDetailPayload();
                    payloadDetail.setTaskId(taskInfoVO.getId());
                    payloadDetail.setApplySettleEqva(applySettleEqva);
                    detailPayloads.add(payloadDetail);
                }

            });
//            log.info("taskInfoVO::2");
            if (detailPayloads.size() > 0) {
                payload.setSettleDetailPayloads(detailPayloads);
//                log.info("taskInfoVO::3");
                String code = generateSeqNum("CAL_TASK_SETTLE");
                payload.setSettleNo(code);
//                log.info("taskInfoVO::4");
                //默认审批通过
                payload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
                //赋值数据
                initData(payload, taskPackageVO);
//                log.info("taskInfoVO::5");
                payloads.add(payload);
            }
        });
//        log.info("taskInfoVO::6");
        List<CalTaskSettleDetailPayload> detailPayloads = new ArrayList<>();

        if (payloads.size() > 0) {
            //批量操作结算单数据
            log.info("结算单数据：{}", JSON.toJSONString(payloads));
            List<CalTaskSettleDO> calTaskSettleDOS = CalTaskSettleConvert.INSTANCE.toDos(payloads);
            List<CalTaskSettleDO> calTaskSettleDOS1 = calTaskSettleDAO.saveAll(calTaskSettleDOS);

            payloads.forEach(payload -> {
                CalTaskSettleDO calTaskSettleDO = calTaskSettleDOS1.stream().filter(settleDO -> settleDO.getTaskId().equals(payload.getTaskId())).findFirst().get();
                payload.setId(calTaskSettleDO.getId());
                payload.getSettleDetailPayloads().forEach(act -> act.setSettleId(calTaskSettleDO.getId()));
                detailPayloads.addAll(payload.getSettleDetailPayloads());
            });
            //批量保存明细
            calTaskSettleDetailService.bacthInsert(detailPayloads);
            List<CalTaskSettleVO> calTaskSettleVOS = CalTaskSettleConvert.INSTANCE.toVos(payloads);
            //产生流水记录及更新任务结算数据及账户数据
            calResourceService.taskSettleTurnover(calTaskSettleVOS);
            //更新任务已结算当量数
            log.info("taskInfoVO::1" + detailPayloads.size());


        }
        log.info("任务自动结算执行完毕....");
        return detailPayloads;

    }

    /**
     * 保存工时任务结算单关系
     *
     * @param taskSettleIdMap
     */
    @Override
    public void saveTaskTaskSettleTimesheet(Map<Long, Long> taskSettleIdMap) {
        if (!taskSettleIdMap.isEmpty()) {
            //保存任务工时结算关系
            TaskSettleTimesheetQuery query = new TaskSettleTimesheetQuery();
            query.setTaskIds(new ArrayList<>(taskSettleIdMap.keySet()));
            query.setSettleFlag(0);
            List<TaskSettleTimesheetVO> taskSettleTimesheetVOS = taskSettleTimesheetService.queryListDynamic(query);

            List<TaskSettleTimesheetPayload> taskSettleTimesheetPayloadS = TaskSettleTimesheetConvert.INSTANCE.toPayloads(taskSettleTimesheetVOS);
            taskSettleTimesheetPayloadS.forEach(timesheetPayload -> {
                if (timesheetPayload.getSettleId() == null) {
                    timesheetPayload.setSettleId(taskSettleIdMap.get(timesheetPayload.getTaskId()));
                }
                timesheetPayload.setSettleFlag(1);
            });
            taskSettleTimesheetService.batchInsert(taskSettleTimesheetPayloadS);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reverseTaskSettle(String taskNo, BigDecimal eqvaNum, String message) {
        if (eqvaNum == null || eqvaNum.compareTo(BigDecimal.ZERO) >= 0) {
            throw TwException.error("", "反向结算数据不合规");
        }
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission) {
            throw TwException.error("", "无操作任务反向结算的权限！");
        }
        TaskInfoVO infoVO = taskInfoService.queryByTaskNo(taskNo);
        if (infoVO == null) {
            throw TwException.error("", "操作任务不存在");
        }
        if (infoVO.getSettledEqva() == null) {
            throw TwException.error("", "该任务未产生结算数据不可反向结算");
        }
        BigDecimal resEqva = infoVO.getSettledEqva().add(eqvaNum);
        if (resEqva.compareTo(BigDecimal.ZERO) < 0) {
            throw TwException.error("", "反向结算后任务结算当量为负，不合规");
        }
        TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
        taskPackageQuery.setId(infoVO.getTaskPackageId());
        List<TaskPackageVO> taskPackageVOS = taskPackageService.taskPackageList(taskPackageQuery);
        if (ObjectUtils.isEmpty(taskPackageVOS)) {
            throw TwException.error("", "关联任务包数据不存在");
        }
        TaskPackageVO taskPackageVO = taskPackageVOS.get(0);
        taskPackageVO.setTaskInfoVOS(Arrays.asList(infoVO));

        CalTaskSettlePayload payload = new CalTaskSettlePayload();
        payload.setTaskId(infoVO.getTaskPackageId());
        payload.setSettleDate(LocalDate.now());

        CalTaskSettleDetailPayload payloadDetail = new CalTaskSettleDetailPayload();
        payloadDetail.setTaskId(infoVO.getId());
        payloadDetail.setApplySettleEqva(eqvaNum);
        List<CalTaskSettleDetailPayload> detailPayloads = Arrays.asList(payloadDetail);
        payload.setSettleDetailPayloads(detailPayloads);
        String code = generateSeqNum("CAL_TASK_SETTLE");
        payload.setSettleNo(code);
        //默认审批通过
        payload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        String remark = "系统管理员反向结算，结算单异常红冲";
        if (StringUtils.hasText(message)) {
            remark = message;
        }
        payload.setRemark(remark);
        //赋值数据
        initData(payload, taskPackageVO);

        CalTaskSettleDO calTaskSettleDO = CalTaskSettleConvert.INSTANCE.toDo(payload);
        CalTaskSettleDO save = calTaskSettleDAO.save(calTaskSettleDO);
        payloadDetail.setSettleId(save.getId());
        //批量保存明细
        calTaskSettleDetailService.bacthInsert(detailPayloads);
        CalTaskSettleVO calTaskSettleVO = CalTaskSettleConvert.INSTANCE.toVo(save);
        //产生流水记录及更新任务结算数据及账户数据
        calResourceService.taskSettleTurnover(Arrays.asList(calTaskSettleVO));
        //更新任务已结算当量数
        taskInfoService.updateSettledEqva(payloadDetail.getTaskId(), payloadDetail.getApproveSettleEqva());
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalTaskSettleVO insertOrUpdate(CalTaskSettlePayload payload) {
        //数据校验
        TaskPackageVO taskPackageVO = checkData(payload);
        //初始化数据
        initData(payload, taskPackageVO);
        //校验账户余额
        String auType = taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) ? CalAccTypeEnum.PROJ.getCode() : taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode()) ? CalAccTypeEnum.OPP.getCode() : CalAccTypeEnum.BU_PROJ.getCode();
        CalAccountVO calAccountVO = calResourceService.queryAccount(auType, taskPackageVO.getReasonId());
        checkAccount(payload, calAccountVO);
        CalAccountVO calAccountVO1 = calResourceService.queryAccount(CalAccTypeEnum.RES.getCode(), taskPackageVO.getReceiverResId());


        //流程实例id
        String procInstId = null;
        if (payload.getId() == null) {
            String code = generateSeqNum("CAL_TASK_SETTLE");
            payload.setSettleNo(code);
        } else {
            CalTaskSettleVO calTaskSettleVO = calTaskSettleDAO.queryByKey(payload.getId());
            if (calTaskSettleVO == null) {
                throw TwException.error("", "编辑数据不存在");
            }
            if (!calTaskSettleVO.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode()) && !calTaskSettleVO.getSettleStatus().equals(CalSettleStatusEnum.REJECTED.getCode())) {
                throw TwException.error("", "不支持数据修改");
            }
            procInstId = calTaskSettleVO.getProcInstId();
            payload.setProcInstId(calTaskSettleVO.getProcInstId());
            payload.setCreateTime(calTaskSettleVO.getCreateTime());
        }
        payload.setSettleStatus(CalSettleStatusEnum.IN_PROCESS.getCode());
        payload.setApplyResId(GlobalUtil.getLoginUserId());
        CalTaskSettleDO entityDo = CalTaskSettleConvert.INSTANCE.toDo(payload);
        CalTaskSettleDO save = calTaskSettleRepo.save(entityDo);
        if (payload.getId() != null) {
            //删除历史详情
            calTaskSettleDetailService.deleteSoftBySettleId(List.of(payload.getId()));
        }
        payload.getSettleDetailPayloads().forEach(act -> act.setSettleId(save.getId()));
        calTaskSettleDetailService.bacthInsert(payload.getSettleDetailPayloads());
        if (procInstId == null) {
            //发起审批流程
            HashMap<String, Object> batchMap = new HashMap<>();
            //验收人确认
            batchMap.put("Activity_0joomyk", Lists.newArrayList(taskPackageVO.getAcceptorId()));
            String procName = "S01." + payload.getTaskName() + "-当量结算申请（"
                    + cacheUtil.getUserName(payload.getIncomeResId()) + "）";
            //新建审批流
            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    "CAL_TASK_SETTLE",
                    procName,
                    entityDo.getId() + "",
                    batchMap)
            );
            procInstId = processInfo.getProcInstId();
            String apprStatus = processInfo.getProcInstStatus().name();
            String settleStatus = CalSettleStatusEnum.IN_PROCESS.getCode();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                settleStatus = CalSettleStatusEnum.FINISH.getCode();
                procInstId = null;
            }
            CalTaskSettlePayload payload0 = new CalTaskSettlePayload();
            payload0.setId(entityDo.getId());
            payload0.setProcInstId(procInstId);
            payload0.setApprStatus(apprStatus);
            payload0.setSettleStatus(settleStatus);
            payload.setNullFields(List.of("procInstId"));
            //开启事务执行修改，主要是修改审批状态
            transactionUtilService.executeWithRunnable(() -> {
                calTaskSettleDAO.updateByKeyDynamic(payload0);
            });
        }
        return CalTaskSettleConvert.INSTANCE.toVo(entityDo);
    }

    /**
     * 数据核验
     *
     * @param payload 验收数据
     */
    TaskPackageVO checkData(CalTaskSettlePayload payload) {
        /**
         * 校验：
         * 1.任务数据是否存在
         * 2.接收人是否是申请人
         * 3.是否有结算价和资源收入价格
         * 1.明细任务是否存在
         * 2.明细状态，暂挂和关闭
         * 3.实际可结算当量和申请当量判断
         *

         */
        if (payload.getTaskId() == null) {
            throw TwException.error("", "任务包数据不可为空");
        }
        if (payload.getSettleDate() == null) {
            throw TwException.error("", "结算期间不可为空");
        }
        if (ObjectUtils.isEmpty(payload.getSettleDetailPayloads())) {
            throw TwException.error("", "结算明细不可为空");
        }
        //本次申请结算的任务ids
        List<Long> taskIds = payload.getSettleDetailPayloads().stream().map(CalTaskSettleDetailPayload::getTaskId).distinct().collect(Collectors.toList());
        if (taskIds.size() != payload.getSettleDetailPayloads().size()) {
            throw TwException.error("", "结算明细任务id不可为空");
        }

        List<CalTaskSettleDetailPayload> collect = payload.getSettleDetailPayloads().stream().filter(payloadDetail -> payloadDetail.getApplySettleEqva() == null || payloadDetail.getApplySettleEqva().compareTo(BigDecimal.ZERO) <= 0).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(collect)) {
            throw TwException.error("", "申请结算当量不合规");
        }
        CalTaskSettleQuery query = new CalTaskSettleQuery();
        query.setTaskId(payload.getTaskId());
        query.setSettleStatus(CalSettleStatusEnum.IN_PROCESS.getCode());
        List<CalTaskSettleVO> calTaskSettleVOS = calTaskSettleDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(calTaskSettleVOS)) {
            CalTaskSettleVO calTaskSettleVO = calTaskSettleVOS.get(0);
            //有结算中的任务包，则要判断是否结算中的任务
            CalTaskSettleDetailQuery queryDetail = new CalTaskSettleDetailQuery();
            queryDetail.setSettleId(calTaskSettleVO.getId());
            List<CalTaskSettleDetailVO> calTaskSettleDetailVOS = calTaskSettleDetailService.queryListDynamic(queryDetail);
            calTaskSettleDetailVOS.forEach(detailVO -> {
                if (taskIds.contains(detailVO.getTaskId())) {
                    throw TwException.error("", "结算明细任务【" + detailVO.getTaskName() + "】处于结算中，结算单号【" + calTaskSettleVO.getSettleNo() + "】,不可再次发起申请");
                }
            });
        }
        TaskPackageVO taskPackageVO = taskPackageService.queryByKey(payload.getTaskId(), true);
        log.info("任务包数据：{}" + taskPackageVO.toString());
        //1.任务数据是否存在
        if (taskPackageVO == null) {
            throw TwException.error("", "结算任务包不存在");
        }
        if (!taskPackageVO.getPricingMethod().equals(PricingMethodEnum.TOTAL.getCode())) {
            throw TwException.error("", "仅支持总价结算");
        }
        //2.接收人是否是申请人
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (taskPackageVO.getReceiverResId() == null || !taskPackageVO.getReceiverResId().equals(loginUserId)) {
            throw TwException.error("", "任务包接收人可发起结算申请");
        }
        if (taskPackageVO.getDisterResId() == null) {
            throw TwException.error("", "任务包发包人不可为空");
        }
        List<TaskInfoVO> taskInfoVOS = taskPackageVO.getTaskInfoVOS();
        //本次申请结算的任务
        List<TaskInfoVO> settleTaskVOS = taskInfoVOS.stream().filter(vo -> taskIds.contains(vo.getId())).collect(Collectors.toList());
        if (settleTaskVOS.size() != taskIds.size()) {
            throw TwException.error("", "结算明细任务存在非该任务包下数据");
        }
        return taskPackageVO;
    }

    /**
     * 数据初始化
     *
     * @param payload       验收数据
     * @param taskPackageVO 任务包数据
     */
    void initData(CalTaskSettlePayload payload, TaskPackageVO taskPackageVO) {
        //3.是否有结算价和资源收入价格
        if (taskPackageVO.getIncomePrice() == null || taskPackageVO.getSettlePrice() == null) {
            throw TwException.error("", "任务包结算价或收入价不可为空");
        }
        //3.是否有接收资源和接收资源bu
        if (taskPackageVO.getReceiverBuId() == null || taskPackageVO.getReceiverResId() == null) {
            throw TwException.error("", "任务包接收资源或接收资源BU不可为空");
        }
        //4.校验任务包事由类型和事由id
        if (!StringUtils.hasText(taskPackageVO.getReasonType()) || taskPackageVO.getReasonId() == null) {
            throw TwException.error("", "任务包事由类型和事由id不可为空");
        }
        //5.校验任务包质保比例
        if (taskPackageVO.getGuaranteeRate() != null) {
            if (taskPackageVO.getGuaranteeRate().compareTo(BigDecimal.ZERO) < 0 || taskPackageVO.getGuaranteeRate().compareTo(BigDecimal.ONE) >= 0) {
                throw TwException.error("", "质保比例范围为【0-100】");
            }
        }
        //赋值:收入资源，收入组织,发包人，项目id、名称，结算单价，收入单价，质保比例,任务状态，预计起止时间
        payload.setSettlePrice(taskPackageVO.getSettlePrice());
        payload.setEqvaSalary(taskPackageVO.getIncomePrice());
        payload.setIncomeResId(taskPackageVO.getReceiverResId());
        payload.setResBuId(taskPackageVO.getReceiverBuId());
        payload.setDisterResId(taskPackageVO.getDisterResId());
        payload.setReasonType(taskPackageVO.getReasonType());
        payload.setProjId(taskPackageVO.getReasonId());
        payload.setProjName(taskPackageVO.getReasonName());
        payload.setGuaranteeRate(taskPackageVO.getGuaranteeRate());
        payload.setTaskName(taskPackageVO.getTaskPackageName());
        payload.setOperateFlag(0);

        String settleType = taskPackageVO.getPricingMethod().equals(PricingMethodEnum.TOTAL.getCode()) ? CalTaskSettleTypeEnum.TOTAL_PRICE.getCode() : CalTaskSettleTypeEnum.UNIT_PRICE.getCode();
        payload.setSettleType(settleType);
        //申请结算当量
        BigDecimal applySettleEqva = BigDecimal.ZERO;
        for (CalTaskSettleDetailPayload detail : payload.getSettleDetailPayloads()) {
            Optional<TaskInfoVO> first = taskPackageVO.getTaskInfoVOS().stream().filter(vo -> vo.getId().equals(detail.getTaskId())).findFirst();
            //1.明细任务是否存在
            if (!first.isPresent()) {
                throw TwException.error("", "结算明细任务不存在");
            }
            //2.明细状态，暂挂和关闭
            TaskInfoVO taskInfoVO = first.get();
            //   List<String> statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
            if (!StringUtils.hasText(taskInfoVO.getSourceType()) || !taskInfoVO.getSourceType().equals(TaskSourceTypeEnum.REWARD.getCode())) {
                //不等于奖励假结算
                if (!taskInfoService.getEffectiveTaskStatus().contains(taskInfoVO.getTaskStatus())) {
                    throw TwException.error("", taskInfoVO.getTaskName() + "-不可发起结算");
                }
            }

            detail.setDistedEqva(taskInfoVO.getTotalEqva());
            detail.setSettledEqva(taskInfoVO.getSettledEqva());
            detail.setTaskStatus(taskInfoVO.getTaskStatus());
            detail.setTaskName(taskInfoVO.getTaskName());
            detail.setProjId(payload.getProjId());
            detail.setPlanStartDate(taskInfoVO.getPlanStartDate());
            detail.setPlanEndDate(taskInfoVO.getPlanEndDate());
            detail.setSsCompPercent(taskInfoVO.getTaskProgress());
            // 3.实际可结算当量和申请当量判断
            BigDecimal subtract = detail.getDistedEqva().subtract(detail.getSettledEqva() == null ? BigDecimal.ZERO : detail.getSettledEqva());
//            if (detail.getApplySettleEqva() == null || detail.getApplySettleEqva().compareTo(BigDecimal.ZERO) <= 0 || detail.getApplySettleEqva().compareTo(subtract) > 0) {
//                throw TwException.error("", "结算明细-申请结算当量[0, " + subtract + "]");
//            }
            if (detail.getApplySettleEqva() == null || subtract.subtract(detail.getApplySettleEqva()).compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "结算明细-申请结算当量[0, " + subtract + "]");
            }
            //初始化赋值
            applySettleEqva = applySettleEqva.add(detail.getApplySettleEqva());
            //申请结算金额
            detail.setApplySettleAmt(detail.getApplySettleEqva().multiply(payload.getSettlePrice()));
            //赋值明细实际当量
            detail.setApproveSettleEqva(detail.getApplySettleEqva());
            //赋值明细实际金额
            detail.setApproveSettleAmt(detail.getApproveSettleEqva().multiply(payload.getSettlePrice()));
        }
        //申请结算总额=申请结算当量*结算单价
        BigDecimal applySettleAmt = applySettleEqva.multiply(payload.getSettlePrice());
        //申请收入总额=申请结算当量*收入单价
        BigDecimal applyIncomeAmt = applySettleEqva.multiply(payload.getEqvaSalary());
        //冻结当量=实际结算当量数*质保比例
        BigDecimal graranteeEqva = applySettleEqva.multiply(payload.getGuaranteeRate());
        //冻结金额=冻结当量*收入单价
        BigDecimal graranteeAmt = graranteeEqva.multiply(payload.getEqvaSalary());
        payload.setApplySettleEqva(applySettleEqva);
        payload.setApplySettleAmt(applySettleAmt);
        payload.setApplyIncomeAmt(applyIncomeAmt);
        //初始化实际值等于申请值
        payload.setApproveSettleEqva(applySettleEqva);
        payload.setApproveSettleAmt(applySettleAmt);
        payload.setApproveIncomeAmt(applyIncomeAmt);

        payload.setGraranteeEqva(graranteeEqva);
        payload.setGraranteeAmt(graranteeAmt);
        //可用当量=实际结算当量数-冻结当量数
        payload.setAvalQty(applySettleEqva.subtract(graranteeEqva));
        log.info("初始化后的结算申请payload：{}", payload.toString());
    }

    /**
     * 账户校验
     *
     * @param payload
     * @param calAccountVO
     */
    void checkAccount(CalTaskSettlePayload payload, CalAccountVO calAccountVO) {
        //可用当量
        BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
        //可用金额
        BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
        calAccountVO.setAvalQty(avalQty.subtract(payload.getApplySettleEqva()));
        calAccountVO.setAvalAmt(avalAmt.subtract(payload.getApplySettleAmt()));
        calResourceService.checkAccount(calAccountVO);
    }

    @Override
    public PagingVO<CalTaskSettleVO> queryPaging(CalTaskSettleQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        //判断查询类型
        if (query.getSearchType() != null && query.getSearchType() == 1) {
            //提现查询
            query.setIncomeResId(loginUserId);
            query.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        }

        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(CalTaskSettleVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<CalTaskSettleVO> calTaskSettleVOS = beanSearcher.searchList(CalTaskSettleVO.class, mapBuilder.build());
        calTaskSettleVOS.forEach(vo -> vo.setAvalAmt(vo.getAvalQty().multiply(vo.getEqvaSalary())));
        return PagingVO.<CalTaskSettleVO>builder().records(calTaskSettleVOS).total(total).build();
//        return calTaskSettleDAO.queryPaging(query);
    }

    private MapBuilder pageWhereBuilder(CalTaskSettleQuery query) {
        MapBuilder builder = MapUtils.builder();
        /** 项目名称/编号 关键字查询 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            builder.field(CalTaskSettleVO::getId, query.getId()).op(FieldOps.Equal);
        }

        /** 结算单号 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleNo())) {
            builder.field(CalTaskSettleVO::getSettleNo, query.getSettleNo()).op(FieldOps.Equal);
        }
        /** 结算状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStatus())) {
            builder.field(CalTaskSettleVO::getSettleStatus, query.getSettleStatus()).op(FieldOps.Equal);
        }
        /** 结算状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStatusList())) {
            builder.field(CalTaskSettleVO::getSettleStatus, query.getSettleStatusList()).op(FieldOps.InList);

        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            builder.field(CalTaskSettleVO::getApprStatus, query.getApprStatus()).op(FieldOps.Equal);
        }
        /** 流程实例id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            builder.field(CalTaskSettleVO::getProcInstId, query.getProcInstId()).op(FieldOps.Equal);
        }
        /** 结算类型（任务包总价结算，任务包单价结算） 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleType())) {
            builder.field(CalTaskSettleVO::getSettleType, query.getSettleType()).op(FieldOps.Equal);
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleDate())) {
            builder.field(CalTaskSettleVO::getSettleDate, query.getSettleDate()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getSettleStartDate()) && !ObjectUtils.isEmpty(query.getSettleEndDate())) {
            builder.field(CalTaskSettleVO::getSettleDate).sql(" $1 >= ? and $1 <= ?", query.getSettleStartDate(), query.getSettleEndDate());
        } else {
            /** 结算日期 精确 */
            if (!ObjectUtils.isEmpty(query.getSettleStartDate())) {
                builder.field(CalTaskSettleVO::getSettleDate, query.getSettleStartDate()).op(FieldOps.GreaterEqual);
            }
            /** 结算日期 精确 */
            if (!ObjectUtils.isEmpty(query.getSettleEndDate())) {
                builder.field(CalTaskSettleVO::getSettleDate, query.getSettleEndDate()).op(FieldOps.LessEqual);
            }
        }


        /** 财务期间id 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodId())) {
            builder.field(CalTaskSettleVO::getFinPeriodId, query.getFinPeriodId()).op(FieldOps.Equal);
        }
        /** 验收方式 精确 */
        if (!ObjectUtils.isEmpty(query.getAcceptMethod())) {
            builder.field(CalTaskSettleVO::getAcceptMethod, query.getAcceptMethod()).op(FieldOps.Equal);
        }
        /** 项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            builder.field(CalTaskSettleVO::getProjId, query.getProjId()).op(FieldOps.Equal);
        }
        /** 任务包id 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskId())) {
            builder.field(CalTaskSettleVO::getTaskId, query.getTaskId()).op(FieldOps.Equal);
        }
        /** 支出bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            builder.field(CalTaskSettleVO::getExpenseBuId, query.getExpenseBuId()).op(FieldOps.Equal);
        }
        /** 收入资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getIncomeResId())) {
            builder.field(CalTaskSettleVO::getIncomeResId, query.getIncomeResId()).op(FieldOps.Equal);
        }
        /** 收入bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getResBuId())) {
            builder.field(CalTaskSettleVO::getResBuId, query.getResBuId()).op(FieldOps.Equal);
        }
        /** 当量系数 精确 */
        if (!ObjectUtils.isEmpty(query.getEqvaRatio())) {
            builder.field(CalTaskSettleVO::getEqvaRatio, query.getEqvaRatio()).op(FieldOps.Equal);
        }
        /** 当量工资(收入单价) 精确 */
        if (!ObjectUtils.isEmpty(query.getEqvaSalary())) {
            builder.field(CalTaskSettleVO::getEqvaSalary, query.getEqvaSalary()).op(FieldOps.Equal);
        }
        /** 申请结算当量数 精确 */
        if (!ObjectUtils.isEmpty(query.getApplySettleEqva())) {
            builder.field(CalTaskSettleVO::getApplySettleEqva, query.getApplySettleEqva()).op(FieldOps.Equal);
        }
        /** 申请结算总额 精确 */
        if (!ObjectUtils.isEmpty(query.getApplySettleAmt())) {
            builder.field(CalTaskSettleVO::getApplySettleAmt, query.getApplySettleAmt()).op(FieldOps.Equal);
        }
        /** 结算单价 精确 */
        if (!ObjectUtils.isEmpty(query.getSettlePrice())) {
            builder.field(CalTaskSettleVO::getSettlePrice, query.getSettlePrice()).op(FieldOps.Equal);
        }
        /** 实际结算当量数 精确 */
        if (!ObjectUtils.isEmpty(query.getApproveSettleEqva())) {
            builder.field(CalTaskSettleVO::getApproveSettleEqva, query.getApproveSettleEqva()).op(FieldOps.Equal);
        }
        /** 实际结算总额 精确 */
        if (!ObjectUtils.isEmpty(query.getApproveSettleAmt())) {
            builder.field(CalTaskSettleVO::getApproveSettleAmt, query.getApproveSettleAmt()).op(FieldOps.Equal);
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            builder.field(CalTaskSettleVO::getCurrCode, query.getCurrCode()).op(FieldOps.Equal);
        }
        /** 质保金比例 精确 */
        if (!ObjectUtils.isEmpty(query.getGuaranteeRate())) {
            builder.field(CalTaskSettleVO::getGuaranteeRate, query.getGuaranteeRate()).op(FieldOps.Equal);
        }
        /** 质保当量 精确 */
        if (!ObjectUtils.isEmpty(query.getGraranteeEqva())) {
            builder.field(CalTaskSettleVO::getGraranteeEqva, query.getGraranteeEqva()).op(FieldOps.Equal);
        }
        /** 申请人资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            builder.field(CalTaskSettleVO::getApplyResId, query.getApplyResId()).op(FieldOps.Equal);
        }
        /** 评价状态 精确 */
        if (!ObjectUtils.isEmpty(query.getEvalStatus())) {
            builder.field(CalTaskSettleVO::getEvalStatus, query.getEvalStatus()).op(FieldOps.Equal);
        }
        /** 累计提现当量 精确 */
        if (!ObjectUtils.isEmpty(query.getWithdrawEqva())) {
            builder.field(CalTaskSettleVO::getWithdrawEqva, query.getWithdrawEqva()).op(FieldOps.Equal);
        }
        /** bu累计提现当量 精确 */
        if (!ObjectUtils.isEmpty(query.getBuWithdrawEqva())) {
            builder.field(CalTaskSettleVO::getBuWithdrawEqva, query.getBuWithdrawEqva()).op(FieldOps.Equal);
        }
        if (query.getSearchType() != null && query.getSearchType() == 1) {
            //可提现当量大于某个值
            builder.field(CalTaskSettleVO::getAvalQty, BigDecimal.ZERO).op(FieldOps.GreaterThan);
            builder.field(CalTaskSettleVO::getOperateFlag, 0).op(FieldOps.Equal);
        }
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);

        return builder;
    }

    @Override
    public List<CalTaskSettleVO> queryListDynamic(CalTaskSettleQuery query) {
        List<CalTaskSettleVO> calTaskSettleVOS = calTaskSettleDAO.queryListDynamic(query);
        calTaskSettleVOS.forEach(vo -> {
            if (vo.getAvalQty() == null || vo.getEqvaSalary() == null) {
                vo.setAvalAmt(BigDecimal.ZERO);
            } else {
                vo.setAvalAmt(vo.getAvalQty().multiply(vo.getEqvaSalary()));
            }

        });
        return calTaskSettleVOS;
    }

    @Override
    public CalTaskSettleVO queryByKey(Long key) {
        CalTaskSettleVO calTaskSettleVO = calTaskSettleDAO.queryByKey(key);
        calTaskSettleVO.setFileDatas(fileUtil.getFileDatas(calTaskSettleVO.getFileCodes()));
        CalTaskSettleDetailQuery query = new CalTaskSettleDetailQuery();
        query.setSettleId(calTaskSettleVO.getId());
        List<CalTaskSettleDetailVO> calTaskSettleDetailVOS = calTaskSettleDetailService.queryListDynamic(query);

        calTaskSettleVO.setSettleDetailVOs(calTaskSettleDetailVOS);
        calTaskSettleVO.setAvalAmt(calTaskSettleVO.getAvalQty().multiply(calTaskSettleVO.getEqvaSalary()));
        return calTaskSettleVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateFlow(CalTaskSettlePayload payload) {

        if (payload.getId() == null) {
            throw TwException.error("", "编辑数据不存在");
        }
        if (ObjectUtils.isEmpty(payload.getSettleDetailPayloads())) {
            throw TwException.error("", "结算明细不可为空");
        }
        CalTaskSettleVO calTaskSettleVO = queryByKey(payload.getId());
        if (calTaskSettleVO == null) {
            throw TwException.error("", "编辑数据不存在");
        }
        if (!calTaskSettleVO.getSettleStatus().equals(CalSettleStatusEnum.IN_PROCESS.getCode())) {
            throw TwException.error("", "不支持的状态修改");
        }
        List<CalTaskSettleDetailVO> settleDetailVOs = calTaskSettleVO.getSettleDetailVOs();

        //实际结算当量数
        BigDecimal approveSettleEqva = BigDecimal.ZERO;
        List<CalTaskSettleDetailPayload> detailPayloads = new ArrayList<>();
        for (CalTaskSettleDetailPayload detail : payload.getSettleDetailPayloads()) {
            Optional<CalTaskSettleDetailVO> first = settleDetailVOs.stream().filter(vo -> vo.getId().equals(detail.getId())).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "变更结算明细不存在");
            }
            CalTaskSettleDetailVO calTaskSettleDetailVO = first.get();
            if (detail.getApproveSettleEqva().compareTo(calTaskSettleDetailVO.getApplySettleEqva()) > 0) {
                throw TwException.error("", "批准结算当量不可大于申请结算当量");
            }
            approveSettleEqva = approveSettleEqva.add(detail.getApproveSettleEqva());
            //赋值明细实际金额
            if (!detail.getApproveSettleEqva().equals(calTaskSettleDetailVO.getApplySettleEqva())) {
                //批准当量不等申请当量
                CalTaskSettleDetailPayload detailPayload = new CalTaskSettleDetailPayload();
                detailPayload.setId(detail.getId());
                detailPayload.setApproveSettleEqva(detail.getApproveSettleEqva());
                detailPayload.setApproveSettleAmt(detail.getApproveSettleEqva().multiply(calTaskSettleVO.getSettlePrice()));
                detailPayloads.add(detailPayload);
            }
        }
        //实际结算总额=实际结算当量*结算单价
        BigDecimal approveSettleAmt = approveSettleEqva.multiply(calTaskSettleVO.getSettlePrice());
        //实际收入总额=实际结算当量*收入单价
        BigDecimal approveIncomeAmt = approveSettleEqva.multiply(calTaskSettleVO.getEqvaSalary());
        //冻结当量=实际结算当量数*质保比例
        BigDecimal graranteeEqva = approveSettleEqva.multiply(calTaskSettleVO.getGuaranteeRate());
        //冻结金额=冻结当量*收入单价
        BigDecimal graranteeAmt = graranteeEqva.multiply(calTaskSettleVO.getEqvaSalary());

        CalTaskSettlePayload payload0 = new CalTaskSettlePayload();
        payload0.setId(payload.getId());
        payload0.setApproveSettleEqva(approveSettleEqva);
        payload0.setApproveSettleAmt(approveSettleAmt);
        payload0.setApproveIncomeAmt(approveIncomeAmt);
        payload0.setGraranteeEqva(graranteeEqva);
        payload0.setGraranteeAmt(graranteeAmt);
        //可用当量=实际结算当量数-冻结当量数
        payload0.setAvalQty(approveSettleEqva.subtract(graranteeEqva));
        payload0.setRemark(payload.getRemark());
        //主数据修改操作
        updateByKeyDynamic(payload0);
        //明细数据修改操作
        if (detailPayloads.size() > 0) {
            //开启事务执行修改明细
            transactionUtilService.executeWithRunnable(() -> {
                detailPayloads.forEach(detail -> {
                    calTaskSettleDetailService.updateByKeyDynamic(detail);
                });
            });
        }
        return 0L;
    }

    @Override
    public long updateByKeyDynamic(CalTaskSettlePayload payload) {
        long result = calTaskSettleDAO.updateByKeyDynamic(payload);
        return result;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<CalTaskSettleVO> calTaskSettleVOs = calTaskSettleDAO.queryByKeys(keys);
            if (calTaskSettleVOs.size() > 0) {
                List<CalTaskSettleVO> collect = calTaskSettleVOs.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode()) && !vo.getSettleStatus().equals(CalSettleStatusEnum.REJECTED.getCode())).collect(Collectors.toList());
                if (collect.size() > 0) {
                    throw TwException.error("", "仅支持新建或结算未通过状态删除");
                }
            }
            calTaskSettleDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        CalTaskSettleVO calTaskSettleVO = calTaskSettleDAO.queryByKey(Long.valueOf(businessKey));
        if (calTaskSettleVO != null) {
            CalTaskSettlePayload taskSettlePayload = new CalTaskSettlePayload();
            taskSettlePayload.setId(Long.parseLong(businessKey));
            taskSettlePayload.setApprStatus(procInstStatus.name());
            int rejectType = 0;
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    taskSettlePayload.setProcInstId(null);
                    taskSettlePayload.setNullFields(List.of("procInstId"));
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    taskSettlePayload.setDeleteFlag(1);
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.REJECTED.getCode());
                    break;
                case APPROVED:
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
                    break;
                case APPROVING:
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.IN_PROCESS.getCode());
                    break;
            }
            updateByKeyDynamic(taskSettlePayload);
            //审批通过产生流水记录及更新任务结算数据
            if (taskSettlePayload.getSettleStatus().equals(CalSettleStatusEnum.FINISH.getCode())) {
//                transactionUtilService.executeWithRunnable(() -> {
                calResourceService.taskSettleTurnover(Arrays.asList(calTaskSettleVO));
//                });
                // 更新任务结算数据
                updateTaskSettleEqva(calTaskSettleVO.getId());

            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSettleDate(List<Long> keys, LocalDate settleDate) {
        if (keys.isEmpty()) {
            throw TwException.error("", "变更主键不可为空");
        }
        if (settleDate == null) {
            throw TwException.error("", "变更期间不可为空");
        }
        List<CalTaskSettleVO> calTaskSettleVOs = calTaskSettleDAO.queryByKeys(keys);
        if (ObjectUtils.isEmpty(calTaskSettleVOs)) {
            throw TwException.error("", "变更数据不存在");
        }
        List<CalTaskSettleVO> collect = calTaskSettleVOs.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode()) && !vo.getSettleStatus().equals(CalSettleStatusEnum.REJECTED.getCode())).collect(Collectors.toList());
        if (collect.size() > 0) {
            throw TwException.error("", "仅支持新建或结算未通过状态变更");
        }
        calTaskSettleDAO.updateSettleDate(keys, settleDate);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskSettleWithdraw(CalTaskSettleWithdrawPayload payload) {
        //校验提现单数据
        List<CalTaskSettleVO> calTaskSettleVOs = checkWithdraw(payload);
//        //开启新的事务
//        transactionUtilService.begin();
//        try {
        if (payload.getWithdrawStatus().equals("1")) {
            //发起提现
            calTaskSettleDAO.updateSettleOperate(payload.getSettleIds(), 2);
        }
        if (payload.getWithdrawStatus().equals("2")) {
            //审批通过
            /**
             * 1.修改原字段 ：提现或解冻标识，已提现当量，可用当量
             * 2.创建资源提现流水记录
             */

            calTaskSettleVOs.forEach(vo -> {
//                BigDecimal bigDecimal1 = payload.getWithdrawAmt() == null ? BigDecimal.ZERO : payload.getWithdrawAmt();
//                payload.setWithdrawAmt(bigDecimal1.add(vo.getAvalQty()));
                //1.修改原字段 ：提现或解冻标识，已提现当量，可用当量
                BigDecimal bigDecimal = vo.getWithdrawEqva() == null ? BigDecimal.ZERO : vo.getWithdrawEqva();
                //累计提现当量=历史累计提现当量+可用当量
                BigDecimal withdrawEqva = bigDecimal.add(vo.getAvalQty());
                CalTaskSettlePayload taskSettlePayload = new CalTaskSettlePayload();
                taskSettlePayload.setId(vo.getId());
                taskSettlePayload.setOperateFlag(0);
                taskSettlePayload.setWithdrawEqva(withdrawEqva);
                taskSettlePayload.setAvalQty(BigDecimal.ZERO);
                updateByKeyDynamic(taskSettlePayload);
            });
            //创建资源流水记录
            calResourceService.taskSettleWithdrawTurnover(payload);
        }
//        } catch (Exception e) {
//            transactionUtilService.rollback();
//        }
//
//        transactionUtilService.commit();

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unFreezeTaskSettleApply(List<Long> keys) {
        List<CalTaskSettleVO> calTaskSettleVOs = calTaskSettleDAO.queryByKeys(keys);
        if (calTaskSettleVOs.size() != keys.size()) {
            throw TwException.error("", "解冻数据匹配异常");
        }
        /**
         * 1.先修改结算单值：提现或解冻标识，冻结当量,冻结金额，可用当量
         * 2.生成冻结记录
         * 3.修改账户信息
         */
        calTaskSettleVOs.forEach(vo -> {
            //1.先修改结算单值：提现或解冻标识，冻结当量,冻结金额，可用当量
            BigDecimal graranteeEqva = vo.getGraranteeEqva() == null ? BigDecimal.ZERO : vo.getGraranteeEqva();
            //可用当量=历史可用当量+解冻当量
            BigDecimal avalQty = graranteeEqva.add(vo.getAvalQty());
            CalTaskSettlePayload taskSettlePayload = new CalTaskSettlePayload();
            taskSettlePayload.setId(vo.getId());
            taskSettlePayload.setOperateFlag(0);
            taskSettlePayload.setGraranteeEqva(BigDecimal.ZERO);
            taskSettlePayload.setGraranteeAmt(BigDecimal.ZERO);
            taskSettlePayload.setAvalQty(avalQty);
            updateByKeyDynamic(taskSettlePayload);
        });
        //生成冻结记录,修改账户信息
        calResourceService.unFreezeTaskSettle(calTaskSettleVOs);
    }


    /**
     * 校验提现单数据
     *
     * @param payload
     * @return
     */
    List<CalTaskSettleVO> checkWithdraw(CalTaskSettleWithdrawPayload payload) {

        if (ObjectUtils.isEmpty(payload.getSettleIds())) {
            throw TwException.error("", "提现单据ids不可为空");
        }
        if (payload.getWithdrawResId() == null) {
            throw TwException.error("", "提现资源id不可为空");
        }
        List<CalTaskSettleVO> calTaskSettleVOs = calTaskSettleDAO.queryByKeys(payload.getSettleIds());
        if (calTaskSettleVOs.size() != payload.getSettleIds().size()) {
            throw TwException.error("", "提现单据数据匹配异常");
        }
        if (payload.getWithdrawQty() == null) {
            throw TwException.error("", "提现当量数据不可为空");
        }
//        if (payload.getWithdrawAmt() == null || payload.getWithdrawAmt().compareTo(BigDecimal.ZERO) <= 0) {
        if (payload.getWithdrawAmt() == null) {
            throw TwException.error("", "提现金额数据不可为空");
        }
        BigDecimal avalQty = BigDecimal.ZERO;
        //  BigDecimal avalAmt = BigDecimal.ZERO;
        //1:月结，收入价格为0,2：人天结算
        int settleType = 0;
        Long projectId = null;
        for (CalTaskSettleVO vo : calTaskSettleVOs) {
            if (vo.getAvalQty() == null || vo.getAvalQty().compareTo(BigDecimal.ZERO) <= 0) {
                throw TwException.error("", "可提现当量校验不通过");
            }
            if (vo.getIncomeResId() != null && !vo.getIncomeResId().equals(payload.getWithdrawResId())) {
                throw TwException.error("", "提现资源与结算单收入资源不匹配");
            }
            //4.0同步的结算单数据发现有的数据没有收益人
            vo.setIncomeResId(payload.getWithdrawResId());
            if (vo.getEqvaSalary() == null || vo.getEqvaSalary().compareTo(BigDecimal.ZERO) <= 0) {
                if (settleType == 0 || settleType == 1) {
                    settleType = 1;
                    if (projectId == null) {
                        projectId = vo.getProjId();
                    } else {
                        if (projectId.longValue() != vo.getProjId().longValue()) {
                            throw TwException.error("", "月结提现单据结算单必须是同项目下");
                        }
                    }
                } else {
                    throw TwException.error("", "结算单结算方式类型不匹配");
                }
            } else {
                if (settleType == 0 || settleType == 2) {
                    settleType = 2;
                } else {
                    throw TwException.error("", "结算单结算方式类型不匹配");
                }
            }
            avalQty = avalQty.add(vo.getAvalQty());
            //avalAmt = avalAmt.add(vo.getAvalQty().multiply(vo.getEqvaSalary()));
        }
        //因为保留小数位问题可能提现金额和可提现金额不能幂等
//        if (avalQty.compareTo(payload.getWithdrawQty()) != 0) {
//            throw TwException.error("", "提现当量校验不通过");
//        }
        if (settleType == 1) {
//            transactionUtilService.begin();
//            try {
            //月结，要重新赋值金额
            CalTaskSettleVO calTaskSettleVO = calTaskSettleVOs.get(0);
            CalTaskSettleVO newVo = new CalTaskSettleVO();
            newVo.copy(calTaskSettleVO);
            newVo.setApproveSettleEqva(BigDecimal.ZERO);
            newVo.setApproveSettleAmt(BigDecimal.ZERO);
            newVo.setGraranteeEqva(BigDecimal.ZERO);
            newVo.setApproveIncomeAmt(payload.getWithdrawAmt());
            calResourceService.taskSettleTurnover(Arrays.asList(newVo));

//            } catch (Exception e) {
//                transactionUtilService.rollback();
//                throw TwException.error("", "反向添加流水异常");
//            }
//            transactionUtilService.commit();
        }

//        if (avalAmt.compareTo(payload.getWithdrawAmt()) != 0) {
//            throw TwException.error("", "提现金额校验不通过");
//        }
        //  payload.setWithdrawAmt(avalAmt);
//        calTaskSettleVOs.forEach(vo -> {
//            if (vo.getAvalQty() == null || vo.getAvalQty().compareTo(BigDecimal.ZERO) <= 0) {
//                throw TwException.error("", "可提现当量校验不通过");
//            }
//            if (!vo.getIncomeResId().equals(payload.getWithdrawResId())) {
//                throw TwException.error("", "提现资源与结算单收入资源不匹配");
//            }
//        });

        return calTaskSettleVOs;
    }

    /**
     * 更新任务结算当量
     *
     * @param settleId
     */
    void updateTaskSettleEqva(Long settleId) {
        CalTaskSettleDetailQuery query = new CalTaskSettleDetailQuery();
        query.setSettleId(settleId);
        List<CalTaskSettleDetailVO> calTaskSettleDetailVOS = calTaskSettleDetailService.queryListDynamic(query);
        calTaskSettleDetailVOS.forEach(vo -> {
            taskInfoService.updateSettledEqva(vo.getTaskId(), vo.getApproveSettleEqva());
        });
    }
}
