package com.elitesland.tw.tw5.server.prd.copartner.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigUserDO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.QPerformanceReadmeConfigDO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.QPerformanceReadmeConfigUserDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigUserRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@Repository
@RequiredArgsConstructor
public class PerformanceReadmeConfigUserDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PerformanceReadmeConfigUserRepo repo;
    private final QPerformanceReadmeConfigUserDO qdo = QPerformanceReadmeConfigUserDO.performanceReadmeConfigUserDO;
    private final QPerformanceReadmeConfigDO qdoConfig = QPerformanceReadmeConfigDO.performanceReadmeConfigDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeConfigUserVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PerformanceReadmeConfigUserVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 配置主键
                qdo.configId,
                // 汇报人员工主键
                qdo.userId,
                //汇报人组织
                qdo.buId,
                //汇报周期
                qdoConfig.configCycle,
                qdoConfig.startDate,
                qdoConfig.endDate,
                //发起人
                qdoConfig.applyUserId,
                // 状态
                qdo.applyStatus,
                // 名称
                qdo.configUserName,
                // 审批名称
                qdo.procInstName,
                // 审批状态
                qdo.procInstStatus,
                // 流程id
                qdo.procInstId
        )).from(qdo).leftJoin(qdoConfig).on(qdoConfig.id.eq(qdo.configId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeConfigUserVO> getJpaQueryWhere(PerformanceReadmeConfigUserQuery query) {
        JPAQuery<PerformanceReadmeConfigUserVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PerformanceReadmeConfigUserQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PerformanceReadmeConfigUserQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 配置主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 员工主键 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getConfigUserName())) {
            list.add(qdo.configUserName.like(SqlUtil.toSqlLikeString(query.getConfigUserName())));
        }
        /** 审批名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getProcInstName())) {
            list.add(qdo.procInstName.like(SqlUtil.toSqlLikeString(query.getProcInstName())));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 流程id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** buId 精确 */
        if (!ObjectUtils.isEmpty(query.getBuId())) {
            list.add(qdo.buId.eq(query.getBuId()));
        }
        /** 考核周期 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigCycle())) {
            list.add(qdoConfig.configCycle.eq(query.getConfigCycle()));
        }
        /** 发起人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            list.add(qdoConfig.applyUserId.eq(query.getApplyUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PerformanceReadmeConfigUserVO queryByKey(Long id) {
        JPAQuery<PerformanceReadmeConfigUserVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PerformanceReadmeConfigUserVO> queryListDynamic(PerformanceReadmeConfigUserQuery query) {
        JPAQuery<PerformanceReadmeConfigUserVO> jpaQuery = getJpaQuerySelect0();
        // 条件封装
        jpaQuery.where(where0(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeConfigUserVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(PerformanceReadmeConfigUserVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 配置主键
                qdo.configId,
                // 员工主键
                qdo.userId,
                // 状态
                qdo.applyStatus,
                // 名称
                qdo.configUserName,
                // 审批名称
                qdo.procInstName,
                // 审批状态
                qdo.procInstStatus,
                // 流程id
                qdo.procInstId
        )).from(qdo);
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where0(PerformanceReadmeConfigUserQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 配置主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 员工主键 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getConfigUserName())) {
            list.add(qdo.configUserName.like(SqlUtil.toSqlLikeString(query.getConfigUserName())));
        }
        /** 审批名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getProcInstName())) {
            list.add(qdo.procInstName.like(SqlUtil.toSqlLikeString(query.getProcInstName())));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 流程id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PerformanceReadmeConfigUserVO> queryPaging(PerformanceReadmeConfigUserQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PerformanceReadmeConfigUserVO> jpaQuery = getJpaQueryWhere(query);
        List<PerformanceReadmeConfigUserVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PerformanceReadmeConfigUserVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PerformanceReadmeConfigUserDO save(PerformanceReadmeConfigUserDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PerformanceReadmeConfigUserDO> saveAll(List<PerformanceReadmeConfigUserDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PerformanceReadmeConfigUserPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 配置主键
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 员工主键
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        // BU主键
        if (payload.getBuId() != null) {
            update.set(qdo.buId, payload.getBuId());
        }
        // 状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 名称
        if (payload.getConfigUserName() != null) {
            update.set(qdo.configUserName, payload.getConfigUserName());
        }
        // 审批名称
        if (payload.getProcInstName() != null) {
            update.set(qdo.procInstName, payload.getProcInstName());
        }
        // 审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 流程id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 配置主键
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // 员工主键
            if (nullFields.contains("userId")) {
                update.setNull(qdo.userId);
            }
            // 状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 名称
            if (nullFields.contains("configUserName")) {
                update.setNull(qdo.configUserName);
            }
            // 审批名称
            if (nullFields.contains("procInstName")) {
                update.setNull(qdo.procInstName);
            }
            // 审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 流程id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据配置id逻辑删除
     *
     * @param configId 配置主键
     * @return 删除的行数
     */
    public long deleteSoftByConfigId(Long configId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.configId.eq(configId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

