package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmPeopleController {

    private final CrmPeopleService service;

    /**
     * 新增或更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/people")
    //@ReSubmitCheck(argExpressions = {"[0].peopleName","[0].customerId","[0].jobs","[0].sex"}, interval = 500, message = "请勿重复提交123")
    @ReSubmitCheck(argExpressions = {""}, interval = 500, message = "请勿重复提交456")
    public TwOutputUtil insertOrUpdate(CrmPeoplePayload payload) {
        return TwOutputUtil.ok(service.insertOrUpdate(payload));
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmPeopleVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    /**
     * 更新爱心等级
     *
     * @param key
     * @param level
     * @return
     */
    @GetMapping("/people/updateLoveLevel")
    public TwOutputUtil updateLoveLevel(Long key, Integer level) {
        service.updateLoveLevel(key, level);
        return TwOutputUtil.ok();
    }

    /**
     * 只针对客户经营下的经营计划列表查询列表
     *
     * @param operId 客户经营id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/customerOperationList")
    //@UdcNameClass
    public TwOutputUtil queryList(Long operId) {
        List<CrmPeopleVO> vos = service.queryList(operId);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 分页查询
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/paging")
    public TwOutputUtil paging(CrmPeopleQuery query) {
        PagingVO<CrmPeopleVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 删除
     *
     * @param keys 人脉主键
     * @param type 删除类型 1：客户或客户经营删除
     * @return
     */
    @DeleteMapping("/people/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys, String type) {
        service.deleteSoft(Arrays.asList(keys), type);
        return TwOutputUtil.ok();
    }


    /**
     * 查询人脉下面的人脉列表
     *
     * @param key       人脉主键
     * @param searchStr 搜索关键字
     * @param type      类型 1：同行，2：现在同事，3：过往同事
     * @return
     */
    @GetMapping("/people/queryRefPeopleList")
    public TwOutputUtil queryRefPeopleList(Long key, String searchStr, String type) {
        List<CrmPeopleVO> vos = service.queryRefPeopleList(key, searchStr, type);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 查询人脉下面的经营往来
     *
     * @param key 人脉主键id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/queryOperateFollowList/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOperateFollowList(@PathVariable Long key) {
        List<CrmFollowVO> vos = service.queryOperateFollowList(key);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 分页获取业务往来
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/queryBusinessFollowPaging/paging")
    @UdcNameClass
    public TwOutputUtil queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query) {
        Object paging = service.queryBusinessFollowPaging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 操作记录日志列表
     *
     * @param key 人脉主键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/queryLogList/{key}")
    @UdcNameClass
    public TwOutputUtil logList(@PathVariable Long key) {
        final List<PrdSystemLogVO> prdSystemLogVOS = service.queryLogList(key);
        return TwOutputUtil.ok(prdSystemLogVOS);
    }

    /**
     * 人脉情况概览
     *
     * @param key 人脉主键查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/queryPeopleView/{key}")
    public TwOutputUtil queryCustomerView(@PathVariable Long key) {
        Object view = service.queryPeopleView(key);
        return TwOutputUtil.ok(view);
    }

    /**
     * 查询人脉相关经营计划
     *
     * @param key 人脉主键查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/people/queryOperationPlanList/{key}")
    @UdcNameClass
    public TwOutputUtil queryOperationPlanList(@PathVariable Long key) {
        List<CrmOperationPlanDetailVO> vos = service.queryOperationPlanDetailList(key);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/people/batchExport")
    public void batchExport(HttpServletResponse response, CrmPeopleQuery query) {
        service.downloadBatch(response, query);
    }
}
