package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationChancePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationChanceDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationChanceRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 客户经营-经营人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@Repository
@RequiredArgsConstructor
public class CrmCustomerOperationChanceDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmCustomerOperationChanceRepo repo;
    private final QCrmCustomerOperationChanceDO qdo = QCrmCustomerOperationChanceDO.crmCustomerOperationChanceDO;
    private final QCrmCustomerOperationDO qdoOperation = QCrmCustomerOperationDO.crmCustomerOperationDO;

    private JPAQuery<CrmCustomerOperationChanceVO> getJpaQuerySelect() {
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerOperationChanceVO.class,
                qdo.id,
                qdo.operId,
                qdo.title,
                qdo.tags,
                qdo.trackerUserId,
                qdo.isRead,
                qdo.informUserIds,
                qdo.involvedUserIds,
                qdo.expectYear,
                qdo.expectQuarter,
                qdo.expectTime,
                qdo.chanceContent,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdoOperation.custName,
                qdoOperation.custOperBu,
                qdoOperation.custOperManagerId,
                qdoOperation.saleOperBu,
                qdoOperation.saleOperManagerId
        )).from(qdo).leftJoin(qdoOperation).on(qdo.operId.eq(qdoOperation.id));
        return jpaQuery;
    }

    /**
     * 主键查询
     *
     * @param id
     * @return
     */
    public CrmCustomerOperationChanceVO queryByKey(Long id) {
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.id.eq(id));
        return jpaQuerySelect.fetchFirst();
    }

    /**
     * 修改数据
     *
     * @param payload
     * @return
     */
    public long update(CrmCustomerOperationChancePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (StringUtils.hasText(payload.getTitle())) {
            update.set(qdo.title, payload.getTitle());
        }
        if (payload.getTrackerUserId() != null) {
            update.set(qdo.trackerUserId, payload.getTrackerUserId());
        }
        if (StringUtils.hasText(payload.getTags())) {
            update.set(qdo.tags, payload.getTags());
        }
        if (StringUtils.hasText(payload.getRemark())) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (StringUtils.hasText(payload.getInvolvedUserIds())) {
            update.set(qdo.involvedUserIds, payload.getInvolvedUserIds());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("trackerUserId")) {
                update.setNull(qdo.trackerUserId);
            }
            if (nullFields.contains("tags")) {
                update.setNull(qdo.tags);
            }
            if (nullFields.contains("tags")) {
                update.setNull(qdo.tags);
            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
            if (nullFields.contains("involvedUserIds")) {
                update.setNull(qdo.involvedUserIds);
            }
        }
        return update.execute();
    }

    /**
     * 列表查询
     *
     * @return
     */
    public List<CrmCustomerOperationChanceVO> queryList(Long operId) {
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.operId.eq(operId));
        return jpaQuerySelect.fetch();
    }

    /**
     * 列表查询
     *
     * @return
     */
    public PagingVO<CrmCustomerOperationChanceVO> paging(CrmCustomerOperationChanceQuery query) {
        JPAQuery<CrmCustomerOperationChanceVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdoOperation.deleteFlag.eq(0));
        if (query.getOperId() != null) {
            jpaQuerySelect.where(qdo.operId.eq(query.getOperId()));
        }
        if (StringUtils.hasText(query.getTitle())) {
            jpaQuerySelect.where(qdo.title.like(SqlUtil.toSqlLikeString(query.getTitle())));
        }
        if (StringUtils.hasText(query.getCustName())) {
            jpaQuerySelect.where(qdoOperation.custName.like(SqlUtil.toSqlLikeString(query.getCustName())));
        }
        if (query.getTrackerUserId() != null) {
            jpaQuerySelect.where(qdo.trackerUserId.eq(query.getTrackerUserId()));
        }
        if (query.getIsRead() != null) {
            jpaQuerySelect.where(qdo.isRead.eq(query.getIsRead()));
        }
        if (StringUtils.hasText(query.getInformUserIds())){
            List<Predicate> list = new ArrayList<>();
            for (String informUserId: query.getInformUserIds().split(",")){
                list.add(qdo.informUserIds.contains(informUserId));
            }
            jpaQuerySelect.where(ExpressionUtils.anyOf(list));
        }
        if (StringUtils.hasText(query.getInvolvedUserIds())){
            List<Predicate> list = new ArrayList<>();
            for (String involvedUserId: query.getInvolvedUserIds().split(",")){
                list.add(qdo.involvedUserIds.contains(involvedUserId));
            }
            jpaQuerySelect.where(ExpressionUtils.anyOf(list));
        }
        if (query.getExpectYear() != null){
            jpaQuerySelect.where(qdo.expectYear.eq(query.getExpectYear()));
        }
        if (query.getExpectQuarter() != null){
            jpaQuerySelect.where(qdo.expectQuarter.eq(query.getExpectQuarter()));
        }
        if (query.getCustOperBu() != null){
            jpaQuerySelect.where(qdoOperation.custOperBu.eq(query.getCustOperBu()));
        }
        if (query.getCustOperManagerId() != null){
            jpaQuerySelect.where(qdoOperation.custOperManagerId.eq(query.getCustOperManagerId()));
        }
        if (query.getSaleOperBu() != null){
            jpaQuerySelect.where(qdoOperation.saleOperBu.eq(query.getSaleOperBu()));
        }
        if (query.getSaleOperManagerId() != null){
            jpaQuerySelect.where(qdoOperation.saleOperManagerId.eq(query.getSaleOperManagerId()));
        }

        //需要验证权限
        if (!query.getNoPermissionFlag()) {
            BooleanExpression jpaQueryOr = qdo.createUserId.eq(query.getCreateUserId()).or(qdo.trackerUserId.eq(query.getCreateUserId()))
                    .or(qdo.informUserIds.like(SqlUtil.toSqlLikeString(query.getCreateUserId() + ""))).or(qdo.involvedUserIds.like(SqlUtil.toSqlLikeString(query.getCreateUserId() + "")));
            if (!ObjectUtils.isEmpty(query.getOperationIds())) {
                jpaQueryOr = jpaQueryOr.or(qdoOperation.id.in(query.getOperationIds()));
            }
            jpaQuerySelect.where(jpaQueryOr);

        }
//        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuerySelect, qdo._super, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        QueryResults<CrmCustomerOperationChanceVO> result = jpaQuerySelect.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmCustomerOperationChanceVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 逻辑删除
     *
     * @param keys
     */
    public void deleteByIdIn(List<Long> keys) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).set(qdo.deleteFlag, 1).where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(where, qdo._super);
        where.execute();
    }

    /**
     * 根据客户经营逻辑删除
     *
     * @param operIds
     */
    public void deleteSoftByOperIds(List<Long> operIds) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).set(qdo.deleteFlag, 1).where(qdo.operId.in(operIds));
        where.execute();
    }
}
