package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOppoDataSourceFieldsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityMeasureDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMeasureRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 商机成单率计算指标
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityMeasureDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityMeasureRepo repo;
    private final QCrmOpportunityMeasureDO qdo = QCrmOpportunityMeasureDO.crmOpportunityMeasureDO;
    private final QCrmOppoDataSourceFieldsDO qCrmOppoDataSourceFieldsDO = QCrmOppoDataSourceFieldsDO.crmOppoDataSourceFieldsDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityMeasureVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CrmOpportunityMeasureVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 商机表字段
                qCrmOppoDataSourceFieldsDO.name.as("oppoTableFieldsName"),
                qCrmOppoDataSourceFieldsDO.field.as("oppoTableFields"),
                // 指标类型
                qCrmOppoDataSourceFieldsDO.type.as("indicatorType"),
                // 商机数据源字段表ID
                qdo.dataSourceFieldsId,
                // 系统选择项key
                qCrmOppoDataSourceFieldsDO.selectionKey,
                // 权重
                qdo.weights
        )).from(qdo)
                .leftJoin(qCrmOppoDataSourceFieldsDO).on(qCrmOppoDataSourceFieldsDO.id.eq(qdo.dataSourceFieldsId));
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmOpportunityMeasureVO queryByKey(Long id) {
        JPAQuery<CrmOpportunityMeasureVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查询所有
     *
     * @return 结果
     */
    public List<CrmOpportunityMeasureVO> queryAll() {
        JPAQuery<CrmOpportunityMeasureVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     * @param ids id
     * @return 删除条数
     */
    public Long deleteSoft(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(ids));
        return update.execute();
    }
}

