package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityPartnerVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityPartnerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityPartnerDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityPartnerRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityPartnerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityPartnerRepo repo;
    private final QCrmOpportunityPartnerDO qdo = QCrmOpportunityPartnerDO.crmOpportunityPartnerDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.partnerIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.partnerIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityPartnerDO save(CrmOpportunityPartnerDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityPartnerVO> getJpaQuerySelect() {
        JPAQuery<CrmOpportunityPartnerVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunityPartnerVO.class,
                qdo.id,
                qdo.oppoId,
                qdo.partnerName,
                qdo.partnerContact,
                qdo.contactEmail,
                qdo.contactPhone,
                qdo.coopDesc,
                qdo.profitShare
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param oppoId 商家主键
     * @return
     * @Description 主键查询
     **/
    public List<CrmOpportunityPartnerVO> queryList(Long oppoId) {
        JPAQuery<CrmOpportunityPartnerVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.oppoId.eq(oppoId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Long getIdByV4(Long partnerIdV4) {
        if(repo.getIdByV4(partnerIdV4)!=null && !repo.getIdByV4(partnerIdV4).isEmpty()){
            return repo.getIdByV4(partnerIdV4).get(0);
        }else{
            return null;
        }
    }
}
