package com.elitesland.tw.tw5.server.prd.humanresources.basebu.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TwJobGradeEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;


@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "BASE_BU_CHANGE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PrdBaseBuChangeCallback implements WorkflowCallBack {


    public final PrdBaseBuChangeService prdBaseBuChangeService;

    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;

    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {

        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank(businessKey)) {
            throw new BusinessException("获取的businessKey为空");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        Long id = Long.valueOf(businessKey);
        PrdBaseBuChangeVO prdBaseBuChangeVO = prdBaseBuChangeService.get(id);

        PrdBaseBuChangePayload prdBaseBuChangePayload = new PrdBaseBuChangePayload();
        prdBaseBuChangePayload.setId(id);
        if (prdBaseBuChangeVO != null) {

            Boolean isUp = false;
            PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
            prdOrgEmployeePayload.setResourceStatus("3");
            prdOrgEmployeePayload.setUserId(prdBaseBuChangeVO.getUserId());
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"激活",流程状态改为未提交
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                case INVALID://仅删除流程
                    prdBaseBuChangePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    //删除当前版本草稿状态的changeLog
//                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    isUp = true;
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdBaseBuChangePayload.setApprovedTime(LocalDateTime.now());
//                    prdBaseBuChangePayload.setActiveDate(LocalDate.now());
                    // 激活当前版本草稿状态的所有changeLog,合并当前及上一个版本
//                    Map<String, Object> stringObjectMap = changeService.activeCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
//                    PersonResPayload newPayload = JSON.parseObject(stringObjectMap.toString(), PersonResPayload.class);
//                    prdOrgEmployeeService.updateNew(newPayload);

                    // 若加入日期为空，审批通过即生效
                    if (null == prdBaseBuChangeVO.getNewJoinDate()) {
                        prdBaseBuChangeVO.setNewJoinDate(LocalDate.now());
                    }
                    if (prdBaseBuChangeVO.getNewJoinDate().isEqual(LocalDate.now()) || prdBaseBuChangeVO.getNewJoinDate().isBefore(LocalDate.now())) {

                        // 更新资源库中的 状态 生效日期 ，职级
                        // 发薪方式
                        prdOrgEmployeePayload.setSalaryMethod(prdBaseBuChangeVO.getSalaryType());
                        // 发薪周期
                        prdOrgEmployeePayload.setSalaryPeriod(prdBaseBuChangeVO.getSalaryCycle());
                        // 合作方式
                        prdOrgEmployeePayload.setCooperationMode(prdBaseBuChangeVO.getCooperateType());
                        // 当量系数
//                        BigDecimal eqvaRatio = BigDecimal.valueOf(Objects.requireNonNull(TwJobGradeEnum.getTwJobGradeEnum(prdBaseBuChangeVO.getJobGrade())).getEqva());
                        BigDecimal eqvaRatio = BigDecimal.ONE;
                        prdOrgEmployeePayload.setEqvaRatio(eqvaRatio);
                        // 职级
                        prdOrgEmployeePayload.setExtString1(prdBaseBuChangeVO.getJobGrade());
                        prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);

                        // 新增当量变更记录
                        PrdOrgEmployeeEqvaRatioPayload employeeEqvaRatioDO = new PrdOrgEmployeeEqvaRatioPayload();
                        employeeEqvaRatioDO.setUserId(prdBaseBuChangeVO.getUserId());
                        employeeEqvaRatioDO.setEqvaRatio(eqvaRatio);
                        employeeEqvaRatioDO.setStartDate(LocalDate.now());
                        employeeEqvaRatioDO.setEndDate(null);
                        prdOrgEmployeeEqvaRatioService.upsertEqvaRatio(employeeEqvaRatioDO);


                        // ref 上级员工id 组织id 加入时间

                        // 根据原baseBu + 用户 修改组织
                        PrdOrgEmployeeRefPayload prdOrgEmployeeRefPayload = new PrdOrgEmployeeRefPayload();
                        prdOrgEmployeeRefPayload.setOrgId(prdBaseBuChangeVO.getOldBuId());
                        prdOrgEmployeeRefPayload.setNewOrgId(prdBaseBuChangeVO.getNewBuId());
                        prdOrgEmployeeRefPayload.setUserId(prdBaseBuChangeVO.getUserId());
                        prdOrgEmployeeRefPayload.setParentId(prdBaseBuChangeVO.getNewPUserId());
                        prdOrgEmployeeRefPayload.setIsDefault(0);
                        prdOrgEmployeeRefPayload.setJoinDate(prdBaseBuChangeVO.getNewJoinDate());

                        prdOrgEmployeeDAO.updateEmployeeRefByUserId(prdOrgEmployeeRefPayload);

                        // bu角色
                        if (StringUtils.isNotBlank(prdBaseBuChangeVO.getNewRoleId())) {

                            String[] roleIds = prdBaseBuChangeVO.getNewRoleId().split(",");
                            for (String str : roleIds) {
                                PrdOrgRoleDO prdOrgRoleDO = prdOrgOrganizationDAO.queryRoleByKey(Long.valueOf(str));
                                if (null == prdOrgRoleDO) {
                                    throw new BusinessException("未找到该角色" + str);
                                }
                                String roleEmployees = prdOrgRoleDO.getRoleEmployees();
                                if (StringUtils.isNotBlank(roleEmployees)) {
                                    // 在后面拼接 ,
                                    roleEmployees = roleEmployees + ",";
                                }
                                roleEmployees = roleEmployees + prdBaseBuChangeVO.getUserId();
                                PrdOrgRolePayload prdOrgRolePayload = new PrdOrgRolePayload();
                                prdOrgRolePayload.setId(Long.valueOf(str));
                                prdOrgRolePayload.setRoleEmployees(roleEmployees);
                                long res = prdOrgOrganizationDAO.updateRole(prdOrgRolePayload);
                            }
                        }

                    } else {
                        // 非立即生效，走定时任务
                    }

                    break;
                case APPROVING:
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    prdOrgEmployeePayload.setResourceStatus("5");
            }
            Long l = prdBaseBuChangeService.updateByCondition(prdBaseBuChangePayload);
            if (!isUp) {
                prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);
            }
        }
        return WorkflowResult.success(null);
    }


}
