package com.elitesland.tw.tw5.server.prd.humanresources.eval.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.QPrdEvaluateDtlDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价明细表RepoProc
 */

@Component
public class PrdEvaluateDtlDao extends BaseRepoProc<PrdEvaluateDtlDO> {

    private static final QPrdEvaluateDtlDO qPrdEvaluateDtlDO = QPrdEvaluateDtlDO.prdEvaluateDtlDO;


    protected PrdEvaluateDtlDao() {

        super(qPrdEvaluateDtlDO);

    }


    public PagingVO<PrdEvaluateDtlVO> page(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        JPAQuery<PrdEvaluateDtlVO> query =
                select(PrdEvaluateDtlVO.class)
                        .where(bulidPredicate(prdEvaluateDtlQuery));
        prdEvaluateDtlQuery.setPaging(query);
        prdEvaluateDtlQuery.fillOrders(query, qPrdEvaluateDtlDO);
        return PagingVO.<PrdEvaluateDtlVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEvaluateDtlDO)
                .set(qPrdEvaluateDtlDO.deleteFlag, 1)
                .where(qPrdEvaluateDtlDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEvaluateDtlVO get(Long id) {

        PrdEvaluateDtlVO prdEvaluateDtlVO = select(PrdEvaluateDtlVO.class)
                .where(qPrdEvaluateDtlDO.id.eq(id))
                .fetchOne();

        return prdEvaluateDtlVO;

    }


    public List<PrdEvaluateDtlVO> getList(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        List<PrdEvaluateDtlVO> res =
                select(PrdEvaluateDtlVO.class)
                        .where(bulidPredicate(prdEvaluateDtlQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdEvaluateDtlDO.pointId,
                        qPrdEvaluateDtlDO.evalId,
                        qPrdEvaluateDtlDO.pointName,
                        qPrdEvaluateDtlDO.score,
                        qPrdEvaluateDtlDO.evalDesc,
                        qPrdEvaluateDtlDO.id,
                        qPrdEvaluateDtlDO.createTime,
                        qPrdEvaluateDtlDO.remark

                )).from(qPrdEvaluateDtlDO);

    }


    private Predicate bulidPredicate(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdEvaluateDtlQuery.getPointId(), qPrdEvaluateDtlDO.pointId, prdEvaluateDtlQuery.getPointId())
                .andEq(null != prdEvaluateDtlQuery.getEvalId(), qPrdEvaluateDtlDO.evalId, prdEvaluateDtlQuery.getEvalId())
                .andEq(StringUtils.isNotBlank(prdEvaluateDtlQuery.getPointName()), qPrdEvaluateDtlDO.pointName, prdEvaluateDtlQuery.getPointName())
                .andEq(null != prdEvaluateDtlQuery.getScore(), qPrdEvaluateDtlDO.score, prdEvaluateDtlQuery.getScore())
                .andEq(StringUtils.isNotBlank(prdEvaluateDtlQuery.getEvalDesc()), qPrdEvaluateDtlDO.evalDesc, prdEvaluateDtlQuery.getEvalDesc())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 评价点id
        if (null != prdEvaluateDtlQuery.getPointId()) {
            predicates.add(qPrdEvaluateDtlDO.pointId.eq(prdEvaluateDtlQuery.getPointId()));
        }
        // 评价id
        if (null != prdEvaluateDtlQuery.getEvalId()) {
            predicates.add(qPrdEvaluateDtlDO.evalId.eq(prdEvaluateDtlQuery.getEvalId()));
        }
        // 评价单名称
        if (StringUtils.isNotEmpty(prdEvaluateDtlQuery.getPointName())) {
            predicates.add(qPrdEvaluateDtlDO.pointName.eq(prdEvaluateDtlQuery.getPointName()));
        }
        // 评分
        if (null != prdEvaluateDtlQuery.getScore()) {
            predicates.add(qPrdEvaluateDtlDO.score.eq(prdEvaluateDtlQuery.getScore()));
        }
        // 评价说明
        if (StringUtils.isNotEmpty(prdEvaluateDtlQuery.getEvalDesc())) {
            predicates.add(qPrdEvaluateDtlDO.evalDesc.eq(prdEvaluateDtlQuery.getEvalDesc()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        long res = select(PrdEvaluateDtlVO.class)
                .where(bulidPredicate(prdEvaluateDtlQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateDtlDO);

        // 评价点id
        if (null != prdEvaluateDtlPayload.getPointId()) {
            update.set(qPrdEvaluateDtlDO.pointId, prdEvaluateDtlPayload.getPointId());
        }
        // 评价id
        if (null != prdEvaluateDtlPayload.getEvalId()) {
            update.set(qPrdEvaluateDtlDO.evalId, prdEvaluateDtlPayload.getEvalId());
        }
        // 评价单名称
        if (StringUtils.isNotEmpty(prdEvaluateDtlPayload.getPointName())) {
            update.set(qPrdEvaluateDtlDO.pointName, prdEvaluateDtlPayload.getPointName());
        }
        // 评分
        if (null != prdEvaluateDtlPayload.getScore()) {
            update.set(qPrdEvaluateDtlDO.score, prdEvaluateDtlPayload.getScore());
        }
        // 评价说明
        if (StringUtils.isNotEmpty(prdEvaluateDtlPayload.getEvalDesc())) {
            update.set(qPrdEvaluateDtlDO.evalDesc, prdEvaluateDtlPayload.getEvalDesc());
        }
        long res = update.where(qPrdEvaluateDtlDO.id.eq(prdEvaluateDtlPayload.getId()))
                .execute();
        return res;

    }

    public Long delByEvalIds(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateDtlDO);
        long res = update.set(qPrdEvaluateDtlDO.deleteFlag, 1)
                .where(qPrdEvaluateDtlDO.evalId.in(ids))
                .execute();
        return res;

    }

}

