package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamResDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamResDtlDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import com.querydsl.core.types.ExpressionUtils;
import java.util.ArrayList;


 /**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果明细RepoProc
 */
 
@Component
public class PrdPerformanceExamResDtlDao extends BaseRepoProc<PrdPerformanceExamResDtlDO>{
    
    private static final QPrdPerformanceExamResDtlDO qPrdPerformanceExamResDtlDO = QPrdPerformanceExamResDtlDO.prdPerformanceExamResDtlDO;
    
    
    protected PrdPerformanceExamResDtlDao() {
    
        super(qPrdPerformanceExamResDtlDO);
        
    }
    
    
    public PagingVO<PrdPerformanceExamResDtlVO> page(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {
        
        JPAQuery<PrdPerformanceExamResDtlVO> query = 
            select(PrdPerformanceExamResDtlVO.class)
                .where(bulidPredicate(prdPerformanceExamResDtlQuery));
        prdPerformanceExamResDtlQuery.setPaging(query);
        prdPerformanceExamResDtlQuery.fillOrders(query, qPrdPerformanceExamResDtlDO);
        return PagingVO.<PrdPerformanceExamResDtlVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
                
    }
    
    
    public Long del(List<Long> ids) {
        
        Long res = jpaQueryFactory.update(qPrdPerformanceExamResDtlDO)
                .set(qPrdPerformanceExamResDtlDO.deleteFlag, 1)
                .where(qPrdPerformanceExamResDtlDO.id.in(ids))
                .execute();
        
        return res;
        
    }
    
    
    public PrdPerformanceExamResDtlVO get(Long id) {
    
        PrdPerformanceExamResDtlVO prdPerformanceExamResDtlVO = select(PrdPerformanceExamResDtlVO.class)
                .where(qPrdPerformanceExamResDtlDO.id.eq(id))
                .fetchOne();
        
        return prdPerformanceExamResDtlVO;
        
    }
    
    
    public List<PrdPerformanceExamResDtlVO> getList(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {
        
        List<PrdPerformanceExamResDtlVO> res = 
            select(PrdPerformanceExamResDtlVO.class)
                .where(bulidPredicate(prdPerformanceExamResDtlQuery))
                .fetch();
        
        return res;
        
    }
    
    
    private <T> JPAQuery<T> select(Class<T> cls) {
    
        return 
                jpaQueryFactory.select(Projections.bean(cls,
                    qPrdPerformanceExamResDtlDO.resultId,
                    qPrdPerformanceExamResDtlDO.pointId,
                    qPrdPerformanceExamResDtlDO.pointName,
                    qPrdPerformanceExamResDtlDO.scoreType,
                    qPrdPerformanceExamResDtlDO.weightRatio,
                    qPrdPerformanceExamResDtlDO.sysExam,
                    qPrdPerformanceExamResDtlDO.scoreRes,
                    qPrdPerformanceExamResDtlDO.selfEval,
                    qPrdPerformanceExamResDtlDO.evalUser,
                    qPrdPerformanceExamResDtlDO.evalUserId,
                    qPrdPerformanceExamResDtlDO.evalDesc,
                    qPrdPerformanceExamResDtlDO.id,
                    qPrdPerformanceExamResDtlDO.standardDesc,
                    qPrdPerformanceExamResDtlDO.createTime,
                    qPrdPerformanceExamResDtlDO.remark
                
                )).from(qPrdPerformanceExamResDtlDO);
            
    }
    
    
    private Predicate bulidPredicate(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {
    
        Predicate predicate = PredicateBuilder.builder()
            .andEq(null != prdPerformanceExamResDtlQuery.getResultId(), qPrdPerformanceExamResDtlDO.resultId, prdPerformanceExamResDtlQuery.getResultId())
            .andEq(null != prdPerformanceExamResDtlQuery.getPointId(), qPrdPerformanceExamResDtlDO.pointId, prdPerformanceExamResDtlQuery.getPointId())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamResDtlQuery.getScoreType()), qPrdPerformanceExamResDtlDO.scoreType, prdPerformanceExamResDtlQuery.getScoreType())
            .andEq(null != prdPerformanceExamResDtlQuery.getWeightRatio(), qPrdPerformanceExamResDtlDO.weightRatio, prdPerformanceExamResDtlQuery.getWeightRatio())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamResDtlQuery.getSysExam()), qPrdPerformanceExamResDtlDO.sysExam, prdPerformanceExamResDtlQuery.getSysExam())
            .andEq(null != prdPerformanceExamResDtlQuery.getScoreRes(), qPrdPerformanceExamResDtlDO.scoreRes, prdPerformanceExamResDtlQuery.getScoreRes())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamResDtlQuery.getSelfEval()), qPrdPerformanceExamResDtlDO.selfEval, prdPerformanceExamResDtlQuery.getSelfEval())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamResDtlQuery.getEvalUser()), qPrdPerformanceExamResDtlDO.evalUser, prdPerformanceExamResDtlQuery.getEvalUser())
            .andEq(null != prdPerformanceExamResDtlQuery.getEvalUserId(), qPrdPerformanceExamResDtlDO.evalUserId, prdPerformanceExamResDtlQuery.getEvalUserId())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamResDtlQuery.getEvalDesc()), qPrdPerformanceExamResDtlDO.evalDesc, prdPerformanceExamResDtlQuery.getEvalDesc())
            .build();
            
        return predicate;
        
    }
    
    
    private List<Predicate> bulidPredicates(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {
        
        List<Predicate> predicates = new ArrayList<>();
        // 绩效考核结果id
        if (null != prdPerformanceExamResDtlQuery.getResultId()) {
            predicates.add(qPrdPerformanceExamResDtlDO.resultId.eq(prdPerformanceExamResDtlQuery.getResultId()));
        }
        // 考核点id
        if (null != prdPerformanceExamResDtlQuery.getPointId()) {
            predicates.add(qPrdPerformanceExamResDtlDO.pointId.eq(prdPerformanceExamResDtlQuery.getPointId()));
        }
        // 评分类型
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlQuery.getScoreType())) {
            predicates.add(qPrdPerformanceExamResDtlDO.scoreType.eq(prdPerformanceExamResDtlQuery.getScoreType()));
        }
        // 考核点权重
        if (null != prdPerformanceExamResDtlQuery.getWeightRatio()) {
            predicates.add(qPrdPerformanceExamResDtlDO.weightRatio.eq(prdPerformanceExamResDtlQuery.getWeightRatio()));
        }
        // 系统考核统计
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlQuery.getSysExam())) {
            predicates.add(qPrdPerformanceExamResDtlDO.sysExam.eq(prdPerformanceExamResDtlQuery.getSysExam()));
        }
        // 评分结果
        if (null != prdPerformanceExamResDtlQuery.getScoreRes()) {
            predicates.add(qPrdPerformanceExamResDtlDO.scoreRes.eq(prdPerformanceExamResDtlQuery.getScoreRes()));
        }
        // 自评说明
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlQuery.getSelfEval())) {
            predicates.add(qPrdPerformanceExamResDtlDO.selfEval.eq(prdPerformanceExamResDtlQuery.getSelfEval()));
        }
        // 考评人
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlQuery.getEvalUser())) {
            predicates.add(qPrdPerformanceExamResDtlDO.evalUser.eq(prdPerformanceExamResDtlQuery.getEvalUser()));
        }
        // 考评人id
        if (null != prdPerformanceExamResDtlQuery.getEvalUserId()) {
            predicates.add(qPrdPerformanceExamResDtlDO.evalUserId.eq(prdPerformanceExamResDtlQuery.getEvalUserId()));
        }
        // 评语
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlQuery.getEvalDesc())) {
            predicates.add(qPrdPerformanceExamResDtlDO.evalDesc.eq(prdPerformanceExamResDtlQuery.getEvalDesc()));
        }
        
//      Predicate predicate = ExpressionUtils.allOf(predicates);
        
        return predicates;
    }
    
    
    public Long count(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {
    
        long res = select(PrdPerformanceExamResDtlVO.class)
                .where(bulidPredicate(prdPerformanceExamResDtlQuery))
                .fetchCount();
        
        return res;
        
        
    }
    
    public Long update(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamResDtlDO);
        
        // 绩效考核结果id
        if (null != prdPerformanceExamResDtlPayload.getResultId()) {
            update.set(qPrdPerformanceExamResDtlDO.resultId,prdPerformanceExamResDtlPayload.getResultId());
        }
        // 考核点id
        if (null != prdPerformanceExamResDtlPayload.getPointId()) {
            update.set(qPrdPerformanceExamResDtlDO.pointId,prdPerformanceExamResDtlPayload.getPointId());
        }
        // 评分类型
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlPayload.getScoreType())) {
            update.set(qPrdPerformanceExamResDtlDO.scoreType,prdPerformanceExamResDtlPayload.getScoreType());
        }
        // 考核点权重
        if (null != prdPerformanceExamResDtlPayload.getWeightRatio()) {
            update.set(qPrdPerformanceExamResDtlDO.weightRatio,prdPerformanceExamResDtlPayload.getWeightRatio());
        }
        // 系统考核统计
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlPayload.getSysExam())) {
            update.set(qPrdPerformanceExamResDtlDO.sysExam,prdPerformanceExamResDtlPayload.getSysExam());
        }
        // 评分结果
        if (null != prdPerformanceExamResDtlPayload.getScoreRes()) {
            update.set(qPrdPerformanceExamResDtlDO.scoreRes,prdPerformanceExamResDtlPayload.getScoreRes());
        }
        // 自评说明
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlPayload.getSelfEval())) {
            update.set(qPrdPerformanceExamResDtlDO.selfEval,prdPerformanceExamResDtlPayload.getSelfEval());
        }
        // 考评人
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlPayload.getEvalUser())) {
            update.set(qPrdPerformanceExamResDtlDO.evalUser,prdPerformanceExamResDtlPayload.getEvalUser());
        }
        // 考评人id
        if (null != prdPerformanceExamResDtlPayload.getEvalUserId()) {
            update.set(qPrdPerformanceExamResDtlDO.evalUserId,prdPerformanceExamResDtlPayload.getEvalUserId());
        }
        // 评语
        if (StringUtils.isNotEmpty(prdPerformanceExamResDtlPayload.getEvalDesc())) {
            update.set(qPrdPerformanceExamResDtlDO.evalDesc,prdPerformanceExamResDtlPayload.getEvalDesc());
        }
        long res = update.where(qPrdPerformanceExamResDtlDO.id.eq(prdPerformanceExamResDtlPayload.getId()))
                .execute();
        return res;
    
    }
    
}

