package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonCertDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonCertDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonCertRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PersonCertDAO {

    private final PersonCertRepo personCertRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonCertDO personCertDO = QPersonCertDO.personCertDO;

    public List<PersonCertDO> findAllByPersonId(Long personId) {
        return personCertRepo.findAllByPersonId(personId);
    }

    public void deleteAllByPersonId(Long personId) {
        jpaQueryFactory.update(personCertDO)
                .set(personCertDO.deleteFlag, 1)
                .where(personCertDO.personId.eq(personId))
                .execute();
    }

    public void saveAll(List<PersonCertDO> personCertDOList) {
        personCertRepo.saveAll(personCertDOList);
    }
}
