package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeDepartApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.EmployeeDepartService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.EmployeeDepartApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.EmployeeDepartApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.EmployeeDepartApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.EmployeeDepartApplyRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class EmployeeDepartServiceImpl implements EmployeeDepartService {

    private final PrdOrgEmployeeService prdOrgEmployeeService;

    private final WorkflowUtil workflowUtil;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final EmployeeDepartApplyDAO departApplyDAO;

    private final PrdOrgEmployeeDAO dao;

    private final PrdUserDAO userDAO;

    private final CacheUtil cacheUtil;

    private final TimesheetService timesheetService;

    private BeanSearcher beanSearcher;

    private final CalTaskSettleService calTaskSettleService;

    private final AccReimService accReimService;

    private final PmsProjectService pmsProjectService;

    private final CrmOpportunityService crmOpportunityService;

    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;

    private final EmployeeDepartApplyRepo repo;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.EMPLOYEE_DEPART_APPLY);
    }

    @Override
    @Transactional
    public void employeeDepart(EmployeeDepartPayload payload) {

        if (payload.getProcInstId() == null) {
            //启动离职流程
            payload.setId(null);
            startDepartPrco(payload);
        } else {
            //更新离职申请数据
            updateEmployeeDepartData(payload);
        }
    }

    public void startDepartPrco(EmployeeDepartPayload payload) {
        List<EmployeeDepartApplyDO> employeeDepartApplyDOList = departApplyDAO.queryByEmployeeId(payload.getEmployeeId());
        if (!ObjectUtils.isEmpty(employeeDepartApplyDOList)) {
            for (EmployeeDepartApplyDO employeeDepartApplyDO : employeeDepartApplyDOList) {
                if (!ObjectUtils.isEmpty(employeeDepartApplyDO.getProcInstStatus()) && employeeDepartApplyDO.getProcInstStatus().equals(ProcInstStatus.APPROVING)) {
                    throw TwException.error("", "您有审批中的离职流程，请勿重复提交");
                }
            }
        }
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();

        HashMap<String, Object> variables;

        Long employeeId = payload.getEmployeeId();
        PrdOrgEmployeeVO employeeVO = prdOrgEmployeeService.queryByKey(employeeId);
        //参数设置
        variables = setWorkFlowVar(payload);
        String procInstName = "A31.离职流程-" + employeeVO.getEmployeeName();

        //保存申请单信息
        EmployeeDepartApplyDO employeeDepartApplyDO = EmployeeDepartApplyConvert.INSTANCE.payloadToDo(payload);
        employeeDepartApplyDO.setProcInstName(procInstName);
        employeeDepartApplyDO.setCreateTime(LocalDateTime.now());
        EmployeeDepartApplyDO employeeDepartApplySaveDO = departApplyDAO.save(employeeDepartApplyDO);

        //发起流程审批
        processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.RES_DEPART.name(),
                procInstName,
                employeeDepartApplySaveDO.getId() + "",
                variables)
        );

        //流程启动成功后，回写业务表数据
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setId(employeeDepartApplySaveDO.getId());
        departApplyDAO.updateProcData(payload);
        PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
//        employeePayload.setProcInstId(processInfo.getProcInstId());
        employeePayload.setProcInstStatus(processInfo.getProcInstStatus());
        employeePayload.setId(payload.getEmployeeId());
        dao.updateProcessDate(employeePayload);
        dao.updateResStatus(employeeId, "4");
        // 发通知给人事 平台人力资源总监 平台员工关系主管 平台员工关系专员 平台薪酬绩效主管 平台薪酬绩效专员
        String userName = cacheUtil.getUserName(employeeDepartApplySaveDO.getUserId());
        String title = "员工离职-" + userName;
        String content = "员工" + userName + "发起了离职申请，申请离职原因为:" + employeeDepartApplySaveDO.getLeaveDesc();
        sendMessage(employeeDepartApplySaveDO.getId(), title, content);

    }

    public HashMap<String, Object> setWorkFlowVar(EmployeeDepartPayload payload) {

        HashMap<String, Object> variables = new HashMap<>();
        Long employeeId = payload.getEmployeeId();
        PrdOrgEmployeeVO employeeVO = prdOrgEmployeeService.queryByKey(employeeId);
        Long userId = employeeVO.getUserId();

        //有无工作交接
        if (payload.getJobHandOverFlag() != null) {
            variables.put("workHandoverFlag", payload.getJobHandOverFlag());
        }
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = dao.queryUserOrgData(userId);
        //直属领导审批
        variables.put("Activity_1xxb5sz", CollUtil.newArrayList(prdOrgEmployeeRefVO.getParentId()));
        //BU负责人审批
        variables.put("Activity_0r5xzs9", CollUtil.newArrayList(prdOrgEmployeeRefVO.getManageId()));
        //资源交接人
        if (payload.getJobHandOverId() != null) {
            variables.put("Activity_1lhkue9", CollUtil.newArrayList(payload.getJobHandOverId()));
        }

        //财务总账会计
        List<Long> accountantIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_GL_ACCOUNTANT.getCode());
        variables.put("Activity_1v1a4mr", accountantIds);
        //行政主管
        List<Long> administrationIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_OFFI_AM.getCode());
        variables.put("Activity_1ltgrs3", administrationIds);
        //总部人事专员
        List<Long> empRelIds = prdSystemRoleDAO.queryUserIdByRoleCodes(CollUtil.newArrayList(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        variables.put("Activity_1j4rmve", empRelIds);
        //平台IT管理员
        List<Long> itAdminIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode());
        variables.put("Activity_09urufw", itAdminIds);

        return variables;
    }

    public void updateEmployeeDepartData(EmployeeDepartPayload payload) {
        EmployeeDepartApplyDO departApplyDO = repo.findById(payload.getId()).orElseGet(EmployeeDepartApplyDO::new);
        EmployeeDepartApplyDO employeeDepartApplyDO = EmployeeDepartApplyConvert.INSTANCE.payloadToDo(payload);
        departApplyDO.copy(employeeDepartApplyDO);
        departApplyDAO.save(departApplyDO);
        updateWorkFlowVar(payload);
    }

    @Override
    public EmployeeDepartApplyVO queryEmployeeDepart(String prcoId) {
        EmployeeDepartApplyDO employeeDepartApplyDO = departApplyDAO.findByPrcoId(prcoId);
        return EmployeeDepartApplyConvert.INSTANCE.doToVo(employeeDepartApplyDO);
    }

    @Override
    public EmployeeDepartCheckVO employeeDepartCheck(Long employeeId) {

        EmployeeDepartCheckVO checkVO = new EmployeeDepartCheckVO();
        PrdOrgEmployeeVO orgEmployeeVO = prdOrgEmployeeService.queryByKey(employeeId);
        Long userId = orgEmployeeVO.getUserId();
        List<String> orgRoles = departApplyDAO.queryOrgRoleByUserId(userId + "");
        List<String> roleCodes = cacheUtil.getSystemRoleCodes(userId);
        List<PrdSystemRoleVO> sysRoleVOList = prdSystemRoleDAO.queryByCodeIn(roleCodes);


        ResDepartCheckPointVO resDepartCheckPointVO = new ResDepartCheckPointVO();
        List<VacationCheckVO> vacationCheckVOList = new ArrayList<>();
        if (sysRoleVOList != null && !sysRoleVOList.isEmpty()) {
            List<String> roleNameList = new ArrayList<>();
            for (PrdSystemRoleVO systemRoleVO : sysRoleVOList) {
                roleNameList.add(systemRoleVO.getRoleName());
            }
            resDepartCheckPointVO.setProcessApprCheckRole("系统角色:" + roleNameList + ";组织角色:" + orgRoles);
        }
        TimesheetQuery query = new TimesheetQuery();
        query.setTsUserId(userId);
        List<String> tsStatusList = new ArrayList<>();
        tsStatusList.add("CREATE");
        tsStatusList.add("REJECTED");
        query.setTsStatusList(tsStatusList);
        List<TimesheetVO> timesheetVOList = timesheetService.queryList(query);
        boolean timesheetSubmitCheckFlag = timesheetVOList.isEmpty();
        //工时检查
        resDepartCheckPointVO.setTimesheetSubmitCheck(timesheetSubmitCheckFlag);
        //结算单检查
        Boolean eqvaCheckFlag = true;
        CalTaskSettleQuery calTaskSettleQuery = new CalTaskSettleQuery();
        calTaskSettleQuery.setIncomeResId(userId);
        List<CalTaskSettleVO> calTaskSettleVOList = calTaskSettleService.queryListDynamic(calTaskSettleQuery);
        if (!ObjectUtils.isEmpty(calTaskSettleVOList)) {
            for (CalTaskSettleVO calTaskSettleVO : calTaskSettleVOList) {
                if (!ObjectUtils.isEmpty(calTaskSettleVO.getSettleStatus())) {
                    if (calTaskSettleVO.getSettleStatus().equals("CREATE") || calTaskSettleVO.getSettleStatus().equals("IN PROCESS")) {
                        eqvaCheckFlag = false;
                        break;
                    }
                }
            }
        }
        resDepartCheckPointVO.setEqvaCheck(eqvaCheckFlag);
        //报销检查
        AccReimQuery accReimQuery = new AccReimQuery();
        accReimQuery.setMyReimUserId(userId);
        accReimQuery.setReimUserId(userId);
        List<AccReimVO> accReimVOList = accReimService.queryListDynamic(accReimQuery);
        Boolean reimbursementDocCheck = true;
        if (!ObjectUtils.isEmpty(accReimVOList)) {
            for (AccReimVO accReimVO : accReimVOList) {
                if (!ObjectUtils.isEmpty(accReimVO.getReimStatus())) {
                    if (accReimVO.getReimStatus().equals("CREATE") || accReimVO.getReimStatus().equals("APPLYING") || accReimVO.getReimStatus().equals("FINANCIAL_AUDIT")) {
                        reimbursementDocCheck = false;
                        break;
                    }
                }
            }
        }
        resDepartCheckPointVO.setReimbursementDocCheck(reimbursementDocCheck);
        //项目检查
        Boolean processCheckFlag = true;
        List<PmsProjectVO> projList = new ArrayList<>();
        PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setDeliUserId(userId);
        List<PmsProjectVO> projectVOList = pmsProjectService.queryListDynamic(pmsProjectQuery);
        if (!ObjectUtils.isEmpty(projectVOList)) {
            projList.addAll(projectVOList);
        }
        PmsProjectQuery PmPmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setPmResId(userId);
        List<PmsProjectVO> pmProjectVOList = pmsProjectService.queryListDynamic(PmPmsProjectQuery);
        if (!ObjectUtils.isEmpty(pmProjectVOList)) {
            projList.addAll(pmProjectVOList);
        }
        if (!ObjectUtils.isEmpty(projList)) {
            for (PmsProjectVO pmsProjectVO : projList) {
                if (!ObjectUtils.isEmpty(pmsProjectVO.getProjStatus())) {
                    if (pmsProjectVO.getProjStatus().equals("ACTIVE") || pmsProjectVO.getProjStatus().equals("PENDING")) {
                        processCheckFlag = false;
                        break;
                    }
                }
            }
        }
        resDepartCheckPointVO.setProcessCheck(processCheckFlag);
        //商机检查
        Boolean businessOpportunityCheckFlag = true;
        List<CrmOpportunityListVO> crmOppoList = new ArrayList<>();
        CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
        crmOpportunityQuery.setManageUserId(userId);
        List<CrmOpportunityListVO> crmOpportunityListVOList = crmOpportunityService.queryListDynamic(crmOpportunityQuery);
        if (!ObjectUtils.isEmpty(crmOpportunityListVOList)) {
            crmOppoList.addAll(crmOpportunityListVOList);
        }
        CrmOpportunityQuery delCrmOpportunityQuery = new CrmOpportunityQuery();
        crmOpportunityQuery.setDeliUserId(userId);
        List<CrmOpportunityListVO> delCrmOpportunityListVOList = crmOpportunityService.queryListDynamic(delCrmOpportunityQuery);
        if (!ObjectUtils.isEmpty(delCrmOpportunityListVOList)) {
            crmOppoList.addAll(delCrmOpportunityListVOList);
        }
        if (!ObjectUtils.isEmpty(crmOppoList)) {
            for (CrmOpportunityListVO crmOpportunityListVO : crmOppoList) {
                if (!ObjectUtils.isEmpty(crmOpportunityListVO.getProjectStatus())) {
                    if (!crmOpportunityListVO.getProjectStatus().equals("CLOSED")) {
                        businessOpportunityCheckFlag = false;
                        break;
                    }
                }
            }
        }
        resDepartCheckPointVO.setBusinessOpportunityCheck(businessOpportunityCheckFlag);

        resDepartCheckPointVO.setLowResCheck(false);
        resDepartCheckPointVO.setBuLeaderCheck(false);
        resDepartCheckPointVO.setClueCheck(false);
        resDepartCheckPointVO.setProjectCheck(false);
        resDepartCheckPointVO.setTaskCheck(false);
        resDepartCheckPointVO.setTimesheetApprCheck(false);
        resDepartCheckPointVO.setProcessApprCheck(false);
        checkVO.setResDepartCheck(resDepartCheckPointVO);
        checkVO.setVacationCheckList(vacationCheckVOList);

        return checkVO;
    }

    @Override
    public PagingVO<EmployeeDepartApplyVO> employeeDepartApplyList(EmployeeDepartApplyQuery query) {
        return departApplyDAO.queryPaging(query);
    }

    @Override
    public PagingVO<EmployeeDepartApplyBSVO> permissionPaging(EmployeeDepartApplyQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(EmployeeDepartApplyBSVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List<EmployeeDepartApplyBSVO> employeeDepartApplyVOList = beanSearcher.searchList(EmployeeDepartApplyBSVO.class, mapBuilder.build());

        return PagingVO.<EmployeeDepartApplyBSVO>builder().records(employeeDepartApplyVOList).total((Long) totalNum).build();
    }


    /**
     * 拼装where条件
     *
     * @param query 查询条件
     * @return 检索参数构建器
     */
    private MapBuilder pageWhereBuilder(EmployeeDepartApplyQuery query) {
        MapBuilder builder = MapUtils.builder();
        // 付款申请单名称/编号
//        if (!ObjectUtils.isEmpty(query.getPaymentNameOrNo())) {
//            String likeStr = "%" + query.getPaymentNameOrNo() + "%";
//            builder.field(PurchasePaymentVO::getPurchaseName, PurchasePaymentVO::getPaymentNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
//        }
//        // 付款申请单类型
//        if (!ObjectUtils.isEmpty(query.getPaymentApplicationType())) {
//            builder.field(PurchasePaymentVO::getPaymentApplicationType, query.getPaymentApplicationType()).op(FieldOps.Equal);
//        }
//        // 付款公司地址簿Id
//        if (!ObjectUtils.isEmpty(query.getPayCompanyBookId())) {
//            builder.field(PurchasePaymentVO::getPayCompanyBookId, query.getPayCompanyBookId()).op(FieldOps.Equal);
//        }
//        // 供应商
//        if (!ObjectUtils.isEmpty(query.getPayCompanyBookId())) {
//            builder.field(PurchasePaymentVO::getSupplierLegalBookId, query.getSupplierLegalBookId()).op(FieldOps.Equal);
//        }
//        // 供应商
//        if (!ObjectUtils.isEmpty(query.getPayCompanyBookId())) {
//            builder.field(PurchasePaymentVO::getSupplierLegalBookId, query.getSupplierLegalBookId()).op(FieldOps.Equal);
//        }
//        // 付款申请单状态
//        if (!ObjectUtils.isEmpty(query.getState())) {
//            builder.field(PurchasePaymentVO::getState, query.getState()).op(FieldOps.Equal);
//        }
//        // 验收方式
//        if (!ObjectUtils.isEmpty(query.getAcceptanceType())) {
//            builder.field(PurchasePaymentVO::getAcceptanceType, query.getAcceptanceType()).op(FieldOps.Equal);
//        }
//        // 关联销售合同
//        if (!ObjectUtils.isEmpty(query.getRelatedSalesContract())) {
//            builder.field(PurchasePaymentVO::getRelatedSalesContract, query.getRelatedSalesContract()).op(FieldOps.Equal);
//        }
//        // 关联项目号
//        if (!ObjectUtils.isEmpty(query.getRelatedProjectNo())) {
//            builder.field(PurchasePaymentVO::getRelatedProjectNo, query.getRelatedProjectNo()).op(FieldOps.Equal);
//        }
//        builder.field(EmployeeDepartApplyBSVO::getDeleteFlag, 0).op(FieldOps.Equal);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    public void updateWorkFlowVar(EmployeeDepartPayload payload) {
        HashMap<String, Object> variables = setWorkFlowVar(payload);
        SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
        setVariablesPayload.setProcInstId(payload.getProcInstId());
        setVariablesPayload.setVariables(variables);
        workflowUtil.setVaribales(setVariablesPayload);
    }

    @Override
    public EmployeeDepartApplyVO queryByKey(Long applyId) {
        return departApplyDAO.queryByKey(applyId);
    }


    // 发通知给人事 平台人力资源总监 平台员工关系主管 平台员工关系专员 平台薪酬绩效主管 平台薪酬绩效专员
    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERM.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERS.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));

        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }
}
