package com.elitesland.tw.tw5.server.prd.humanresources.recommended.controller;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdInternalRecommQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @folder 内部招聘-我的推荐
 * @date 2023-12-14
 */
@Api(tags = "内部招聘-我的推荐")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdInternalRecomm")
@Slf4j
public class PrdInternalRecommController {

    private final PrdInternalRecommService prdInternalRecommService;

    /**
     * 内部招聘-我的推荐-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 内部招聘-我的推荐
     */
    @PostMapping
    @ApiOperation("内部招聘-我的推荐-新增")
    public TwOutputUtil<PrdInternalRecommVO> insert(@RequestBody PrdInternalRecommPayload payload) {
        return TwOutputUtil.ok(prdInternalRecommService.insert(payload));
    }

    /**
     * 内部招聘-我的推荐-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 内部招聘-我的推荐
     */
    @PutMapping
    @ApiOperation("内部招聘-我的推荐-更新")
    public TwOutputUtil<PrdInternalRecommVO> update(@RequestBody PrdInternalRecommPayload payload) {
        return TwOutputUtil.ok(prdInternalRecommService.update(payload));
    }

    /**
     * 内部招聘-我的推荐-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 内部招聘-我的推荐
     */
    @PutMapping("update")
    @ApiOperation("内部招聘-我的推荐-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdInternalRecommPayload payload) {
        return TwOutputUtil.ok(prdInternalRecommService.updateByKeyDynamic(payload));
    }

    /**
     * 内部招聘-我的推荐-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 内部招聘-我的推荐
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("内部招聘-我的推荐-主键查询")
    public TwOutputUtil<PrdInternalRecommVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdInternalRecommService.queryByKey(key));
    }

    /**
     * 内部招聘-我的推荐-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 内部招聘-我的推荐
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("内部招聘-我的推荐-分页")
    public TwOutputUtil<PagingVO<PrdInternalRecommVO>> paging(PrdInternalRecommQuery query) {
        return TwOutputUtil.ok(prdInternalRecommService.queryPaging(query));
    }

    /**
     * 内部招聘-我的推荐-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 内部招聘-我的推荐
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("内部招聘-我的推荐-查询列表")
    public TwOutputUtil<List<PrdInternalRecommVO>> queryList(PrdInternalRecommQuery query) {
        return TwOutputUtil.ok(prdInternalRecommService.queryListDynamic(query));
    }

    /**
     * 内部招聘-我的推荐-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 内部招聘-我的推荐
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("内部招聘-我的推荐-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdInternalRecommService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

