package com.elitesland.tw.tw5.server.prd.inv.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceDocRefPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDocRefQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceDocRefService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDocRefVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceDocRefConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceDocRefDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceDocRefDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceDocRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 发票单据关联管理
 *
 * @author sunxw
 * @date 2023-12-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvInvoiceDocRefServiceImpl extends BaseServiceImpl implements InvInvoiceDocRefService {

    private final InvInvoiceDocRefRepo repo;
    private final InvInvoiceDocRefDAO dao;

    @Override
    public PagingVO<InvInvoiceDocRefVO> queryPaging(InvInvoiceDocRefQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<InvInvoiceDocRefVO> queryListDynamic(InvInvoiceDocRefQuery query) {
        return dao.queryListDynamic(query);
    }

    @Override
    public List<Long> queryByDtlIdAndType(Long docDtlId, String docType) {
        return dao.queryByDtlIdAndType(docDtlId, docType);
    }

    @Override
    public InvInvoiceDocRefVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    @Transactional
    public InvInvoiceDocRefVO insert(InvInvoiceDocRefPayload payload) {
        InvInvoiceDocRefDO entityDo = InvInvoiceDocRefConvert.INSTANCE.toDo(payload);
        return InvInvoiceDocRefConvert.INSTANCE.toVo(repo.save(entityDo));
    }

    @Override
    @Transactional
    public long batchInsert(List<InvInvoiceDocRefPayload> payloads) {
        List<InvInvoiceDocRefDO> entityDos = InvInvoiceDocRefConvert.INSTANCE.payloads2Dos(payloads);
        List<InvInvoiceDocRefDO> invInvoiceDocRefDOS = dao.saveAll(entityDos);
        return invInvoiceDocRefDOS.size();
    }

    @Override
    @Transactional
    public InvInvoiceDocRefVO update(InvInvoiceDocRefPayload payload) {
        InvInvoiceDocRefDO entity = repo.findById(payload.getId()).orElseGet(InvInvoiceDocRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceDocRefDO entityDo = InvInvoiceDocRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvInvoiceDocRefConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(InvInvoiceDocRefPayload payload) {
        InvInvoiceDocRefDO entity = repo.findById(payload.getId()).orElseGet(InvInvoiceDocRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = dao.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void delByDocIdAndType(Long docId, String docType) {
        dao.delByDocIdAndType(docId, docType);
    }

}
