package com.elitesland.tw.tw5.server.prd.my.callback;

import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "REWARD_LEAVE_APPLY" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class RewardLeaveApplyWorkFlowCallBack implements WorkflowCallBack {

    private final RewardLeaveApplyDAO rewardLeaveApplyDAO;

    private final RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO;

    private final TaskInfoService taskInfoService;

    private final UserVacationService userVacationService;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        RewardLeaveApplyPayload rewardLeaveApplyPayload = new RewardLeaveApplyPayload();
        rewardLeaveApplyPayload.setId(applyId);
        RewardLeaveApplyVO applyVO = rewardLeaveApplyDAO.queryByKey(applyId);
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                //一般情况将单据状态变成"激活",流程状态改为未提交
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                if (applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                    taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                }
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.INTERRUPT);
                break;
            case INVALID://仅删除流程
                rewardLeaveApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                rewardLeaveApplyPayload.setDeleteFlag(1);
                if (applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                    taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                }
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                //将单据状态变为新建状态
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                if (applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                    taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                }
                break;
            case APPROVED:
                RewardLeaveApplyDetailQuery rewardLeaveApplyDetailQuery = new RewardLeaveApplyDetailQuery();
                rewardLeaveApplyDetailQuery.setApplyId(applyId);
                List<RewardLeaveApplyDetailVO> detailVOList = rewardLeaveApplyDetailDAO.queryListDynamic(rewardLeaveApplyDetailQuery);
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                rewardLeaveApplyPayload.setApprovedTime(LocalDateTime.now());
                //任务结算
                if (applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                    taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                }
                //生成假期
                for (RewardLeaveApplyDetailVO detailVO : detailVOList) {
                    UserVacationPayload userVacationPayload = new UserVacationPayload();
                    userVacationPayload.setVacationType("REWARD");
                    userVacationPayload.setExpirationDate(applyVO.getPlanEndDate());
                    userVacationPayload.setTotalDays(detailVO.getDays());
                    userVacationPayload.setReasonId(applyVO.getReasonId());
                    userVacationPayload.setReasonType(applyVO.getReasonType());
                    userVacationPayload.setUserId(detailVO.getUserId());
                    userVacationPayload.setVacationYear((long) applyVO.getPlanEndDate().getYear());
                    userVacationPayload.setTotalDays(detailVO.getDays());
                    userVacationPayload.setStartDate(applyVO.getPlanStartDate());
                    userVacationPayload.setEndDate(applyVO.getPlanEndDate());
                    userVacationPayload.setUsedDays(BigDecimal.ZERO);
                    userVacationService.saveRewardLeave(userVacationPayload);
                }
                break;
            case APPROVING:
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                break;
        }
        rewardLeaveApplyDAO.updateByKeyDynamic(rewardLeaveApplyPayload);
        return WorkflowResult.success(null);
    }

}
