package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyConfigVO;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyConfigService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 远程办公审批配置
 *
 * @folder 远程办公审批配置
 * @author wangly
 * @date 2024-06-13
 */
@Api(tags = "远程办公审批配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/abnormalWorkApplyConfig")
@Slf4j
public class AbnormalWorkApplyConfigController {

private final AbnormalWorkApplyConfigService abnormalWorkApplyConfigService;

    /**
     * 远程办公审批配置-新增
     *
     * @folder 远程办公审批配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("远程办公审批配置-新增")
    public TwOutputUtil<AbnormalWorkApplyConfigVO> insert(@RequestBody AbnormalWorkApplyConfigPayload payload){
         return TwOutputUtil.ok(abnormalWorkApplyConfigService.insert(payload));
    }

    /**
     * 远程办公审批配置-更新
     *
         * @folder 远程办公审批配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("远程办公审批配置-更新")
    public TwOutputUtil<AbnormalWorkApplyConfigVO> update(@RequestBody AbnormalWorkApplyConfigPayload payload){
        return TwOutputUtil.ok(abnormalWorkApplyConfigService.update(payload));
    }

    /**
     * 远程办公审批配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 远程办公审批配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("远程办公审批配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AbnormalWorkApplyConfigPayload payload){
        return TwOutputUtil.ok(abnormalWorkApplyConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 远程办公审批配置-主键查询
     *
     * @folder 远程办公审批配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("远程办公审批配置-主键查询")
    public TwOutputUtil<AbnormalWorkApplyConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(abnormalWorkApplyConfigService.queryByKey(key));
    }

    /**
     * 远程办公审批配置-分页
     *
         * @folder 远程办公审批配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("远程办公审批配置-分页")
    public TwOutputUtil<PagingVO<AbnormalWorkApplyConfigVO>> paging(AbnormalWorkApplyConfigQuery query) {
        return TwOutputUtil.ok(abnormalWorkApplyConfigService.queryPaging(query));
    }

    /**
     * 远程办公审批配置-查询列表
     *
     * @folder 远程办公审批配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("远程办公审批配置-查询列表")
    public TwOutputUtil<List<AbnormalWorkApplyConfigVO>> queryList(AbnormalWorkApplyConfigQuery query) {
        return TwOutputUtil.ok(abnormalWorkApplyConfigService.queryListDynamic(query));
    }

    /**
     * 远程办公审批配置-删除
     *
         * @folder 远程办公审批配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("远程办公审批配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         abnormalWorkApplyConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

