package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceNormalPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceLogVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalMonthVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceNormalDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceRemarkDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceRuleDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceNormalDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceNormalRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;


@Repository
@RequiredArgsConstructor
public class TAttendanceNormalMonthDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TAttendanceNormalRepo repo;
    private final QTAttendanceNormalDO qdo = QTAttendanceNormalDO.tAttendanceNormalDO;

    private final QTAttendanceRuleDO qtAttendanceRuleDO = QTAttendanceRuleDO.tAttendanceRuleDO;

    private final QTAttendanceRemarkDO qtAttendanceRemarkDO = QTAttendanceRemarkDO.tAttendanceRemarkDO;


    private final QPrdOrgEmployeeRefDO qPrdOrgEmployeeRefDO = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO odo = QPrdOrgOrganizationDO.prdOrgOrganizationDO;

    private static final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceNormalMonthVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TAttendanceNormalMonthVO.class,
                        qdo.id,
                        //qdo.remark,
                        //qdo.createUserId,
                        //qdo.creator,
                        //qdo.createTime,
                        //qdo.modifyUserId,
                        //qdo.updater,
                        //qdo.modifyTime,
                        // 打卡人员ID
                        qdo.attendanceResId,
                        // 部门
                        qPrdOrgEmployeeRefDO.orgId,
                        // 打卡月份
                        Expressions.dateTemplate(String.class, "function('CONCAT', function('YEAR', {0}), '-', LPAD(function('MONTH', {0}), 2, '0'))", qdo.attendanceDate).as("attendanceMonth"),
                        // 打卡状态
                        Expressions.stringTemplate("group_concat({0})", qdo.attendanceResultDetail).as("attendanceResultDetailStr"),
                        // 规则ID
                        qdo.attendanceRuleId,
                        // 规则名称
                        qtAttendanceRuleDO.ruleName,
                        // 城市
                        qdo.attendanceCity,
                        // base地
                        employeeDO.extString5.as("baseCity")
                )).from(qdo).leftJoin(employeeDO).on(employeeDO.userId.longValue().eq(qdo.attendanceResId.longValue()))
                .leftJoin(qPrdOrgEmployeeRefDO).on(qdo.attendanceResId.longValue().eq(qPrdOrgEmployeeRefDO.userId.longValue()).and(qPrdOrgEmployeeRefDO.isDefault.eq(0)).and(qPrdOrgEmployeeRefDO.deleteFlag.eq(0)))
                .leftJoin(qtAttendanceRuleDO).on(qtAttendanceRuleDO.id.eq(qdo.attendanceRuleId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceNormalMonthVO> getJpaQueryWhere(TAttendanceNormalQuery query) {
        JPAQuery<TAttendanceNormalMonthVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        //jpaQuery.groupBy(Expressions.dateTemplate(Integer.class, "year({0})", qdo.attendanceDate), Expressions.dateTemplate(Integer.class, "month({0})", qdo.attendanceDate));
        jpaQuery.groupBy(qdo.attendanceResId, Expressions.dateTemplate(Integer.class, "year({0})", qdo.attendanceDate), Expressions.dateTemplate(Integer.class, "month({0})", qdo.attendanceDate));
//        jpaQuery.groupBy(Expressions.stringTemplate("${attendanceResId}-${attendanceDate}", Map.of("attendanceResId", qdo.attendanceResId, "attendanceDate", qdo.attendanceDate)));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TAttendanceNormalQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(employeeDO).on(employeeDO.userId.longValue().eq(qdo.attendanceResId.longValue()))
                .from(qdo).leftJoin(qPrdOrgEmployeeRefDO).on(qdo.attendanceResId.longValue().eq(qPrdOrgEmployeeRefDO.userId.longValue()).and(qPrdOrgEmployeeRefDO.isDefault.eq(0)).and(qPrdOrgEmployeeRefDO.deleteFlag.eq(0)))
                .leftJoin(qtAttendanceRuleDO).on(qtAttendanceRuleDO.id.eq(qdo.attendanceRuleId));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TAttendanceNormalQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 打卡人员ID 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceResId())) {
            list.add(qdo.attendanceResId.eq(query.getAttendanceResId()));
        }
        /** 打卡人员I部门id 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(qPrdOrgEmployeeRefDO.orgId.eq(query.getOrgId()));
        }
        /** 打卡日期 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceDate())) {
            list.add(qdo.attendanceDate.eq(query.getAttendanceDate()));
        }
        /** 打卡日期    区间 */
        if (!ObjectUtils.isEmpty(query.getAttendanceDates())) {
            list.add(qdo.attendanceDate.between(query.getAttendanceDates().get(0), query.getAttendanceDates().get(1)));
        }
        /** 规则ID 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceRuleId())) {
            list.add(qdo.attendanceRuleId.eq(query.getAttendanceRuleId()));
        }
        /** 上班时间 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceTimeStart())) {
            list.add(qdo.attendanceTimeStart.eq(query.getAttendanceTimeStart()));
        }
        /** 下班时间 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceTimeEnd())) {
            list.add(qdo.attendanceTimeEnd.eq(query.getAttendanceTimeEnd()));
        }
        /** 打卡结果 YSE/NO 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceResult())) {
            list.add(qdo.attendanceResult.eq(query.getAttendanceResult()));
        }
        /** 正常、迟到或早退、矿工 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceResultDetail())) {
            list.add(qdo.attendanceResultDetail.eq(query.getAttendanceResultDetail()));
        }
        /** 特殊打卡原因 精确 */
        if (!ObjectUtils.isEmpty(query.getSpecialReason())) {
            list.add(qdo.specialReason.eq(query.getSpecialReason()));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceDevice())) {
            list.add(qdo.attendanceDevice.eq(query.getAttendanceDevice()));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceSiteLatitude())) {
            list.add(qdo.attendanceSiteLatitude.eq(query.getAttendanceSiteLatitude()));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceSiteLongitude())) {
            list.add(qdo.attendanceSiteLongitude.eq(query.getAttendanceSiteLongitude()));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceLocation())) {
            list.add(qdo.attendanceLocation.eq(query.getAttendanceLocation()));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceCity())) {
            list.add(qdo.attendanceCity.like(SqlUtil.toSqlLikeString(query.getAttendanceCity())));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getBaseCity())) {
            list.add(employeeDO.extString5.eq(query.getBaseCity()));
        }
        /** 资源经理 */
        if (!ObjectUtils.isEmpty(query.getResManagerId())) {
            list.add(employeeDO.resManagerId.eq(query.getResManagerId()));
        }
        if (!ObjectUtils.isEmpty(query.getAttendanceMonths())) {
            String startMonth = query.getAttendanceMonths().get(0);
            String endMonth = query.getAttendanceMonths().get(1);

            // 使用DateTimeFormatter解析字符串
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate startDate = LocalDate.parse(startMonth + "-01", formatter);

            LocalDate endMonthFirstDay = LocalDate.parse(endMonth + "-01", formatter);
            LocalDate endDate = endMonthFirstDay.with(TemporalAdjusters.lastDayOfMonth());

            list.add(qdo.attendanceDate.between(startDate, endDate));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TAttendanceNormalMonthVO queryByKey(Long id) {
        JPAQuery<TAttendanceNormalMonthVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TAttendanceNormalMonthVO> queryListDynamic(TAttendanceNormalQuery query) {
        JPAQuery<TAttendanceNormalMonthVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TAttendanceNormalMonthVO> queryPaging(TAttendanceNormalQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TAttendanceNormalMonthVO> jpaQuery = getJpaQueryWhere(query);
        List<TAttendanceNormalMonthVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TAttendanceNormalMonthVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TAttendanceNormalDO save(TAttendanceNormalDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TAttendanceNormalDO> saveAll(List<TAttendanceNormalDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TAttendanceNormalPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 打卡人员ID
        if (payload.getAttendanceResId() != null) {
            update.set(qdo.attendanceResId, payload.getAttendanceResId());
        }
        // 打卡日期
        if (payload.getAttendanceDate() != null) {
            update.set(qdo.attendanceDate, payload.getAttendanceDate());
        }
        // 规则ID
        if (payload.getAttendanceRuleId() != null) {
            update.set(qdo.attendanceRuleId, payload.getAttendanceRuleId());
        }
        // 上班时间
        if (payload.getAttendanceTimeStart() != null) {
            update.set(qdo.attendanceTimeStart, payload.getAttendanceTimeStart());
        }
        // 下班时间
        if (payload.getAttendanceTimeEnd() != null) {
            update.set(qdo.attendanceTimeEnd, payload.getAttendanceTimeEnd());
        }
        // 打卡结果 YSE/NO
        if (payload.getAttendanceResult() != null) {
            update.set(qdo.attendanceResult, payload.getAttendanceResult());
        }
        // 正常、迟到或早退、矿工
        if (payload.getAttendanceResultDetail() != null) {
            update.set(qdo.attendanceResultDetail, payload.getAttendanceResultDetail());
        }
        // 特殊打卡原因
        if (payload.getSpecialReason() != null) {
            update.set(qdo.specialReason, payload.getSpecialReason());
        }
        // 打卡设备
        if (payload.getAttendanceDevice() != null) {
            update.set(qdo.attendanceDevice, payload.getAttendanceDevice());
        }
        // 经度
        if (payload.getAttendanceSiteLongitude() != null) {
            update.set(qdo.attendanceSiteLongitude, payload.getAttendanceSiteLongitude());
        }
        // 纬度
        if (payload.getAttendanceSiteLatitude() != null) {
            update.set(qdo.attendanceSiteLatitude, payload.getAttendanceSiteLatitude());
        }
        // 打卡地址
        if (payload.getAttendanceLocation() != null) {
            update.set(qdo.attendanceLocation, payload.getAttendanceLocation());
        }
        // 打卡城市
        if (payload.getAttendanceCity() != null) {
            update.set(qdo.attendanceCity, payload.getAttendanceCity());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 打卡人员ID
            if (nullFields.contains("attendanceResId")) {
                update.setNull(qdo.attendanceResId);
            }
            // 打卡日期
            if (nullFields.contains("attendanceDate")) {
                update.setNull(qdo.attendanceDate);
            }
            // 规则ID
            if (nullFields.contains("attendanceRuleId")) {
                update.setNull(qdo.attendanceRuleId);
            }
            // 上班时间
            if (nullFields.contains("attendanceTimeStart")) {
                update.setNull(qdo.attendanceTimeStart);
            }
            // 下班时间
            if (nullFields.contains("attendanceTimeEnd")) {
                update.setNull(qdo.attendanceTimeEnd);
            }
            // 打卡结果 YSE/NO
            if (nullFields.contains("attendanceResult")) {
                update.setNull(qdo.attendanceResult);
            }
            // 正常、迟到或早退、矿工
            if (nullFields.contains("attendanceResultDetail")) {
                update.setNull(qdo.attendanceResultDetail);
            }
            // 特殊打卡原因
            if (nullFields.contains("specialReason")) {
                update.setNull(qdo.specialReason);
            }
            // 打卡设备
            if (nullFields.contains("attendanceDevice")) {
                update.setNull(qdo.attendanceDevice);
            }
            // 经度
            if (nullFields.contains("attendanceSiteLongitude")) {
                update.setNull(qdo.attendanceSiteLongitude);
            }
            // 纬度
            if (nullFields.contains("attendanceSiteLatitude")) {
                update.setNull(qdo.attendanceSiteLatitude);
            }
            // 打卡地址
            if (nullFields.contains("attendanceLocation")) {
                update.setNull(qdo.attendanceLocation);
            }
            // 打卡城市
            if (nullFields.contains("attendanceCity")) {
                update.setNull(qdo.attendanceCity);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


    public List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate) {
        return jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .where(qdo.attendanceResId.eq(resId).and(qdo.attendanceDate.eq(attendanceDate)))
                .orderBy(qdo.attendanceTimeStart.desc())
                .fetch();
    }

    public String findStartTime(Long id) {
        return jpaQueryFactory.select(qdo.attendanceTimeStart)
                .from(qdo)
                .where(qdo.id.eq(id))
                .fetchOne();
    }

    public String findResAttendanceStatus(Long id) {
        return jpaQueryFactory.select(qdo.attendanceResultDetail)
                .from(qdo)
                .where(qdo.id.eq(id))
                .fetchOne();
    }

    public String findResAttendanceResult(Long id) {
        return jpaQueryFactory.select(qdo.attendanceResult)
                .from(qdo)
                .where(qdo.id.eq(id))
                .fetchOne();
    }

    public List<MobAttendanceLogVO> getResAttendanceLog(Long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        JPAQuery<MobAttendanceLogVO> jpaQuery = jpaQueryFactory.select(Projections.bean(MobAttendanceLogVO.class,
                        qdo.id,
                        qdo.attendanceDate,
                        qdo.frozen
                )).from(qdo)
                .innerJoin(qtAttendanceRuleDO).on(qtAttendanceRuleDO.id.eq(qdo.attendanceRuleId))
                .where(qdo.attendanceResId.eq(resId));
        if (attendanceDateStart != null) {
            jpaQuery.where(qdo.attendanceDate.goe(attendanceDateStart));
        }
        if (attendanceDateEnd != null) {
            jpaQuery.where(qdo.attendanceDate.loe(attendanceDateEnd));
        }
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.desc("attendanceTimeStart"));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        return jpaQuery.fetch();
    }

    public TAttendanceNormalMonthVO getAttendanceNormal(Long attendanceId) {
        return jpaQueryFactory.select(Projections.bean(TAttendanceNormalMonthVO.class,
                        qdo.id,
                        qdo.attendanceRuleId,
                        qdo.attendanceDate,
                        qdo.attendanceTimeStart,
                        qdo.attendanceTimeEnd,
                        qdo.attendanceSiteLongitude,
                        qdo.attendanceSiteLatitude,
                        qdo.attendanceLocation,
                        qdo.specialReason,
                        qdo.attendanceResultDetail,
                        qdo.attendanceResult,
                        qtAttendanceRemarkDO.approvalResult,
                        qtAttendanceRemarkDO.rejectedCause,
                        qtAttendanceRemarkDO.attendanceAbnormalDesc,
                        qtAttendanceRuleDO.ruleName
                ))
                .from(qdo)
                .innerJoin(qtAttendanceRuleDO).on(qtAttendanceRuleDO.id.eq(qdo.attendanceRuleId))
                .leftJoin(qtAttendanceRemarkDO).on(qtAttendanceRemarkDO.tAttendanceNormalId.eq(qdo.id))
                .where(qdo.id.eq(attendanceId))
                .fetchOne();
    }

}

