package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetBiweeklyDetailTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetBiweeklyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetBiweeklyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetBiweeklyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetBiweeklyReadFlagDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 双周计划
 *
 * @author duwh
 * @date 2022-12-21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TimesheetBiweeklyServiceImpl implements TimesheetBiweeklyService {

    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final PrdUserService prdUserService;
    private final TimesheetService timesheetService;
    private final TimesheetRepo timesheetRepo;
    private final TimesheetPlanService timesheetPlanService;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetBiweeklyDetailService timesheetBiweeklyDetailService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final PrdUserDAO daoUser;
    private final TimesheetBiweeklyDAO timesheetBiweeklyDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;

    @Override
    public PagingVO<TimesheetBiweeklyVO> paging(TimesheetBiweeklyQuery query) {
        final Specification<TimesheetBiweeklyDO> spec = (root, criteriaQuery, criteriaBuilder) -> {
            final Predicate predicate = QueryHelp.getPredicate(root, query, criteriaBuilder);

            List<Predicate> predicates = new ArrayList<>();
            predicates.add(predicate);
            criteriaQuery.distinct(true);
            List<Predicate> dataFilterQuery = new ArrayList<>();
            // 判断当前登录人是否是系统管理员
            List<Long> userIdsByPlatRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
            if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(query.getUserId())) {
                if (null != query.getUserId() && null == query.getCreateUserId()) {
                    Predicate tsUserId = criteriaBuilder.equal(root.get("tsUserId"), query.getUserId());
                    Predicate receiveUserIds = criteriaBuilder.like(root.get("receiveUserIds"), SqlUtil.toSqlLikeString(query.getUserId() + ""));
                    dataFilterQuery.add(tsUserId);
                    dataFilterQuery.add(receiveUserIds);
                }
                if (!CollectionUtils.isEmpty(dataFilterQuery)) {
                    Predicate[] predicatesListResult = dataFilterQuery.toArray(new Predicate[dataFilterQuery.size()]);
                    //  组合条件  or查询
                    predicates.add(criteriaBuilder.or(predicatesListResult));
                }
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        Page<TimesheetBiweeklyDO> page = timesheetBiweeklyRepo.findAll(spec, query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetBiweeklyConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<TimesheetBiweeklyVO> pagingNew(TimesheetBiweeklyQuery query) {
        //当前登录人
        Long userId = GlobalUtil.getLoginUserId();
        if(query.getCreateUserId()!=null){
            query.setTsUserId(query.getCreateUserId());
            query.setCreateUserId(null);
        }
        // 权限处理
        getPermissionParams(query);
        // 获取当前年周
//        if(ObjectUtils.isEmpty(query.getYearWeek())){
//            query.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(LocalDate.now())));
//        }
        query.setReadUserId(userId);
        PagingVO<TimesheetBiweeklyVO> pagingVO = timesheetBiweeklyDAO.queryListBiweekly(query);
        return pagingVO;
    }


    @Override
    public PagingVO<TimesheetReportFormVO> pagingReportForms(TimesheetBiweeklyQuery query) {
        LocalDate date = LocalDate.now();
        // 如果没传年月，默认当前月
        if(!ObjectUtils.isEmpty(query.getMonthDate())){
            date = LocalDate.parse(query.getMonthDate());
        }
        //本月的第一天
        LocalDate firstDay = LocalDate.of(date.getYear(),date.getMonth(),1);
        //本月的最后一天
        LocalDate lastDay =date.with(TemporalAdjusters.lastDayOfMonth());
        //本月第一天所在周的周一
        WeekFields weekFields= WeekFields.ISO;
        firstDay = firstDay.with(weekFields.dayOfWeek(), 1L);
        //本月最后一天所在周的周日
        lastDay = lastDay.with(weekFields.dayOfWeek(), 7L);
        if(query.getTsUserId()!=null){
            query.setTsUserId(query.getTsUserId());
            query.setCreateUserId(null);
        }
        // 权限处理
        getPermissionParams(query);


//        query.setStartDate(firstday);
//        query.setEndDate(lastDay);
        if (!ObjectUtils.isEmpty(query.getTsbBuId())){
            Set<Long> orgIdList = new HashSet<>();
            orgIdList.add(query.getTsbBuId());
            Set<Long> childOrgs = prdOrgOrganizationDAO.queryAllChildOrgs(orgIdList);
            orgIdList.addAll(childOrgs);
            query.setOrgIdList(orgIdList);
        }
        PagingVO<TimesheetReportFormVO> pagingVO = timesheetBiweeklyDAO.queryTimesheetReport(query);
        List<TimesheetReportFormVO> records = pagingVO.getRecords();
        for (TimesheetReportFormVO record : records) {
            //查询record
            List<LocalDate> tsDateList = timesheetRepo.queryTsDateList(firstDay,lastDay,record.getTsUserId());
            List<LocalDate> planDateList = timesheetPlanRepo.queryPlanDateList(firstDay,lastDay,record.getTsUserId());
            record.setTsDateList(tsDateList);
            record.setPlanDateList(planDateList);
        }
        return pagingVO;
    }



    @Override
    @Transactional
    public TimesheetBiweeklyVO queryByUserIdAndDate(Long userId, LocalDate date) {
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(date));
        //获取当前登录人，标记为已读
        final Long loginUserId = GlobalUtil.getLoginUserId();
        TimesheetBiweeklyReadFlagDO readFlagDO = biweeklyReadFlagRepo.findByUserIdAndReadUserId(userId, loginUserId);
        if(ObjectUtils.isEmpty(readFlagDO)){
            readFlagDO = new TimesheetBiweeklyReadFlagDO();
            readFlagDO.setReadFlag(1);
            readFlagDO.setUserId(userId);
            readFlagDO.setReadUserId(loginUserId);
//            readFlagDO.setYearWeek(yearWeek);
            //插入一条数据，标记为已读
            biweeklyReadFlagRepo.save(readFlagDO);
        }else{
            //更新为已读
            biweeklyReadFlagRepo.updateReadFlagById(readFlagDO.getId(),1);
        }
        LocalDate weekStartDate = date.with(WeekFields.ISO.dayOfWeek(), 1L);
        TimesheetBiweeklyVO vo = new TimesheetBiweeklyVO();
        vo.setCreateUserId(userId);
        vo.setStartWeekDate(weekStartDate);
        vo.setYearWeek(yearWeek);
        vo.setEndWeekDate(weekStartDate.plusDays(6));
        List<TimesheetBiweeklyDetailVO> biweeklyDetailVOS = new ArrayList<>();

        //本周工时列表
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setYearWeek(yearWeek);
        timesheetQuery.setTsUserId(userId);
        List<TimesheetVO> timesheetVOS = timesheetService.queryList(timesheetQuery);
        for (TimesheetVO timesheetVO : timesheetVOS) {
            TimesheetBiweeklyDetailVO biweeklyDetailVO = TimesheetConvert.INSTANCE.toTimesheetBiweeklyDetailVo(timesheetVO);
            biweeklyDetailVO.setTsbDate(timesheetVO.getWorkDate());
            biweeklyDetailVO.setType("20");
            biweeklyDetailVOS.add(biweeklyDetailVO);
        }
        //本周计划列表
        TimesheetPlanQuery thisWeekPlanQuery = new TimesheetPlanQuery();
        thisWeekPlanQuery.setTsUserId(userId);
        thisWeekPlanQuery.setYearWeek(yearWeek);
        List<TimesheetPlanVO> thisWeekTimesheetPlanVOS = timesheetPlanService.queryList(thisWeekPlanQuery);
        for (TimesheetPlanVO thisWeekTimesheetPlanVO : thisWeekTimesheetPlanVOS) {
            TimesheetBiweeklyDetailVO biweeklyDetailVO = TimesheetPlanConvert.INSTANCE.toTimesheetBiweeklyDetailVo(thisWeekTimesheetPlanVO);
            biweeklyDetailVO.setTsbDate(thisWeekTimesheetPlanVO.getWorkDate());
            biweeklyDetailVO.setType("10");
            biweeklyDetailVOS.add(biweeklyDetailVO);
        }
        //下周计划列表
        TimesheetPlanQuery nextWeekPlanQuery = new TimesheetPlanQuery();
        nextWeekPlanQuery.setTsUserId(userId);
        nextWeekPlanQuery.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(date.plusWeeks(1))));
        List<TimesheetPlanVO> nextWeekTimesheetPlanVOS = timesheetPlanService.queryList(nextWeekPlanQuery);
        for (TimesheetPlanVO nextWeekTimesheetPlanVO : nextWeekTimesheetPlanVOS) {
            TimesheetBiweeklyDetailVO biweeklyDetailVO = TimesheetPlanConvert.INSTANCE.toTimesheetBiweeklyDetailVo(nextWeekTimesheetPlanVO);
            biweeklyDetailVO.setTsbDate(nextWeekTimesheetPlanVO.getWorkDate());
            biweeklyDetailVO.setType("30");
            biweeklyDetailVOS.add(biweeklyDetailVO);
        }

        vo.setDetailList(biweeklyDetailVOS);
        return vo;
    }





    private void getPermissionParams(TimesheetBiweeklyQuery query){
        if(query.getIsPermission()){
            final Long loginUserId = GlobalUtil.getLoginUserId();
//            final Long loginUserId = 579785889740361181L;


            // 判断 管理员 
//            final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
//            if (!isSystemAdmin) {
                // 判断当前登录人是否是系统管理员
                List<Long> userIdsByPlatRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(),RoleEnum.TIME_SHEET_MANAGER.getCode()));
                // BU级权限（查看当前登录人是否是部门负责人）
                final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                    //查询所有子部门
                    Set<Long> childOrgs = prdOrgOrganizationDAO.queryAllChildOrgs(orgIdList);
                    orgIdList.addAll(childOrgs);
                }
                // 上下级权限
                //查出来userId的所有下级userId
                final List<PrdOrgEmployeeRefVO> empRef = daoUser.queryLowListByKey(null, loginUserId);
                final Set<Long> empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                // 有没有平台级权限
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    Set<Long> queryUserIds = new HashSet<>();
                    //最基础的权限要查看自己
                    queryUserIds.add(loginUserId);
                    //有没有部门级别权限
                    if(orgIdList!=null && !orgIdList.isEmpty()){
                        // 部门成员
                        //查询部门下的成员
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set<Long> collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if(empRefUserIdList!=null && !empRefUserIdList.isEmpty()){
                        // 查询下级
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setUserIdList(queryUserIds);
                }
//            }
        }
    }


    @Override
    public List<TimesheetBiweeklyVO> queryList(TimesheetBiweeklyQuery query) {
        return TimesheetBiweeklyConvert.INSTANCE.toVoList(timesheetBiweeklyRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetBiweeklyVO queryByKey(Long key) {
        TimesheetBiweeklyDO entity = timesheetBiweeklyRepo.findById(key).orElseGet(TimesheetBiweeklyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetBiweeklyVO vo = TimesheetBiweeklyConvert.INSTANCE.toVo(entity);

        TimesheetBiweeklyDetailQuery query = new TimesheetBiweeklyDetailQuery();
        query.setTsbId(vo.getId());
        final List<TimesheetBiweeklyDetailVO> timesheetBiweeklyDetailVOS = timesheetBiweeklyDetailService.queryList(query);
        // 明细数据
        vo.setDetailList(timesheetBiweeklyDetailVOS);

        //如果是审批人查看 更改已读
        if (entity.getReceiveUserIds().contains(GlobalUtil.getLoginUserId() + "")) {
            TimesheetBiweeklyPayload update = new TimesheetBiweeklyPayload();
            update.setId(key);
            update.setIsRead(1);
            update(update);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetBiweeklyVO insert(TimesheetBiweeklyPayload payload) {
        // 生成周报日期 后台可以判断是哪个周, 不传值默认今天
        if (payload.getGenerateDate() == null) {
            payload.setGenerateDate(LocalDate.now());
        }
        final Long userId = GlobalUtil.getLoginUserId();
        // 生成周报需要校验，上传周报时间范围的下周工作计划不能为空，本周工时不可为空；
        //下周工作计划不填写，点击【生成周报】，需提醒“请填写下周工作计划”
        //本周工时没写，点击【生成周报】，需提醒“请填写本周工作日志”
        //二者都没填写，需优先进行工时校验
        final LocalDate startWeekDay = DateUtil.getStartWeekDay(payload.getGenerateDate());
        // 周五
        LocalDate endWeekDay = DateUtil.getEndWeekDay(payload.getGenerateDate());
        // 周日
        endWeekDay = endWeekDay.plusDays(2);

        // 校验本周工作计划
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        List<LocalDate> workDatePlanList = new ArrayList<>();
        workDatePlanList.add(startWeekDay);
        workDatePlanList.add(endWeekDay);
        timesheetPlanQuery.setWorkDate(workDatePlanList);
        timesheetPlanQuery.setTsUserId(userId);
        // 值无所谓
        timesheetPlanQuery.setWorkDescNotNull("null");
        final List<TimesheetPlanVO> timesheetPlanVOList = timesheetPlanService.queryList(timesheetPlanQuery);
        //if (CollectionUtils.isEmpty(timesheetPlanVOList)) {
        //    throw TwException.error("", "请填写本周工作计划");
        //}

        // 校验本周工时填写情况
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        List<LocalDate> workDateList = new ArrayList<>();
        workDateList.add(startWeekDay);
        workDateList.add(endWeekDay);
        timesheetQuery.setWorkDateBetween(workDateList);
        timesheetQuery.setTsUserId(userId);
        List<String> tsStatusList = new ArrayList<>();
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.SETTLED.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        final List<TimesheetVO> timesheetVOList = timesheetService.queryList(timesheetQuery);
        if (CollectionUtils.isEmpty(timesheetVOList)) {
            throw TwException.error("", "请填写本周工作日志，确保工时状态为审批中、已审批");
        }

        // 校验下周工作计划
        final LocalDate nextStartWeekDay = startWeekDay.plusDays(7);
        final LocalDate nextEndWeekDay = endWeekDay.plusDays(7);
        TimesheetPlanQuery timesheetPlanNextQuery = new TimesheetPlanQuery();
        List<LocalDate> workDatePlanNextList = new ArrayList<>();
        workDatePlanNextList.add(nextStartWeekDay);
        workDatePlanNextList.add(nextEndWeekDay);
        timesheetPlanNextQuery.setWorkDate(workDatePlanNextList);
        timesheetPlanNextQuery.setTsUserId(userId);
        // 值无所谓
        timesheetPlanNextQuery.setWorkDescNotNull("null");
        final List<TimesheetPlanVO> timesheetPlanVONextList = timesheetPlanService.queryList(timesheetPlanNextQuery);
        //if (CollectionUtils.isEmpty(timesheetPlanVONextList)) {
        //    throw TwException.error("", "请填写下周工作计划");
        //}

        // 初始化数据
        initData(payload);

        //（2） 点击生成周报后，撤回一条工作日志，重新点击生成周报进行数据覆盖
        //（3） 修改工作计划以后需要重新生成周报，选择周报所属时间段进行数据覆盖

        // 先判断有没有生成周报，有的话 ，提示不能重复提交
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setStartWeekDateQuery(startWeekDay);
        timesheetBiweeklyQuery.setTsUserId(userId);
        final List<TimesheetBiweeklyVO> timesheetBiweeklyVOS = queryList(timesheetBiweeklyQuery);
        List<TimesheetBiweeklyDetailPayload> timesheetBiweeklyDetailPayloadList = new ArrayList<>();
        TimesheetBiweeklyVO timesheetBiweeklyVOResult;
        if (!CollectionUtils.isEmpty(timesheetBiweeklyVOS)) {
            timesheetBiweeklyVOResult = timesheetBiweeklyVOS.get(0);
            //throw TwException.error("", "请勿重复提交");
            final List<Long> delIdArr = timesheetBiweeklyVOS.stream().map(timesheetBiweeklyVO -> timesheetBiweeklyVO.getId()).collect(Collectors.toList());
            //deleteSoft(delIdArr);
            //// 删除 周报明细
            //timesheetBiweeklyDetailService.deleteSoftByTsbIds(delIdArr);

            // 只更新工时周报情况
            timesheetBiweeklyDetailService.deleteSoftByTsbIds(delIdArr, TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
            // 保存明细 本周工时
            timesheetVOList.forEach(timesheetVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVOResult.getId());
                week.setExt1(StringUtils.hasText(timesheetVO.getType()) ? timesheetVO.getType() : "PROJ");
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
                week.setYearWeek(timesheetVO.getYearWeek());
                week.setProjId(timesheetVO.getProjId());
                week.setProjectName(timesheetVO.getProjName());
                week.setTaskId(timesheetVO.getTaskId());
                week.setTaskName(timesheetVO.getTaskName());
                week.setActId(timesheetVO.getActId());
                week.setActName(timesheetVO.getActName());
                week.setTsbDate(timesheetVO.getWorkDate());
                week.setWorkDesc(timesheetVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });

        } else {
            // 插入新数据
            TimesheetBiweeklyDO entityDo = TimesheetBiweeklyConvert.INSTANCE.toDo(payload);
            final TimesheetBiweeklyVO timesheetBiweeklyVO = TimesheetBiweeklyConvert.INSTANCE.toVo(timesheetBiweeklyRepo.save(entityDo));
            timesheetBiweeklyVOResult = timesheetBiweeklyVO;

            // 保存明细 本周工作计划
            timesheetPlanVOList.forEach(timesheetPlanVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO.getId());
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET_PLAN.getCode());
                week.setExt1(StringUtils.hasText(timesheetPlanVO.getType()) ? timesheetPlanVO.getType() : "PROJ");
                week.setYearWeek(timesheetPlanVO.getYearWeek());
                week.setProjId(timesheetPlanVO.getProjId());
                week.setProjectName(timesheetPlanVO.getProjName());
                week.setTaskId(timesheetPlanVO.getTaskId());
                week.setTaskName(timesheetPlanVO.getTaskName());
                week.setActId(timesheetPlanVO.getActId());
                week.setActName(timesheetPlanVO.getActName());
                week.setTsbDate(timesheetPlanVO.getWorkDate());
                week.setWorkDesc(timesheetPlanVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });

            // 保存明细 下周工作计划
            timesheetPlanVONextList.forEach(timesheetPlanVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO.getId());
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET_PLAN_NEXT_WEEK.getCode());
                week.setExt1(StringUtils.hasText(timesheetPlanVO.getType()) ? timesheetPlanVO.getType() : "PROJ");
                week.setYearWeek(timesheetPlanVO.getYearWeek());
                week.setProjId(timesheetPlanVO.getProjId());
                week.setProjectName(timesheetPlanVO.getProjName());
                week.setTaskId(timesheetPlanVO.getTaskId());
                week.setTaskName(timesheetPlanVO.getTaskName());
                week.setActId(timesheetPlanVO.getActId());
                week.setActName(timesheetPlanVO.getActName());
                week.setTsbDate(timesheetPlanVO.getWorkDate());
                week.setWorkDesc(timesheetPlanVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
            // 保存明细 本周工时
            timesheetVOList.forEach(timesheetVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO.getId());
                week.setExt1(StringUtils.hasText(timesheetVO.getType()) ? timesheetVO.getType() : "PROJ");
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
                week.setYearWeek(timesheetVO.getYearWeek());
                week.setProjId(timesheetVO.getProjId());
                week.setProjectName(timesheetVO.getProjName());
                week.setTaskId(timesheetVO.getTaskId());
                week.setTaskName(timesheetVO.getTaskName());
                week.setActId(timesheetVO.getActId());
                week.setActName(timesheetVO.getActName());
                week.setTsbDate(timesheetVO.getWorkDate());
                week.setWorkDesc(timesheetVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });

        }
        timesheetBiweeklyDetailPayloadList.forEach(timesheetBiweeklyDetailPayload -> {
            timesheetBiweeklyDetailService.insert(timesheetBiweeklyDetailPayload);
        });
        return timesheetBiweeklyVOResult;
    }


    /**
     * 初始化数据
     *
     * @param payload 有效载荷
     */
    private void initData(TimesheetBiweeklyPayload payload) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        payload.setTsUserId(loginUserId);
        // 审批人赋值
        final Set<Long> parentIdsByUserId = prdOrgEmployeeService.queryParentIdsByUserId(loginUserId);
        final String receiveUserIds = org.apache.commons.lang3.StringUtils.join(parentIdsByUserId.toArray(), ",");
        payload.setReceiveUserIds(receiveUserIds);
        if (!StringUtils.hasText(payload.getTsbType())) {
            payload.setTsbType("week");
        }
        if (!StringUtils.hasText(payload.getTitle())) {
            String title = "";
            if (payload.getTsbType().equals("week")) {
                title = "周报";
            }
            payload.setTitle(GlobalUtil.getLoginUserName() + title);
        }
        if (null == payload.getIsRead()) {
            payload.setIsRead(0);
        }
        // TODO 获取用户上级、上级的上级....
        if (null == payload.getStartWeekDate()) {
            final LocalDate startWeekDay = DateUtil.getStartWeekDay(payload.getGenerateDate());
            if (null == startWeekDay) {
                throw TwException.error("", "参数异常，请指定生成周报日期");
            }
            payload.setStartWeekDate(startWeekDay);
            payload.setEndWeekDate(startWeekDay.plusDays(7));
            payload.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(startWeekDay)));
        }
        // TODO 获取当前用户的组织信息
        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdUserService.queryOrgList();
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
            final List<PrdOrgDataRefVO> list = prdOrgDataRefVOS.stream()
                    .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                final Long orgId = list.get(0).getOrgId();
                payload.setTsbBuId(orgId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetBiweeklyVO update(TimesheetBiweeklyPayload payload) {
        TimesheetBiweeklyDO entity = timesheetBiweeklyRepo.findById(payload.getId()).orElseGet(TimesheetBiweeklyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetBiweeklyDO entityDo = TimesheetBiweeklyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetBiweeklyConvert.INSTANCE.toVo(timesheetBiweeklyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            timesheetBiweeklyDAO.deleteSoft(keys);
        }
    }

    @Override
    public void download(List<TimesheetBiweeklyVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TimesheetBiweeklyVO timesheetBiweekly : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("标题", timesheetBiweekly.getTitle());
            map.put("双周计划类型", timesheetBiweekly.getTsbType());
            map.put("双周计划Buid", timesheetBiweekly.getTsbBuId());
            map.put("发送对象", timesheetBiweekly.getReceiveUserIds());
            map.put("是否已读", timesheetBiweekly.getIsRead());
            map.put("拓展1", timesheetBiweekly.getExt1());
            map.put("拓展2", timesheetBiweekly.getExt2());
            map.put("拓展3", timesheetBiweekly.getExt3());
            map.put("本周开始日期", timesheetBiweekly.getStartWeekDate());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }


}
