package com.elitesland.tw.tw5.server.prd.org.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baiwang.bop.client.BopException;
import com.baiwang.open.entity.request.OutputEinvoiceQueryRequest;
import com.baiwang.open.entity.request.node.OutputEinvoiceQueryInvoiceQueryParam;
import com.baiwang.open.entity.response.OutputEinvoiceQueryResponse;
import com.baiwang.open.entity.response.node.OutputEinvoiceQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgSyncDataService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.salecon.service.*;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 同步数据测试
 *
 * @author wangding
 */
@Api("维度版本管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgTestController {

    private final PrdOrgSyncDataService service;
    private final CrmOpportunityDAO opportunityDAO;
    private final TransferUtilServiceImpl transferUtilService;
    private final SaleConContractService saleConContractService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final ConReceivableService conReceivableService;
    private final ConReceivableDService conReceivableDService;
    private final ConPurchaseDemandService conPurchaseDemandService;
    private final ConEpibolyCostConService conEpibolyCostConService;
    private final ConAchieveService conAchieveService;
    private final ConInvBatchService invBatchService;
    private final TimesheetService timesheetService;
    private final HttpUtil httpUtil;
    @Value("${tw4.opportunity.operation}")
    private String opportunity_operation;
    @Autowired
    private TwInvoiceSendMsgService invoiceSendMsgService;
    private final TAttendanceNormalService tAttendanceNormalService;
    private final TAttendanceOtherService tAttendanceOtherService;
    private final TAttendanceRecordService tAttendanceRecordService;
    private final TAttendanceRemarkService tAttendanceRemarkService;

    private final PmsProjectBriefService pmsProjectBriefService;

    private final PmsProjectService pmsProjectService;

    /**
     * 同步用户数据
     *
     * @return result
     */
    @GetMapping("/test/syncUsers")


    public TwOutputUtil syncUsers() {
        service.syncUsers();
        return TwOutputUtil.ok();
    }


    /**
     * 同步当量系数数据
     *
     * @return result
     */
    @GetMapping("/test/syncEmployeeEqvaRatio")
    public TwOutputUtil syncEmployeeEqvaRatio() {
        service.syncEqvaRatio();
        return TwOutputUtil.ok();
    }

    /**
     * 同组织数据
     *
     * @return result
     */
    @GetMapping("/test/syncOrgs")
    public TwOutputUtil syncOrgs() {
        service.syncOrgs();
        return TwOutputUtil.ok();
    }

    /**
     * 同步组织员工关系数据
     *
     * @return result
     */
    @GetMapping("/test/syncOrgRefUsers")
    public TwOutputUtil syncOrgRefUsers() {
        service.syncOrgRefUsers();
        return TwOutputUtil.ok();
    }


    // TODO 5.0项目、任务上线后删除
    // /**
    //  * 同步任务
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncTasks")
    // public TwOutputUtil syncTasks(String param) {
    //     service.syncTasks(param);
    //     return TwOutputUtil.ok();
    // }

    // /**
    //  * 同步活动
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncActivity")
    // public TwOutputUtil syncActivity() {
    //     service.syncActivity();
    //     return TwOutputUtil.ok();
    // }


    // /**
    //  * 任务包授权同步
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncTaskAuthorized")
    // public TwOutputUtil syncTaskAuthorized() {
    //     service.syncTaskAuthorized();
    //     return TwOutputUtil.ok();
    // }

    // /**
    //  * 任务包授权明细
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncTaskAuthorizedDetails")
    // public TwOutputUtil syncTaskAuthorizedDetails() {
    //     service.syncTaskAuthorizedDetails();
    //     return TwOutputUtil.ok();
    // }

    // /**
    //  * 项目同步
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncProject")
    // public TwOutputUtil syncProject() {
    //     service.syncProjects();
    //     return TwOutputUtil.ok();
    // }

    // /**
    //  * 项目成员同步
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncProjSh")
    // public TwOutputUtil syncProjSh() {
    //     service.syncProjSh();
    //     return TwOutputUtil.ok();
    // }

    // /**
    //  * 工时同步
    //  *
    //  * @return result
    //  */
    // @GetMapping("/test/syncTimesheet")
    // public TwOutputUtil syncTimesheet(String param) {
    //     service.syncTimesheetDataTo4(param);
    //     return TwOutputUtil.ok();
    // }

    //
    // /**
    //  * 假期工时定时任务// TODO duwn 待开发5.0 功能 开发完后删除
    //  *
    //  * @return 定时任务执行结果
    //  */
    // @GetMapping("/test/syncVacationTimesheetTo5")
    // public TwOutputUtil syncTimesheetTo5() {
    //     service.syncVacationTimesheetDataTo5();
    //     return TwOutputUtil.ok();
    // }


//    /**
//     * 商机数据修复
//     *
//     * @return result
//     */
//    @GetMapping("/test/syncOppoFix")
//    public TwOutputUtil syncOppoFix() {
//        CrmOpportunityQuery query = new CrmOpportunityQuery();
////        query.setOppoIdsV4(Arrays.asList(2267L,2271L,2272L,2273L,2275L,2276L,2277L,2278L,2281L,2284L,2293L,2298L,2299L,2304L,2317L,2318L,2320L,2323L,2324L,2329L,2341L,2344L,2345L,2482L,2483L,2485L,2486L,2488L,2489L,2492L,2493L,2495L,2496L,2497L,2498L,2501L,2502L,2503L,2504L,2505L,2506L,2507L,2508L,2509L));//更新4.0错误数据
//        query.setOppoIdsV4(Arrays.asList(32L,983L,1044L,1123L,1248L,1595L,1696L,1720L,1749L,1754L,2073L,2116L,2159L,2250L,2311L,2313L,2317L,2385L,2390L,2426L,2457L,2489L,2517L,2563L,2575L,2602L,2635L,2647L,2655L,2658L,2661L,2685L,2707L,2734L,2735L,2750L,2753L,2754L,2755L,2768L,2769L,2771L,2789L,2793L,2798L,2801L,2817L,2819L,2834L,2842L,2844L,2849L,2852L,2860L,2873L,2878L,2882L,2894L,2895L,2896L,2897L,2912L,2922L,2926L,2927L,2930L,2931L,2932L,2941L,2945L,2954L,2955L,2956L,2961L,2966L,2976L,2979L,2981L,2988L,2990L,2993L,2999L,3004L,3007L,3012L,3014L,3023L,3035L,3038L,3043L,3050L,3052L,3055L,3057L,3066L,3068L,3071L,3078L,3079L,3080L,3081L,3083L,3084L,3086L,3088L,3093L,3099L,3105L,3110L,3111L,3113L,3114L,3115L,3116L,3118L,3119L,3121L,3123L,3126L,3127L,3130L,3133L,3135L,3136L,3141L,3143L,3147L,3148L,3149L,3151L,3153L,3155L,3157L,3161L,3162L,3164L,3166L,3168L,3171L,3172L,3173L,3176L,3177L,3178L,3181L,3182L,3184L,3186L,3194L,3196L,3197L,3200L,3204L,3205L,3206L,3207L,3208L,3209L,3210L,3213L,3215L,3216L,3217L,3219L,3224L,3225L,3227L,3229L,3230L,3231L,3247L,3248L,3249L,3251L,3252L,3253L,3257L,3259L,3260L,3264L,3269L,3270L,3272L,3278L,3279L,3281L,3289L,3290L,3292L,3298L,3299L,3304L,3305L,3306L,3310L,3316L,3320L,3321L,3323L,3324L,3326L,3327L,3331L,3337L,3339L,3341L,3342L,3347L,3351L,3353L,3356L,3358L,3361L,3370L,3376L,3377L,3379L,3385L,3386L,3390L,3391L,3392L,3397L,3398L,3400L,3405L,3409L,3410L,3414L,3419L,3420L,3421L,3424L,3429L,3433L,3434L,3437L,3442L,3444L,3450L,3456L,3458L,3463L,3470L,3472L,3475L,3479L,3480L,3486L,3487L,3488L,3489L,3493L,3494L,3495L,3508L,3511L,3515L,3516L,3517L,3520L,3525L,3526L,3531L,3533L,3534L,3537L,3587L,3588L,3604L));
//        List<CrmOpportunityVO> opportunityVOList = opportunityDAO.queryList(query,null,null);
////        List<CrmOpportunityPayload> collect = opportunityVOList.stream().map(e -> CrmOpportunityConvert.INSTANCE.toPayload(e)).collect(Collectors.toList());
//        for (CrmOpportunityVO crmOpportunityPayload : opportunityVOList) {
//            //同步到4.0
//            Map<String, Object> map = transferUtilService.beanToMap(crmOpportunityPayload);
//            CrmActProjectVO project = opportunityDAO.queryProjectBykey(crmOpportunityPayload.getId());
//            map.put("id", project.getOppoIdV4());
//            httpUtil.sendSyncPost(opportunity_operation, map);
//        }
//        return TwOutputUtil.ok();
//    }


    /**
     * 同步项目信息到帮我8-升级版
     *
     * @return result
     */
    @GetMapping("/test/bangwo8/projectsprd")
    public TwOutputUtil syncProjectsToBangwo8Pro(String param) {
        service.syncProjectsToBangwo8Pro(param);
        return TwOutputUtil.ok();
    }

    /**
     * 同步顾问信息到帮我8
     *
     * @return result
     */
    @GetMapping("/test/bangwo8/advisers")
    public TwOutputUtil syncAdvisersToBangwo8() {
        service.syncAdvisersToBangwo8(null);
        return TwOutputUtil.ok();
    }

    /**
     * 同步帮我吧工单信息到tw
     *
     * @return result
     */
    @GetMapping("/test/bangwo8/tickets")
    public TwOutputUtil syncTicketsToBangwo8(String date) {
        if (ObjectUtils.isEmpty(date)) {
            return TwOutputUtil.error("日期不能为空");
        }
        DateTime parse = DateUtil.parse(date);
        LocalDateTime localDateTime = parse.toLocalDateTime();
        service.syncTicketsFromBangwo8(localDateTime);
        return TwOutputUtil.ok();
    }

    /**
     * 采购合同
     *
     * @return result
     */
    @GetMapping("/test/purchaseContract/main")
    public TwOutputUtil syncPurchaseContract(@RequestParam String param) {
        service.syncPurchaseContractTo5(param);
        return TwOutputUtil.ok();
    }

//    /**
//     * 采购合同明细
//     *
//     * @return result
//     */
//    @GetMapping("/test/purchaseContract/detail")
//    public TwOutputUtil syncPurchaseContractDetail(@RequestParam String param) {
//        service.syncPurchaseContractDetailTo5(param);
//        return TwOutputUtil.ok();
//    }

    /**
     * 财务年度
     *
     * @return result
     */
    @GetMapping("/test/finYear")
    public TwOutputUtil syncFinYearTo5(@RequestParam String param) {
        service.syncFinYearTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 财务期间
     *
     * @return result
     */
    @GetMapping("/test/finPeriod")
    public TwOutputUtil syncFinPeriodTo5(@RequestParam String param) {
        service.syncFinPeriodTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 产品类别
     *
     * @return result
     */
    @GetMapping("/test/productClass")
    public TwOutputUtil syncProductClassTo5(@RequestParam String param) {
        service.syncProductClassTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 产品
     *
     * @return result
     */
    @GetMapping("/test/product")
    public TwOutputUtil syncProductTo5(@RequestParam String param) {
        service.syncProductTo5(param);
        return TwOutputUtil.ok();
    }

//    /**
//     * 地址簿4.0-5.0
//     *
//     * @return result
//     */
//    @GetMapping("/test/ab")
//    public TwOutputUtil syncAbTo5(@RequestParam String param) {
//        service.syncAbTo5(param);
//        return TwOutputUtil.ok();
//    }

//    /**
//     * 销售合同5.0-4.0
//     * @param param
//     * @return
//     */
//    @GetMapping("/test/syncSaleContractTo4")
//    public TwOutputUtil syncSaleContractTo4(@RequestParam String param) {
//        saleConContractService.syncSaleContractDataTo4(param);
//        return TwOutputUtil.ok();
//    }

//    /**
//     * 采购需求5.0-4.0
//     * @param param
//     * @return
//     */
//    @GetMapping("/test/syncPurcDemandTo4")
//    public TwOutputUtil syncPurcDemandTo4(@RequestParam String param) {
//        conPurchaseDemandService.syncPurcDemandTo4(param);
//        return TwOutputUtil.ok();
//    }

    /**
     * 收款计划5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncContractRecvplanTo4")
    public TwOutputUtil syncContractRecvplanTo4(@RequestParam String param) {
        conReceivablePlanService.syncContractRecvplanTo4(param);
        return TwOutputUtil.ok();
    }

    /**
     * 合同开票5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncContractInvBatchTo4")
    public TwOutputUtil syncContractInvBatchTo4(@RequestParam String param) {
        invBatchService.syncContractInvBatchTo4(param);
        return TwOutputUtil.ok();
    }


    /**
     * 合同开票发票5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncContractInvBatchInvDtlTo4")
    public TwOutputUtil syncContractInvBatchInvDtlTo4(@RequestParam String param) {
        invBatchService.syncContractInvBatchInvDtlTo4(param);
        return TwOutputUtil.ok();
    }

    /**
     * 合同收款5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncConReceivableTo4")
    public TwOutputUtil syncConReceivableTo4(@RequestParam String param) {
        conReceivableService.syncConReceivableTo4(param);
        return TwOutputUtil.ok();
    }

    /**
     * 合同收款明细5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncConReceivableDTo4")
    public TwOutputUtil syncConReceivableDTo4(@RequestParam String param) {
        conReceivableDService.syncConReceivableDTo4(param);
        return TwOutputUtil.ok();
    }

    /**
     * 外包费用5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncCostConTo4")
    public TwOutputUtil syncCostConTo4(@RequestParam String param) {
        conEpibolyCostConService.syncCostConTo4(param);
        return TwOutputUtil.ok();
    }

    /**
     * 业绩统计5.0-4.0
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncConAchieveTo4")
    public TwOutputUtil syncConAchieveTo4(@RequestParam String param) {
        conAchieveService.syncConAchieveTo4(param);
        return TwOutputUtil.ok();
    }


    /**
     * 采购需求4.0-5.0，关键字段同步
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncPurcDemandTo5")
    public TwOutputUtil syncPurcDemandTo5(@RequestParam String param) {
        service.syncPurcDemandTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 收款计划4.0-5.0，关键字段同步
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncContractRecvplanTo5")
    public TwOutputUtil syncContractRecvplanTo5(@RequestParam String param) {
        service.syncContractRecvplanTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 外包费用4.0-5.0，关键字段同步
     *
     * @param param
     * @return
     */
    @GetMapping("/test/syncCostConTo5")
    public TwOutputUtil syncCostConTo5(@RequestParam String param) {
        service.syncCostConTo5(param);
        return TwOutputUtil.ok();
    }

    //==============================上线后单次同步=======================================

//    /**
//     * 销售合同（单次）
//     *
//     * @return result
//     */
//    @GetMapping("/test/contractHistory")
//    public TwOutputUtil syncContractHistoryTo5(@RequestParam String param) {
//        saleConContractService.syncSaleContractHistoryDataTo5(param);
//        return TwOutputUtil.ok();
//    }

    /**
     * 业绩统计（单次）
     *
     * @return result
     */
    @GetMapping("/test/contractAchieve")
    public TwOutputUtil syncContractAchieveTo5(@RequestParam String param) {
        service.syncContractAchieveTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 收款计划（单次）
     *
     * @return result
     */
    @GetMapping("/test/receivePlan")
    public TwOutputUtil syncReceivePlanTo5(@RequestParam String param) {
        service.syncReceivePlanTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 合同开票（单次）
     *
     * @return result
     */
    @GetMapping("/test/invBatch")
    public TwOutputUtil syncInvBatchTo5(@RequestParam String param) {
        service.syncInvBatchTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 合同开票发票（单次）
     *
     * @return result
     */
    @GetMapping("/test/invBatchInvdtl")
    public TwOutputUtil syncInvBatchInvdtlTo5(@RequestParam String param) {
        service.syncInvBatchInvdtlTo5(param);
        return TwOutputUtil.ok();
    }

//    /**
//     * 采购需求（单次）
//     *
//     * @return result
//     */
//    @GetMapping("/test/purchaseDemand")
//    public TwOutputUtil syncPuchaseDemandTo5(@RequestParam String param) {
//        service.syncPurchaseDemandTo5(param);
//        return TwOutputUtil.ok();
//    }
//    /**
//     * 采购需求明细（单次）
//     *
//     * @return result
//     */
//    @GetMapping("/test/purchaseDemandDetail")
//    public TwOutputUtil syncPuchaseDemandDetailTo5(@RequestParam String param) {
//        service.syncPurchaseDemandDetailTo5(param);
//        return TwOutputUtil.ok();
//    }

    /**
     * 外包费用（单次）
     *
     * @return result
     */
    @GetMapping("/test/channelCostCon")
    public TwOutputUtil syncChannelCostConTo5(@RequestParam String param) {
        service.syncChannelCostConTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 外包费用明细（单次）
     *
     * @return result
     */
    @GetMapping("/test/channelCostCond")
    public TwOutputUtil syncChannelCostCondTo5(@RequestParam String param) {
        service.syncChannelCostCondTo5(param);
        return TwOutputUtil.ok();
    }

    //==============================上线后单次同步=======================================

//    /**
//     * 一键同步销售合同相关数据到4.0（单次）
//     * @return result
//     */
//    @GetMapping("/test/syncContractRelateDataTo4")
//    public TwOutputUtil syncContractRelateDataTo4(@RequestParam String param) {
//        saleConContractService.syncSaleContractDataTo4(param);
//        conReceivablePlanService.syncContractRecvplanTo4(param);
//        conPurchaseDemandService.syncPurcDemandTo4(param);
//        conEpibolyCostConService.syncCostConTo4(param);
//        conAchieveService.syncConAchieveTo4(param);
//        return TwOutputUtil.ok();
//    }

    private final CrmCustomerOperationService crmCustomerOperationService;

    @GetMapping("/testOverdueOperNotice")
    public TwOutputUtil testOverdueOperNotice(String param) {
        crmCustomerOperationService.overdueCompleteCustOperation(param);
        return TwOutputUtil.ok();
    }

    @GetMapping("/testautoCustOperation")
    public TwOutputUtil testautoCustOperation(String param) {
        crmCustomerOperationService.autoCustOperation(param);
        return TwOutputUtil.ok();
    }


    @GetMapping("/testInvBatch/{batchId}")
    public TwOutputUtil testautoCustOperation(@PathVariable Long batchId) {
        invBatchService.deleteInvInfoToBaiwang(batchId, 1);
        return TwOutputUtil.ok();
    }

    private final ConReceivablePlanRepo conReceivablePlanRepo;

    @GetMapping("/testPlanUpdate/{batchId}")
    public TwOutputUtil testPlanUpdate(@PathVariable Long batchId) {
        conReceivablePlanRepo.updateReceStatusByBatchId(batchId, "testcode");
        return TwOutputUtil.ok();
    }


    /**
     * 工时提醒问题测试
     *
     * @param param
     * @return
     */
    @GetMapping("/test/timesheetAlertAll")
    public TwOutputUtil timesheetAlertAll(@RequestParam String param) {
        Long employeeId = !StringUtils.hasText(param) ? null : Long.parseLong(param);
        timesheetService.timesheetAlertAll(employeeId);
        return TwOutputUtil.ok();
    }

    /**
     * 工时提醒问题测试-拒绝
     *
     * @param param
     * @return
     */
    @GetMapping("/test/timesheetAlertAllBack")
    public TwOutputUtil timesheetAlertAllBack(@RequestParam String param) {
        Long employeeId = !StringUtils.hasText(param) ? null : Long.parseLong(param);
        timesheetService.timesheetAlertAllBack(employeeId);
        return TwOutputUtil.ok();
    }

    /**
     * 帮我吧单个工单同步
     *
     * @param ticketId
     * @return
     */
    @GetMapping("/test/sync/bangwo8timesheet/{ticketId}")
    public TwOutputUtil timesheetAlertAll(@PathVariable Long ticketId) {
        service.syncTicketsFromBangwo8Single(ticketId);
        return TwOutputUtil.ok();
    }

    /**
     * 项目汇报自动发起测试
     *
     * @return
     */
    @GetMapping("/test/projectBriefJobHandler")
    public TwOutputUtil projectBriefJobHandler(@RequestParam String date) {
        pmsProjectBriefService.projectBriefJobHandler(date);
        return TwOutputUtil.ok();
    }

    /**
     * 开票发票同步
     *
     * @param
     * @return
     */
    @GetMapping("/test/sync/invoicing")
    public TwOutputUtil invoicingAll() {
        invBatchService.getInvoicesFromBaiwang();
        return TwOutputUtil.ok();
    }

    /**
     * 测试邮件发送
     *
     * @return
     */
    @GetMapping("/test/sendEmail/{invBatchId}")
    public TwOutputUtil sendEmail(@PathVariable Long invBatchId) {
        ConInvBatchVO conInvBatchVO = invBatchService.queryByKey(invBatchId);
        invBatchService.sendEmail(conInvBatchVO);
        return TwOutputUtil.ok();
    }

    /**
     * 测试发票回调
     *
     * @return
     */
    @GetMapping("/test/getBatchDetail/{tempBatchNo}")
    public TwOutputUtil getBatchInv(@PathVariable String tempBatchNo) {
        OutputEinvoiceQueryRequest request = new OutputEinvoiceQueryRequest();
        OutputEinvoiceQueryInvoiceQueryParam data = new OutputEinvoiceQueryInvoiceQueryParam();
        data.setPageNo(1);
        data.setPageSize(500);
        data.setSerialNo(tempBatchNo);//流水单号
        request.setData(data);
        //税号
        request.setTaxNo("91310000766919029T");
        try {
            // 调用发票查询接口
            OutputEinvoiceQueryResponse response = invoiceSendMsgService.invoiceQuery(request);
            if (response.getSuccess() && response.getResponse().size() > 0) {
                List<OutputEinvoiceQuery> reInvs = response.getResponse();
                return TwOutputUtil.ok(reInvs);
            }
        } catch (BopException e) {
            log.error("[百望系统获取开票信息失败],TW批次号：", ",百望流水号：", tempBatchNo, ",response=", e);
        }
        return TwOutputUtil.ok();
    }


    /**
     * 数据同步
     *
     * @return
     */
    @GetMapping("/test/sync/attendanceNormalTo5")
    public TwOutputUtil attendanceNormalTo5(@RequestParam String param) {
        tAttendanceNormalService.attendanceNormalTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 数据同步
     *
     * @return
     */
    @GetMapping("/test/sync/attendanceOtherTo5")
    public TwOutputUtil attendanceOtherTo5(@RequestParam String param) {
        tAttendanceOtherService.attendanceOtherTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 数据同步
     *
     * @return
     */
    @GetMapping("/test/sync/attendanceRecordTo5")
    public TwOutputUtil attendanceRecordTo5(@RequestParam String param) {
        tAttendanceRecordService.attendanceRecordTo5(param);
        return TwOutputUtil.ok();
    }

    /**
     * 数据同步
     *
     * @return
     */
    @GetMapping("/test/sync/attendanceRemarkTo5")
    public TwOutputUtil attendanceRemarkTo5(@RequestParam String param) {
        tAttendanceRemarkService.attendanceRemarkTo5(param);
        return TwOutputUtil.ok();
    }


    /**
     * 自动创建项目
     *
     * @return
     */
    @GetMapping("/test/sync/autoCreateProject")
    public TwOutputUtil autoCreateProject(@RequestParam String contractId) {
        long id = Long.parseLong(contractId);
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(id);
        PmsProjectPayload pmsProjectPayload = pmsProjectService.autoCreateProject(saleConContractVO);
        pmsProjectService.insertOrUpdate(pmsProjectPayload);
        return TwOutputUtil.ok();
    }


}
