package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgVersionPayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgVersionService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgVersionConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgVersionDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 维度管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgVersionServiceImpl implements PrdOrgVersionService {
    private final PrdOrgVersionDAO dao;

    @Transactional
    @Override
    public PrdOrgVersionVO insert(PrdOrgVersionPayload payload) {
        //1.首先判断这个维度是不是当前使用维度
        PrdOrgDimensionDO dimensionDO = dao.queryByDimensionId(payload.getDimensionId());
        if (dimensionDO.getVersionId() == null || dimensionDO.getVersionId().longValue() == 0) {
            if (dao.queryVersionByCode(payload.getDimensionId(), payload.getVersionNo()) != null) {
                throw TwException.error("", "版本号不可重复");
            }
            //2.如果是，则进行保存
            PrdOrgVersionDO ado = PrdOrgVersionConvert.INSTANCE.toDo(payload);
            ado = dao.save(ado);
            //3.备份新的维度
            PrdOrgDimensionDO dimensionDONEW = (PrdOrgDimensionDO) dimensionDO.clone();

            boolean aa = dimensionDONEW == dimensionDO;
            dimensionDONEW.setId(0L);
            dimensionDONEW.setVersionId(ado.getId());
            dimensionDONEW = dao.saveDimension(dimensionDONEW);

            Map<Long, Long> orgMap = new HashMap<Long, Long>();
            List<PrdOrgOrganizationRefDO> orgRefDOS = new ArrayList<>();
            //4.查询当前所有维度下的组织关系
            List<PrdOrgOrganizationRefDO> orgOrganizationRefDOS = dao.queryOrgListByDimensionId(payload.getDimensionId());

            for (PrdOrgOrganizationRefDO refDO : orgOrganizationRefDOS) {
                //5.查询当前所有维度下的组织关系对应的组织
                PrdOrgOrganizationDO prdOrgOrganizationDO = dao.queryOrg(refDO.getOrgId());
                if (prdOrgOrganizationDO != null) {
                    //6.备份新的组织
                    PrdOrgOrganizationDO prdOrgOrganizationDONEW = (PrdOrgOrganizationDO) prdOrgOrganizationDO.clone();
                    prdOrgOrganizationDONEW.setId(0L);
                    prdOrgOrganizationDONEW.setChangeId(prdOrgOrganizationDO.getId());
                    prdOrgOrganizationDONEW.setDimensionId(dimensionDONEW.getId());
                    prdOrgOrganizationDONEW.setIsCopy(1);
                    prdOrgOrganizationDONEW = dao.saveOrganization(prdOrgOrganizationDONEW);
                    orgMap.put(prdOrgOrganizationDO.getId(), prdOrgOrganizationDONEW.getId());
                    orgRefDOS.add((PrdOrgOrganizationRefDO) refDO.clone());
                }
            }

            for (PrdOrgOrganizationRefDO refDONEW : orgRefDOS) {
                // PrdOrgOrganizationRefDO refDONEW = (PrdOrgOrganizationRefDO) refDO.clone();
                refDONEW.setId(0L);
                refDONEW.setOrgId(orgMap.get(refDONEW.getOrgId()));
                refDONEW.setDimensionId(dimensionDONEW.getId());
                refDONEW.setParentId(orgMap.get(refDONEW.getParentId()));
                refDONEW.setIsCopy(1);
                // dao.saveOrganizationRef(refDONEW);
            }
            //7.备份新的组织关系
            dao.saveOrganizationRefs(orgRefDOS);

            List<PrdOrgRoleDO> prdOrgRoleDOAll = new ArrayList<>();
            List<PrdOrgEmployeeRefDO> prdOrgEmployeeRefDOAll = new ArrayList<>();
            for (Map.Entry<Long, Long> entry : orgMap.entrySet()) {
                //8.查询每个组织所属角色
                List<PrdOrgRoleDO> prdOrgRoleDOS = dao.queryOrgRolesByOrgId(entry.getKey());
                for (PrdOrgRoleDO roleDO : prdOrgRoleDOS) {
                    PrdOrgRoleDO roleDONEW = (PrdOrgRoleDO) roleDO.clone();
                    roleDONEW.setChangeId(entry.getKey());
                    roleDONEW.setOrgId(entry.getValue());
                    roleDONEW.setIsCopy(1);
                    roleDONEW.setId(0L);
                    prdOrgRoleDOAll.add(roleDONEW);
                }

                //9.查询每个组织所属员工关系
                List<PrdOrgEmployeeRefDO> prdOrgEmployeeRefDOS = dao.queryOrgEmployeesByOrgId(entry.getKey());
                for (PrdOrgEmployeeRefDO employeeRefDO : prdOrgEmployeeRefDOS) {

                    PrdOrgEmployeeRefDO employeeRefDONEW = (PrdOrgEmployeeRefDO) employeeRefDO.clone();

                    employeeRefDONEW.setOrgId(entry.getValue());
                    employeeRefDONEW.setIsCopy(1);
                    employeeRefDONEW.setId(0L);
                    prdOrgEmployeeRefDOAll.add(employeeRefDONEW);
                }
                //prdOrgEmployeeRefDOAll.addAll(prdOrgEmployeeRefDOS);
            }
            //10.备份组织新的角色
            dao.saveRoles(prdOrgRoleDOAll);
            //11.备份当前维度下所有组织的角色
            dao.saveEmployeeRefs(prdOrgEmployeeRefDOAll);
            return PrdOrgVersionConvert.INSTANCE.toVo(ado);
        } else {
            throw TwException.error("", "历史数据不可备份");
        }
    }

    @Transactional
    @Override
    public Long update(PrdOrgVersionPayload payload) {
        PrdOrgVersionDO versionDO = dao.queryVersionByCode(payload.getDimensionId(), payload.getVersionNo());
        if (versionDO != null && versionDO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error("", "版本号不可重复");
        }
        return dao.updateByKeyDynamic(payload);
    }

    @Override
    public List<PrdOrgVersionVO> queryList(Long dimensionId) {

        return dao.queryListByDimensionId(dimensionId);
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long key) {
        return dao.deleteSoft(key) >= 0;
    }
}
