package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分级策略-分级记录
 *
 * @author wangly
 * @date 2023-06-28
 */
@Entity
@Table(name = "business_strategy_index_record", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_strategy_index_record", comment = "分级策略-分级记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessStrategyIndexRecordDO extends BaseModel implements Serializable  {
    /** 策略id business_strategy.id */
    @Comment("策略id business_strategy.id")
    @Column()
    private Long strategyId;
    /** 业务伙伴id business_partner.id */
    @Comment("业务伙伴id business_partner.id")
    @Column()
    private Long partnerId;
    /** 指标名称 */
    @Comment("指标名称")
    @Column()
    private String indexName;
    /** 指标权重 */
    @Comment("指标权重")
    @Column()
    private Integer indexWeight;
    /** 指标分数 */
    @Comment("指标分数")
    @Column()
    private BigDecimal indexScore;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 客户id business_customer_info.id */
    @Comment("客户id business_customer_info.id")
    @Column()
    private Long customerId;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;


    public void copy(BusinessStrategyIndexRecordDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
