package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyGradeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexRecordPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.*;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.*;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SearchScopeEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessCutomizeEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessStrategyIndexEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessStrategyRangeEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.CustomerGradeEnum;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * 分级策略
 *
 * @author wangly
 * @date 2023-06-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyServiceImpl extends BaseServiceImpl implements BusinessStrategyService {

    private final BusinessStrategyRepo businessStrategyRepo;
    private final BusinessStrategyDAO businessStrategyDAO;
    private final BusinessStrategyRangeSettingService businessStrategyRangeSettingService;
    private final BusinessStrategyRefService businessStrategyRefService;
    private final BusinessStrategyIndexSettingService businessStrategyIndexSettingService;
    private final BusinessStrategyGradeSettingService businessStrategyGradeSettingService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final CacheUtil cacheUtil;
    private final BusinessStrategyModelService businessStrategyModelService;
    private final BusinessModelIndexService businessModelIndexService;
    private final BusinessModelIndexSettingService businessModelIndexSettingService;
 //   private final ContractService contractService;
    private final BusinessStrategyIndexRecordService businessStrategyIndexRecordService;
    @Override
    public PagingVO<BusinessStrategyVO> queryPaging(BusinessStrategyQuery query){
        return businessStrategyDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyVO> queryListDynamic(BusinessStrategyQuery query){
        return businessStrategyDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyVO queryByKey(Long key) {
        BusinessStrategyDO entity = businessStrategyRepo.findById(key).orElseGet(BusinessStrategyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyVO vo = BusinessStrategyConvert.INSTANCE.toVo(entity);
        Long strategyId = vo.getId();
        //范围为自定义
        if(BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(vo.getStrategyRange())){
            List<BusinessStrategyRangeSettingVO> businessStrategyRangeSettingVOS = businessStrategyRangeSettingService.queryListByStrategyId(strategyId);
            vo.setStrategyRangeSettingList(businessStrategyRangeSettingVOS);
            StringBuilder stringBuilder = new StringBuilder();
            businessStrategyRangeSettingVOS.stream().forEach(businessStrategyRangeSettingVO->{
                String desc = SearchScopeEnum.valueOf(businessStrategyRangeSettingVO.getSearchScope()).getDesc();
                stringBuilder.append(businessStrategyRangeSettingVO.getFieldName()+desc+businessStrategyRangeSettingVO.getExt1()+"、");
            });
            //去除多余的逗号
            if(stringBuilder.length()>0){
                vo.setStrategyRangeDetail(stringBuilder.substring(0,stringBuilder.length()-1));
            }
        }

        //范围为指定业务伙伴
        if(BusinessStrategyRangeEnum.APPOINT.getCode().equals(vo.getStrategyRange())){
            List<BusinessStrategyRefVO> businessStrategyRefVOS = businessStrategyRefService.queryListByStrategyId(strategyId);
            StringBuilder stringBuilder = new StringBuilder("");
            businessStrategyRefVOS.stream().forEach(businessStrategyRefVO->{
                stringBuilder.append(businessStrategyRefVO.getPartnerName()+"、");
            });
            if(stringBuilder.length()>0){
                vo.setStrategyRangeDetail(stringBuilder.substring(0,stringBuilder.length()-1));
            }
            vo.setStrategyBusinessRefList(businessStrategyRefService.queryListByStrategyId(strategyId));
        }
        //指标数据
        vo.setStrategyIndexList(businessStrategyIndexSettingService.queryListByStrategyId(strategyId));
        //等级数据
        vo.setStrategyGradeList(businessStrategyGradeSettingService.queryListByStrategyId(strategyId));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(BusinessStrategyPayload payload) {
        //保存分级策略基本信息 新增/更新
        Boolean rangFlag = false;
        String oldStrategyRange ="";
        Long strategyId = payload.getId();
        BusinessStrategyQuery query = new BusinessStrategyQuery();
        //判断是新增还是更新
        if(strategyId!=null){
            query.setStrategyPriority(payload.getStrategyPriority());
            List<BusinessStrategyVO> businessStrategyVOS = queryListDynamic(query);
            if(!CollectionUtils.isEmpty(businessStrategyVOS)){
                //查询出来的数据条数大于一条 肯定有重复优先级
                if(businessStrategyVOS.size()>1){
                    throw TwException.error("","存在相同优先级的策略，请修改优先级后保存");
                }
                //判断查询出来的数据id 是否和自己相等 不相等说明有其他优先级数据
                if(!businessStrategyVOS.get(0).getId().equals(payload.getId())){
                    throw TwException.error("","存在相同优先级的策略，请修改优先级后保存");
                }
            }

            BusinessStrategyDO entity = businessStrategyRepo.findById(payload.getId()).orElseGet(BusinessStrategyDO::new);
            Assert.notNull(entity.getId(), "不存在");
            //判断策略范围是否发生改变
            if(!entity.getStrategyRange().equals(payload.getStrategyRange())){
                rangFlag = true;
                oldStrategyRange=entity.getStrategyRange();
            }
            BusinessStrategyDO entityDo = BusinessStrategyConvert.INSTANCE.toDo(payload);
            entity.copy(entityDo);
            businessStrategyRepo.save(entity);
        }else{
            query.setStrategyPriority(payload.getStrategyPriority());
            List<BusinessStrategyVO> businessStrategyVOS = queryListDynamic(query);
            if(!CollectionUtils.isEmpty(businessStrategyVOS)){
                throw TwException.error("","存在相同优先级的策略，请修改优先级后保存");
            }
            //新增
            BusinessStrategyDO entityDo = BusinessStrategyConvert.INSTANCE.toDo(payload);
            BusinessStrategyDO save = businessStrategyRepo.save(entityDo);
            strategyId = save.getId();
        }
        final Long id = strategyId;
        //保存策略范围 全部无需保存
        //范围为自定义
        if(BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(payload.getStrategyRange()) && !CollectionUtils.isEmpty(payload.getStrategyRangeSettingList())){
            //全删全插
            businessStrategyRangeSettingService.deleteSoftByStrategyId(strategyId);

            payload.getStrategyRangeSettingList().stream().forEach(strategyRangeSettingPayload->{
                strategyRangeSettingPayload.setStrategyId(id);
                if(!StringUtils.isEmpty(strategyRangeSettingPayload.getSearchCondition())){
                    businessStrategyRangeSettingService.insert(strategyRangeSettingPayload);
                }
            });
        }
        //范围为指定业务伙伴
        if(BusinessStrategyRangeEnum.APPOINT.getCode().equals(payload.getStrategyRange()) && !CollectionUtils.isEmpty(payload.getStrategyBusinessRefList())){
            //全删全插
            businessStrategyRefService.deleteSoftByStrategyId(strategyId);
            payload.getStrategyBusinessRefList().forEach(strategyBusinessRefPayLoad->{
                strategyBusinessRefPayLoad.setStrategyId(id);
                businessStrategyRefService.insert(strategyBusinessRefPayLoad);
            });
        }


        /**
         * 如果范围被更改了有以下几种情况
         *
         * 1.由全部变为其他类型 上面已保存 无需处理
         * 2.自定义和指定类型相互转变 只需要将原来类型的数据删除即可
         * 3.自定义/指定变为全部 将原来的删除
         * 因此只需要判断rangeFalg是否为true 且旧的范围类型是什么就删除什么即可
         *
         * **/

        if(rangFlag&&BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(oldStrategyRange)){
            businessStrategyRangeSettingService.deleteSoftByStrategyId(id);
        }

        if(rangFlag&&BusinessStrategyRangeEnum.APPOINT.getCode().equals(oldStrategyRange)){
            businessStrategyRefService.deleteSoftByStrategyId(id);
        }

        //保存指标配置
        if(CollectionUtils.isEmpty(payload.getStrategyIndexList())){
            log.error("分级策略的指标数据不能为空");
            throw TwException.error("","分级策略的指标数据不能为空");
        }
        businessStrategyIndexSettingService.deleteByStrategyId(id);
        payload.getStrategyIndexList().forEach(strategyIndexPayload->{
            strategyIndexPayload.setStrategyId(id);
            businessStrategyIndexSettingService.insert(strategyIndexPayload);
        });

        //保存等级
        List<BusinessStrategyGradeSettingPayload> strategyGradePayLoadList = payload.getStrategyGradeList();
        if(CollectionUtils.isEmpty(strategyGradePayLoadList)){
            log.error("分级策略的等级配置不能为空");
            throw TwException.error("","分级策略的等级配置不能为空");
        }
        //校验用户填入的分数是否符合规范
        checkStrategyGrade(strategyGradePayLoadList);
        strategyGradePayLoadList.forEach(strategyGradePayLoad->{
            if(strategyGradePayLoad.getId()!=null){
                businessStrategyGradeSettingService.update(strategyGradePayLoad);
            }else{
                strategyGradePayLoad.setStrategyId(id);
                businessStrategyGradeSettingService.insert(strategyGradePayLoad);
            }
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyVO update(BusinessStrategyPayload payload) {
        BusinessStrategyDO entity = businessStrategyRepo.findById(payload.getId()).orElseGet(BusinessStrategyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyDO entityDo = BusinessStrategyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyConvert.INSTANCE.toVo(businessStrategyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyPayload payload) {
        BusinessStrategyDO entity = businessStrategyRepo.findById(payload.getId()).orElseGet(BusinessStrategyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessStrategyDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateStrategyStatus(List<Long> keys,String strategyStatus) {
        if (!keys.isEmpty()) {
            if(BusinessStrategyStatusEnum.OPEN.getCode().equals(strategyStatus)){
                Long count = businessStrategyIndexSettingService.quertDeleteModelCountByStrategyIds(keys);
                if (count>0){
                    throw TwException.error("","模型被删除，请在编辑中重新选择模型后再进行启用");
                }
            }
            keys.stream().forEach(id -> {
                Optional<BusinessStrategyDO> optional = businessStrategyRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessStrategyDO entity = optional.get();
                    entity.setStrategyStatus(strategyStatus);
                    businessStrategyRepo.save(entity);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void businessStrategyJobHandler() {
        //首先将所有的客户的客户级别 分数 strategyId indexInfo字段置空
        businessCustomerInfoService.updateCustomerGrade();

        //查询所有优先级 优先级由低到高执行
        List<BusinessStrategyVO> businessStrategyVOList = businessStrategyDAO.queryStraegyJobHandler();
        if(CollectionUtils.isEmpty(businessStrategyVOList)){
            log.error("分级策略未配置");
            return;
        }
        for(BusinessStrategyVO businessStrategyVO:businessStrategyVOList){
            Long strategyId = businessStrategyVO.getId();
            //通过策略id获取指标信息以及模型信息
            List<BusinessStrategyIndexModelRefVO> strategyIndexModelRefData = getStrategyData(strategyId);
            //查询等级信息
            List<BusinessStrategyGradeSettingVO>  strategyGradeData = businessStrategyGradeSettingService.queryListByStrategyId(strategyId);
            //查询策略范围内的业务伙伴
            if(!StringUtils.isEmpty(businessStrategyVO.getStrategyRange())){
                //如果是全部
                if(BusinessStrategyRangeEnum.ALL.getCode().equals(businessStrategyVO.getStrategyRange())){
                    //查询业务伙伴
                    List<BusinessStrategyCustomerVO> businessCustomerInfoVOS = businessCustomerInfoService.queryCustomerList(new BusinessPartnerQuery());
                    if(!CollectionUtils.isEmpty(businessCustomerInfoVOS)){
                        //处理数据
                        dealData(businessCustomerInfoVOS,strategyIndexModelRefData,strategyGradeData,strategyId);
                    }

                }
                //指定用户
                if(BusinessStrategyRangeEnum.APPOINT.getCode().equals(businessStrategyVO.getStrategyRange())){
                    List<BusinessStrategyCustomerVO> businessCustomerInfoVOS = businessStrategyRefService.queryAppointCustomerInfoByStrategyId(strategyId);
                    if(!CollectionUtils.isEmpty(businessCustomerInfoVOS)){
                        //处理数据
                        dealData(businessCustomerInfoVOS,strategyIndexModelRefData,strategyGradeData,strategyId);
                    }
                }
                //自定义
                if(BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(businessStrategyVO.getStrategyRange())){
                    List<BusinessStrategyRangeSettingVO> businessStrategyRangeSettingVOS = businessStrategyRangeSettingService.queryListByStrategyId(strategyId);
                    BusinessPartnerQuery businessPartnerQuery = new BusinessPartnerQuery();
                    List countryList = new ArrayList();
                    List industryList = new ArrayList();
                    List natureList = new ArrayList();
                    //循环便利自定义的范围配置 然后去查询对应的客户信息
                    businessStrategyRangeSettingVOS.stream().forEach(vo->{
                        if(BusinessCutomizeEnum.COUNTRY.getCode().equals(vo.getFieldKey())){
                            countryList.add(vo.getSearchCondition());
                        }

                        if(BusinessCutomizeEnum.INDUSTRY.getCode().equals(vo.getFieldKey())){
                            industryList.add(vo.getSearchCondition());
                        }

                        if(BusinessCutomizeEnum.NATURE.getCode().equals(vo.getFieldKey())){
                            natureList.add(vo.getSearchCondition());
                        }
                    });
                    businessPartnerQuery.setCountryList(countryList);
                    businessPartnerQuery.setPartnerIndustryList(industryList);
                    businessPartnerQuery.setPartnerNatureList(natureList);
                    //查询业务伙伴
                    List<BusinessStrategyCustomerVO> businessCustomerInfoVOS = businessCustomerInfoService.queryCustomerList(businessPartnerQuery);
                    if(!CollectionUtils.isEmpty(businessCustomerInfoVOS)){
                        //处理数据
                        dealData(businessCustomerInfoVOS,strategyIndexModelRefData,strategyGradeData,strategyId);
                    }
                }
            }
        }


    }

    /**
     * 通过获得的业务伙伴进行模型匹配处理
     *
     * @param  businessCustomerInfoVOS 客户信息
     * @param strategyIndexModelRefData  策略指标和模型对应关系数据
     * @param strategyGradeData 配置的等级数据
     * @param strategyId 策略id
     *
     **/
    public void dealData(List<BusinessStrategyCustomerVO> businessCustomerInfoVOS, List<BusinessStrategyIndexModelRefVO> strategyIndexModelRefData,List<BusinessStrategyGradeSettingVO>  strategyGradeData,Long strategyId){
        if(!CollectionUtils.isEmpty(businessCustomerInfoVOS)){
            //循环业务伙伴计算它的级别
            BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
            businessCustomerInfoVOS.forEach(vo->{
                //计算业务伙伴的等级
                Map map = countCustomerGrade(strategyIndexModelRefData, vo, strategyGradeData, strategyId);
                //更新客户信息
                payload.setId(vo.getId());
                payload.setCustomerGradle((String) map.get("gradleType"));
                payload.setStrategyId(strategyId);
                payload.setScore((BigDecimal) map.get("score"));
                payload.setPartnerId(vo.getPartnerId());
                String list = JSONUtil.toJsonStr(map.get("list"));
                payload.setIndexInfo(list) ;
                businessCustomerInfoService.update(payload);
            });
        }
    }


    /**
     * 通过策略id获取指标信息以及模型信息
     *
     * @param strategyId 策略id
     *
     **/
    public List<BusinessStrategyIndexModelRefVO> getStrategyData(Long strategyId){
        //先获取策略的指标和模型
        List<BusinessStrategyIndexModelRefVO> businessStrategyIndexModelRefVOS = businessStrategyIndexSettingService.queryIndexModelRef(strategyId);
        businessStrategyIndexModelRefVOS.stream().forEach(vo->{
            if(vo.getStandaryFlag()){
                vo.setBusinessModelIndexVOList(businessStrategyModelService.findRfmSettingByDate(vo.getDateRange()));
                //上面的数据初始化是没有 rmf的权重的 因此需要重新赋值
                if(!CollectionUtils.isEmpty(vo.getBusinessModelIndexVOList())){
                  vo.getBusinessModelIndexVOList().forEach(indexVO->{
                      if(BusinessStrategyIndexEnum.R.getCode().equals(indexVO.getSourceField())){
                          indexVO.setWeight(vo.getRWeight());
                      }
                      if(BusinessStrategyIndexEnum.F.getCode().equals(indexVO.getSourceField())){
                          indexVO.setWeight(vo.getFWeight());
                      }
                      if(BusinessStrategyIndexEnum.M.getCode().equals(indexVO.getSourceField())){
                          indexVO.setWeight(vo.getMWeight());
                      }

                  });
              }
            }else{
                BusinessModelIndexQuery businessModelIndexQuery = new BusinessModelIndexQuery();
                businessModelIndexQuery.setModelId(vo.getModelId());
                List<BusinessModelIndexVO> businessModelIndexVOS = businessModelIndexService.queryListDynamic(businessModelIndexQuery);
                BusinessModelIndexSettingQuery businessModelIndexSettingQuery = new BusinessModelIndexSettingQuery();
                businessModelIndexVOS.stream().forEach(businessModelIndexVO->{
                    businessModelIndexSettingQuery.setIndexId(businessModelIndexVO.getId());
                    businessModelIndexVO.setBusinessModelIndexSettingVOList(businessModelIndexSettingService.queryListDynamic(businessModelIndexSettingQuery));
                });
                vo.setBusinessModelIndexVOList(businessModelIndexVOS) ;
            }
        });
        return businessStrategyIndexModelRefVOS;
    }


    /**
     * 计算业务伙伴的等级
     *
     * @param  businessStrategyCustomerVO 客户信息
     * @param businessStrategyIndexModelRefVOS  策略指标和模型对应关系数据
     * @param strategyGradeDataList 配置的等级数据
     * @param strategyId 策略id
     *
     **/
    public Map countCustomerGrade(List<BusinessStrategyIndexModelRefVO> businessStrategyIndexModelRefVOS,BusinessStrategyCustomerVO businessStrategyCustomerVO,List<BusinessStrategyGradeSettingVO>  strategyGradeDataList,Long strategyId){
        BigDecimal endScore = BigDecimal.ZERO;

        List<BusinessStrategyIndexRecordVO> list = new ArrayList<>();
        for(BusinessStrategyIndexModelRefVO vo:businessStrategyIndexModelRefVOS){
            BigDecimal score = BigDecimal.ZERO;
            if(vo.getStandaryFlag()){
//                //标准的去查询客户的合同信息
//                LocalDateTime createTimeStart ;
//                if(BusinessModelDateEnum.YEAR.getCode().equals(vo.getDateRange())){
//                    createTimeStart =   LocalDateTime.of(LocalDate.now(), LocalTime.MIN).minusYears(1);
//                }else{
//                    createTimeStart =  LocalDateTime.of(LocalDate.now(), LocalTime.MIN).minusMonths(6);
//                }
//                //标准模版处理
//                score = score.add(dealStandardModel(vo, businessStrategyCustomerVO.getPartnerId(), createTimeStart));

            }else{
                score = score.add(dealNotStandardModel(vo, businessStrategyCustomerVO));
            }
            BigDecimal indexScore = score.multiply(new BigDecimal(vo.getIndexWeight()).divide(new BigDecimal("100"))).setScale(2, RoundingMode.HALF_UP);
            // 保存指标信息 此处需要落库
            BusinessStrategyIndexRecordPayload payload = new BusinessStrategyIndexRecordPayload();
            payload.setCustomerId(businessStrategyCustomerVO.getId());
            payload.setStrategyId(strategyId);
            payload.setPartnerId(businessStrategyCustomerVO.getPartnerId());
            payload.setIndexName(vo.getIndexName());
            payload.setIndexWeight(vo.getIndexWeight());
            payload.setIndexScore(indexScore);
            businessStrategyIndexRecordService.insert(payload);
            //将对象最终转为json 存到business_customer_info 的indexInfo字段中 等页面查询详情的时候 将json转为vo直接展示
            BusinessStrategyIndexRecordVO businessStrategyIndexRecordVO = new BusinessStrategyIndexRecordVO();
            businessStrategyIndexRecordVO.setCustomerId(businessStrategyCustomerVO.getId());
            businessStrategyIndexRecordVO.setStrategyId(strategyId);
            businessStrategyIndexRecordVO.setPartnerId(businessStrategyCustomerVO.getPartnerId());
            businessStrategyIndexRecordVO.setIndexName(vo.getIndexName());
            businessStrategyIndexRecordVO.setIndexWeight(vo.getIndexWeight());
            businessStrategyIndexRecordVO.setIndexScore(indexScore);
            list.add(businessStrategyIndexRecordVO);
            endScore = endScore.add(indexScore);
        }
        String gradleType = "";
        Map map = new HashMap();
        map.put("score",endScore);
        map.put("gradleType",gradleType);
        map.put("list",list);
        for(BusinessStrategyGradeSettingVO strategyData:strategyGradeDataList){
            // 判断分数在哪两个之间
            if(strategyData.getScoreStart().compareTo(endScore)<=0&&strategyData.getScoreEnd().compareTo(endScore)>=0){
                gradleType = strategyData.getGradleType();
                map.put("gradleType",gradleType);
                break;
            }
        }
        return map;
    }


    /**
     * 标准模版处理
     *
     * @param  partnerId 业务伙伴id
     * @param businessStrategyIndexModelRefVO  策略指标和模型对应关系数据
     * @param createTimeStart 近一年/六个月 的时间
     *
     **/
//    public BigDecimal dealStandardModel(BusinessStrategyIndexModelRefVO businessStrategyIndexModelRefVO,Long partnerId,LocalDateTime createTimeStart){
//
//        //合同管理
//        ContractQuery query = new ContractQuery();
//        query.setCreateTimeStart(createTimeStart);
//        query.setPartnerId(partnerId);
//        query.setDataPermissionFlag(false);
//        List<ContractVO> contractVOS = contractService.contractSaleCount(query);
//        BigDecimal score = BigDecimal.ZERO;
//        if(!CollectionUtils.isEmpty(contractVOS)){
//            //合同数量
//            Integer size = contractVOS.size();
//            //合同金额
//            BigDecimal contractTotalAmount = BigDecimal.ZERO;
//            //距离现在的时间
//            LocalDateTime time = createTimeStart;
//            for(ContractVO contractVO:contractVOS){
//                contractTotalAmount = contractTotalAmount.add(contractVO.getContractAmount());
//                if(time.compareTo(contractVO.getCreateTime())<0){
//                    time = contractVO.getCreateTime();
//                }
//            }
//            int months = Period.between(time.toLocalDate(),LocalDate.now()).getMonths();
//            List<BusinessModelIndexVO> businessModelIndexVOList = businessStrategyIndexModelRefVO.getBusinessModelIndexVOList();
//            for (BusinessModelIndexVO vo:businessModelIndexVOList) {
//                if(BusinessStrategyIndexEnum.R.getCode().equals(vo.getSourceField())){
//                    List<BusinessModelIndexSettingVO> businessModelIndexSettingVOList = vo.getBusinessModelIndexSettingVOList();
//                    for(BusinessModelIndexSettingVO indexSettingVO:businessModelIndexSettingVOList){
//                        //大于最小值 小于最大值/最大值为空 说明在这个区间 直接取分数 跳出循环
//                        if(Integer.valueOf(indexSettingVO.getExt2()).compareTo(months)<=0&&(StringUtils.isEmpty(indexSettingVO.getExt3())||Integer.valueOf(indexSettingVO.getExt3()).compareTo(months)>0)){
//                            score = score.add(indexSettingVO.getOptionScore().multiply(vo.getWeight().divide(new BigDecimal("100"))));
//                            break;
//                        }
//                    }
//                }
//                if(BusinessStrategyIndexEnum.F.getCode().equals(vo.getSourceField())){
//                    List<BusinessModelIndexSettingVO> businessModelIndexSettingVOList = vo.getBusinessModelIndexSettingVOList();
//                    for(BusinessModelIndexSettingVO indexSettingVO:businessModelIndexSettingVOList){
//                        //大于最小值 小于最大值/最大值为空 说明在这个区间 直接取分数 跳出循环
//                        if(Integer.valueOf(indexSettingVO.getExt2()).compareTo(size)<=0&&(StringUtils.isEmpty(indexSettingVO.getExt3())||Integer.valueOf(indexSettingVO.getExt3()).compareTo(size)>=0)){
//                            score = score.add(indexSettingVO.getOptionScore().multiply(vo.getWeight().divide(new BigDecimal("100"))));
//                            break;
//                        }
//                    }
//                }
//                if(BusinessStrategyIndexEnum.M.getCode().equals(vo.getSourceField())){
//                    List<BusinessModelIndexSettingVO> businessModelIndexSettingVOList = vo.getBusinessModelIndexSettingVOList();
//                    for(BusinessModelIndexSettingVO indexSettingVO:businessModelIndexSettingVOList){
//                        //大于最小值 小于最大值/最大值为空 说明在这个区间 直接取分数 跳出循环
//                        if(new BigDecimal(indexSettingVO.getExt2()).compareTo(contractTotalAmount)<=0&&(StringUtils.isEmpty(indexSettingVO.getExt3())||new BigDecimal(indexSettingVO.getExt3()).compareTo(contractTotalAmount)>0)){
//                            score = score.add(indexSettingVO.getOptionScore().multiply(vo.getWeight().divide(new BigDecimal("100"))));
//                            break;
//                        }
//                    }
//                }
//            }
//        }
//
//        return  score;
//    }

    /**
     * 非标准模版处理
     *
     * @param  businessStrategyCustomerVO 客户信息
     * @param vo  策略指标和模型对应关系数据
     *
     **/
    public BigDecimal dealNotStandardModel(BusinessStrategyIndexModelRefVO vo,BusinessStrategyCustomerVO businessStrategyCustomerVO){
        List<BusinessModelIndexVO> businessModelIndexVOList = vo.getBusinessModelIndexVOList();
        BigDecimal score = BigDecimal.ZERO;
        for(BusinessModelIndexVO indexVO:businessModelIndexVOList){
            //经营策略
            if(BusinessStrategyIndexEnum.businessStrategy.getCode().equals(indexVO.getSourceField())){
                String businessStrategy = businessStrategyCustomerVO.getBusinessStrategy();
                BigDecimal indexScore = dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), businessStrategy);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));

            }
            //与公司紧密度
            if(BusinessStrategyIndexEnum.companyTightness.getCode().equals(indexVO.getSourceField())){
                String companyTightness = businessStrategyCustomerVO.getCompanyTightness();
                BigDecimal indexScore = dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(),companyTightness);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));

            }
            //组织规模
            if(BusinessStrategyIndexEnum.organizationScale.getCode().equals(indexVO.getSourceField())){
                String organizationScale = businessStrategyCustomerVO.getOrganizationScale();
                BigDecimal indexScore = dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(),organizationScale);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));

            }
            //行业
            if(BusinessStrategyIndexEnum.industryStand.getCode().equals(indexVO.getSourceField())){
                String industryStand = businessStrategyCustomerVO.getIndustryStand();
                BigDecimal indexScore = dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(),industryStand);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));

            }
            //性质
            if(BusinessStrategyIndexEnum.partnerNature.getCode().equals(indexVO.getSourceField())){
                String partnerNature = businessStrategyCustomerVO.getPartnerNature();
                BigDecimal indexScore = dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), partnerNature);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));

            }
        }
        return score;
    }

    /**
     * 根据模型指标的明细获取对应的分数
     *
     * @param  businessModelIndexSettingVOList 模型指标明细数据
     * @param sourceFileValue  数据库对应字段
     *
     **/
    public BigDecimal dealNotStandaryIndexDetail(List<BusinessModelIndexSettingVO> businessModelIndexSettingVOList,String sourceFileValue){
        BigDecimal indexScore =  BigDecimal.ZERO;
        for(BusinessModelIndexSettingVO indexSettingVO:businessModelIndexSettingVOList){
            if(indexSettingVO.getSourceFiledOption().equals(sourceFileValue)){
                indexScore = indexSettingVO.getOptionScore();
                break;
            }
        }
        return indexScore;
    }


    //校验用户填入的分数是否符合规范
    public void checkStrategyGrade(List<BusinessStrategyGradeSettingPayload> payloadList){
        Map<String,BusinessStrategyGradeSettingPayload> map = new HashMap<>();
        payloadList.stream().forEach(payload->map.put(payload.getGradleType(),payload));
        //E到S之间的分数应该是连续且不交叉的 且S的最大值应该是100 E的最小值应该是0
        if(map.get(CustomerGradeEnum.E.getCode()).getScoreStart().compareTo(BigDecimal.ZERO)!=0){
            log.error("E等级分数配置需从0开始");
            throw TwException.error("","E等级分数配置需从0开始");
        }
        if(map.get(CustomerGradeEnum.S.getCode()).getScoreEnd().compareTo(new BigDecimal("100"))!=0){
            log.error("S等级分数配置最大值应为100");
            throw TwException.error("","S等级分数配置最大值应为100");
        }
        if(map.get(CustomerGradeEnum.E.getCode()).getScoreEnd().compareTo(map.get(CustomerGradeEnum.D.getCode()).getScoreStart())!=0){
            log.error("E的最大值应等于D的最小值");
            throw TwException.error("","E的最大值应等于D的最小值");
        }
        if(map.get(CustomerGradeEnum.D.getCode()).getScoreEnd().compareTo(map.get(CustomerGradeEnum.C.getCode()).getScoreStart())!=0){
            log.error("D的最大值应等于C的最小值");
            throw TwException.error("","D的最大值应等于C的最小值");
        }

        if(map.get(CustomerGradeEnum.C.getCode()).getScoreEnd().compareTo(map.get(CustomerGradeEnum.B.getCode()).getScoreStart())!=0){
            log.error("C的最大值应等于B的最小值");
            throw TwException.error("","C的最大值应等于B的最小值");
        }

        if(map.get(CustomerGradeEnum.B.getCode()).getScoreEnd().compareTo(map.get(CustomerGradeEnum.A.getCode()).getScoreStart())!=0){
            log.error("B的最大值应等于A的最小值");
            throw TwException.error("","B的最大值应等于A的最小值");
        }

        if(map.get(CustomerGradeEnum.A.getCode()).getScoreEnd().compareTo(map.get(CustomerGradeEnum.S.getCode()).getScoreStart())!=0){
            log.error("A的最大值应等于S的最小值");
            throw TwException.error("","A的最大值应等于S的最小值");
        }
    }
}
